/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzaof;
import com.google.android.gms.internal.ads.zzaog;
import com.google.android.gms.internal.ads.zzaoh;
import com.google.android.gms.internal.ads.zzaoj;
import com.google.android.gms.internal.ads.zzaok;
import com.google.android.gms.internal.ads.zzaoo;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.security.DigestException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class zzaon {
    private static int zzb(int n) {
        switch (n) {
            default: {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Unknown content digest algorthm: ");
                stringBuilder.append(n);
                throw new IllegalArgumentException(stringBuilder.toString());
            }
            case 2: {
                return 64;
            }
            case 1: 
        }
        return 32;
    }

    private static int zzc(int n) {
        switch (n) {
            default: {
                long l = n;
                String string2 = String.valueOf(Long.toHexString(l));
                throw new IllegalArgumentException("Unknown signature algorithm: 0x".concat(string2));
            }
            case 258: 
            case 260: 
            case 514: {
                return 2;
            }
            case 257: 
            case 259: 
            case 513: 
            case 769: 
        }
        return 1;
    }

    private static String zzd(int n) {
        switch (n) {
            default: {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Unknown content digest algorthm: ");
                stringBuilder.append(n);
                throw new IllegalArgumentException(stringBuilder.toString());
            }
            case 2: {
                return "SHA-512";
            }
            case 1: 
        }
        return "SHA-256";
    }

    private static ByteBuffer zze(ByteBuffer byteBuffer, int n) throws BufferUnderflowException {
        ByteBuffer byteBuffer2;
        int n2 = byteBuffer.limit();
        int n3 = byteBuffer.position();
        n = n3 + n;
        if (n < n3 || n > n2) {
            throw new BufferUnderflowException();
        }
        byteBuffer.limit(n);
        try {
            byteBuffer2 = byteBuffer.slice();
            byteBuffer2.order(byteBuffer.order());
            byteBuffer.position(n);
        }
        catch (Throwable throwable) {
            byteBuffer.limit(n2);
            throw throwable;
        }
        byteBuffer.limit(n2);
        return byteBuffer2;
    }

    private static ByteBuffer zzf(ByteBuffer byteBuffer) throws IOException {
        if (byteBuffer.remaining() < 4) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Remaining buffer too short to contain length of length-prefixed field. Remaining: ");
            stringBuilder.append(byteBuffer.remaining());
            throw new IOException(stringBuilder.toString());
        }
        int n = byteBuffer.getInt();
        if (n < 0) {
            throw new IllegalArgumentException("Negative length");
        }
        if (n > byteBuffer.remaining()) {
            int n2 = byteBuffer.remaining();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Length-prefixed field longer than remaining buffer. Field length: ");
            stringBuilder.append(n);
            stringBuilder.append(", remaining: ");
            stringBuilder.append(n2);
            throw new IOException(stringBuilder.toString());
        }
        return zzaon.zze(byteBuffer, n);
    }

    private static void zzg(int n, byte[] byArray, int n2) {
        byArray[1] = (byte)(n & 0xFF);
        byArray[2] = (byte)(n >>> 8 & 0xFF);
        byArray[3] = (byte)(n >>> 16 & 0xFF);
        byArray[4] = (byte)(n >> 24);
    }

    private static void zzh(Map map, FileChannel object, long l, long l2, long l3, ByteBuffer object2) throws SecurityException {
        if (map.isEmpty()) {
            throw new SecurityException("No digests provided");
        }
        zzaoh zzaoh2 = new zzaoh((FileChannel)object, 0L, l);
        zzaoh zzaoh3 = new zzaoh((FileChannel)object, l2, l3 -= l2);
        object = ((ByteBuffer)object2).duplicate();
        ((ByteBuffer)object).order(ByteOrder.LITTLE_ENDIAN);
        zzaoo.zzd((ByteBuffer)object, l);
        object2 = new zzaof((ByteBuffer)object);
        int[] nArray = new int[map.size()];
        Iterator iterator = map.keySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            nArray[n] = (Integer)iterator.next();
            ++n;
        }
        try {
            object2 = zzaon.zzk(nArray, new zzaog[]{zzaoh2, zzaoh3, object2});
        }
        catch (DigestException digestException) {
            throw new SecurityException("Failed to compute digest(s) of contents", digestException);
        }
        for (n = 0; n < nArray.length; ++n) {
            int n2 = nArray[n];
            if (MessageDigest.isEqual((byte[])map.get(n2), (byte[])object2[n])) continue;
            throw new SecurityException(zzaon.zzd(n2).concat(" digest of contents did not verify"));
        }
    }

    private static byte[] zzi(ByteBuffer byteBuffer) throws IOException {
        int n = byteBuffer.getInt();
        if (n < 0) {
            throw new IOException("Negative length");
        }
        if (n > byteBuffer.remaining()) {
            int n2 = byteBuffer.remaining();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Underflow while reading length-prefixed value. Length: ");
            stringBuilder.append(n);
            stringBuilder.append(", available: ");
            stringBuilder.append(n2);
            throw new IOException(stringBuilder.toString());
        }
        byte[] byArray = new byte[n];
        byteBuffer.get(byArray);
        return byArray;
    }

    /*
     * Exception decompiling
     */
    private static X509Certificate[] zzj(ByteBuffer var0, Map var1_10, CertificateFactory var2_13) throws SecurityException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Extractable last case doesn't follow previous, and can't clone.
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:611)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Loose catch block
     */
    private static byte[][] zzk(int[] nArray, zzaog[] object) throws DigestException {
        byte[][] byArrayArray;
        block15: {
            String string2;
            int n;
            int n2;
            long l = 0L;
            for (n2 = 0; n2 < 3; ++n2) {
                l += (object[n2].zza() + 1048575L) / 0x100000L;
            }
            if (l >= 0x1FFFFFL) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Too many chunks: ");
                stringBuilder.append(l);
                throw new DigestException(stringBuilder.toString());
            }
            byte[][] byArrayArray2 = new byte[nArray.length][];
            for (n2 = 0; n2 < (n = nArray.length); ++n2) {
                int n3 = (int)l;
                byte[] byArray = new byte[n3 * zzaon.zzb(nArray[n2]) + 5];
                byArray[0] = 90;
                zzaon.zzg(n3, byArray, 1);
                byArrayArray2[n2] = byArray;
            }
            byte[] byArray = new byte[5];
            byArray[0] = -91;
            MessageDigest[] messageDigestArray = new MessageDigest[n];
            for (n2 = 0; n2 < nArray.length; ++n2) {
                string2 = zzaon.zzd(nArray[n2]);
                messageDigestArray[n2] = MessageDigest.getInstance(string2);
                continue;
            }
            n2 = 0;
            n = 0;
            for (int i = 0; i < 3; ++i) {
                zzaog zzaog2 = object[i];
                long l2 = 0L;
                for (long j = zzaog2.zza(); j > 0L; j -= l) {
                    int n4;
                    int n5 = (int)Math.min(j, 0x100000L);
                    zzaon.zzg(n5, byArray, 1);
                    for (n4 = 0; n4 < messageDigestArray.length; ++n4) {
                        messageDigestArray[n4].update(byArray);
                    }
                    zzaog2.zzb(messageDigestArray, l2, n5);
                    for (n4 = 0; n4 < nArray.length; ++n4) {
                        MessageDigest messageDigest = messageDigestArray[n4];
                        byte[] byArray2 = byArrayArray2[n4];
                        int n6 = zzaon.zzb(nArray[n4]);
                        int n7 = messageDigest.digest(byArray2, n2 * n6 + 5, n6);
                        if (n7 == n6) continue;
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("Unexpected output size of ");
                        stringBuilder.append(messageDigest.getAlgorithm());
                        stringBuilder.append(" digest: ");
                        stringBuilder.append(n7);
                        throw new RuntimeException(stringBuilder.toString());
                    }
                    l = n5;
                    l2 += l;
                    ++n2;
                }
                ++n;
            }
            byArrayArray = new byte[nArray.length][];
            for (int i = 0; i < nArray.length; ++i) {
                byte[] byArray3 = byArrayArray2[i];
                Object object2 = zzaon.zzd(nArray[i]);
                try {
                    object2 = MessageDigest.getInstance((String)object2);
                    byArrayArray[i] = ((MessageDigest)object2).digest(byArray3);
                    continue;
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    String string3 = ((String)object2).concat(" digest not supported");
                    throw new RuntimeException(string3, noSuchAlgorithmException);
                }
            }
            break block15;
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                object = string2.concat(" digest not supported");
                throw new RuntimeException((String)object, noSuchAlgorithmException);
            }
            catch (IOException iOException) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Failed to digest chunk #");
                stringBuilder.append(n2);
                stringBuilder.append(" of section #");
                stringBuilder.append(n);
                throw new DigestException(stringBuilder.toString(), iOException);
            }
        }
        return byArrayArray;
    }

    /*
     * Exception decompiling
     */
    public static X509Certificate[][] zza(String var0) throws zzaok, SecurityException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 26[TRYBLOCK] [26 : 1064->1133)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static X509Certificate[][] zzl(FileChannel fileChannel, zzaoj zzaoj2) throws SecurityException {
        CertificateFactory certificateFactory;
        HashMap hashMap = new HashMap();
        ArrayList<X509Certificate[]> arrayList = new ArrayList<X509Certificate[]>();
        try {
            certificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateException) {
            throw new RuntimeException("Failed to obtain X.509 CertificateFactory", certificateException);
        }
        try {}
        catch (IOException iOException) {
            throw new SecurityException("Failed to read list of signers", iOException);
        }
        ByteBuffer byteBuffer = zzaon.zzf(zzaoj.zze(zzaoj2));
        int n = 0;
        while (byteBuffer.hasRemaining()) {
            ++n;
            try {
                arrayList.add(zzaon.zzj(zzaon.zzf(byteBuffer), hashMap, certificateFactory));
            }
            catch (IOException | SecurityException | BufferUnderflowException exception) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Failed to parse/verify signer #");
                stringBuilder.append(n);
                stringBuilder.append(" block");
                throw new SecurityException(stringBuilder.toString(), exception);
            }
        }
        if (n <= 0) {
            throw new SecurityException("No signers found");
        }
        if (hashMap.isEmpty()) {
            throw new SecurityException("No content digests found");
        }
        zzaon.zzh(hashMap, fileChannel, zzaoj.zza(zzaoj2), zzaoj.zzb(zzaoj2), zzaoj.zzc(zzaoj2), zzaoj.zzd(zzaoj2));
        ArrayList<X509Certificate[]> arrayList2 = arrayList;
        return (X509Certificate[][])arrayList2.toArray((T[])new X509Certificate[arrayList2.size()][]);
    }
}

