/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.os.Build;
import com.google.android.gms.internal.ads.zzgdo;
import com.google.android.gms.internal.ads.zzgdx;
import com.google.android.gms.internal.ads.zzggf;
import com.google.android.gms.internal.ads.zzgka;
import com.google.android.gms.internal.ads.zzgkr;
import com.google.android.gms.internal.ads.zzgoa;
import com.google.android.gms.internal.ads.zzgvp;
import com.google.android.gms.internal.ads.zzgvr;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.Objects;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class zzguo
implements zzgdo {
    private final SecretKey zza;
    private final byte[] zzb;

    public static zzgdo zzb(zzggf zzggf2) throws GeneralSecurityException {
        zzggf2.zzb();
        zzggf2.zzb();
        return new zzguo(zzggf2.zzd().zzd(zzgdx.zza()), zzggf2.zzc());
    }

    private zzguo(byte[] byArray, zzgvr zzgvr2) throws GeneralSecurityException {
        if (!zzgkr.zza(2)) {
            throw new GeneralSecurityException("Can not use AES-GCM in FIPS-mode, as BoringCrypto module is not available.");
        }
        zzgvp.zza(byArray.length);
        String string2 = "AES";
        this.zza = new SecretKeySpec(byArray, string2);
        this.zzb = zzgvr2.zzc();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public final byte[] zza(byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        void var3_6;
        if (byArray == null) {
            throw new NullPointerException("ciphertext is null");
        }
        int n = byArray.length;
        byte[] byArray3 = this.zzb;
        if (n < byArray3.length + 28) {
            throw new GeneralSecurityException("ciphertext too short");
        }
        if (!zzgoa.zzc(byArray3, byArray)) {
            throw new GeneralSecurityException("Decryption failed (OutputPrefix mismatch).");
        }
        byte[] byArray4 = new byte[12];
        System.arraycopy(byArray, this.zzb.length, byArray4, 0, 12);
        if (!Objects.equals(System.getProperty("java.vendor"), "The Android Project")) {
            Object var3_5 = null;
        } else {
            Integer n2 = Build.VERSION.SDK_INT;
        }
        if (var3_6 != null) {
            var3_6.intValue();
        }
        GCMParameterSpec gCMParameterSpec = new GCMParameterSpec(128, byArray4, 0, 12);
        SecretKey secretKey = this.zza;
        Cipher cipher = zzgka.zza();
        cipher.init(2, (Key)secretKey, gCMParameterSpec);
        if (byArray2 != null && byArray2.length != 0) {
            cipher.updateAAD(byArray2);
        }
        int n3 = this.zzb.length;
        return cipher.doFinal(byArray, n3 + 12, n - n3 + -12);
    }
}

