/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.util;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.AlertDialog;
import android.app.KeyguardManager;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Rect;
import android.hardware.display.DisplayManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.PowerManager;
import android.os.Process;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.webkit.WebResourceResponse;
import android.webkit.WebSettings;
import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import androidx.browser.customtabs.CustomTabsIntent;
import com.google.android.gms.ads.formats.zzj;
import com.google.android.gms.ads.impl.R;
import com.google.android.gms.ads.internal.client.zzbc;
import com.google.android.gms.ads.internal.client.zzbe;
import com.google.android.gms.ads.internal.util.zzad;
import com.google.android.gms.ads.internal.util.zzbo;
import com.google.android.gms.ads.internal.util.zzbp;
import com.google.android.gms.ads.internal.util.zzbr;
import com.google.android.gms.ads.internal.util.zzbw;
import com.google.android.gms.ads.internal.util.zzcd;
import com.google.android.gms.ads.internal.util.zzce;
import com.google.android.gms.ads.internal.util.zzcf;
import com.google.android.gms.ads.internal.util.zzcg;
import com.google.android.gms.ads.internal.util.zze;
import com.google.android.gms.ads.internal.util.zzf;
import com.google.android.gms.ads.internal.util.zzl;
import com.google.android.gms.ads.internal.util.zzm;
import com.google.android.gms.ads.internal.util.zzn;
import com.google.android.gms.ads.internal.util.zzo;
import com.google.android.gms.ads.internal.util.zzp;
import com.google.android.gms.ads.internal.util.zzq;
import com.google.android.gms.ads.internal.zzv;
import com.google.android.gms.ads.nativead.NativeAdView;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.util.ClientLibraryUtils;
import com.google.android.gms.common.util.CrashUtils;
import com.google.android.gms.common.util.DeviceProperties;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.ads.zzbcc;
import com.google.android.gms.internal.ads.zzbcl;
import com.google.android.gms.internal.ads.zzbdm;
import com.google.android.gms.internal.ads.zzbeu;
import com.google.android.gms.internal.ads.zzbvu;
import com.google.android.gms.internal.ads.zzbzw;
import com.google.android.gms.internal.ads.zzceo;
import com.google.android.gms.internal.ads.zzcga;
import com.google.android.gms.internal.ads.zzcgq;
import com.google.android.gms.internal.ads.zzdoz;
import com.google.android.gms.internal.ads.zzdrv;
import com.google.android.gms.internal.ads.zzdrw;
import com.google.android.gms.internal.ads.zzfbo;
import com.google.android.gms.internal.ads.zzfbr;
import com.google.android.gms.internal.ads.zzfqw;
import com.google.android.gms.internal.ads.zzfty;
import com.google.android.gms.internal.ads.zzfvc;
import com.google.android.gms.internal.ads.zzfve;
import com.google.android.gms.internal.ads.zzgch;
import com.google.android.gms.internal.ads.zzhfk;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class zzs {
    public static final zzfqw zza = new zzf(Looper.getMainLooper());
    private final AtomicReference zzb = new AtomicReference<Object>(null);
    private final AtomicReference zzc = new AtomicReference<Object>(null);
    private final AtomicReference zzd = new AtomicReference<Bundle>(new Bundle());
    private final AtomicBoolean zze = new AtomicBoolean();
    private boolean zzf = true;
    private final Object zzg = new Object();
    @GuardedBy(value="userAgentLock")
    private String zzh;
    private volatile String zzi;
    private boolean zzj = false;
    private boolean zzk = false;
    private final Executor zzl = Executors.newSingleThreadExecutor();

    public static int zza(int n) {
        if (n >= 5000) {
            return n;
        }
        if (n > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("HTTP timeout too low: ");
            stringBuilder.append(n);
            stringBuilder.append(" milliseconds. Reverting to default timeout: 60000 milliseconds.");
            com.google.android.gms.ads.internal.util.client.zzo.zzj((String)stringBuilder.toString());
        }
        return 60000;
    }

    @Nullable
    private static KeyguardManager zzY(Context object) {
        if ((object = object.getSystemService("keyguard")) != null && object instanceof KeyguardManager) {
            return (KeyguardManager)object;
        }
        return null;
    }

    @Nullable
    private static Bundle zzZ(Context context) throws RemoteException {
        try {
            context = Wrappers.packageManager((Context)context).getApplicationInfo((String)context.getPackageName(), (int)128).metaData;
            return context;
        }
        catch (PackageManager.NameNotFoundException | NullPointerException throwable) {
            com.google.android.gms.ads.internal.util.zze.zzb("Error getting metadata", throwable);
            return null;
        }
    }

    public final ListenableFuture zzb(Uri uri) {
        return zzgch.zzj((Callable)new zzn(uri), (Executor)this.zzl);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String zzaa(Bundle object) {
        if (object == null || TextUtils.isEmpty((CharSequence)(object = object.getString("com.google.android.gms.ads.APPLICATION_ID"))) || !((String)object).matches("^ca-app-pub-[0-9]{16}~[0-9]{10}$") && !((String)object).matches("^/\\d+~.+$")) {
            return "";
        }
        return object;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final String zzc(Context context, String string2) {
        Object object = zzbcl.zzle;
        if (((Boolean)zzbe.zzc().zza(object)).booleanValue()) {
            if (((zzs)string4).zzi != null) {
                return ((zzs)string4).zzi;
            }
            ((zzs)string4).zzi = zzs.zzae(context, string2);
            return ((zzs)string4).zzi;
        }
        object = ((zzs)string4).zzg;
        synchronized (object) {
            String string3 = ((zzs)string4).zzh;
            if (string3 != null) {
                return string3;
            }
            ((zzs)string4).zzh = zzs.zzae(context, string2);
            return ((zzs)string4).zzh;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List zzd() {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        Iterator iterator = zzbe.zza().zzb().iterator();
        block2: while (iterator.hasNext()) {
            Object object = (String)iterator.next();
            object = zzfvc.zzb((zzfty)zzfty.zzc((char)',')).zzd((CharSequence)object).iterator();
            while (true) {
                if (!object.hasNext()) continue block2;
                String string2 = (String)object.next();
                try {
                    arrayList.add(Long.valueOf(string2));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    com.google.android.gms.ads.internal.util.zze.zza("Experiment ID is not a number");
                    continue;
                }
                break;
            }
            break;
        }
        return arrayList;
    }

    static /* bridge */ /* synthetic */ void zze(zzs zzs2, boolean bl) {
        zzs2.zzf = bl;
    }

    public final void zzf(Context context, String string2, boolean bl, HttpURLConnection httpURLConnection, boolean bl2, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = zzs.zza(n);
        stringBuilder.append("HTTP timeout: ");
        stringBuilder.append(n2);
        stringBuilder.append(" milliseconds.");
        com.google.android.gms.ads.internal.util.client.zzo.zzi((String)stringBuilder.toString());
        httpURLConnection.setConnectTimeout(n2);
        HttpURLConnection httpURLConnection2 = httpURLConnection;
        httpURLConnection2.setInstanceFollowRedirects(false);
        httpURLConnection2.setReadTimeout(n2);
        if (TextUtils.isEmpty((CharSequence)httpURLConnection.getRequestProperty("User-Agent"))) {
            String string3 = ((zzs)((Object)string3)).zzc(context, string2);
            httpURLConnection.setRequestProperty("User-Agent", string3);
        }
        httpURLConnection.setUseCaches(false);
    }

    final /* synthetic */ void zzg(Context context, String string2, SharedPreferences sharedPreferences, String string3) {
        this.zzd.set(zzad.zzb(context, string2));
    }

    public static void zzh(Runnable runnable) {
        if (Looper.getMainLooper().getThread() != Thread.currentThread()) {
            runnable.run();
            return;
        }
        zzbzw.zza.execute(runnable);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void zzi(Context context, @Nullable String string2, String object, Bundle bundle, boolean bl) {
        zzv.zzq();
        bundle.putString("device", zzs.zzs());
        object = zzbe.zza().zza();
        object = TextUtils.join((CharSequence)",", (Iterable)object);
        bundle.putString("eids", (String)object);
        if (bundle.isEmpty()) {
            com.google.android.gms.ads.internal.util.client.zzo.zze((String)"Empty or null bundle.");
        } else {
            object = zzbcl.zzkt;
            object = (String)zzbe.zzc().zza((zzbcc)object);
            if (!((zzs)object2).zze.getAndSet(true)) {
                ((zzs)object2).zzd.set(zzad.zza(context, (String)object, new zzm((zzs)object2, context, (String)object)));
            }
            bundle.putAll((Bundle)((zzs)object2).zzd.get());
        }
        zzbc.zzb();
        Object object2 = new zzl(context, string2);
        com.google.android.gms.ads.internal.util.client.zzf.zzw((Context)context, (String)string2, (String)"gmob-apps", (Bundle)bundle, (boolean)true, (com.google.android.gms.ads.internal.util.client.zze)object2);
    }

    public final boolean zzj(String string2) {
        Object object = zzbcl.zzao;
        object = (String)zzbe.zzc().zza(object);
        return zzs.zzab(string2, this.zzb, (String)object);
    }

    public final boolean zzk(String string2) {
        Object object = zzbcl.zzap;
        object = (String)zzbe.zzc().zza(object);
        return zzs.zzab(string2, this.zzc, (String)object);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean zzab(String string2, AtomicReference serializable, String string3) {
        void var1_4;
        Pattern pattern;
        block7: {
            void var2_6;
            block6: {
                if (TextUtils.isEmpty((CharSequence)string2)) {
                    return false;
                }
                try {
                    pattern = (Pattern)((AtomicReference)serializable).get();
                    if (pattern == null) break block6;
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    return false;
                }
                boolean bl = var2_6.equals(pattern.pattern());
                if (bl) break block7;
            }
            Pattern pattern2 = Pattern.compile((String)var2_6);
            ((AtomicReference)serializable).set(pattern2);
            Pattern pattern3 = pattern2;
            return var1_4.matcher(string2).matches();
        }
        Pattern pattern4 = pattern;
        return var1_4.matcher(string2).matches();
    }

    /*
     * Enabled aggressive block sorting
     */
    @SuppressLint(value={"UnprotectedReceiver"})
    public final boolean zzl(Context context) {
        if (this.zzk) {
            return false;
        }
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("com.google.android.ads.intent.DEBUG_LOGGING_ENABLEMENT_CHANGED");
        zzbcl.zza((Context)context);
        zzbcc zzbcc2 = zzbcl.zzkR;
        if (((Boolean)zzbe.zzc().zza(zzbcc2)).booleanValue() && Build.VERSION.SDK_INT >= 33) {
            context.getApplicationContext().registerReceiver((BroadcastReceiver)new zzp(this, null), intentFilter, 4);
        } else {
            context.getApplicationContext().registerReceiver((BroadcastReceiver)new zzp(this, null), intentFilter);
        }
        this.zzk = true;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @SuppressLint(value={"UnprotectedReceiver"})
    public final boolean zzm(Context context) {
        if (this.zzj) {
            return false;
        }
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.USER_PRESENT");
        intentFilter.addAction("android.intent.action.SCREEN_OFF");
        zzbcl.zza((Context)context);
        zzbcc zzbcc2 = zzbcl.zzkR;
        if (((Boolean)zzbe.zzc().zza(zzbcc2)).booleanValue() && Build.VERSION.SDK_INT >= 33) {
            context.getApplicationContext().registerReceiver((BroadcastReceiver)new zzq(this, null), intentFilter, 4);
        } else {
            context.getApplicationContext().registerReceiver((BroadcastReceiver)new zzq(this, null), intentFilter);
        }
        this.zzj = true;
        return true;
    }

    public final int zzn(Context context, Uri uri) {
        if (context == null) {
            com.google.android.gms.ads.internal.util.zze.zza("Trying to open chrome custom tab on a null context");
            return 3;
        }
        if (!(context instanceof Activity)) {
            zzs.zzac(context, uri);
            return 2;
        }
        Object object = zzbcl.zzeG;
        if (((Boolean)zzbe.zzc().zza((zzbcc)object)).booleanValue()) {
            CustomTabsIntent customTabsIntent = new CustomTabsIntent.Builder(zzv.zzf().zza()).build();
            customTabsIntent.intent.setPackage(zzhfk.zza(context));
            customTabsIntent.launchUrl(context, uri);
            return 5;
        }
        object = zzbcl.zzeE;
        if (((Boolean)zzbe.zzc().zza((zzbcc)object)).booleanValue()) {
            object = new zzbdm();
            ((zzbdm)object).zze(new zzo(this, (zzbdm)object, context, uri));
            ((zzbdm)object).zzb((Activity)context);
            return 5;
        }
        zzs.zzac(context, uri);
        return 9;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final boolean zzo(View view) {
        if ((view = view.getRootView()) == null) {
            return false;
        }
        if (!((view = view.getContext()) instanceof Activity)) return false;
        view = (Activity)view;
        if (view == null) {
            return false;
        }
        if ((view = view.getWindow()) == null) {
            return false;
        }
        view = view.getAttributes();
        if (view == null) return false;
        if ((view.flags & 0x80000) == 0) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static final void zzp(Context object, Intent intent) {
        void var1_2;
        if (var1_2 == null) {
            return;
        }
        Bundle bundle = var1_2.getExtras() != null ? var1_2.getExtras() : new Bundle();
        bundle.putBinder("android.support.customtabs.extra.SESSION", null);
        String string2 = object.getPackageName();
        bundle.putString("com.android.browser.application_id", string2);
        var1_2.putExtras(bundle);
    }

    private static final void zzac(Context context, Uri uri) {
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setData(uri);
        intent.addFlags(0x10000000);
        context.startActivity(intent);
    }

    public static final String zzq(Context context) throws RemoteException {
        if (context.getApplicationContext() != null) {
            context = context.getApplicationContext();
        }
        return zzs.zzaa(zzs.zzZ(context));
    }

    static final String zzr() {
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append("Mozilla/5.0 (Linux; U; Android");
        if (Build.VERSION.RELEASE != null) {
            stringBuilder.append(" ");
            stringBuilder.append(Build.VERSION.RELEASE);
        }
        stringBuilder.append("; ");
        stringBuilder.append(Locale.getDefault());
        if (Build.DEVICE != null) {
            stringBuilder.append("; ");
            stringBuilder.append(Build.DEVICE);
            if (Build.DISPLAY != null) {
                stringBuilder.append(" Build/");
                stringBuilder.append(Build.DISPLAY);
            }
        }
        stringBuilder.append(") AppleWebKit/533 Version/4.0 Safari/533");
        return stringBuilder.toString();
    }

    public static final String zzs() {
        String string2 = Build.MODEL;
        String string3 = Build.MANUFACTURER;
        if (string2.startsWith(string3)) {
            return string2;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string3);
        stringBuilder.append(" ");
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    @Nullable
    public static final Integer zzt(Context object) {
        if ((object = object.getSystemService("display")) instanceof DisplayManager) {
            return ((DisplayManager)object).getDisplays().length;
        }
        return null;
    }

    public static final DisplayMetrics zzu(WindowManager windowManager) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        windowManager.getDefaultDisplay().getMetrics(displayMetrics);
        return displayMetrics;
    }

    protected static final int[] zzv() {
        return new int[]{0, 0};
    }

    public static final Map zzw(String string2) {
        JSONObject jSONObject;
        HashMap hashMap = new HashMap();
        try {
            jSONObject = new JSONObject(string2);
        }
        catch (JSONException jSONException) {
            String string3 = "AdUtil.getMapOfFileNamesToKeysFromJsonString";
            zzv.zzp().zzw(jSONException, string3);
            return hashMap;
        }
        Iterator iterator = jSONObject.keys();
        while (iterator.hasNext()) {
            String string4 = (String)iterator.next();
            HashSet<String> hashSet = new HashSet<String>();
            JSONArray jSONArray = jSONObject.optJSONArray(string4);
            if (jSONArray == null) continue;
            for (int i = 0; i < jSONArray.length(); ++i) {
                String string5 = jSONArray.optString(i);
                if (string5 == null) continue;
                hashSet.add(string5);
            }
            hashMap.put(string4, hashSet);
        }
        return hashMap;
    }

    public static final long zzx(View view) {
        float f = Float.MAX_VALUE;
        while (view instanceof View) {
            View view2 = view;
            f = Math.min(f, view2.getAlpha());
            view = view2.getParent();
            if (!(f <= 0.0f)) continue;
        }
        if (f < 0.0f) {
            f = 0.0f;
        }
        return Math.round(f * 100.0f);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final WebResourceResponse zzy(Context object, String object2, String string2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("User-Agent", zzv.zzq().zzc((Context)object, (String)object2));
        hashMap.put("Cache-Control", "max-stale=3600");
        object2 = new zzbo((Context)object);
        object = ((zzbo)object2).zzb(0, string2, hashMap, null);
        object = (String)object.get(60L, TimeUnit.SECONDS);
        if (object == null) return null;
        try {
            return new WebResourceResponse("application/javascript", "UTF-8", (InputStream)new ByteArrayInputStream(((String)object).getBytes("UTF-8")));
        }
        catch (IOException | InterruptedException | ExecutionException | TimeoutException exception) {
            com.google.android.gms.ads.internal.util.client.zzo.zzk((String)"Could not fetch MRAID JS.", (Throwable)exception);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final String zzz() {
        void var0_2;
        Resources resources = zzv.zzp().zze();
        if (resources == null) return var0_2;
        String string2 = resources.getString(R.string.s7);
        return var0_2;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final zzbr zzA(Context object) {
        void var0_4;
        Object obj;
        try {
            obj = object.getClassLoader().loadClass("com.google.android.gms.ads.internal.util.WorkManagerUtil").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            String string2 = "Failed to instantiate WorkManagerUtil";
            zzv.zzp().zzw(exception, string2);
            return null;
        }
        if (!(obj instanceof IBinder)) {
            com.google.android.gms.ads.internal.util.client.zzo.zzg((String)"Instantiated WorkManagerUtil not instance of IBinder.");
            return null;
        }
        IBinder iBinder = (IBinder)obj;
        if (iBinder == null) {
            return var0_4;
        }
        IInterface iInterface = iBinder.queryLocalInterface("com.google.android.gms.ads.internal.util.IWorkManagerUtil");
        if (iInterface instanceof zzbr) {
            zzbr zzbr2 = (zzbr)iInterface;
            return var0_4;
        }
        zzbp zzbp2 = new zzbp(iBinder);
        return var0_4;
    }

    public static final boolean zzB(Context object, String string2) {
        Context context = zzbvu.zza(object);
        object = context.getPackageName();
        return Wrappers.packageManager((Context)context).checkPermission(string2, (String)object) == 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean zzC(Context context) {
        try {
            return DeviceProperties.isBstar((Context)context);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            return false;
        }
    }

    public static final boolean zzD(String string2) {
        int n;
        String[] stringArray;
        if (!com.google.android.gms.ads.internal.util.client.zzl.zzk()) {
            return false;
        }
        Object object = zzbcl.zzeY;
        if (!((Boolean)zzbe.zzc().zza((zzbcc)object)).booleanValue()) {
            return false;
        }
        object = zzbcl.zzfa;
        object = (String)zzbe.zzc().zza((zzbcc)object);
        if (!((String)object).isEmpty()) {
            stringArray = ((String)object).split(";");
            n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                if (!stringArray[i].equals(string2)) continue;
                return false;
            }
        }
        Object object2 = zzbcl.zzeZ;
        object2 = (String)zzbe.zzc().zza((zzbcc)object2);
        if (((String)object2).isEmpty()) {
            return true;
        }
        stringArray = ((String)object2).split(";");
        n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (!stringArray[i].equals(string2)) continue;
            return true;
        }
        return false;
    }

    public static final boolean zzE(Context context) {
        if (context == null) {
            return false;
        }
        return (context = zzs.zzY(context)) != null && context.isKeyguardLocked();
    }

    public static final boolean zzF(Context object) {
        try {
            object = object.getClassLoader();
            String string2 = "com.google.android.gms.ads.internal.ClientApi";
            ((ClassLoader)object).loadClass(string2);
            return false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return true;
        }
        catch (Throwable throwable) {
            com.google.android.gms.ads.internal.util.client.zzo.zzh((String)"Error loading class.", (Throwable)throwable);
            String string3 = "AdUtil.isLiteSdk";
            zzv.zzp().zzw(throwable, string3);
            return false;
        }
    }

    public static final boolean zzG() {
        int n = Process.myUid();
        return n == 0 || n == 1000;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final boolean zzH(Context context) {
        try {
            block5: {
                boolean bl;
                Object object = (ActivityManager)context.getSystemService("activity");
                KeyguardManager keyguardManager = (KeyguardManager)context.getSystemService("keyguard");
                if (object == null || keyguardManager == null) {
                    return false;
                }
                if ((object = object.getRunningAppProcesses()) == null) {
                    return false;
                }
                object = object.iterator();
                while (bl = object.hasNext()) {
                    boolean bl2;
                    int n;
                    ActivityManager.RunningAppProcessInfo runningAppProcessInfo = (ActivityManager.RunningAppProcessInfo)object.next();
                    int n2 = Process.myPid();
                    if (n2 != (n = runningAppProcessInfo.pid)) continue;
                    int n3 = runningAppProcessInfo.importance;
                    if (n3 == 100 && (n3 = (int)(keyguardManager.inKeyguardRestrictedInputMode() ? 1 : 0)) == 0 && (context = (PowerManager)context.getSystemService("power")) != null && (bl2 = context.isScreenOn())) break block5;
                }
                return true;
            }
            return false;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static final boolean zzI(Context context) {
        block3: {
            boolean bl;
            String string2;
            try {
                context = zzs.zzZ(context);
                string2 = context.getString("com.google.android.gms.ads.INTEGRATION_MANAGER");
                bl = TextUtils.isEmpty((CharSequence)zzs.zzaa((Bundle)context));
                if (!bl) break block3;
            }
            catch (RemoteException remoteException) {
                return false;
            }
            bl = TextUtils.isEmpty((CharSequence)string2);
            if (bl) break block3;
            return true;
        }
        return false;
    }

    public static final boolean zzJ(Context context) {
        if (!(context instanceof Activity)) {
            return false;
        }
        if ((context = ((Activity)context).getWindow()) == null || context.getDecorView() == null) {
            return false;
        }
        Rect rect = new Rect();
        Rect rect2 = new Rect();
        context.getDecorView().getGlobalVisibleRect(rect, null);
        context.getDecorView().getWindowVisibleDisplayFrame(rect2);
        return rect.bottom != 0 && rect2.bottom != 0 && rect.top == rect2.top;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void zzK(View object, int n, MotionEvent motionEvent) {
        int[] nArray = new int[2];
        Rect rect = new Rect();
        try {
            Object object2;
            Object object3;
            int n2;
            int n3;
            int n4;
            String string2;
            String string3 = object.getContext().getPackageName();
            boolean bl = object instanceof zzdoz;
            if (bl) {
                object = ((zzdoz)((Object)object)).getChildAt(0);
            }
            if ((bl = object instanceof zzj) || (bl = object instanceof NativeAdView)) {
                string2 = "NATIVE";
                n4 = 1;
            } else {
                string2 = "UNKNOWN";
                n4 = 0;
            }
            if ((n3 = object.getLocalVisibleRect(rect)) != 0) {
                n3 = rect.width();
                n2 = rect.height();
            } else {
                n3 = 0;
                n2 = 0;
            }
            zzv.zzq();
            long l = zzs.zzx((View)object);
            object.getLocationOnScreen(nArray);
            int n5 = nArray[0];
            int n6 = nArray[1];
            boolean bl2 = object instanceof zzcga;
            String string4 = "none";
            if (bl2) {
                object3 = ((zzcga)object).zzR();
                if (object3 != null) {
                    object3 = ((zzfbr)object3).zzb;
                    Object object4 = object;
                    int n7 = object4.hashCode();
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append((String)object3);
                    stringBuilder.append(":");
                    stringBuilder.append(n7);
                    object4.setContentDescription((CharSequence)stringBuilder.toString());
                } else {
                    object3 = string4;
                }
            } else {
                object3 = string4;
            }
            boolean bl3 = object instanceof zzceo;
            String string5 = "none";
            if (bl3) {
                object2 = ((zzceo)object).zzD();
                if (object2 != null) {
                    string2 = zzfbo.zza(((zzfbo)object2).zzb);
                    n4 = ((zzfbo)object2).zze;
                    object2 = ((zzfbo)object2).zzE;
                } else {
                    object2 = string5;
                }
            } else {
                object2 = string5;
            }
            object = String.format(Locale.US, "<Ad hashCode=%d, package=%s, adNetCls=%s, gwsQueryId=%s, format=%s, impType=%d, class=%s, x=%d, y=%d, width=%d, height=%d, vWidth=%d, vHeight=%d, alpha=%d, state=%s>", object.hashCode(), string3, object2, object3, string2, n4, object.getClass().getName(), n5, n6, object.getWidth(), object.getHeight(), n3, n2, l, Integer.toString(n, 2));
            com.google.android.gms.ads.internal.util.client.zzo.zzi((String)object);
            return;
        }
        catch (Exception exception) {
            com.google.android.gms.ads.internal.util.client.zzo.zzh((String)"Failure getting view location.", (Throwable)exception);
            return;
        }
    }

    public static final AlertDialog.Builder zzL(Context context) {
        zzv.zzr();
        return new AlertDialog.Builder(context, 16974374);
    }

    public static final void zzM(Context context, String string2, String string3) {
        new zzbw(context, string2, string3, null, null).zzb();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void zzN(Context context, Throwable throwable) {
        block4: {
            block3: {
                if (context != null) {
                    try {
                        boolean bl = (Boolean)zzbeu.zzb.zze();
                        if (!bl) break block3;
                        break block4;
                    }
                    catch (IllegalStateException illegalStateException) {
                        return;
                    }
                }
            }
            return;
        }
        CrashUtils.addDynamiteErrorToDropBox((Context)context, (Throwable)throwable);
    }

    private static final void zzad(Context context, Intent intent) {
        try {
            context.startActivity(intent);
            return;
        }
        catch (Throwable throwable) {
            intent.addFlags(0x10000000);
            context.startActivity(intent);
            return;
        }
    }

    public static final int zzO(String string2) {
        try {
            int n = Integer.parseInt(string2);
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            com.google.android.gms.ads.internal.util.client.zzo.zzj((String)"Could not parse value:".concat(((Object)numberFormatException).toString()));
            return 0;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public static final Map zzP(Uri uri) {
        HashMap<String, String> hashMap;
        block9: {
            String string2;
            block10: {
                Object object;
                block8: {
                    if (uri == null) {
                        return null;
                    }
                    object = zzbcl.zzp;
                    if (!((Boolean)zzbe.zzc().zza((zzbcc)object)).booleanValue()) break block8;
                    hashMap = new HashMap<String, String>();
                    if (uri.isOpaque() || (string2 = uri.getEncodedQuery()) == null) break block9;
                    break block10;
                }
                object = new HashMap();
                Iterator iterator = uri.getQueryParameterNames().iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        return object;
                    }
                    String string3 = (String)iterator.next();
                    if (TextUtils.isEmpty((CharSequence)string3)) continue;
                    String string4 = string3;
                    ((HashMap)object).put(string4, uri.getQueryParameter(string4));
                }
            }
            int n = 0;
            while (true) {
                int n2;
                int n3 = string2.indexOf(38, n);
                int n4 = string2.length();
                if (n3 != -1) {
                    n4 = n3;
                }
                if ((n2 = string2.indexOf(61, n)) <= n4) {
                    if (n2 == -1) {
                        n2 = n4;
                    }
                } else {
                    n2 = n4;
                }
                String string5 = Uri.decode((String)string2.substring(n, n2));
                String string6 = n2 == n4 ? "" : Uri.decode((String)string2.substring(n2 + 1, n4));
                hashMap.put(string5, string6);
                if (n3 == -1) break;
                n = n3 + 1;
            }
        }
        return hashMap;
    }

    public static final int[] zzQ(Activity activity) {
        if ((activity = activity.getWindow()) != null && (activity = activity.findViewById(0x1020002)) != null) {
            return new int[]{activity.getWidth(), activity.getHeight()};
        }
        return zzs.zzv();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final String zzae(Context context, String string2) {
        String string3;
        void var2_12;
        void var2_10;
        void var2_8;
        if (string2 == null) return zzs.zzr();
        try {
            zzcg zzcg2 = zzcg.zza();
            boolean bl = TextUtils.isEmpty((CharSequence)zzcg2.zza);
            if (bl) {
                void var2_15;
                boolean bl2 = ClientLibraryUtils.isPackageSide();
                if (bl2) {
                    Context context2 = context;
                    String string4 = (String)zzcd.zza((Context)context2, (Callable)new zzce(context2));
                } else {
                    Context context3 = GooglePlayServicesUtilLight.getRemoteContext((Context)context);
                    String string5 = (String)zzcd.zza((Context)context, (Callable)new zzcf(context3, context));
                }
                zzcg2.zza = var2_15;
            }
            String string6 = zzcg2.zza;
        }
        catch (Exception exception) {
            Object var2_18 = null;
        }
        if (TextUtils.isEmpty((CharSequence)var2_8)) {
            String string7 = WebSettings.getDefaultUserAgent((Context)context);
        }
        if (TextUtils.isEmpty((CharSequence)var2_10)) {
            String string8 = zzs.zzr();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((String)var2_12);
        stringBuilder.append(" (Mobile; ");
        stringBuilder.append(string2);
        string2 = stringBuilder.toString();
        try {
            boolean bl = Wrappers.packageManager((Context)context).isCallerInstantApp();
            if (bl) {
                StringBuilder stringBuilder2 = new StringBuilder();
                stringBuilder2.append(string2);
                stringBuilder2.append(";aia");
                string3 = stringBuilder2.toString();
                return string3.concat(")");
            }
            string3 = string2;
            return string3.concat(")");
        }
        catch (Exception exception) {
            String string9 = "AdUtil.getUserAgent";
            zzv.zzp().zzw(exception, string9);
            string3 = string2;
            return string3.concat(")");
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final int[] zzR(Activity activity) {
        void var1_4;
        View view;
        Window window = activity.getWindow();
        if (window != null && (view = window.findViewById(0x1020002)) != null) {
            int[] nArray = new int[]{view.getTop(), view.getBottom()};
            return new int[]{zzbc.zzb().zzb((Context)activity, (int)var1_4[0]), zzbc.zzb().zzb((Context)activity, (int)var1_4[1])};
        }
        int[] nArray = zzs.zzv();
        return new int[]{zzbc.zzb().zzb((Context)activity, (int)var1_4[0]), zzbc.zzb().zzb((Context)activity, (int)var1_4[1])};
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final boolean zzS(View view, PowerManager powerManager, KeyguardManager keyguardManager) {
        boolean bl = !zzv.zzq().zzf ? (keyguardManager == null ? true : (keyguardManager.inKeyguardRestrictedInputMode() ? zzs.zzo(view) : true)) : true;
        long l = zzs.zzx(view);
        if (view.getVisibility() != 0) {
            return false;
        }
        if (!view.isShown()) {
            return false;
        }
        if (powerManager != null && !powerManager.isScreenOn()) {
            return false;
        }
        if (!bl) {
            return false;
        }
        powerManager = zzbcl.zzbu;
        if (((Boolean)zzbe.zzc().zza((zzbcc)powerManager)).booleanValue() && !view.getLocalVisibleRect(new Rect()) && !view.getGlobalVisibleRect(new Rect())) {
            return false;
        }
        view = zzbcl.zzkv;
        if ((Boolean)zzbe.zzc().zza((zzbcc)view) == false) return true;
        view = zzbcl.zzkx;
        if (l >= (long)((Integer)zzbe.zzc().zza((zzbcc)view)).intValue()) return true;
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void zzT(Context context, Intent object) {
        zzbcc zzbcc2 = zzbcl.zzkS;
        if (!((Boolean)zzbe.zzc().zza(zzbcc2)).booleanValue()) {
            zzs.zzad(context, (Intent)object);
            return;
        }
        try {
            zzs.zzad(context, (Intent)object);
            return;
        }
        catch (SecurityException securityException) {
            com.google.android.gms.ads.internal.util.client.zzo.zzk((String)"", (Throwable)securityException);
            object = "AdUtil.startActivityWithUnknownContext";
            zzv.zzp().zzw(securityException, (String)object);
            return;
        }
    }

    public static final void zzU(Context object, Uri uri) {
        try {
            Context context = object;
            Intent intent = new Intent("android.intent.action.VIEW", uri);
            Bundle bundle = new Bundle();
            intent.putExtras(bundle);
            zzs.zzp(context, intent);
            bundle.putString("com.android.browser.application_id", object.getPackageName());
            context.startActivity(intent);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Opening ");
            stringBuilder.append(uri.toString());
            stringBuilder.append(" in a new browser.");
            object = stringBuilder.toString();
            com.google.android.gms.ads.internal.util.client.zzo.zze((String)object);
            return;
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            com.google.android.gms.ads.internal.util.client.zzo.zzh((String)"No browser is found.", (Throwable)activityNotFoundException);
            return;
        }
    }

    public static final int[] zzV(Activity activity) {
        int[] nArray = zzs.zzQ(activity);
        return new int[]{zzbc.zzb().zzb((Context)activity, nArray[0]), zzbc.zzb().zzb((Context)activity, nArray[1])};
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean zzW(View view, Context context) {
        Context context2 = context.getApplicationContext();
        if (context2 != null) {
            context2 = (PowerManager)context2.getSystemService("power");
            return zzs.zzS(view, (PowerManager)context2, zzs.zzY(context));
        }
        context2 = null;
        return zzs.zzS(view, (PowerManager)context2, zzs.zzY(context));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void zzX(Context context, Intent intent, @Nullable zzdrw zzdrw2, String string2) {
        zzbcc zzbcc2 = zzbcl.zzmU;
        if (((Boolean)zzbe.zzc().zza(zzbcc2)).booleanValue() && context instanceof zzcgq) {
            try {
                Object object;
                Uri uri = intent.getData();
                if (uri != null && (object = uri.toString()) != null) {
                    String string3 = uri.toString();
                    object = zzbcl.zzmW;
                    object = zzbe.zzc().zza((zzbcc)object);
                    boolean bl = string3.matches((String)object);
                    if (bl) {
                        ((zzcgq)context).zzc(intent, 236);
                        zzbcc zzbcc3 = zzbcl.zzmV;
                        Object object2 = zzbe.zzc().zza(zzbcc3);
                        boolean bl2 = (Boolean)object2;
                        if (bl2 && zzdrw2 != null) {
                            zzdrv zzdrv2 = zzdrw2.zza();
                            zzdrv2.zzb("action", "hila");
                            zzdrv2.zzb("gqi", zzfve.zzc((String)string2));
                            zzdrv2.zzf();
                            return;
                        }
                        return;
                    }
                }
                zzs.zzT(context, intent);
                return;
            }
            catch (ActivityNotFoundException | SecurityException throwable) {
                com.google.android.gms.ads.internal.util.client.zzo.zzh((String)"Error occurred while starting activity for result", (Throwable)throwable);
                string2 = "AdUtil.startActivityForResult";
                zzv.zzp().zzw(throwable, string2);
                zzs.zzT(context, intent);
                return;
            }
            catch (Exception exception) {
                com.google.android.gms.ads.internal.util.client.zzo.zzh((String)"Error occurred while starting activity for result", (Throwable)exception);
                string2 = "AdUtil.startActivityForResult";
                zzv.zzp().zzw(exception, string2);
                zzs.zzT(context, intent);
                return;
            }
        }
        zzs.zzT(context, intent);
    }
}

