/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import androidx.annotation.Nullable;
import com.google.android.gms.internal.ads.zzi;
import com.google.android.gms.internal.ads.zzj;
import java.util.Arrays;
import java.util.Locale;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.dataflow.qual.Pure;

public final class zzk {
    public static final zzk zza;
    public final int zzb;
    public final int zzc;
    public final int zzd;
    @Nullable
    public final byte[] zze;
    public final int zzf;
    public final int zzg;
    private int zzh;

    public final int hashCode() {
        int n = this.zzh;
        if (n == 0) {
            byte[] byArray = this.zze;
            this.zzh = (((((this.zzb + 527) * 31 + this.zzc) * 31 + this.zzd) * 31 + Arrays.hashCode(byArray)) * 31 + this.zzf) * 31 + this.zzg;
            return this.zzh;
        }
        return n;
    }

    @Pure
    public static int zza(int n) {
        switch (n) {
            default: {
                return -1;
            }
            case 9: {
                return 6;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return 2;
            }
            case 1: 
        }
        return 1;
    }

    @Pure
    public static int zzb(int n) {
        switch (n) {
            default: {
                return -1;
            }
            case 18: {
                return 7;
            }
            case 16: {
                return 6;
            }
            case 13: {
                return 2;
            }
            case 4: {
                return 10;
            }
            case 1: 
            case 6: 
            case 7: 
        }
        return 3;
    }

    public final zzi zzc() {
        return new zzi(this, null);
    }

    private static String zzh(int n) {
        switch (n) {
            default: {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Undefined color range ");
                stringBuilder.append(n);
                return stringBuilder.toString();
            }
            case 2: {
                return "Limited range";
            }
            case 1: {
                return "Full range";
            }
            case -1: 
        }
        return "Unset color range";
    }

    private static String zzi(int n) {
        switch (n) {
            default: {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Undefined color space ");
                stringBuilder.append(n);
                return stringBuilder.toString();
            }
            case 6: {
                return "BT2020";
            }
            case 2: {
                return "BT601";
            }
            case 1: {
                return "BT709";
            }
            case -1: 
        }
        return "Unset color space";
    }

    private static String zzj(int n) {
        switch (n) {
            default: {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Undefined color transfer ");
                stringBuilder.append(n);
                return stringBuilder.toString();
            }
            case 10: {
                return "Gamma 2.2";
            }
            case 7: {
                return "HLG";
            }
            case 6: {
                return "ST2084 PQ";
            }
            case 3: {
                return "SDR SMPTE 170M";
            }
            case 2: {
                return "sRGB";
            }
            case 1: {
                return "Linear";
            }
            case -1: 
        }
        return "Unset color transfer";
    }

    /*
     * Enabled aggressive block sorting
     */
    public final String zzd() {
        Object object;
        String string2;
        if (((zzk)object).zzf()) {
            int n = ((zzk)object).zzb;
            Object[] objectArray = new Object[]{zzk.zzi(n), zzk.zzh(((zzk)object).zzc), zzk.zzj(((zzk)object).zzd)};
            string2 = String.format(Locale.US, "%s/%s/%s", objectArray);
        } else {
            string2 = "NA/NA/NA";
        }
        if (((zzk)object).zze()) {
            int n = ((zzk)object).zzf;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(n);
            stringBuilder.append("/");
            stringBuilder.append(((zzk)object).zzg);
            object = stringBuilder.toString();
        } else {
            object = "NA/NA";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string2);
        stringBuilder.append("/");
        stringBuilder.append((String)object);
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    public final String toString() {
        String string2;
        int n;
        String string3;
        int n2 = this.zzf;
        String string4 = zzk.zzi(this.zzb);
        String string5 = zzk.zzh(this.zzc);
        String string6 = zzk.zzj(this.zzd);
        if (n2 != -1) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(n2);
            stringBuilder.append("bit Luma");
            string3 = stringBuilder.toString();
        } else {
            string3 = "NA";
        }
        if ((n = this.zzg) != -1) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(n);
            stringBuilder.append("bit Chroma");
            string2 = stringBuilder.toString();
        } else {
            string2 = "NA";
        }
        boolean bl = this.zze != null;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ColorInfo(");
        stringBuilder.append(string4);
        stringBuilder.append(", ");
        stringBuilder.append(string5);
        stringBuilder.append(", ");
        stringBuilder.append(string6);
        stringBuilder.append(", ");
        stringBuilder.append(bl);
        stringBuilder.append(", ");
        stringBuilder.append(string3);
        stringBuilder.append(", ");
        stringBuilder.append(string2);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    static {
        zzi zzi2 = new zzi();
        zzi2.zzc(1);
        zzi2.zzb(2);
        zzi2.zzd(3);
        zza = zzi2.zzg();
        zzi zzi3 = new zzi();
        zzi3.zzc(1);
        zzi3.zzb(1);
        zzi3.zzd(2);
        zzi3.zzg();
        Integer.toString(0, 36);
        Integer.toString(1, 36);
        Integer.toString(2, 36);
        Integer.toString(3, 36);
        Integer.toString(4, 36);
        Integer.toString(5, 36);
    }

    /* synthetic */ zzk(int n, int n2, int n3, byte[] byArray, int n4, int n5, zzj zzj2) {
        this.zzb = n;
        this.zzc = n2;
        this.zzd = n3;
        this.zze = byArray;
        this.zzf = n4;
        this.zzg = n5;
    }

    public final boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        object = (zzk)object;
        return this.zzb == ((zzk)object).zzb && this.zzc == ((zzk)object).zzc && this.zzd == ((zzk)object).zzd && Arrays.equals(this.zze, ((zzk)object).zze) && this.zzf == ((zzk)object).zzf && this.zzg == ((zzk)object).zzg;
    }

    public final boolean zze() {
        return this.zzf != -1 && this.zzg != -1;
    }

    public final boolean zzf() {
        return this.zzb != -1 && this.zzc != -1 && this.zzd != -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @EnsuresNonNullIf(result=false, expression={"#1"})
    public static boolean zzg(@Nullable zzk zzk2) {
        int n;
        if (zzk2 == null) {
            return true;
        }
        int n2 = zzk2.zzb;
        if (n2 != -1 && n2 != 1) {
            if (n2 != 2) return 0 != 0;
        }
        if ((n2 = zzk2.zzc) != -1) {
            if (n2 != 2) return 0 != 0;
        }
        if ((n2 = zzk2.zzd) != -1) {
            if (n2 != 3) return 0 != 0;
        }
        if (zzk2.zze != null) return 0 != 0;
        n2 = zzk2.zzg;
        if (n2 != -1) {
            if (n2 != 8) return 0 != 0;
        }
        if ((n = zzk2.zzf) == -1) return 1 != 0;
        if (n == 8) return true;
        return 0 != 0;
    }
}

