/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.request;

import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import com.google.android.gms.ads.internal.request.zzk;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.ads.internal.zzh;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.zzhy;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class LargeParcelTeleporter
implements SafeParcelable {
    public static final Parcelable.Creator<LargeParcelTeleporter> CREATOR = new zzk();
    final int zzzH;
    ParcelFileDescriptor zzzI;
    private Parcelable zzzJ;
    private boolean zzzK;

    LargeParcelTeleporter(int versionCode, ParcelFileDescriptor parcelFileDescriptor) {
        this.zzzH = versionCode;
        this.zzzI = parcelFileDescriptor;
        this.zzzJ = null;
        this.zzzK = true;
    }

    public LargeParcelTeleporter(SafeParcelable teleportee) {
        this.zzzH = 1;
        this.zzzI = null;
        this.zzzJ = teleportee;
        this.zzzK = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends SafeParcelable> T zza(Parcelable.Creator<T> creator) {
        if (this.zzzK) {
            byte[] byArray;
            if (this.zzzI == null) {
                zzb.zzak("File descriptor is empty, returning null.");
                return null;
            }
            DataInputStream dataInputStream = new DataInputStream((InputStream)new ParcelFileDescriptor.AutoCloseInputStream(this.zzzI));
            try {
                byArray = new byte[dataInputStream.readInt()];
                dataInputStream.readFully(byArray, 0, byArray.length);
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Could not read from parcel file descriptor", iOException);
            }
            finally {
                zzhy.zzb((Closeable)dataInputStream);
            }
            Parcel parcel = Parcel.obtain();
            try {
                parcel.unmarshall(byArray, 0, byArray.length);
                parcel.setDataPosition(0);
                this.zzzJ = (SafeParcelable)creator.createFromParcel(parcel);
            }
            finally {
                parcel.recycle();
            }
            this.zzzK = false;
        }
        return (T)((SafeParcelable)this.zzzJ);
    }

    public int describeContents() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToParcel(Parcel dest, int flags) {
        if (this.zzzI == null) {
            byte[] byArray;
            Parcel parcel = Parcel.obtain();
            try {
                this.zzzJ.writeToParcel(parcel, 0);
                byArray = parcel.marshall();
            }
            finally {
                parcel.recycle();
            }
            this.zzzI = this.zzd(byArray);
        }
        zzk.zza(this, dest, flags);
    }

    protected <T> ParcelFileDescriptor zzd(byte[] byArray) {
        try {
            ParcelFileDescriptor[] parcelFileDescriptorArray = ParcelFileDescriptor.createPipe();
            ParcelFileDescriptor parcelFileDescriptor = parcelFileDescriptorArray[1];
            ParcelFileDescriptor.AutoCloseOutputStream autoCloseOutputStream = new ParcelFileDescriptor.AutoCloseOutputStream(parcelFileDescriptor);
            Runnable runnable = new Runnable((OutputStream)autoCloseOutputStream, byArray){
                final /* synthetic */ OutputStream zzzL;
                final /* synthetic */ byte[] zzzM;
                {
                    this.zzzL = outputStream;
                    this.zzzM = byArray;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    DataOutputStream dataOutputStream = new DataOutputStream(this.zzzL);
                    try {
                        dataOutputStream.writeInt(this.zzzM.length);
                        dataOutputStream.write(this.zzzM);
                    }
                    catch (IOException iOException) {
                        zzb.zzb("Error transporting the ad response", iOException);
                        zzh.zzaT().zzc(iOException, true);
                    }
                    finally {
                        zzhy.zzb((Closeable)dataOutputStream);
                    }
                }
            };
            new Thread(runnable).start();
            return parcelFileDescriptorArray[0];
        }
        catch (IOException iOException) {
            zzb.zzb("Error transporting the ad response", iOException);
            zzh.zzaT().zzc(iOException, true);
            return null;
        }
    }
}

