/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.util.client;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.provider.Settings;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.internal.zzeo;
import com.google.android.gms.internal.zzic;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;

@zzeo
public class zza {
    public static final Handler zzCH = new Handler(Looper.getMainLooper());

    public int zzb(Context context, int n) {
        return this.zza(context.getResources().getDisplayMetrics(), n);
    }

    public int zza(DisplayMetrics displayMetrics, int n) {
        return (int)TypedValue.applyDimension((int)1, (float)n, (DisplayMetrics)displayMetrics);
    }

    public int zzc(Context context, int n) {
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        Display display = windowManager.getDefaultDisplay();
        DisplayMetrics displayMetrics = new DisplayMetrics();
        display.getMetrics(displayMetrics);
        return this.zzb(displayMetrics, n);
    }

    public int zzb(DisplayMetrics displayMetrics, int n) {
        return Math.round((float)n / displayMetrics.density);
    }

    public void zza(ViewGroup viewGroup, AdSizeParcel adSizeParcel, String string2, String string3) {
        zzb.zzan(string3);
        this.zza(viewGroup, adSizeParcel, string2, -65536, -16777216);
    }

    public void zza(ViewGroup viewGroup, AdSizeParcel adSizeParcel, String string2) {
        this.zza(viewGroup, adSizeParcel, string2, -16777216, -1);
    }

    private void zza(ViewGroup viewGroup, AdSizeParcel adSizeParcel, String string2, int n, int n2) {
        if (viewGroup.getChildCount() != 0) {
            return;
        }
        Context context = viewGroup.getContext();
        TextView textView = new TextView(context);
        textView.setGravity(17);
        textView.setText((CharSequence)string2);
        textView.setTextColor(n);
        textView.setBackgroundColor(n2);
        FrameLayout frameLayout = new FrameLayout(context);
        frameLayout.setBackgroundColor(n);
        int n3 = this.zzb(context, 3);
        frameLayout.addView((View)textView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(adSizeParcel.widthPixels - n3, adSizeParcel.heightPixels - n3, 17));
        viewGroup.addView((View)frameLayout, adSizeParcel.widthPixels, adSizeParcel.heightPixels);
    }

    public String zzC(Context context) {
        ContentResolver contentResolver = context.getContentResolver();
        String string2 = contentResolver == null ? null : Settings.Secure.getString((ContentResolver)contentResolver, (String)"android_id");
        return this.zzai(string2 == null || this.zzfj() ? "emulator" : string2);
    }

    public boolean zzfj() {
        return Build.DEVICE.startsWith("generic");
    }

    public boolean zzfk() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    public String zzai(String string2) {
        for (int i = 0; i < 2; ++i) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                messageDigest.update(string2.getBytes());
                return String.format(Locale.US, "%032X", new BigInteger(1, messageDigest.digest()));
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                continue;
            }
        }
        return null;
    }

    public boolean zzD(Context context) {
        return 0 == GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)context);
    }

    public boolean zzE(Context context) {
        if (context.getResources().getConfiguration().orientation != 2) {
            return false;
        }
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        return (int)((float)displayMetrics.heightPixels / displayMetrics.density) < 600;
    }

    public boolean zzF(Context context) {
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        Display display = windowManager.getDefaultDisplay();
        int n = 0;
        int n2 = 0;
        if (zzic.zznj()) {
            display.getRealMetrics(displayMetrics);
            n = displayMetrics.heightPixels;
            n2 = displayMetrics.widthPixels;
        } else {
            try {
                n = (Integer)Display.class.getMethod("getRawHeight", new Class[0]).invoke((Object)display, new Object[0]);
                n2 = (Integer)Display.class.getMethod("getRawWidth", new Class[0]).invoke((Object)display, new Object[0]);
            }
            catch (Exception exception) {
                return false;
            }
        }
        display.getMetrics(displayMetrics);
        int n3 = displayMetrics.heightPixels;
        int n4 = displayMetrics.widthPixels;
        return n3 == n && n4 == n2;
    }

    public int zzG(Context context) {
        int n = context.getResources().getIdentifier("navigation_bar_width", "dimen", "android");
        if (n > 0) {
            return context.getResources().getDimensionPixelSize(n);
        }
        return 0;
    }
}

