/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import com.google.android.gms.ads.internal.client.zzj;
import com.google.android.gms.ads.internal.util.client.zza;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.ads.internal.zzh;
import com.google.android.gms.internal.zzat;
import com.google.android.gms.internal.zzeo;
import com.google.android.gms.internal.zzfq;
import com.google.android.gms.internal.zzgd;
import com.google.android.gms.internal.zzht;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

@zzeo
public class zzcd {
    private static final Set<String> zztQ = Collections.synchronizedSet(new HashSet());
    private zzgd zznp;
    private File zztR;
    private boolean zztS;

    public zzcd(zzgd zzgd2) {
        this.zznp = zzgd2;
        Context context = zzgd2.getContext();
        File file = context.getCacheDir();
        if (file == null) {
            zzb.zzan("Context.getCacheDir() returned null");
            return;
        }
        this.zztR = new File(file, "admobVideoStreams");
        if (!this.zztR.mkdirs() && !this.zztR.isDirectory()) {
            zzb.zzan("Could not create preload cache directory at " + this.zztR.getAbsolutePath());
            this.zztR = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean zzI(String string) {
        if (this.zztR == null) {
            this.zza(string, null);
            return false;
        }
        while (this.zzcY() > zzat.zzrs.get()) {
            if (this.zzcZ()) continue;
            zzb.zzan("Unable to expire stream cache");
            this.zza(string, null);
            return false;
        }
        String string2 = this.zzJ(string);
        File file = new File(this.zztR, string2);
        File file2 = this.zza(file);
        if (file.isFile() && file2.isFile()) {
            int n = (int)file.length();
            zzb.zzaj("Stream cache hit at " + string);
            this.zza(string, file, n);
            return true;
        }
        String string3 = this.zztR.getAbsolutePath() + string;
        Object object = zztQ;
        synchronized (object) {
            if (zztQ.contains(string3)) {
                zzb.zzan("Stream cache already in progress at " + string);
                this.zza(string, file);
                return false;
            }
            zztQ.add(string3);
        }
        try {
            int n;
            int n2;
            object = new URL(string).openConnection();
            int n3 = zzat.zzrw.get();
            ((URLConnection)object).setConnectTimeout(n3);
            ((URLConnection)object).setReadTimeout(n3);
            if (object instanceof HttpURLConnection && (n2 = ((HttpURLConnection)object).getResponseCode()) >= 400) {
                throw new IOException("HTTP status code " + n2 + " at " + string);
            }
            n2 = ((URLConnection)object).getContentLength();
            if (n2 < 0) {
                zzb.zzan("Stream cache aborted, missing content-length header at " + string);
                this.zza(string, file);
                zztQ.remove(string3);
                return false;
            }
            String string4 = new DecimalFormat("#,###").format(n2);
            int n4 = zzat.zzrt.get();
            if (n2 > n4) {
                zzb.zzan("Content length " + string4 + " exceeds limit at " + string);
                this.zza(string, file);
                zztQ.remove(string3);
                return false;
            }
            zzb.zzaj("Caching " + string4 + " bytes from " + string);
            InputStream inputStream = ((URLConnection)object).getInputStream();
            ReadableByteChannel readableByteChannel = Channels.newChannel(inputStream);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            FileChannel fileChannel = fileOutputStream.getChannel();
            ByteBuffer byteBuffer = ByteBuffer.allocate(0x100000);
            zzht zzht2 = zzh.zzaU();
            int n5 = 0;
            long l = zzht2.currentTimeMillis();
            long l2 = zzat.zzrv.get();
            zzfq zzfq2 = new zzfq(l2);
            long l3 = zzat.zzru.get();
            while ((n = readableByteChannel.read(byteBuffer)) >= 0) {
                if ((n5 += n) > n4) {
                    throw new IOException("stream cache file size limit exceeded");
                }
                byteBuffer.flip();
                while (fileChannel.write(byteBuffer) > 0) {
                }
                byteBuffer.clear();
                long l4 = zzht2.currentTimeMillis();
                if (l4 - l > l3 * 1000L) {
                    throw new IOException("stream cache time limit exceeded");
                }
                if (this.zztS) {
                    throw new IOException("abort requested");
                }
                if (!zzfq2.tryAcquire()) continue;
                this.zza(string, file, n5, n2);
            }
            fileOutputStream.close();
            if (zzb.zzC(3)) {
                String string5 = new DecimalFormat("#,###").format(n5);
                zzb.zzaj("Preloaded " + string5 + " bytes from " + string);
            }
            zzcd.zzb(file2);
            this.zza(string, file, n5);
            zztQ.remove(string3);
            return true;
        }
        catch (IOException iOException) {
            if (this.zztS) {
                zzb.zzan("Preload aborted for URL \"" + string + "\"");
            } else {
                zzb.zzd("Preload failed for URL \"" + string + "\"", iOException);
            }
            if (file.exists() && !file.delete()) {
                zzb.zzan("Could not delete partial cache file at " + file.getAbsolutePath());
            }
            this.zza(string, file);
            zztQ.remove(string3);
            return false;
        }
    }

    public void abort() {
        this.zztS = true;
    }

    public int zzcY() {
        if (this.zztR == null) {
            return 0;
        }
        int n = 0;
        for (File file : this.zztR.listFiles()) {
            if (file.getName().endsWith(".done")) continue;
            ++n;
        }
        return n;
    }

    public boolean zzcZ() {
        if (this.zztR == null) {
            return false;
        }
        File file = null;
        long l = Long.MAX_VALUE;
        for (File file2 : this.zztR.listFiles()) {
            long l2;
            if (file2.getName().endsWith(".done") || (l2 = file2.lastModified()) >= l) continue;
            file = file2;
            l = l2;
        }
        boolean bl = false;
        if (file != null) {
            bl = file.delete();
            File file3 = this.zza(file);
            if (file3.isFile()) {
                bl &= file3.delete();
            }
        }
        return bl;
    }

    private void zza(final String string, final File file, final int n, final int n2) {
        zza.zzCH.post(new Runnable(){

            @Override
            public void run() {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("event", "precacheProgress");
                hashMap.put("src", string);
                hashMap.put("cachedSrc", file.getAbsolutePath());
                hashMap.put("bytesLoaded", Integer.toString(n));
                hashMap.put("totalBytes", Integer.toString(n2));
                zzcd.this.zznp.zzb("onPrecacheEvent", hashMap);
            }
        });
    }

    private void zza(final String string, final File file, final int n) {
        zza.zzCH.post(new Runnable(){

            @Override
            public void run() {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("event", "precacheComplete");
                hashMap.put("src", string);
                hashMap.put("cachedSrc", file.getAbsolutePath());
                hashMap.put("totalBytes", Integer.toString(n));
                zzcd.this.zznp.zzb("onPrecacheEvent", hashMap);
            }
        });
    }

    private void zza(final String string, final File file) {
        zza.zzCH.post(new Runnable(){

            @Override
            public void run() {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("event", "precacheCanceled");
                hashMap.put("src", string);
                if (file != null) {
                    hashMap.put("cachedSrc", file.getAbsolutePath());
                }
                zzcd.this.zznp.zzb("onPrecacheEvent", hashMap);
            }
        });
    }

    private String zzJ(String string) {
        return zzj.zzbJ().zzai(string);
    }

    private File zza(File file) {
        return new File(this.zztR, file.getName() + ".done");
    }

    private static void zzb(File file) {
        if (file.isFile()) {
            file.setLastModified(System.currentTimeMillis());
        } else {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

