/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.provider.CalendarContract;
import android.text.TextUtils;
import com.google.android.gms.R;
import com.google.android.gms.ads.internal.zzh;
import com.google.android.gms.internal.zzak;
import com.google.android.gms.internal.zzdg;
import com.google.android.gms.internal.zzeo;
import com.google.android.gms.internal.zzgd;
import java.util.Map;

@zzeo
public class zzda
extends zzdg {
    private final Map<String, String> zzvi;
    private final Context mContext;
    private String zzvj;
    private long zzvk;
    private long zzvl;
    private String zzvm;
    private String zzvn;

    public zzda(zzgd zzgd2, Map<String, String> map) {
        super(zzgd2, "createCalendarEvent");
        this.zzvi = map;
        this.mContext = zzgd2.zzfp();
        this.zzdd();
    }

    private void zzdd() {
        this.zzvj = this.zzN("description");
        this.zzvm = this.zzN("summary");
        this.zzvk = this.zzO("start_ticks");
        this.zzvl = this.zzO("end_ticks");
        this.zzvn = this.zzN("location");
    }

    private String zzN(String string2) {
        return TextUtils.isEmpty((CharSequence)this.zzvi.get(string2)) ? "" : this.zzvi.get(string2);
    }

    private long zzO(String string2) {
        String string3 = this.zzvi.get(string2);
        if (string3 == null) {
            return -1L;
        }
        try {
            return Long.parseLong(string3);
        }
        catch (NumberFormatException numberFormatException) {
            return -1L;
        }
    }

    public void execute() {
        if (this.mContext == null) {
            this.zzQ("Activity context is not available.");
            return;
        }
        zzak zzak2 = zzh.zzaQ().zzz(this.mContext);
        if (!zzak2.zzca()) {
            this.zzQ("This feature is not available on the device.");
            return;
        }
        AlertDialog.Builder builder = zzh.zzaQ().zzy(this.mContext);
        builder.setTitle((CharSequence)zzh.zzaT().zzc(R.string.create_calendar_title, "Create calendar event"));
        builder.setMessage((CharSequence)zzh.zzaT().zzc(R.string.create_calendar_message, "Allow Ad to create a calendar event?"));
        builder.setPositiveButton((CharSequence)zzh.zzaT().zzc(R.string.accept, "Accept"), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                Intent intent = zzda.this.createIntent();
                zzda.this.mContext.startActivity(intent);
            }
        });
        builder.setNegativeButton((CharSequence)zzh.zzaT().zzc(R.string.decline, "Decline"), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                zzda.this.zzQ("Operation denied by user.");
            }
        });
        builder.create().show();
    }

    Intent createIntent() {
        Intent intent = new Intent("android.intent.action.EDIT").setData(CalendarContract.Events.CONTENT_URI);
        intent.putExtra("title", this.zzvj);
        intent.putExtra("eventLocation", this.zzvn);
        intent.putExtra("description", this.zzvm);
        if (this.zzvk > -1L) {
            intent.putExtra("beginTime", this.zzvk);
        }
        if (this.zzvl > -1L) {
            intent.putExtra("endTime", this.zzvl);
        }
        intent.setFlags(0x10000000);
        return intent;
    }
}

