/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.RelativeLayout;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.zzj;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.ads.internal.zzh;
import com.google.android.gms.internal.zzdg;
import com.google.android.gms.internal.zzdh;
import com.google.android.gms.internal.zzeo;
import com.google.android.gms.internal.zzgd;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@zzeo
public class zzdb
extends zzdg {
    static final Set<String> zzvp = new HashSet<String>(Arrays.asList("top-left", "top-right", "top-center", "center", "bottom-left", "bottom-right", "bottom-center"));
    private String zzvq = "top-right";
    private boolean zzvr = true;
    private int zzvs = 0;
    private int zzvt = 0;
    private int zzmb = -1;
    private int zzvu = 0;
    private int zzvv = 0;
    private int zzma = -1;
    private final Object zzoe = new Object();
    private final zzgd zznp;
    private final Activity zzvw;
    private AdSizeParcel zzuO;
    private ImageView zzvx;
    private LinearLayout zzvy;
    private zzdh zzvz;
    private PopupWindow zzvA;
    private RelativeLayout zzvB;
    private ViewGroup zzvC;

    public zzdb(zzgd zzgd2, zzdh zzdh2) {
        super(zzgd2, "resize");
        this.zznp = zzgd2;
        this.zzvw = zzgd2.zzfp();
        this.zzvz = zzdh2;
    }

    private void zzf(Map<String, String> map) {
        String string;
        if (!TextUtils.isEmpty((CharSequence)map.get("width"))) {
            this.zzma = zzh.zzaQ().zzae(map.get("width"));
        }
        if (!TextUtils.isEmpty((CharSequence)map.get("height"))) {
            this.zzmb = zzh.zzaQ().zzae(map.get("height"));
        }
        if (!TextUtils.isEmpty((CharSequence)map.get("offsetX"))) {
            this.zzvu = zzh.zzaQ().zzae(map.get("offsetX"));
        }
        if (!TextUtils.isEmpty((CharSequence)map.get("offsetY"))) {
            this.zzvv = zzh.zzaQ().zzae(map.get("offsetY"));
        }
        if (!TextUtils.isEmpty((CharSequence)map.get("allowOffscreen"))) {
            this.zzvr = Boolean.parseBoolean(map.get("allowOffscreen"));
        }
        if (!TextUtils.isEmpty((CharSequence)(string = map.get("customClosePosition")))) {
            this.zzvq = string;
        }
    }

    boolean zzde() {
        return this.zzma > -1 && this.zzmb > -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzg(Map<String, String> map) {
        Object object = this.zzoe;
        synchronized (object) {
            Bitmap bitmap;
            if (this.zzvw == null) {
                this.zzQ("Not an activity context. Cannot resize.");
                return;
            }
            if (this.zznp.zzah() == null) {
                this.zzQ("Webview is not yet available, size is not set.");
                return;
            }
            if (this.zznp.zzah().zzpY) {
                this.zzQ("Is interstitial. Cannot resize an interstitial.");
                return;
            }
            if (this.zznp.zzfx()) {
                this.zzQ("Cannot resize an expanded banner.");
                return;
            }
            this.zzf(map);
            if (!this.zzde()) {
                this.zzQ("Invalid width and height options. Cannot resize.");
                return;
            }
            Window window = this.zzvw.getWindow();
            if (window == null || window.getDecorView() == null) {
                this.zzQ("Activity context is not ready, cannot get window or decor view.");
                return;
            }
            int[] nArray = this.zzdf();
            if (nArray == null) {
                this.zzQ("Resize location out of screen or close button is not visible.");
                return;
            }
            int n = zzj.zzbJ().zzb((Context)this.zzvw, this.zzma);
            int n2 = zzj.zzbJ().zzb((Context)this.zzvw, this.zzmb);
            ViewParent viewParent = this.zznp.getWebView().getParent();
            if (viewParent != null && viewParent instanceof ViewGroup) {
                ((ViewGroup)viewParent).removeView((View)this.zznp.getWebView());
                if (this.zzvA == null) {
                    this.zzvC = (ViewGroup)viewParent;
                    bitmap = zzh.zzaQ().zzj((View)this.zznp.getWebView());
                    this.zzvx = new ImageView((Context)this.zzvw);
                    this.zzvx.setImageBitmap(bitmap);
                    this.zzuO = this.zznp.zzah();
                    this.zzvC.addView((View)this.zzvx);
                } else {
                    this.zzvA.dismiss();
                }
            } else {
                this.zzQ("Webview is detached, probably in the middle of a resize or expand.");
                return;
            }
            this.zzvB = new RelativeLayout((Context)this.zzvw);
            this.zzvB.setBackgroundColor(0);
            this.zzvB.setLayoutParams(new ViewGroup.LayoutParams(n, n2));
            this.zzvA = zzh.zzaQ().zza((View)this.zzvB, n, n2, false);
            this.zzvA.setOutsideTouchable(true);
            this.zzvA.setTouchable(true);
            this.zzvA.setClippingEnabled(!this.zzvr);
            this.zzvB.addView((View)this.zznp.getWebView(), -1, -1);
            this.zzvy = new LinearLayout((Context)this.zzvw);
            bitmap = new RelativeLayout.LayoutParams(zzj.zzbJ().zzb((Context)this.zzvw, 50), zzj.zzbJ().zzb((Context)this.zzvw, 50));
            switch (this.zzvq) {
                case "top-left": {
                    bitmap.addRule(10);
                    bitmap.addRule(9);
                    break;
                }
                case "top-center": {
                    bitmap.addRule(10);
                    bitmap.addRule(14);
                    break;
                }
                case "center": {
                    bitmap.addRule(13);
                    break;
                }
                case "bottom-left": {
                    bitmap.addRule(12);
                    bitmap.addRule(9);
                    break;
                }
                case "bottom-center": {
                    bitmap.addRule(12);
                    bitmap.addRule(14);
                    break;
                }
                case "bottom-right": {
                    bitmap.addRule(12);
                    bitmap.addRule(11);
                    break;
                }
                default: {
                    bitmap.addRule(10);
                    bitmap.addRule(11);
                }
            }
            this.zzvy.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    zzdb.this.zzn(true);
                }
            });
            this.zzvy.setContentDescription((CharSequence)"Close button");
            this.zzvB.addView((View)this.zzvy, (ViewGroup.LayoutParams)bitmap);
            try {
                this.zzvA.showAtLocation(window.getDecorView(), 0, zzj.zzbJ().zzb((Context)this.zzvw, nArray[0]), zzj.zzbJ().zzb((Context)this.zzvw, nArray[1]));
            }
            catch (RuntimeException runtimeException) {
                this.zzQ("Cannot show popup window: " + runtimeException.getMessage());
                this.zzvB.removeView((View)this.zznp.getWebView());
                if (this.zzvC != null) {
                    this.zzvC.removeView((View)this.zzvx);
                    this.zzvC.addView((View)this.zznp.getWebView());
                    this.zznp.zza(this.zzuO);
                }
                return;
            }
            this.zzb(nArray[0], nArray[1]);
            this.zznp.zza(new AdSizeParcel((Context)this.zzvw, new AdSize(this.zzma, this.zzmb)));
            this.zzc(nArray[0], nArray[1]);
            this.zzS("resized");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzn(boolean bl) {
        Object object = this.zzoe;
        synchronized (object) {
            if (this.zzvA != null) {
                this.zzvA.dismiss();
                this.zzvB.removeView((View)this.zznp.getWebView());
                if (this.zzvC != null) {
                    this.zzvC.removeView((View)this.zzvx);
                    this.zzvC.addView((View)this.zznp.getWebView());
                    this.zznp.zza(this.zzuO);
                }
                if (bl) {
                    this.zzS("default");
                    if (this.zzvz != null) {
                        this.zzvz.zzaq();
                    }
                }
                this.zzvA = null;
                this.zzvB = null;
                this.zzvC = null;
                this.zzvy = null;
            }
        }
    }

    private int[] zzdf() {
        if (!this.zzdh()) {
            return null;
        }
        if (this.zzvr) {
            return new int[]{this.zzvs + this.zzvu, this.zzvt + this.zzvv};
        }
        int[] nArray = zzh.zzaQ().zzh(this.zzvw);
        int[] nArray2 = zzh.zzaQ().zzj(this.zzvw);
        int n = nArray[0];
        int n2 = this.zzvs + this.zzvu;
        int n3 = this.zzvt + this.zzvv;
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 + this.zzma > n) {
            n2 = n - this.zzma;
        }
        if (n3 < nArray2[0]) {
            n3 = nArray2[0];
        } else if (n3 + this.zzmb > nArray2[1]) {
            n3 = nArray2[1] - this.zzmb;
        }
        return new int[]{n2, n3};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(int n, int n2, boolean bl) {
        Object object = this.zzoe;
        synchronized (object) {
            this.zzvs = n;
            this.zzvt = n2;
            if (this.zzvA != null && bl) {
                int[] nArray = this.zzdf();
                if (nArray != null) {
                    this.zzvA.update(zzj.zzbJ().zzb((Context)this.zzvw, nArray[0]), zzj.zzbJ().zzb((Context)this.zzvw, nArray[1]), this.zzvA.getWidth(), this.zzvA.getHeight());
                    this.zzc(nArray[0], nArray[1]);
                } else {
                    this.zzn(true);
                }
            }
        }
    }

    void zzb(int n, int n2) {
        if (this.zzvz != null) {
            this.zzvz.zza(n, n2, this.zzma, this.zzmb);
        }
    }

    void zzc(int n, int n2) {
        int n3 = zzh.zzaQ().zzj(this.zzvw)[0];
        this.zzb(n, n2 - n3, this.zzma, this.zzmb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean zzdg() {
        Object object = this.zzoe;
        synchronized (object) {
            return this.zzvA != null;
        }
    }

    public void zzd(int n, int n2) {
        this.zzvs = n;
        this.zzvt = n2;
    }

    boolean zzdh() {
        int[] nArray = zzh.zzaQ().zzh(this.zzvw);
        int[] nArray2 = zzh.zzaQ().zzj(this.zzvw);
        int n = nArray[0];
        int n2 = nArray[1];
        if (this.zzma < 50 || this.zzma > n) {
            zzb.zzan("Width is too small or too large.");
            return false;
        }
        if (this.zzmb < 50 || this.zzmb > n2) {
            zzb.zzan("Height is too small or too large.");
            return false;
        }
        if (this.zzmb == n2 && this.zzma == n) {
            zzb.zzan("Cannot resize to a full-screen ad.");
            return false;
        }
        if (this.zzvr) {
            int n3 = -1;
            int n4 = -2;
            switch (this.zzvq) {
                case "top-left": {
                    n3 = this.zzvs + this.zzvu;
                    n4 = this.zzvt + this.zzvv;
                    break;
                }
                case "top-center": {
                    n3 = this.zzvs + this.zzvu + this.zzma / 2 - 25;
                    n4 = this.zzvt + this.zzvv;
                    break;
                }
                case "center": {
                    n3 = this.zzvs + this.zzvu + this.zzma / 2 - 25;
                    n4 = this.zzvt + this.zzvv + this.zzmb / 2 - 25;
                    break;
                }
                case "bottom-left": {
                    n3 = this.zzvs + this.zzvu;
                    n4 = this.zzvt + this.zzvv + this.zzmb - 50;
                    break;
                }
                case "bottom-center": {
                    n3 = this.zzvs + this.zzvu + this.zzma / 2 - 25;
                    n4 = this.zzvt + this.zzvv + this.zzmb - 50;
                    break;
                }
                case "bottom-right": {
                    n3 = this.zzvs + this.zzvu + this.zzma - 50;
                    n4 = this.zzvt + this.zzvv + this.zzmb - 50;
                    break;
                }
                default: {
                    n3 = this.zzvs + this.zzvu + this.zzma - 50;
                    n4 = this.zzvt + this.zzvv;
                }
            }
            if (n3 < 0 || n3 + 50 > n || n4 < nArray2[0] || n4 + 50 > nArray2[1]) {
                return false;
            }
        }
        return true;
    }
}

