/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.AlertDialog;
import android.app.KeyguardManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.PowerManager;
import android.os.Process;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.view.WindowManager;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.widget.PopupWindow;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.zzj;
import com.google.android.gms.ads.internal.overlay.AdOverlayInfoParcel;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.ads.internal.zzh;
import com.google.android.gms.internal.zzak;
import com.google.android.gms.internal.zzat;
import com.google.android.gms.internal.zzeo;
import com.google.android.gms.internal.zzfi;
import com.google.android.gms.internal.zzfp;
import com.google.android.gms.internal.zzgd;
import com.google.android.gms.internal.zzk;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzeo
public class zzfl {
    public static final Handler zzCr = new zzfi(Looper.getMainLooper());
    private final Object zzoe = new Object();
    private boolean zzCs = true;
    private String zzBW;
    private boolean zzCt = false;

    public void zza(Context context, String string, boolean bl, HttpURLConnection httpURLConnection) {
        this.zza(context, string, bl, httpURLConnection, false);
    }

    public void zza(Context context, String string, boolean bl, HttpURLConnection httpURLConnection, boolean bl2) {
        httpURLConnection.setConnectTimeout(60000);
        httpURLConnection.setInstanceFollowRedirects(bl);
        httpURLConnection.setReadTimeout(60000);
        httpURLConnection.setRequestProperty("User-Agent", this.zzf(context, string));
        httpURLConnection.setUseCaches(bl2);
    }

    public void zza(Context context, String string, boolean bl, HttpURLConnection httpURLConnection, String string2) {
        httpURLConnection.setConnectTimeout(60000);
        httpURLConnection.setInstanceFollowRedirects(bl);
        httpURLConnection.setReadTimeout(60000);
        httpURLConnection.setRequestProperty("User-Agent", string2);
        httpURLConnection.setUseCaches(false);
    }

    public boolean zzv(Context context) {
        Intent intent = new Intent();
        intent.setClassName(context, "com.google.android.gms.ads.AdActivity");
        PackageManager packageManager = context.getPackageManager();
        ResolveInfo resolveInfo = packageManager.resolveActivity(intent, 65536);
        boolean bl = true;
        if (resolveInfo == null || resolveInfo.activityInfo == null) {
            zzb.zzan("Could not find com.google.android.gms.ads.AdActivity, please make sure it is declared in AndroidManifest.xml.");
            bl = false;
        } else {
            String string = "com.google.android.gms.ads.AdActivity requires the android:configChanges value to contain \"%s\".";
            if ((resolveInfo.activityInfo.configChanges & 0x10) == 0) {
                zzb.zzan(String.format(string, "keyboard"));
                bl = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x20) == 0) {
                zzb.zzan(String.format(string, "keyboardHidden"));
                bl = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x80) == 0) {
                zzb.zzan(String.format(string, "orientation"));
                bl = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x100) == 0) {
                zzb.zzan(String.format(string, "screenLayout"));
                bl = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x200) == 0) {
                zzb.zzan(String.format(string, "uiMode"));
                bl = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x400) == 0) {
                zzb.zzan(String.format(string, "screenSize"));
                bl = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x800) == 0) {
                zzb.zzan(String.format(string, "smallestScreenSize"));
                bl = false;
            }
        }
        return bl;
    }

    public boolean zza(PackageManager packageManager, String string, String string2) {
        return packageManager.checkPermission(string2, string) == 0;
    }

    public boolean zzeZ() {
        return this.zzCs;
    }

    public void zza(Context context, String string, List<String> list) {
        for (String string2 : list) {
            new zzfp(context, string, string2).zzeW();
        }
    }

    public void zzc(Context context, String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string2);
        this.zza(context, string, arrayList);
    }

    public void zza(Context context, String string, List<String> list, String string2) {
        for (String string3 : list) {
            new zzfp(context, string, string3, string2).zzeW();
        }
    }

    public String zza(InputStreamReader inputStreamReader) throws IOException {
        int n;
        StringBuilder stringBuilder = new StringBuilder(8192);
        char[] cArray = new char[2048];
        while ((n = inputStreamReader.read(cArray)) != -1) {
            stringBuilder.append(cArray, 0, n);
        }
        return stringBuilder.toString();
    }

    public boolean zzw(Context context) {
        if (this.zzCt) {
            return false;
        }
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.USER_PRESENT");
        intentFilter.addAction("android.intent.action.SCREEN_OFF");
        context.getApplicationContext().registerReceiver((BroadcastReceiver)new zza(), intentFilter);
        this.zzCt = true;
        return true;
    }

    public void zza(Context context, String string, WebSettings webSettings) {
        webSettings.setUserAgentString(this.zzf(context, string));
    }

    String zzfa() {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("Mozilla/5.0 (Linux; U; Android");
        if (Build.VERSION.RELEASE != null) {
            stringBuffer.append(" ").append(Build.VERSION.RELEASE);
        }
        stringBuffer.append("; ").append(Locale.getDefault());
        if (Build.DEVICE != null) {
            stringBuffer.append("; ").append(Build.DEVICE);
            if (Build.DISPLAY != null) {
                stringBuffer.append(" Build/").append(Build.DISPLAY);
            }
        }
        stringBuffer.append(") AppleWebKit/533 Version/4.0 Safari/533");
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String zzf(final Context context, String string) {
        Object object = this.zzoe;
        synchronized (object) {
            if (this.zzBW != null) {
                return this.zzBW;
            }
            try {
                this.zzBW = zzh.zzaS().getDefaultUserAgent(context);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (TextUtils.isEmpty((CharSequence)this.zzBW)) {
                if (!zzj.zzbJ().zzfk()) {
                    this.zzBW = null;
                    zzCr.post(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Object object = zzfl.this.zzoe;
                            synchronized (object) {
                                zzfl.this.zzBW = zzfl.this.zzx(context);
                                zzfl.this.zzoe.notifyAll();
                            }
                        }
                    });
                    while (this.zzBW == null) {
                        try {
                            this.zzoe.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            this.zzBW = this.zzfa();
                            zzb.zzan("Interrupted, use default user agent: " + this.zzBW);
                        }
                    }
                } else {
                    try {
                        this.zzBW = this.zzx(context);
                    }
                    catch (Exception exception) {
                        this.zzBW = this.zzfa();
                    }
                }
            }
            this.zzBW = this.zzBW + " (Mobile; " + string + ")";
            return this.zzBW;
        }
    }

    protected String zzx(Context context) {
        return new WebView(context).getSettings().getUserAgentString();
    }

    public boolean zza(ClassLoader classLoader, Class<?> clazz, String string) {
        try {
            Class<?> clazz2 = Class.forName(string, false, classLoader);
            return clazz.isAssignableFrom(clazz2);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public String zzad(String string) {
        return Uri.parse((String)string).buildUpon().query(null).build().toString();
    }

    public JSONObject zzx(Map<String, ?> map) throws JSONException {
        try {
            JSONObject jSONObject = new JSONObject();
            for (String string : map.keySet()) {
                this.zza(jSONObject, string, map.get(string));
            }
            return jSONObject;
        }
        catch (ClassCastException classCastException) {
            throw new JSONException("Could not convert map to JSON: " + classCastException.getMessage());
        }
    }

    private JSONObject zzd(Bundle bundle) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        for (String string : bundle.keySet()) {
            this.zza(jSONObject, string, bundle.get(string));
        }
        return jSONObject;
    }

    private JSONArray zza(Collection<?> collection) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        for (Object obj : collection) {
            this.zza(jSONArray, obj);
        }
        return jSONArray;
    }

    JSONArray zza(Object[] objectArray) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        for (Object object : objectArray) {
            this.zza(jSONArray, object);
        }
        return jSONArray;
    }

    private void zza(JSONArray jSONArray, Object object) throws JSONException {
        if (object instanceof Bundle) {
            jSONArray.put((Object)this.zzd((Bundle)object));
        } else if (object instanceof Map) {
            Map map = (Map)object;
            jSONArray.put((Object)this.zzx(map));
        } else if (object instanceof Collection) {
            jSONArray.put((Object)this.zza((Collection)object));
        } else if (object instanceof Object[]) {
            jSONArray.put((Object)this.zza((Object[])object));
        } else {
            jSONArray.put(object);
        }
    }

    private void zza(JSONObject jSONObject, String string, Object object) throws JSONException {
        if (object instanceof Bundle) {
            jSONObject.put(string, (Object)this.zzd((Bundle)object));
        } else if (object instanceof Map) {
            Map map = (Map)object;
            jSONObject.put(string, (Object)this.zzx(map));
        } else if (object instanceof Collection) {
            jSONObject.put(string != null ? string : "null", (Object)this.zza((Collection)object));
        } else if (object instanceof Object[]) {
            jSONObject.put(string, (Object)this.zza(Arrays.asList((Object[])object)));
        } else {
            jSONObject.put(string, object);
        }
    }

    public Map<String, String> zzd(Uri uri) {
        if (uri == null) {
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Set<String> set = zzh.zzaS().zze(uri);
        for (String string : set) {
            hashMap.put(string, uri.getQueryParameter(string));
        }
        return hashMap;
    }

    public String zzfb() {
        UUID uUID = UUID.randomUUID();
        byte[] byArray = BigInteger.valueOf(uUID.getLeastSignificantBits()).toByteArray();
        byte[] byArray2 = BigInteger.valueOf(uUID.getMostSignificantBits()).toByteArray();
        String string = new BigInteger(1, byArray).toString();
        for (int i = 0; i < 2; ++i) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                messageDigest.update(byArray);
                messageDigest.update(byArray2);
                byte[] byArray3 = new byte[8];
                System.arraycopy(messageDigest.digest(), 0, byArray3, 0, 8);
                string = new BigInteger(1, byArray3).toString();
                continue;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        return string;
    }

    public int zzae(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            zzb.zzan("Could not parse value:" + numberFormatException);
            return 0;
        }
    }

    public String zzfc() {
        String string = Build.MODEL;
        String string2 = Build.MANUFACTURER;
        return string.startsWith(string2) ? string : string2 + " " + string;
    }

    protected int[] zzfd() {
        return new int[]{0, 0};
    }

    public int[] zzg(Activity activity) {
        View view;
        Window window = activity.getWindow();
        if (window != null && (view = window.findViewById(0x1020002)) != null) {
            return new int[]{view.getWidth(), view.getHeight()};
        }
        return this.zzfd();
    }

    public int[] zzh(Activity activity) {
        int[] nArray = this.zzg(activity);
        return new int[]{zzj.zzbJ().zzc((Context)activity, nArray[0]), zzj.zzbJ().zzc((Context)activity, nArray[1])};
    }

    public int[] zzi(Activity activity) {
        View view;
        Window window = activity.getWindow();
        if (window != null && (view = window.findViewById(0x1020002)) != null) {
            return new int[]{view.getTop(), view.getBottom()};
        }
        return this.zzfd();
    }

    public int[] zzj(Activity activity) {
        int[] nArray = this.zzi(activity);
        return new int[]{zzj.zzbJ().zzc((Context)activity, nArray[0]), zzj.zzbJ().zzc((Context)activity, nArray[1])};
    }

    public boolean zzaf(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        return string.matches("([^\\s]+(\\.(?i)(jpg|png|gif|bmp|webp))$)");
    }

    public void zza(Activity activity, ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener) {
        Window window = activity.getWindow();
        if (window != null && window.getDecorView() != null && window.getDecorView().getViewTreeObserver() != null) {
            window.getDecorView().getViewTreeObserver().addOnGlobalLayoutListener(onGlobalLayoutListener);
        }
    }

    public void zza(Activity activity, ViewTreeObserver.OnScrollChangedListener onScrollChangedListener) {
        Window window = activity.getWindow();
        if (window != null && window.getDecorView() != null && window.getDecorView().getViewTreeObserver() != null) {
            window.getDecorView().getViewTreeObserver().addOnScrollChangedListener(onScrollChangedListener);
        }
    }

    public void zzb(Activity activity, ViewTreeObserver.OnScrollChangedListener onScrollChangedListener) {
        Window window = activity.getWindow();
        if (window != null && window.getDecorView() != null && window.getDecorView().getViewTreeObserver() != null) {
            window.getDecorView().getViewTreeObserver().removeOnScrollChangedListener(onScrollChangedListener);
        }
    }

    public DisplayMetrics zza(WindowManager windowManager) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        Display display = windowManager.getDefaultDisplay();
        display.getMetrics(displayMetrics);
        return displayMetrics;
    }

    public AlertDialog.Builder zzy(Context context) {
        return new AlertDialog.Builder(context);
    }

    public zzak zzz(Context context) {
        return new zzak(context);
    }

    public Bitmap zzj(View view) {
        view.setDrawingCacheEnabled(true);
        Bitmap bitmap = Bitmap.createBitmap((Bitmap)view.getDrawingCache());
        view.setDrawingCacheEnabled(false);
        return bitmap;
    }

    public PopupWindow zza(View view, int n, int n2, boolean bl) {
        return new PopupWindow(view, n, n2, bl);
    }

    public String zzA(Context context) {
        try {
            ActivityManager.RunningTaskInfo runningTaskInfo;
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            if (activityManager == null) {
                return null;
            }
            List list = activityManager.getRunningTasks(1);
            if (list != null && !list.isEmpty() && (runningTaskInfo = (ActivityManager.RunningTaskInfo)list.get(0)) != null && runningTaskInfo.topActivity != null) {
                return runningTaskInfo.topActivity.getClassName();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public String zza(Context context, View view, AdSizeParcel adSizeParcel) {
        if (!zzat.zzrR.get().booleanValue()) {
            return null;
        }
        try {
            JSONObject jSONObject = new JSONObject();
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put("width", adSizeParcel.width);
            jSONObject2.put("height", adSizeParcel.height);
            jSONObject.put("size", (Object)jSONObject2);
            jSONObject.put("activity", (Object)this.zzA(context));
            if (!adSizeParcel.zzpY) {
                JSONArray jSONArray = new JSONArray();
                View view2 = view;
                while (view2 != null) {
                    ViewParent viewParent = view2.getParent();
                    if (viewParent != null) {
                        int n = -1;
                        if (viewParent instanceof ViewGroup) {
                            n = ((ViewGroup)viewParent).indexOfChild(view2);
                        }
                        JSONObject jSONObject3 = new JSONObject();
                        jSONObject3.put("type", (Object)viewParent.getClass().getName());
                        jSONObject3.put("index_of_child", n);
                        jSONArray.put((Object)jSONObject3);
                    }
                    if (viewParent != null && viewParent instanceof View) {
                        view2 = (View)viewParent;
                        continue;
                    }
                    view2 = null;
                }
                if (jSONArray.length() > 0) {
                    jSONObject.put("parents", (Object)jSONArray);
                }
            }
            return jSONObject.toString();
        }
        catch (JSONException jSONException) {
            zzb.zzd("Fail to get view hierarchy json", jSONException);
            return null;
        }
    }

    public int zzk(Activity activity) {
        if (activity == null) {
            zzb.zzan("Fail to get AdActivity type since it is null");
            return 0;
        }
        AdOverlayInfoParcel adOverlayInfoParcel = AdOverlayInfoParcel.zzb(activity.getIntent());
        if (adOverlayInfoParcel == null) {
            zzb.zzan("Fail to get AdOverlayInfo");
            return 0;
        }
        switch (adOverlayInfoParcel.zzwF) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
        }
        return 0;
    }

    public String zzb(zzgd zzgd2, String string) {
        return this.zza(zzgd2.getContext(), zzgd2.zzfv(), string);
    }

    public String zza(Context context, zzk zzk2, String string) {
        if (zzk2 == null) {
            return string;
        }
        try {
            Uri uri = Uri.parse((String)string);
            if (zzk2.zzc(uri)) {
                uri = zzk2.zza(uri, context);
            }
            return uri.toString();
        }
        catch (Exception exception) {
            return string;
        }
    }

    public boolean zzB(Context context) {
        try {
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            KeyguardManager keyguardManager = (KeyguardManager)context.getSystemService("keyguard");
            if (activityManager == null || keyguardManager == null) {
                return false;
            }
            List list = activityManager.getRunningAppProcesses();
            if (list == null) {
                return false;
            }
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
                if (Process.myPid() != runningAppProcessInfo.pid) continue;
                if (runningAppProcessInfo.importance != 100 || keyguardManager.inKeyguardRestrictedInputMode() || !this.zzm(context)) break;
                return true;
            }
            return false;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private boolean zzm(Context context) {
        PowerManager powerManager = (PowerManager)context.getSystemService("power");
        if (powerManager == null) {
            return false;
        }
        return powerManager.isScreenOn();
    }

    public void zza(Context context, String string, String string2, Bundle bundle) {
        Uri.Builder builder = new Uri.Builder().scheme("https").path("//pagead2.googlesyndication.com/pagead/gen_204").appendQueryParameter("id", string2);
        for (String string3 : bundle.keySet()) {
            builder.appendQueryParameter(string3, bundle.getString(string3));
        }
        zzh.zzaQ().zzc(context, string, builder.toString());
    }

    private final class zza
    extends BroadcastReceiver {
        private zza() {
        }

        public void onReceive(Context context, Intent intent) {
            if ("android.intent.action.USER_PRESENT".equals(intent.getAction())) {
                zzfl.this.zzCs = true;
            } else if ("android.intent.action.SCREEN_OFF".equals(intent.getAction())) {
                zzfl.this.zzCs = false;
            }
        }
    }
}

