/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.purchase;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.SystemClock;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.internal.zzfl;
import com.google.android.gms.internal.zzgk;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;

@zzgk
public class zzd
extends zzfl.zza {
    private String zzqK;
    private Context mContext;
    private String zzBW;
    private ArrayList<String> zzBX;

    public zzd(String string, ArrayList<String> arrayList, Context context, String string2) {
        this.zzBW = string;
        this.zzBX = arrayList;
        this.zzqK = string2;
        this.mContext = context;
    }

    @Override
    public String getProductId() {
        return this.zzBW;
    }

    protected int zzy(int n) {
        if (n == 0) {
            return 1;
        }
        if (n == 1) {
            return 2;
        }
        if (n == 4) {
            return 3;
        }
        return 0;
    }

    protected String zza(String string, HashMap<String, String> hashMap) {
        String string2 = this.mContext.getPackageName();
        String string3 = "";
        try {
            string3 = this.mContext.getPackageManager().getPackageInfo((String)string2, (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            zzb.zzd("Error to retrieve app version", nameNotFoundException);
        }
        long l = zzp.zzbA().zzgb().zzgl();
        long l2 = SystemClock.elapsedRealtime() - l;
        for (String string4 : hashMap.keySet()) {
            string = string.replaceAll(String.format("(?<!@)((?:@@)*)@%s(?<!@)((?:@@)*)@", string4), String.format("$1%s$2", hashMap.get(string4)));
        }
        return string.replaceAll(String.format("(?<!@)((?:@@)*)@%s(?<!@)((?:@@)*)@", "sessionid"), String.format("$1%s$2", zzp.zzbA().getSessionId())).replaceAll(String.format("(?<!@)((?:@@)*)@%s(?<!@)((?:@@)*)@", "appid"), String.format("$1%s$2", string2)).replaceAll(String.format("(?<!@)((?:@@)*)@%s(?<!@)((?:@@)*)@", "osversion"), String.format("$1%s$2", String.valueOf(Build.VERSION.SDK_INT))).replaceAll(String.format("(?<!@)((?:@@)*)@%s(?<!@)((?:@@)*)@", "sdkversion"), String.format("$1%s$2", this.zzqK)).replaceAll(String.format("(?<!@)((?:@@)*)@%s(?<!@)((?:@@)*)@", "appversion"), String.format("$1%s$2", string3)).replaceAll(String.format("(?<!@)((?:@@)*)@%s(?<!@)((?:@@)*)@", "timestamp"), String.format("$1%s$2", String.valueOf(l2))).replaceAll(String.format("(?<!@)((?:@@)*)@%s(?<!@)((?:@@)*)@", "[^@]+"), String.format("$1%s$2", "")).replaceAll("@@", "@");
    }

    @Override
    public void recordResolution(int resolution) {
        if (resolution == 1) {
            this.zzfh();
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("status", String.valueOf(resolution));
        hashMap.put("sku", this.zzBW);
        LinkedList<String> linkedList = new LinkedList<String>();
        for (String string : this.zzBX) {
            linkedList.add(this.zza(string, hashMap));
        }
        zzp.zzbx().zza(this.mContext, this.zzqK, linkedList);
    }

    @Override
    public void recordPlayBillingResolution(int billingResponseCode) {
        if (billingResponseCode == 0) {
            this.zzfh();
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("google_play_status", String.valueOf(billingResponseCode));
        hashMap.put("sku", this.zzBW);
        hashMap.put("status", String.valueOf(this.zzy(billingResponseCode)));
        LinkedList<String> linkedList = new LinkedList<String>();
        for (String string : this.zzBX) {
            linkedList.add(this.zza(string, hashMap));
        }
        zzp.zzbx().zza(this.mContext, this.zzqK, linkedList);
    }

    void zzfh() {
        try {
            Class<?> clazz = this.mContext.getClassLoader().loadClass("com.google.ads.conversiontracking.IAPConversionReporter");
            Method method = clazz.getDeclaredMethod("reportWithProductId", Context.class, String.class, String.class, Boolean.TYPE);
            method.invoke(null, this.mContext, this.zzBW, "", true);
        }
        catch (ClassNotFoundException classNotFoundException) {
            zzb.zzaE("Google Conversion Tracking SDK 1.2.0 or above is required to report a conversion.");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            zzb.zzaE("Google Conversion Tracking SDK 1.2.0 or above is required to report a conversion.");
        }
        catch (Exception exception) {
            zzb.zzd("Fail to report a conversion.", exception);
        }
    }
}

