/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.request;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.ads.internal.request.AdRequestInfoParcel;
import com.google.android.gms.ads.internal.request.AdResponseParcel;
import com.google.android.gms.ads.internal.request.zza;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.internal.zzbb;
import com.google.android.gms.internal.zzbe;
import com.google.android.gms.internal.zzbr;
import com.google.android.gms.internal.zzby;
import com.google.android.gms.internal.zzdg;
import com.google.android.gms.internal.zzdh;
import com.google.android.gms.internal.zzdl;
import com.google.android.gms.internal.zzdv;
import com.google.android.gms.internal.zzgk;
import com.google.android.gms.internal.zzgn;
import com.google.android.gms.internal.zzhj;
import com.google.android.gms.internal.zzhq;
import com.google.android.gms.internal.zzij;
import com.google.android.gms.internal.zzip;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.json.JSONException;
import org.json.JSONObject;

@zzgk
public class zzm
extends zzhq {
    static final long zzEu = TimeUnit.SECONDS.toMillis(10L);
    private static final Object zzpm = new Object();
    private static boolean zzEv = false;
    private static zzdv zzEw = null;
    private static zzdh zzEx = null;
    private static zzdl zzEy = null;
    private static zzdg zzEz = null;
    private final zza.zza zzDp;
    private final AdRequestInfoParcel.zza zzDq;
    private final Object zzCE = new Object();
    private final Context mContext;
    private zzdv.zzd zzEA;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public zzm(Context context, AdRequestInfoParcel.zza zza2, zza.zza zza3) {
        this.zzDp = zza3;
        this.mContext = context;
        this.zzDq = zza2;
        Object object = zzpm;
        synchronized (object) {
            if (!zzEv) {
                zzEy = new zzdl();
                zzEx = new zzdh(context.getApplicationContext(), zza2.zzqb);
                zzEz = new zzc();
                zzEw = new zzdv(this.mContext.getApplicationContext(), this.zzDq.zzqb, zzby.zztW.get(), new zzb(), new zza());
                zzEv = true;
            }
        }
    }

    protected static void zzc(zzbb zzbb2) {
        zzbb2.zza("/loadAd", zzEy);
        zzbb2.zza("/fetchHttpRequest", zzEx);
        zzbb2.zza("/invalidRequest", zzEz);
    }

    protected static void zzd(zzbb zzbb2) {
        zzbb2.zzb("/loadAd", zzEy);
        zzbb2.zzb("/fetchHttpRequest", zzEx);
        zzbb2.zzb("/invalidRequest", zzEz);
    }

    @Override
    public void zzdG() {
        com.google.android.gms.ads.internal.util.client.zzb.zzaC("SdkLessAdLoaderBackgroundTask started.");
        AdRequestInfoParcel adRequestInfoParcel = new AdRequestInfoParcel(this.zzDq, null, null, -1L);
        AdResponseParcel adResponseParcel = this.zzf(adRequestInfoParcel);
        long l = zzp.zzbB().elapsedRealtime();
        final zzhj.zza zza2 = new zzhj.zza(adRequestInfoParcel, adResponseParcel, null, null, adResponseParcel.errorCode, l, adResponseParcel.zzEb, null);
        com.google.android.gms.ads.internal.util.client.zza.zzIy.post(new Runnable(){

            @Override
            public void run() {
                zzm.this.zzDp.zza(zza2);
                if (zzm.this.zzEA != null) {
                    zzm.this.zzEA.release();
                    zzm.this.zzEA = null;
                }
            }
        });
    }

    private AdResponseParcel zzf(AdRequestInfoParcel adRequestInfoParcel) {
        JSONObject jSONObject;
        final String string = UUID.randomUUID().toString();
        final JSONObject jSONObject2 = this.zza(adRequestInfoParcel, string);
        if (jSONObject2 == null) {
            return new AdResponseParcel(0);
        }
        long l = zzp.zzbB().elapsedRealtime();
        Future<JSONObject> future = zzEy.zzW(string);
        com.google.android.gms.ads.internal.util.client.zza.zzIy.post(new Runnable(){

            @Override
            public void run() {
                zzm.this.zzEA = zzEw.zzdL();
                zzm.this.zzEA.zza(new zzij.zzc<zzbe>(){

                    public void zzb(zzbe zzbe2) {
                        try {
                            zzbe2.zza("AFMA_getAdapterLessMediationAd", jSONObject2);
                        }
                        catch (Exception exception) {
                            com.google.android.gms.ads.internal.util.client.zzb.zzb("Error requesting an ad url", exception);
                            zzEy.zzX(string);
                        }
                    }

                    @Override
                    public /* synthetic */ void zzc(Object object) {
                        this.zzb((zzbe)object);
                    }
                }, new zzij.zza(){

                    @Override
                    public void run() {
                        zzEy.zzX(string);
                    }
                });
            }
        });
        long l2 = zzEu - (zzp.zzbB().elapsedRealtime() - l);
        try {
            jSONObject = future.get(l2, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | CancellationException exception) {
            return new AdResponseParcel(-1);
        }
        catch (TimeoutException timeoutException) {
            return new AdResponseParcel(2);
        }
        catch (ExecutionException executionException) {
            return new AdResponseParcel(0);
        }
        if (jSONObject == null) {
            return new AdResponseParcel(-1);
        }
        AdResponseParcel adResponseParcel = zzgn.zza(this.mContext, adRequestInfoParcel, jSONObject.toString());
        if (adResponseParcel.errorCode != -3 && TextUtils.isEmpty((CharSequence)adResponseParcel.body)) {
            return new AdResponseParcel(3);
        }
        return adResponseParcel;
    }

    private JSONObject zza(AdRequestInfoParcel adRequestInfoParcel, String string) {
        Bundle bundle = adRequestInfoParcel.zzDy.extras.getBundle("sdk_less_server_data");
        String string2 = adRequestInfoParcel.zzDy.extras.getString("sdk_less_network_id");
        if (bundle == null) {
            return null;
        }
        JSONObject jSONObject = zzgn.zza(this.mContext, adRequestInfoParcel, zzp.zzbD().zzD(this.mContext), null, null, new zzbr(zzby.zztW.get()), null, null, new ArrayList<String>());
        if (jSONObject == null) {
            return null;
        }
        AdvertisingIdClient.Info info = null;
        try {
            info = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.mContext);
        }
        catch (GooglePlayServicesNotAvailableException | GooglePlayServicesRepairableException | IOException | IllegalStateException throwable) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Cannot get advertising id info", throwable);
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("request_id", string);
        hashMap.put("network_id", string2);
        hashMap.put("request_param", jSONObject);
        hashMap.put("data", bundle);
        if (info != null) {
            hashMap.put("adid", info.getId());
            hashMap.put("lat", info.isLimitAdTrackingEnabled() ? 1 : 0);
        }
        try {
            return zzp.zzbx().zzx(hashMap);
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStop() {
        Object object = this.zzCE;
        synchronized (object) {
            com.google.android.gms.ads.internal.util.client.zza.zzIy.post(new Runnable(){

                @Override
                public void run() {
                    if (zzm.this.zzEA != null) {
                        zzm.this.zzEA.release();
                        zzm.this.zzEA = null;
                    }
                }
            });
        }
    }

    public static class zza
    implements zzdv.zzb<zzbb> {
        public void zza(zzbb zzbb2) {
            zzm.zzd(zzbb2);
        }

        @Override
        public /* synthetic */ void zzc(Object object) {
            this.zza((zzbb)object);
        }
    }

    public static class zzb
    implements zzdv.zzb<zzbb> {
        public void zza(zzbb zzbb2) {
            zzm.zzc(zzbb2);
        }

        @Override
        public /* synthetic */ void zzc(Object object) {
            this.zza((zzbb)object);
        }
    }

    public static class zzc
    implements zzdg {
        @Override
        public void zza(zzip zzip2, Map<String, String> map) {
            String string = map.get("request_id");
            String string2 = map.get("errors");
            com.google.android.gms.ads.internal.util.client.zzb.zzaE("Invalid request: " + string2);
            zzEy.zzX(string);
        }
    }
}

