/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.provider.CalendarContract;
import android.text.TextUtils;
import com.google.android.gms.R;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.internal.zzbq;
import com.google.android.gms.internal.zzfb;
import com.google.android.gms.internal.zzgk;
import com.google.android.gms.internal.zzip;
import java.util.Map;

@zzgk
public class zzev
extends zzfb {
    private final Map<String, String> zzvs;
    private final Context mContext;
    private String zzzi;
    private long zzzj;
    private long zzzk;
    private String zzzl;
    private String zzzm;

    public zzev(zzip zzip2, Map<String, String> map) {
        super(zzip2, "createCalendarEvent");
        this.zzvs = map;
        this.mContext = zzip2.zzgN();
        this.zzdV();
    }

    private void zzdV() {
        this.zzzi = this.zzae("description");
        this.zzzl = this.zzae("summary");
        this.zzzj = this.zzaf("start_ticks");
        this.zzzk = this.zzaf("end_ticks");
        this.zzzm = this.zzae("location");
    }

    private String zzae(String string2) {
        return TextUtils.isEmpty((CharSequence)this.zzvs.get(string2)) ? "" : this.zzvs.get(string2);
    }

    private long zzaf(String string2) {
        String string3 = this.zzvs.get(string2);
        if (string3 == null) {
            return -1L;
        }
        try {
            return Long.parseLong(string3);
        }
        catch (NumberFormatException numberFormatException) {
            return -1L;
        }
    }

    public void execute() {
        if (this.mContext == null) {
            this.zzah("Activity context is not available.");
            return;
        }
        zzbq zzbq2 = zzp.zzbx().zzM(this.mContext);
        if (!zzbq2.zzda()) {
            this.zzah("This feature is not available on the device.");
            return;
        }
        AlertDialog.Builder builder = zzp.zzbx().zzL(this.mContext);
        builder.setTitle((CharSequence)zzp.zzbA().zzc(R.string.create_calendar_title, "Create calendar event"));
        builder.setMessage((CharSequence)zzp.zzbA().zzc(R.string.create_calendar_message, "Allow Ad to create a calendar event?"));
        builder.setPositiveButton((CharSequence)zzp.zzbA().zzc(R.string.accept, "Accept"), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                Intent intent = zzev.this.createIntent();
                zzev.this.mContext.startActivity(intent);
            }
        });
        builder.setNegativeButton((CharSequence)zzp.zzbA().zzc(R.string.decline, "Decline"), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                zzev.this.zzah("Operation denied by user.");
            }
        });
        builder.create().show();
    }

    Intent createIntent() {
        Intent intent = new Intent("android.intent.action.EDIT").setData(CalendarContract.Events.CONTENT_URI);
        intent.putExtra("title", this.zzzi);
        intent.putExtra("eventLocation", this.zzzm);
        intent.putExtra("description", this.zzzl);
        if (this.zzzj > -1L) {
            intent.putExtra("beginTime", this.zzzj);
        }
        if (this.zzzk > -1L) {
            intent.putExtra("endTime", this.zzzk);
        }
        intent.setFlags(0x10000000);
        return intent;
    }
}

