/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.RemoteException;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.formats.zzc;
import com.google.android.gms.ads.internal.formats.zzf;
import com.google.android.gms.ads.internal.formats.zzh;
import com.google.android.gms.ads.internal.zzn;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzan;
import com.google.android.gms.internal.zzbb;
import com.google.android.gms.internal.zzbc;
import com.google.android.gms.internal.zzby;
import com.google.android.gms.internal.zzcr;
import com.google.android.gms.internal.zzcv;
import com.google.android.gms.internal.zzdg;
import com.google.android.gms.internal.zzgg;
import com.google.android.gms.internal.zzgh;
import com.google.android.gms.internal.zzgi;
import com.google.android.gms.internal.zzgk;
import com.google.android.gms.internal.zzhj;
import com.google.android.gms.internal.zzhu;
import com.google.android.gms.internal.zzhy;
import com.google.android.gms.internal.zzie;
import com.google.android.gms.internal.zzif;
import com.google.android.gms.internal.zzig;
import com.google.android.gms.internal.zzih;
import com.google.android.gms.internal.zzip;
import com.google.android.gms.internal.zzlr;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzgk
public class zzgf
implements Callable<zzhj> {
    private static final long zzCS = TimeUnit.SECONDS.toMillis(60L);
    private final Context mContext;
    private final zzhy zzCT;
    private final zzn zzCU;
    private final zzan zzwh;
    private final zzbc zzCV;
    private final Object zzpc = new Object();
    private final zzhj.zza zzCF;
    private boolean zzCW;
    private int zzCI;
    private List<String> zzCX;

    public zzgf(Context context, zzn zzn2, zzbc zzbc2, zzhy zzhy2, zzan zzan2, zzhj.zza zza2) {
        this.mContext = context;
        this.zzCU = zzn2;
        this.zzCT = zzhy2;
        this.zzCV = zzbc2;
        this.zzCF = zza2;
        this.zzwh = zzan2;
        this.zzCW = false;
        this.zzCI = -2;
        this.zzCX = null;
    }

    public zzhj zzfr() {
        try {
            zzbb zzbb2 = this.zzfs();
            JSONObject jSONObject = this.zzb(zzbb2);
            zza zza2 = this.zzd(jSONObject);
            zzh.zza zza3 = this.zza(zzbb2, zza2, jSONObject);
            this.zza(zza3, zzbb2);
            zzhj zzhj2 = this.zza(zza3);
            return zzhj2;
        }
        catch (CancellationException cancellationException) {
        }
        catch (ExecutionException executionException) {
        }
        catch (InterruptedException interruptedException) {
        }
        catch (JSONException jSONException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Malformed native JSON response.", jSONException);
        }
        catch (TimeoutException timeoutException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Timeout when loading native ad.", timeoutException);
        }
        if (!this.zzCW) {
            this.zzB(0);
        }
        return this.zza(null);
    }

    private zzbb zzfs() throws CancellationException, ExecutionException, InterruptedException, TimeoutException {
        if (this.zzft()) {
            return null;
        }
        String string2 = zzby.zzuU.get();
        String string3 = this.zzCF.zzGM.zzAT.indexOf("https") == 0 ? "https:" : "http:";
        String string4 = string3 + string2;
        zzbb zzbb2 = this.zzCV.zza(this.mContext, this.zzCF.zzGL.zzqb, string4, this.zzwh).get(zzCS, TimeUnit.MILLISECONDS);
        zzbb2.zza(this.zzCU, this.zzCU, this.zzCU, this.zzCU, false, null, null, null, null);
        return zzbb2;
    }

    private JSONObject zzb(final zzbb zzbb2) throws TimeoutException, JSONException {
        zzdg zzdg2;
        if (this.zzft()) {
            return null;
        }
        final zzie zzie2 = new zzie();
        final zzb zzb2 = new zzb();
        zzb2.zzDk = zzdg2 = new zzdg(){

            @Override
            public void zza(zzip zzip2, Map<String, String> map) {
                zzbb2.zzb("/nativeAdPreProcess", zzb2.zzDk);
                try {
                    String string2 = map.get("success");
                    if (!TextUtils.isEmpty((CharSequence)string2)) {
                        zzie2.zzf(new JSONObject(string2).getJSONArray("ads").getJSONObject(0));
                        return;
                    }
                }
                catch (JSONException jSONException) {
                    com.google.android.gms.ads.internal.util.client.zzb.zzb("Malformed native JSON response.", jSONException);
                }
                zzgf.this.zzB(0);
                zzx.zza((boolean)zzgf.this.zzft(), (Object)"Unable to set the ad state error!");
                zzie2.zzf(null);
            }
        };
        zzbb2.zza("/nativeAdPreProcess", zzdg2);
        JSONObject jSONObject = new JSONObject(this.zzCF.zzGM.body);
        zzbb2.zza("google.afma.nativeAds.preProcessJsonGmsg", jSONObject);
        return (JSONObject)zzie2.get(zzCS, TimeUnit.MILLISECONDS);
    }

    protected zza zzd(JSONObject jSONObject) throws JSONException, TimeoutException {
        boolean bl;
        if (this.zzft()) {
            return null;
        }
        String string2 = jSONObject.getString("template_id");
        boolean bl2 = this.zzCF.zzGL.zzqt != null ? this.zzCF.zzGL.zzqt.zzwn : false;
        boolean bl3 = bl = this.zzCF.zzGL.zzqt != null ? this.zzCF.zzGL.zzqt.zzwp : false;
        if ("2".equals(string2)) {
            return new zzgg(bl2, bl);
        }
        if ("1".equals(string2)) {
            return new zzgh(bl2, bl);
        }
        if ("3".equals(string2)) {
            final String string3 = jSONObject.getString("custom_template_id");
            final zzie zzie2 = new zzie();
            zzhu.zzHK.post(new Runnable(){

                @Override
                public void run() {
                    zzie2.zzf(zzgf.this.zzCU.zzbq().get((Object)string3));
                }
            });
            if (zzie2.get(zzCS, TimeUnit.MILLISECONDS) != null) {
                return new zzgi(bl2);
            }
            com.google.android.gms.ads.internal.util.client.zzb.e("No handler for custom template: " + jSONObject.getString("custom_template_id"));
        } else {
            this.zzB(0);
        }
        return null;
    }

    private void zza(zzh.zza zza2, zzbb zzbb2) {
        zzdg zzdg2;
        if (!(zza2 instanceof zzf)) {
            return;
        }
        final zzf zzf2 = (zzf)zza2;
        zzb zzb2 = new zzb();
        zzb2.zzDk = zzdg2 = new zzdg(){

            @Override
            public void zza(zzip zzip2, Map<String, String> map) {
                String string2 = map.get("asset");
                zzgf.this.zzb(zzf2, string2);
            }
        };
        zzbb2.zza("/nativeAdCustomClick", zzdg2);
    }

    private void zzb(zzcr zzcr2, String string2) {
        try {
            zzcv zzcv2 = this.zzCU.zzr(zzcr2.getCustomTemplateId());
            if (zzcv2 != null) {
                zzcv2.zza(zzcr2, string2);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to call onCustomClick for asset " + string2 + ".", remoteException);
        }
    }

    private zzh.zza zza(zzbb zzbb2, zza zza2, JSONObject jSONObject) throws ExecutionException, InterruptedException, JSONException {
        if (this.zzft()) {
            return null;
        }
        JSONObject jSONObject2 = jSONObject.getJSONObject("tracking_urls_and_actions");
        String[] stringArray = this.zzc(jSONObject2, "impression_tracking_urls");
        this.zzCX = stringArray == null ? null : Arrays.asList(stringArray);
        Object t = zza2.zza(this, jSONObject);
        if (t == null) {
            com.google.android.gms.ads.internal.util.client.zzb.e("Failed to retrieve ad assets.");
            return null;
        }
        t.zza(new zzh(this.mContext, this.zzCU, zzbb2, this.zzwh, jSONObject, (zzh.zza)t, this.zzCF.zzGL.zzqb));
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private zzhj zza(zzh.zza zza2) {
        int n;
        Object object = this.zzpc;
        synchronized (object) {
            n = this.zzCI;
            if (zza2 == null && this.zzCI == -2) {
                n = 0;
            }
        }
        if (n != -2) {
            zza2 = null;
        }
        return new zzhj(this.zzCF.zzGL.zzDy, null, this.zzCF.zzGM.zzyw, n, this.zzCF.zzGM.zzyx, this.zzCX, this.zzCF.zzGM.orientation, this.zzCF.zzGM.zzyA, this.zzCF.zzGL.zzDB, false, null, null, null, null, null, 0L, this.zzCF.zzqf, this.zzCF.zzGM.zzDW, this.zzCF.zzGI, this.zzCF.zzGJ, this.zzCF.zzGM.zzEc, this.zzCF.zzGF, zza2, this.zzCF.zzGL.zzDO);
    }

    public zzih<com.google.android.gms.ads.internal.formats.zza> zze(JSONObject jSONObject) throws JSONException {
        JSONObject jSONObject2 = jSONObject.optJSONObject("attribution");
        if (jSONObject2 == null) {
            return new zzif<Object>(null);
        }
        final String string2 = jSONObject2.optString("text");
        final int n = jSONObject2.optInt("text_size", -1);
        final Integer n2 = this.zzb(jSONObject2, "text_color");
        final Integer n3 = this.zzb(jSONObject2, "bg_color");
        zzih<zzc> zzih2 = this.zza(jSONObject2, "image", false, false);
        return zzig.zza(zzih2, new zzig.zza<zzc, com.google.android.gms.ads.internal.formats.zza>(){

            public com.google.android.gms.ads.internal.formats.zza zza(zzc zzc2) {
                try {
                    return zzc2 == null || TextUtils.isEmpty((CharSequence)string2) ? null : new com.google.android.gms.ads.internal.formats.zza(string2, (Drawable)zze.zzp((zzd)zzc2.zzdr()), n3, n2, n > 0 ? Integer.valueOf(n) : null);
                }
                catch (RemoteException remoteException) {
                    com.google.android.gms.ads.internal.util.client.zzb.zzb("Could not get attribution icon", remoteException);
                    return null;
                }
            }

            @Override
            public /* synthetic */ Object zze(Object object) {
                return this.zza((zzc)object);
            }
        });
    }

    private Integer zzb(JSONObject jSONObject, String string2) {
        try {
            JSONObject jSONObject2 = jSONObject.getJSONObject(string2);
            int n = jSONObject2.getInt("r");
            int n2 = jSONObject2.getInt("g");
            int n3 = jSONObject2.getInt("b");
            return Color.rgb((int)n, (int)n2, (int)n3);
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    public Future<zzc> zza(JSONObject jSONObject, String string2, boolean bl) throws JSONException {
        JSONObject jSONObject2 = jSONObject.getJSONObject(string2);
        boolean bl2 = jSONObject2.optBoolean("require", true);
        jSONObject2 = jSONObject2 == null ? new JSONObject() : jSONObject2;
        return this.zza(jSONObject2, bl2, bl);
    }

    public zzih<zzc> zza(JSONObject jSONObject, String string2, boolean bl, boolean bl2) throws JSONException {
        JSONObject jSONObject2 = bl ? jSONObject.getJSONObject(string2) : jSONObject.optJSONObject(string2);
        jSONObject2 = jSONObject2 == null ? new JSONObject() : jSONObject2;
        return this.zza(jSONObject2, bl, bl2);
    }

    public List<zzih<zzc>> zza(JSONObject jSONObject, String string2, boolean bl, boolean bl2, boolean bl3) throws JSONException {
        JSONArray jSONArray = bl ? jSONObject.getJSONArray(string2) : jSONObject.optJSONArray(string2);
        ArrayList<zzih<zzc>> arrayList = new ArrayList<zzih<zzc>>();
        if (jSONArray == null || jSONArray.length() == 0) {
            this.zza(0, bl);
            return arrayList;
        }
        int n = bl3 ? jSONArray.length() : 1;
        for (int i = 0; i < n; ++i) {
            JSONObject jSONObject2 = jSONArray.getJSONObject(i);
            jSONObject2 = jSONObject2 == null ? new JSONObject() : jSONObject2;
            arrayList.add(this.zza(jSONObject2, bl, bl2));
        }
        return arrayList;
    }

    private zzih<zzc> zza(JSONObject jSONObject, final boolean bl, boolean bl2) throws JSONException {
        String string2;
        String string3 = string2 = bl ? jSONObject.getString("url") : jSONObject.optString("url");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.zza(0, bl);
            return new zzif<Object>(null);
        }
        if (bl2) {
            return new zzif<zzc>(new zzc(null, Uri.parse((String)string2)));
        }
        return this.zzCT.zza(string2, new zzhy.zza<zzc>(){

            public zzc zzfu() {
                zzgf.this.zza(2, bl);
                return null;
            }

            public zzc zzg(InputStream inputStream) {
                byte[] byArray = null;
                try {
                    byArray = zzlr.zzk((InputStream)inputStream);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (byArray == null) {
                    zzgf.this.zza(2, bl);
                    return null;
                }
                Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length);
                if (bitmap == null) {
                    zzgf.this.zza(2, bl);
                    return null;
                }
                return new zzc((Drawable)new BitmapDrawable(Resources.getSystem(), bitmap), Uri.parse((String)string2));
            }

            @Override
            public /* synthetic */ Object zzfv() {
                return this.zzfu();
            }

            @Override
            public /* synthetic */ Object zzh(InputStream inputStream) {
                return this.zzg(inputStream);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean zzft() {
        Object object = this.zzpc;
        synchronized (object) {
            return this.zzCW;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzB(int n) {
        Object object = this.zzpc;
        synchronized (object) {
            this.zzCW = true;
            this.zzCI = n;
        }
    }

    public void zza(int n, boolean bl) {
        if (bl) {
            this.zzB(n);
        }
    }

    private String[] zzc(JSONObject jSONObject, String string2) throws JSONException {
        JSONArray jSONArray = jSONObject.optJSONArray(string2);
        if (jSONArray == null) {
            return null;
        }
        String[] stringArray = new String[jSONArray.length()];
        for (int i = 0; i < jSONArray.length(); ++i) {
            stringArray[i] = jSONArray.getString(i);
        }
        return stringArray;
    }

    @Override
    public /* synthetic */ Object call() throws Exception {
        return this.zzfr();
    }

    class zzb {
        public zzdg zzDk;

        zzb() {
        }
    }

    public static interface zza<T extends zzh.zza> {
        public T zza(zzgf var1, JSONObject var2) throws JSONException, InterruptedException, ExecutionException;
    }
}

