/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.MutableContextWrapper;
import android.graphics.Canvas;
import android.net.Uri;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.webkit.DownloadListener;
import android.webkit.ValueCallback;
import android.webkit.WebSettings;
import android.webkit.WebView;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.zzk;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.ads.internal.zzd;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.internal.zzan;
import com.google.android.gms.internal.zzaz;
import com.google.android.gms.internal.zzdr;
import com.google.android.gms.internal.zzfb;
import com.google.android.gms.internal.zzgk;
import com.google.android.gms.internal.zzhu;
import com.google.android.gms.internal.zzid;
import com.google.android.gms.internal.zzip;
import com.google.android.gms.internal.zziq;
import com.google.android.gms.internal.zzit;
import com.google.android.gms.internal.zzlv;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

@zzgk
public class zzis
extends WebView
implements ViewTreeObserver.OnGlobalLayoutListener,
DownloadListener,
zzip {
    private final zziq zzCq;
    private final zza zzJk;
    private final Object zzpc = new Object();
    private final zzan zzwh;
    private final VersionInfoParcel zzpa;
    private final zzd zzov;
    private com.google.android.gms.ads.internal.overlay.zzd zzJl;
    private AdSizeParcel zzyK;
    private boolean zzJm;
    private boolean zzJn;
    private boolean zzJo;
    private boolean zzJp;
    private Boolean zzHi;
    private int zzJq;
    private boolean zzJr = true;
    private String zzBm = "";
    private String zzJs;
    private com.google.android.gms.ads.internal.overlay.zzd zzJt;
    private zzid zzqG;
    private int zzzR = -1;
    private int zzzQ = -1;
    private int zzzT = -1;
    private int zzzU = -1;
    private Map<String, zzdr> zzJu;
    private final WindowManager zzqX;

    static zzis zzb(Context context, AdSizeParcel adSizeParcel, boolean bl, boolean bl2, zzan zzan2, VersionInfoParcel versionInfoParcel, zzd zzd2) {
        zza zza2 = new zza(context);
        return new zzis(zza2, adSizeParcel, bl, bl2, zzan2, versionInfoParcel, zzd2);
    }

    protected zzis(zza zza2, AdSizeParcel adSizeParcel, boolean bl, boolean bl2, zzan zzan2, VersionInfoParcel versionInfoParcel, zzd zzd2) {
        super((Context)zza2);
        this.zzJk = zza2;
        this.zzyK = adSizeParcel;
        this.zzJo = bl;
        this.zzJq = -1;
        this.zzwh = zzan2;
        this.zzpa = versionInfoParcel;
        this.zzov = zzd2;
        this.zzqX = (WindowManager)this.getContext().getSystemService("window");
        this.setBackgroundColor(0);
        WebSettings webSettings = this.getSettings();
        webSettings.setJavaScriptEnabled(true);
        webSettings.setSavePassword(false);
        webSettings.setSupportMultipleWindows(true);
        webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
        if (Build.VERSION.SDK_INT >= 21) {
            webSettings.setMixedContentMode(0);
        }
        zzp.zzbx().zza((Context)zza2, versionInfoParcel.zzIz, webSettings);
        zzp.zzbz().zza(this.getContext(), webSettings);
        this.setDownloadListener(this);
        this.zzCq = zzp.zzbz().zzb(this, bl2);
        this.setWebViewClient(this.zzCq);
        this.setWebChromeClient(zzp.zzbz().zzf(this));
        this.zzhk();
        if (zzlv.zzpT()) {
            this.addJavascriptInterface(new zzit(this), "googleAdsJsInterface");
        }
        this.zzqG = new zzid(this.zzJk.zzgN(), this, null);
    }

    @Override
    public WebView getWebView() {
        return this;
    }

    @Override
    public zzd zzgP() {
        return this.zzov;
    }

    public boolean zzhi() {
        int n;
        int n2;
        if (!this.zzgS().zzbY()) {
            return false;
        }
        DisplayMetrics displayMetrics = zzp.zzbx().zza(this.zzqX);
        int n3 = zzk.zzcE().zzb(displayMetrics, displayMetrics.widthPixels);
        int n4 = zzk.zzcE().zzb(displayMetrics, displayMetrics.heightPixels);
        Activity activity = this.zzgN();
        if (activity == null || activity.getWindow() == null) {
            n2 = n3;
            n = n4;
        } else {
            int[] nArray = zzp.zzbx().zzg(activity);
            n2 = zzk.zzcE().zzb(displayMetrics, nArray[0]);
            n = zzk.zzcE().zzb(displayMetrics, nArray[1]);
        }
        if (this.zzzQ == n3 && this.zzzR == n4 && this.zzzT == n2 && this.zzzU == n) {
            return false;
        }
        boolean bl = this.zzzQ != n3 || this.zzzR != n4;
        this.zzzQ = n3;
        this.zzzR = n4;
        this.zzzT = n2;
        this.zzzU = n;
        new zzfb(this).zza(n3, n4, n2, n, displayMetrics.density, this.zzqX.getDefaultDisplay().getRotation());
        return bl;
    }

    @Override
    public void zzc(String string2, Map<String, ?> map) {
        JSONObject jSONObject;
        try {
            jSONObject = zzp.zzbx().zzx(map);
        }
        catch (JSONException jSONException) {
            zzb.zzaE("Could not convert parameters to JSON.");
            return;
        }
        this.zzb(string2, jSONObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluateJavascript(String script, ValueCallback<String> resultCallback) {
        Object object = this.zzpc;
        synchronized (object) {
            if (this.isDestroyed()) {
                zzb.zzaE("The webview is destroyed. Ignoring action.");
                if (resultCallback != null) {
                    resultCallback.onReceiveValue(null);
                }
                return;
            }
            super.evaluateJavascript(script, resultCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zzaJ(String string2) {
        Object object = this.zzpc;
        synchronized (object) {
            if (!this.isDestroyed()) {
                this.loadUrl(string2);
            } else {
                zzb.zzaE("The webview is destroyed. Ignoring action.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadUrl(String uri) {
        Object object = this.zzpc;
        synchronized (object) {
            if (!this.isDestroyed()) {
                super.loadUrl(uri);
            } else {
                zzb.zzaE("The webview is destroyed. Ignoring action.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzaF(String string2) {
        Object object = this.zzpc;
        synchronized (object) {
            super.loadUrl(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadData(String data, String mimeType, String encoding) {
        Object object = this.zzpc;
        synchronized (object) {
            if (!this.isDestroyed()) {
                super.loadData(data, mimeType, encoding);
            } else {
                zzb.zzaE("The webview is destroyed. Ignoring action.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadDataWithBaseURL(String baseUrl, String data, String mimeType, String encoding, String historyUrl) {
        Object object = this.zzpc;
        synchronized (object) {
            if (!this.isDestroyed()) {
                super.loadDataWithBaseURL(baseUrl, data, mimeType, encoding, historyUrl);
            } else {
                zzb.zzaE("The webview is destroyed. Ignoring action.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zza(String string2, ValueCallback<String> valueCallback) {
        Object object = this.zzpc;
        synchronized (object) {
            if (!this.isDestroyed()) {
                this.evaluateJavascript(string2, valueCallback);
            } else {
                zzb.zzaE("The webview is destroyed. Ignoring action.");
                if (valueCallback != null) {
                    valueCallback.onReceiveValue(null);
                }
            }
        }
    }

    protected void zzaK(String string2) {
        if (zzlv.zzpV()) {
            if (this.zzgg() == null) {
                this.zzhj();
            }
            if (this.zzgg().booleanValue()) {
                this.zza(string2, (ValueCallback<String>)null);
            } else {
                this.zzaJ("javascript:" + string2);
            }
        } else {
            this.zzaJ("javascript:" + string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzhj() {
        Object object = this.zzpc;
        synchronized (object) {
            this.zzHi = zzp.zzbA().zzgg();
            if (this.zzHi == null) {
                try {
                    String string2 = "(function(){})()";
                    this.evaluateJavascript(string2, null);
                    this.zzb(true);
                }
                catch (IllegalStateException illegalStateException) {
                    this.zzb(false);
                }
            }
        }
    }

    void zzb(Boolean bl) {
        this.zzHi = bl;
        zzp.zzbA().zzb(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Boolean zzgg() {
        Object object = this.zzpc;
        synchronized (object) {
            return this.zzHi;
        }
    }

    @Override
    public void zza(String string2, JSONObject jSONObject) {
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        String string3 = jSONObject.toString();
        this.zza(string2, string3);
    }

    @Override
    public void zza(String string2, String string3) {
        String string4 = string2 + "(" + string3 + ");";
        this.zzaK(string4);
    }

    @Override
    public void zzb(String string2, JSONObject jSONObject) {
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        String string3 = jSONObject.toString();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("AFMA_ReceiveMessage('");
        stringBuilder.append(string2);
        stringBuilder.append("'");
        stringBuilder.append(",");
        stringBuilder.append(string3);
        stringBuilder.append(");");
        zzb.v("Dispatching AFMA event: " + stringBuilder.toString());
        this.zzaK(stringBuilder.toString());
    }

    @Override
    public void zzgM() {
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.zzpa.zzIz);
        this.zzc("onhide", hashMap);
    }

    @Override
    public void zzv(int n) {
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        hashMap.put("closetype", String.valueOf(n));
        hashMap.put("version", this.zzpa.zzIz);
        this.zzc("onhide", hashMap);
    }

    @Override
    public void zzeD() {
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.zzpa.zzIz);
        this.zzc("onshow", hashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public com.google.android.gms.ads.internal.overlay.zzd zzgQ() {
        Object object = this.zzpc;
        synchronized (object) {
            return this.zzJl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public com.google.android.gms.ads.internal.overlay.zzd zzgR() {
        Object object = this.zzpc;
        synchronized (object) {
            return this.zzJt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AdSizeParcel zzaN() {
        Object object = this.zzpc;
        synchronized (object) {
            return this.zzyK;
        }
    }

    @Override
    public zziq zzgS() {
        return this.zzCq;
    }

    @Override
    public boolean zzgT() {
        return this.zzJm;
    }

    @Override
    public zzan zzgU() {
        return this.zzwh;
    }

    @Override
    public VersionInfoParcel zzgV() {
        return this.zzpa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean zzgW() {
        Object object = this.zzpc;
        synchronized (object) {
            return this.zzJo;
        }
    }

    public void onDownloadStart(String url, String userAgent, String contentDisposition, String mimeType, long size) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setDataAndType(Uri.parse((String)url), mimeType);
            this.getContext().startActivity(intent);
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            zzb.zzaC("Couldn't find an Activity to view url/mimetype: " + url + " / " + mimeType);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.zzwh != null) {
            this.zzwh.zza(event);
        }
        if (this.isDestroyed()) {
            return false;
        }
        return super.onTouchEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        Object object = this.zzpc;
        synchronized (object) {
            if (this.isDestroyed()) {
                this.setMeasuredDimension(0, 0);
                return;
            }
            if (this.isInEditMode() || this.zzJo || this.zzyK.zzsJ) {
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
                return;
            }
            if (this.zzyK.zzsH) {
                DisplayMetrics displayMetrics = new DisplayMetrics();
                this.zzqX.getDefaultDisplay().getMetrics(displayMetrics);
                this.setMeasuredDimension(displayMetrics.widthPixels, displayMetrics.heightPixels);
                return;
            }
            int n = View.MeasureSpec.getMode((int)widthMeasureSpec);
            int n2 = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int n3 = View.MeasureSpec.getMode((int)heightMeasureSpec);
            int n4 = View.MeasureSpec.getSize((int)heightMeasureSpec);
            int n5 = Integer.MAX_VALUE;
            if (n == Integer.MIN_VALUE || n == 0x40000000) {
                n5 = n2;
            }
            int n6 = Integer.MAX_VALUE;
            if (n3 == Integer.MIN_VALUE || n3 == 0x40000000) {
                n6 = n4;
            }
            if (this.zzyK.widthPixels > n5 || this.zzyK.heightPixels > n6) {
                float f = this.zzJk.getResources().getDisplayMetrics().density;
                zzb.zzaE("Not enough space to show ad. Needs " + (int)((float)this.zzyK.widthPixels / f) + "x" + (int)((float)this.zzyK.heightPixels / f) + " dp, but only has " + (int)((float)n2 / f) + "x" + (int)((float)n4 / f) + " dp.");
                if (this.getVisibility() != 8) {
                    this.setVisibility(4);
                }
                this.setMeasuredDimension(0, 0);
            } else {
                if (this.getVisibility() != 8) {
                    this.setVisibility(0);
                }
                this.setMeasuredDimension(this.zzyK.widthPixels, this.zzyK.heightPixels);
            }
        }
    }

    public void onGlobalLayout() {
        boolean bl = this.zzhi();
        com.google.android.gms.ads.internal.overlay.zzd zzd2 = this.zzgQ();
        if (zzd2 != null && bl) {
            zzd2.zzeC();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zza(Context context, AdSizeParcel adSizeParcel) {
        Object object = this.zzpc;
        synchronized (object) {
            this.zzqG.zzgE();
            this.setContext(context);
            this.zzJl = null;
            this.zzyK = adSizeParcel;
            this.zzJo = false;
            this.zzJm = false;
            this.zzBm = "";
            this.zzJq = -1;
            zzp.zzbz().zzb(this);
            this.loadUrl("about:blank");
            this.zzCq.reset();
            this.setOnTouchListener(null);
            this.setOnClickListener(null);
            this.zzJr = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zza(com.google.android.gms.ads.internal.overlay.zzd zzd2) {
        Object object = this.zzpc;
        synchronized (object) {
            this.zzJl = zzd2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzb(com.google.android.gms.ads.internal.overlay.zzd zzd2) {
        Object object = this.zzpc;
        synchronized (object) {
            this.zzJt = zzd2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zza(AdSizeParcel adSizeParcel) {
        Object object = this.zzpc;
        synchronized (object) {
            this.zzyK = adSizeParcel;
            this.requestLayout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzC(boolean bl) {
        Object object = this.zzpc;
        synchronized (object) {
            this.zzJo = bl;
            this.zzhk();
        }
    }

    @Override
    public void zzgZ() {
        this.zzqG.zzgD();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onAttachedToWindow() {
        Object object = this.zzpc;
        synchronized (object) {
            super.onAttachedToWindow();
            if (!this.isDestroyed()) {
                this.zzqG.onAttachedToWindow();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onDetachedFromWindow() {
        Object object = this.zzpc;
        synchronized (object) {
            if (!this.isDestroyed()) {
                this.zzqG.onDetachedFromWindow();
            }
            super.onDetachedFromWindow();
        }
    }

    @Override
    public void setContext(Context context) {
        this.zzJk.setBaseContext(context);
        this.zzqG.zzl(this.zzJk.zzgN());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzD(boolean bl) {
        Object object = this.zzpc;
        synchronized (object) {
            if (this.zzJl != null) {
                this.zzJl.zza(this.zzCq.zzbY(), bl);
            } else {
                this.zzJm = bl;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRequestedOrientation() {
        Object object = this.zzpc;
        synchronized (object) {
            return this.zzJq;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRequestedOrientation(int requestedOrientation) {
        Object object = this.zzpc;
        synchronized (object) {
            this.zzJq = requestedOrientation;
            if (this.zzJl != null) {
                this.zzJl.setRequestedOrientation(this.zzJq);
            }
        }
    }

    @Override
    public Activity zzgN() {
        return this.zzJk.zzgN();
    }

    @Override
    public Context zzgO() {
        return this.zzJk.zzgO();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzhk() {
        Object object = this.zzpc;
        synchronized (object) {
            if (this.zzJo || this.zzyK.zzsH) {
                if (Build.VERSION.SDK_INT < 14) {
                    zzb.zzaC("Disabling hardware acceleration on an overlay.");
                    this.zzhl();
                } else {
                    zzb.zzaC("Enabling hardware acceleration on an overlay.");
                    this.zzhm();
                }
            } else if (Build.VERSION.SDK_INT < 18) {
                zzb.zzaC("Disabling hardware acceleration on an AdView.");
                this.zzhl();
            } else {
                zzb.zzaC("Enabling hardware acceleration on an AdView.");
                this.zzhm();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzhl() {
        Object object = this.zzpc;
        synchronized (object) {
            if (!this.zzJp) {
                zzp.zzbz().zzl((View)this);
            }
            this.zzJp = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzhm() {
        Object object = this.zzpc;
        synchronized (object) {
            if (this.zzJp) {
                zzp.zzbz().zzk((View)this);
            }
            this.zzJp = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        Object object = this.zzpc;
        synchronized (object) {
            this.zzqG.zzgE();
            if (this.zzJl != null) {
                this.zzJl.close();
                this.zzJl.onDestroy();
                this.zzJl = null;
            }
            this.zzCq.reset();
            if (this.zzJn) {
                return;
            }
            zzp.zzbK().zza(this);
            this.zzhn();
            this.zzJn = true;
            zzb.v("Initiating WebView self destruct sequence in 3...");
            this.zzCq.zzhd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzgX() {
        Object object = this.zzpc;
        synchronized (object) {
            zzb.v("Destroying WebView!");
            zzhu.zzHK.post(new Runnable(){

                @Override
                public void run() {
                    zzis.super.destroy();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDestroyed() {
        Object object = this.zzpc;
        synchronized (object) {
            return this.zzJn;
        }
    }

    protected void onDraw(Canvas canvas) {
        if (this.isDestroyed()) {
            return;
        }
        if (Build.VERSION.SDK_INT == 21 && canvas.isHardwareAccelerated() && !this.isAttachedToWindow()) {
            return;
        }
        super.onDraw(canvas);
    }

    public void onPause() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            super.onPause();
        }
        catch (Exception exception) {
            zzb.zzb("Could not pause webview.", exception);
        }
    }

    public void onResume() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            super.onResume();
        }
        catch (Exception exception) {
            zzb.zzb("Could not resume webview.", exception);
        }
    }

    @Override
    public void stopLoading() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            super.stopLoading();
        }
        catch (Exception exception) {
            zzb.zzb("Could not stop loading webview.", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzE(boolean bl) {
        Object object = this.zzpc;
        synchronized (object) {
            this.zzJr = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean zzgY() {
        Object object = this.zzpc;
        synchronized (object) {
            return this.zzJr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzhn() {
        Object object = this.zzpc;
        synchronized (object) {
            if (this.zzJu != null) {
                for (zzdr zzdr2 : this.zzJu.values()) {
                    zzdr2.release();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzaG(String string2) {
        Object object = this.zzpc;
        synchronized (object) {
            this.zzBm = string2 == null ? "" : string2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getRequestId() {
        Object object = this.zzpc;
        synchronized (object) {
            return this.zzBm;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzaH(String string2) {
        Object object = this.zzpc;
        synchronized (object) {
            this.zzJs = string2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String zzha() {
        Object object = this.zzpc;
        synchronized (object) {
            return this.zzJs;
        }
    }

    @Override
    public void zza(zzaz zzaz2, boolean bl) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("isVisible", bl ? "1" : "0");
        this.zzc("onAdVisibilityChanged", hashMap);
    }

    @zzgk
    public static class zza
    extends MutableContextWrapper {
        private Activity zzIs;
        private Context zzqO;
        private Context zzJw;

        public zza(Context context) {
            super(context);
            this.setBaseContext(context);
        }

        public void setBaseContext(Context base) {
            this.zzqO = base.getApplicationContext();
            this.zzIs = base instanceof Activity ? (Activity)base : null;
            this.zzJw = base;
            super.setBaseContext(this.zzqO);
        }

        public void startActivity(Intent intent) {
            if (this.zzIs != null && !zzlv.isAtLeastL()) {
                this.zzIs.startActivity(intent);
            } else {
                intent.setFlags(0x10000000);
                this.zzqO.startActivity(intent);
            }
        }

        public Activity zzgN() {
            return this.zzIs;
        }

        public Object getSystemService(String service) {
            return this.zzJw.getSystemService(service);
        }

        public Context zzgO() {
            return this.zzJw;
        }
    }
}

