/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.client;

import android.content.Context;
import android.os.RemoteException;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.doubleclick.AppEventListener;
import com.google.android.gms.ads.doubleclick.OnCustomRenderedAdLoadedListener;
import com.google.android.gms.ads.doubleclick.PublisherInterstitialAd;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.zza;
import com.google.android.gms.ads.internal.client.zzb;
import com.google.android.gms.ads.internal.client.zzc;
import com.google.android.gms.ads.internal.client.zzh;
import com.google.android.gms.ads.internal.client.zzj;
import com.google.android.gms.ads.internal.client.zzl;
import com.google.android.gms.ads.internal.client.zzs;
import com.google.android.gms.ads.internal.client.zzy;
import com.google.android.gms.ads.purchase.InAppPurchaseListener;
import com.google.android.gms.ads.purchase.PlayStorePurchaseListener;
import com.google.android.gms.internal.zzcl;
import com.google.android.gms.internal.zzel;
import com.google.android.gms.internal.zzfx;
import com.google.android.gms.internal.zzgb;

public class zzaa {
    private final zzel zztD = new zzel();
    private final Context mContext;
    private final zzh zznL;
    private AdListener zzsz;
    private zza zzsy;
    private zzs zztF;
    private String zzpa;
    private String zztG;
    private AppEventListener zztj;
    private PlayStorePurchaseListener zztJ;
    private InAppPurchaseListener zztI;
    private PublisherInterstitialAd zztL;
    private OnCustomRenderedAdLoadedListener zztK;

    public zzaa(Context context) {
        this(context, zzh.zzcB(), null);
    }

    public zzaa(Context context, PublisherInterstitialAd publisherInterstitialAd) {
        this(context, zzh.zzcB(), publisherInterstitialAd);
    }

    public zzaa(Context context, zzh zzh2, PublisherInterstitialAd publisherInterstitialAd) {
        this.mContext = context;
        this.zznL = zzh2;
        this.zztL = publisherInterstitialAd;
    }

    public AdListener getAdListener() {
        return this.zzsz;
    }

    public String getAdUnitId() {
        return this.zzpa;
    }

    public AppEventListener getAppEventListener() {
        return this.zztj;
    }

    public InAppPurchaseListener getInAppPurchaseListener() {
        return this.zztI;
    }

    public OnCustomRenderedAdLoadedListener getOnCustomRenderedAdLoadedListener() {
        return this.zztK;
    }

    public boolean isLoaded() {
        try {
            if (this.zztF == null) {
                return false;
            }
            return this.zztF.isReady();
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to check if ad is ready.", remoteException);
            return false;
        }
    }

    public boolean isLoading() {
        try {
            if (this.zztF == null) {
                return false;
            }
            return this.zztF.isLoading();
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to check if ad is loading.", remoteException);
            return false;
        }
    }

    public void zza(zzy zzy2) {
        try {
            if (this.zztF == null) {
                this.zzM("loadAd");
            }
            if (this.zztF.zzb(this.zznL.zza(this.mContext, zzy2))) {
                this.zztD.zze(zzy2.zzcO());
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to load ad.", remoteException);
        }
    }

    public void setAdListener(AdListener adListener) {
        try {
            this.zzsz = adListener;
            if (this.zztF != null) {
                this.zztF.zza(adListener != null ? new zzc(adListener) : null);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the AdListener.", remoteException);
        }
    }

    public void zza(zza zza2) {
        try {
            this.zzsy = zza2;
            if (this.zztF != null) {
                this.zztF.zza(zza2 != null ? new zzb(zza2) : null);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the AdClickListener.", remoteException);
        }
    }

    public void setAdUnitId(String adUnitId) {
        if (this.zzpa != null) {
            throw new IllegalStateException("The ad unit ID can only be set once on InterstitialAd.");
        }
        this.zzpa = adUnitId;
    }

    public void setAppEventListener(AppEventListener appEventListener) {
        try {
            this.zztj = appEventListener;
            if (this.zztF != null) {
                this.zztF.zza(appEventListener != null ? new zzj(appEventListener) : null);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the AppEventListener.", remoteException);
        }
    }

    public void setInAppPurchaseListener(InAppPurchaseListener inAppPurchaseListener) {
        if (this.zztJ != null) {
            throw new IllegalStateException("Play store purchase parameter has already been set.");
        }
        try {
            this.zztI = inAppPurchaseListener;
            if (this.zztF != null) {
                this.zztF.zza(inAppPurchaseListener != null ? new zzfx(inAppPurchaseListener) : null);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the InAppPurchaseListener.", remoteException);
        }
    }

    public void setOnCustomRenderedAdLoadedListener(OnCustomRenderedAdLoadedListener onCustomRenderedAdLoadedListener) {
        try {
            this.zztK = onCustomRenderedAdLoadedListener;
            if (this.zztF != null) {
                this.zztF.zza(onCustomRenderedAdLoadedListener != null ? new zzcl(onCustomRenderedAdLoadedListener) : null);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the OnCustomRenderedAdLoadedListener.", remoteException);
        }
    }

    public void setPlayStorePurchaseParams(PlayStorePurchaseListener playStorePurchaseListener, String publicKey) {
        if (this.zztI != null) {
            throw new IllegalStateException("In app purchase parameter has already been set.");
        }
        try {
            this.zztJ = playStorePurchaseListener;
            this.zztG = publicKey;
            if (this.zztF != null) {
                this.zztF.zza(playStorePurchaseListener != null ? new zzgb(playStorePurchaseListener) : null, publicKey);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the play store purchase parameter.", remoteException);
        }
    }

    public String getMediationAdapterClassName() {
        try {
            if (this.zztF != null) {
                return this.zztF.getMediationAdapterClassName();
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to get the mediation adapter class name.", remoteException);
        }
        return null;
    }

    public void show() {
        try {
            this.zzN("show");
            this.zztF.showInterstitial();
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to show interstitial.", remoteException);
        }
    }

    private void zzM(String string) throws RemoteException {
        if (this.zzpa == null) {
            this.zzN(string);
        }
        this.zztF = zzl.zzcG().zzb(this.mContext, new AdSizeParcel(), this.zzpa, this.zztD);
        if (this.zzsz != null) {
            this.zztF.zza(new zzc(this.zzsz));
        }
        if (this.zzsy != null) {
            this.zztF.zza(new zzb(this.zzsy));
        }
        if (this.zztj != null) {
            this.zztF.zza(new zzj(this.zztj));
        }
        if (this.zztI != null) {
            this.zztF.zza(new zzfx(this.zztI));
        }
        if (this.zztJ != null) {
            this.zztF.zza(new zzgb(this.zztJ), this.zztG);
        }
        if (this.zztK != null) {
            this.zztF.zza(new zzcl(this.zztK));
        }
    }

    private void zzN(String string) {
        if (this.zztF == null) {
            throw new IllegalStateException("The ad unit ID must be set on InterstitialAd before " + string + " is called.");
        }
    }
}

