/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.formats;

import android.content.Context;
import android.graphics.Rect;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.formats.zzb;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.zzn;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzan;
import com.google.android.gms.internal.zzbb;
import com.google.android.gms.internal.zzdk;
import com.google.android.gms.internal.zzgr;
import com.google.android.gms.internal.zziz;
import com.google.android.gms.internal.zzja;
import java.lang.ref.WeakReference;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

@zzgr
public class zzh {
    private final Object zzpd = new Object();
    private final zzn zzwF;
    private final Context mContext;
    private final JSONObject zzwI;
    private final zzbb zzwJ;
    private final zza zzwK;
    private final zzan zzwL;
    private final VersionInfoParcel zzpb;
    private boolean zzwM;
    private zziz zzoM;
    private String zzwN;

    public zzh(Context context, zzn zzn2, zzbb zzbb2, zzan zzan2, JSONObject jSONObject, zza zza2, VersionInfoParcel versionInfoParcel) {
        this.mContext = context;
        this.zzwF = zzn2;
        this.zzwJ = zzbb2;
        this.zzwL = zzan2;
        this.zzwI = jSONObject;
        this.zzwK = zza2;
        this.zzpb = versionInfoParcel;
    }

    public zzb zza(View.OnClickListener onClickListener) {
        com.google.android.gms.ads.internal.formats.zza zza2 = this.zzwK.zzdz();
        if (zza2 == null) {
            return null;
        }
        zzb zzb2 = new zzb(this.mContext, zza2);
        zzb2.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        zzb2.zzdu().setOnClickListener(onClickListener);
        zzb2.zzdu().setContentDescription((CharSequence)"Ad attribution icon");
        return zzb2;
    }

    public void zza(String string, JSONObject jSONObject, JSONObject jSONObject2) {
        zzx.zzci((String)"performClick must be called on the main UI thread.");
        try {
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("asset", (Object)string);
            jSONObject3.put("template", (Object)this.zzwK.zzdy());
            JSONObject jSONObject4 = new JSONObject();
            jSONObject4.put("ad", (Object)this.zzwI);
            jSONObject4.put("click", (Object)jSONObject3);
            jSONObject4.put("has_custom_click_handler", this.zzwF.zzr(this.zzwK.getCustomTemplateId()) != null);
            if (jSONObject != null) {
                jSONObject4.put("view_rectangles", (Object)jSONObject);
            }
            if (jSONObject2 != null) {
                jSONObject4.put("click_point", (Object)jSONObject2);
            }
            this.zzwJ.zza("google.afma.nativeAds.handleClickGmsg", jSONObject4);
        }
        catch (JSONException jSONException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzb("Unable to create click JSON.", jSONException);
        }
    }

    public void zza(View view, Map<String, WeakReference<View>> map, JSONObject jSONObject, JSONObject jSONObject2) {
        zzx.zzci((String)"performClick must be called on the main UI thread.");
        for (Map.Entry<String, WeakReference<View>> entry : map.entrySet()) {
            View view2 = (View)entry.getValue().get();
            if (!view.equals(view2)) continue;
            this.zza(entry.getKey(), jSONObject, jSONObject2);
            break;
        }
    }

    public void zzb(MotionEvent motionEvent) {
        this.zzwL.zza(motionEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzi(View view) {
        Object object = this.zzpd;
        synchronized (object) {
            if (this.zzwM) {
                return;
            }
            if (!view.isShown()) {
                return;
            }
            if (!view.getGlobalVisibleRect(new Rect(), null)) {
                return;
            }
            this.recordImpression();
        }
    }

    public void recordImpression() {
        zzx.zzci((String)"recordImpression must be called on the main UI thread.");
        this.zzl(true);
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("ad", (Object)this.zzwI);
            this.zzwJ.zza("google.afma.nativeAds.handleImpressionPing", jSONObject);
        }
        catch (JSONException jSONException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzb("Unable to create impression JSON.", jSONException);
        }
    }

    public void zzh(View view) {
    }

    public zziz zzdC() {
        this.zzoM = this.zzdD();
        this.zzoM.getView().setVisibility(8);
        this.zzwJ.zza("/loadHtml", new zzdk(){

            @Override
            public void zza(zziz zziz2, final Map<String, String> map) {
                zzh.this.zzoM.zzhe().zza(new zzja.zza(){

                    @Override
                    public void zza(zziz zziz2, boolean bl) {
                        zzh.this.zzwN = (String)map.get("id");
                        JSONObject jSONObject = new JSONObject();
                        try {
                            jSONObject.put("messageType", (Object)"htmlLoaded");
                            jSONObject.put("id", (Object)zzh.this.zzwN);
                            zzh.this.zzwJ.zzb("sendMessageToNativeJs", jSONObject);
                        }
                        catch (JSONException jSONException) {
                            com.google.android.gms.ads.internal.util.client.zzb.zzb("Unable to dispatch sendMessageToNativeJsevent", jSONException);
                        }
                    }
                });
                String string = map.get("overlayHtml");
                String string2 = map.get("baseUrl");
                if (TextUtils.isEmpty((CharSequence)string2)) {
                    zzh.this.zzoM.loadData(string, "text/html", "UTF-8");
                } else {
                    zzh.this.zzoM.loadDataWithBaseURL(string2, string, "text/html", "UTF-8", null);
                }
            }
        });
        this.zzwJ.zza("/showOverlay", new zzdk(){

            @Override
            public void zza(zziz zziz2, Map<String, String> map) {
                zzh.this.zzoM.getView().setVisibility(0);
            }
        });
        this.zzwJ.zza("/hideOverlay", new zzdk(){

            @Override
            public void zza(zziz zziz2, Map<String, String> map) {
                zzh.this.zzoM.getView().setVisibility(8);
            }
        });
        this.zzoM.zzhe().zza("/hideOverlay", new zzdk(){

            @Override
            public void zza(zziz zziz2, Map<String, String> map) {
                zzh.this.zzoM.getView().setVisibility(8);
            }
        });
        this.zzoM.zzhe().zza("/sendMessageToSdk", new zzdk(){

            @Override
            public void zza(zziz zziz2, Map<String, String> map) {
                JSONObject jSONObject = new JSONObject();
                try {
                    for (String string : map.keySet()) {
                        jSONObject.put(string, (Object)map.get(string));
                    }
                    jSONObject.put("id", (Object)zzh.this.zzwN);
                    zzh.this.zzwJ.zzb("sendMessageToNativeJs", jSONObject);
                }
                catch (JSONException jSONException) {
                    com.google.android.gms.ads.internal.util.client.zzb.zzb("Unable to dispatch sendMessageToNativeJs event", jSONException);
                }
            }
        });
        return this.zzoM;
    }

    protected void zzl(boolean bl) {
        this.zzwM = bl;
    }

    zziz zzdD() {
        return zzp.zzbw().zza(this.mContext, AdSizeParcel.zzs(this.mContext), false, false, this.zzwL, this.zzpb);
    }

    public Context getContext() {
        return this.mContext;
    }

    public static interface zza {
        public void zza(zzh var1);

        public String zzdy();

        public String getCustomTemplateId();

        public com.google.android.gms.ads.internal.formats.zza zzdz();
    }
}

