/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.provider.CalendarContract;
import android.text.TextUtils;
import com.google.android.gms.R;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.internal.zzbq;
import com.google.android.gms.internal.zzfh;
import com.google.android.gms.internal.zzgr;
import com.google.android.gms.internal.zziz;
import java.util.Map;

@zzgr
public class zzfb
extends zzfh {
    private final Map<String, String> zzvS;
    private final Context mContext;
    private String zzzV;
    private long zzzW;
    private long zzzX;
    private String zzzY;
    private String zzzZ;

    public zzfb(zziz zziz2, Map<String, String> map) {
        super(zziz2, "createCalendarEvent");
        this.zzvS = map;
        this.mContext = zziz2.zzgZ();
        this.zzec();
    }

    private void zzec() {
        this.zzzV = this.zzah("description");
        this.zzzY = this.zzah("summary");
        this.zzzW = this.zzai("start_ticks");
        this.zzzX = this.zzai("end_ticks");
        this.zzzZ = this.zzah("location");
    }

    private String zzah(String string2) {
        return TextUtils.isEmpty((CharSequence)this.zzvS.get(string2)) ? "" : this.zzvS.get(string2);
    }

    private long zzai(String string2) {
        String string3 = this.zzvS.get(string2);
        if (string3 == null) {
            return -1L;
        }
        try {
            return Long.parseLong(string3);
        }
        catch (NumberFormatException numberFormatException) {
            return -1L;
        }
    }

    public void execute() {
        if (this.mContext == null) {
            this.zzak("Activity context is not available.");
            return;
        }
        zzbq zzbq2 = zzp.zzbv().zzL(this.mContext);
        if (!zzbq2.zzdb()) {
            this.zzak("This feature is not available on the device.");
            return;
        }
        AlertDialog.Builder builder = zzp.zzbv().zzK(this.mContext);
        builder.setTitle((CharSequence)zzp.zzby().zzd(R.string.create_calendar_title, "Create calendar event"));
        builder.setMessage((CharSequence)zzp.zzby().zzd(R.string.create_calendar_message, "Allow Ad to create a calendar event?"));
        builder.setPositiveButton((CharSequence)zzp.zzby().zzd(R.string.accept, "Accept"), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                Intent intent = zzfb.this.createIntent();
                zzp.zzbv().zzb(zzfb.this.mContext, intent);
            }
        });
        builder.setNegativeButton((CharSequence)zzp.zzby().zzd(R.string.decline, "Decline"), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                zzfb.this.zzak("Operation denied by user.");
            }
        });
        builder.create().show();
    }

    Intent createIntent() {
        Intent intent = new Intent("android.intent.action.EDIT").setData(CalendarContract.Events.CONTENT_URI);
        intent.putExtra("title", this.zzzV);
        intent.putExtra("eventLocation", this.zzzZ);
        intent.putExtra("description", this.zzzY);
        if (this.zzzW > -1L) {
            intent.putExtra("beginTime", this.zzzW);
        }
        if (this.zzzX > -1L) {
            intent.putExtra("endTime", this.zzzX);
        }
        intent.setFlags(0x10000000);
        return intent;
    }
}

