/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.media.AudioManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import com.google.android.gms.ads.internal.client.zzl;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.internal.zzgr;
import java.util.Locale;

@zzgr
public final class zzgy {
    public final int zzGs;
    public final boolean zzGt;
    public final boolean zzGu;
    public final String zzGv;
    public final String zzGw;
    public final boolean zzGx;
    public final boolean zzGy;
    public final boolean zzGz;
    public final boolean zzGA;
    public final String zzGB;
    public final String zzGC;
    public final int zzGD;
    public final int zzGE;
    public final int zzGF;
    public final int zzGG;
    public final int zzGH;
    public final int zzGI;
    public final float zzEz;
    public final int zzEx;
    public final int zzEy;
    public final double zzGJ;
    public final boolean zzGK;
    public final boolean zzGL;
    public final int zzGM;
    public final String zzGN;

    zzgy(int n, boolean bl, boolean bl2, String string2, String string3, boolean bl3, boolean bl4, boolean bl5, boolean bl6, String string4, String string5, int n2, int n3, int n4, int n5, int n6, int n7, float f, int n8, int n9, double d, boolean bl7, boolean bl8, int n10, String string6) {
        this.zzGs = n;
        this.zzGt = bl;
        this.zzGu = bl2;
        this.zzGv = string2;
        this.zzGw = string3;
        this.zzGx = bl3;
        this.zzGy = bl4;
        this.zzGz = bl5;
        this.zzGA = bl6;
        this.zzGB = string4;
        this.zzGC = string5;
        this.zzGD = n2;
        this.zzGE = n3;
        this.zzGF = n4;
        this.zzGG = n5;
        this.zzGH = n6;
        this.zzGI = n7;
        this.zzEz = f;
        this.zzEx = n8;
        this.zzEy = n9;
        this.zzGJ = d;
        this.zzGK = bl7;
        this.zzGL = bl8;
        this.zzGM = n10;
        this.zzGN = string6;
    }

    public static final class zza {
        private int zzGs;
        private boolean zzGz;
        private boolean zzGA;
        private int zzGD;
        private int zzGH;
        private int zzGI;
        private String zzGv;
        private int zzGE;
        private int zzGF;
        private int zzGG;
        private boolean zzGL;
        private int zzGM;
        private double zzGJ;
        private boolean zzGK;
        private String zzGN;
        private boolean zzGt;
        private boolean zzGu;
        private String zzGw;
        private boolean zzGx;
        private boolean zzGy;
        private String zzGB;
        private String zzGC;
        private float zzEz;
        private int zzEx;
        private int zzEy;

        public zza(Context context) {
            PackageManager packageManager = context.getPackageManager();
            this.zzz(context);
            this.zza(context, packageManager);
            this.zzA(context);
            Locale locale = Locale.getDefault();
            this.zzGt = zza.zza(packageManager, "geo:0,0?q=donuts") != null;
            this.zzGu = zza.zza(packageManager, "http://www.google.com") != null;
            this.zzGw = locale.getCountry();
            this.zzGx = zzl.zzcF().zzgS();
            this.zzGy = GooglePlayServicesUtil.zzag((Context)context);
            this.zzGB = locale.getLanguage();
            this.zzGC = zza.zza(packageManager);
            Resources resources = context.getResources();
            if (resources == null) {
                return;
            }
            DisplayMetrics displayMetrics = resources.getDisplayMetrics();
            if (displayMetrics == null) {
                return;
            }
            this.zzEz = displayMetrics.density;
            this.zzEx = displayMetrics.widthPixels;
            this.zzEy = displayMetrics.heightPixels;
        }

        public zza(Context context, zzgy zzgy2) {
            PackageManager packageManager = context.getPackageManager();
            this.zzz(context);
            this.zza(context, packageManager);
            this.zzA(context);
            this.zzB(context);
            this.zzGt = zzgy2.zzGt;
            this.zzGu = zzgy2.zzGu;
            this.zzGw = zzgy2.zzGw;
            this.zzGx = zzgy2.zzGx;
            this.zzGy = zzgy2.zzGy;
            this.zzGB = zzgy2.zzGB;
            this.zzGC = zzgy2.zzGC;
            this.zzEz = zzgy2.zzEz;
            this.zzEx = zzgy2.zzEx;
            this.zzEy = zzgy2.zzEy;
        }

        private void zzz(Context context) {
            AudioManager audioManager = (AudioManager)context.getSystemService("audio");
            this.zzGs = audioManager.getMode();
            this.zzGz = audioManager.isMusicActive();
            this.zzGA = audioManager.isSpeakerphoneOn();
            this.zzGD = audioManager.getStreamVolume(3);
            this.zzGH = audioManager.getRingerMode();
            this.zzGI = audioManager.getStreamVolume(2);
        }

        private void zza(Context context, PackageManager packageManager) {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            this.zzGv = telephonyManager.getNetworkOperator();
            this.zzGF = telephonyManager.getNetworkType();
            this.zzGG = telephonyManager.getPhoneType();
            this.zzGE = -2;
            this.zzGL = false;
            this.zzGM = -1;
            if (zzp.zzbv().zza(packageManager, context.getPackageName(), "android.permission.ACCESS_NETWORK_STATE")) {
                NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
                if (networkInfo != null) {
                    this.zzGE = networkInfo.getType();
                    this.zzGM = networkInfo.getDetailedState().ordinal();
                } else {
                    this.zzGE = -1;
                }
                if (Build.VERSION.SDK_INT >= 16) {
                    this.zzGL = connectivityManager.isActiveNetworkMetered();
                }
            }
        }

        private void zzA(Context context) {
            IntentFilter intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
            Intent intent = context.registerReceiver(null, intentFilter);
            if (intent != null) {
                int n = intent.getIntExtra("status", -1);
                int n2 = intent.getIntExtra("level", -1);
                int n3 = intent.getIntExtra("scale", -1);
                this.zzGJ = (float)n2 / (float)n3;
                this.zzGK = n == 2 || n == 5;
            } else {
                this.zzGJ = -1.0;
                this.zzGK = false;
            }
        }

        private void zzB(Context context) {
            this.zzGN = Build.FINGERPRINT;
        }

        private static String zza(PackageManager packageManager) {
            ResolveInfo resolveInfo = zza.zza(packageManager, "market://details?id=com.google.android.gms.ads");
            if (resolveInfo == null) {
                return null;
            }
            ActivityInfo activityInfo = resolveInfo.activityInfo;
            if (activityInfo == null) {
                return null;
            }
            try {
                PackageInfo packageInfo = packageManager.getPackageInfo(activityInfo.packageName, 0);
                return packageInfo != null ? packageInfo.versionCode + "." + activityInfo.packageName : null;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                return null;
            }
        }

        private static ResolveInfo zza(PackageManager packageManager, String string2) {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)string2));
            return packageManager.resolveActivity(intent, 65536);
        }

        public zzgy zzfX() {
            return new zzgy(this.zzGs, this.zzGt, this.zzGu, this.zzGv, this.zzGw, this.zzGx, this.zzGy, this.zzGz, this.zzGA, this.zzGB, this.zzGC, this.zzGD, this.zzGE, this.zzGF, this.zzGG, this.zzGH, this.zzGI, this.zzEz, this.zzEx, this.zzEy, this.zzGJ, this.zzGK, this.zzGL, this.zzGM, this.zzGN);
        }
    }
}

