/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.RemoteException;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.reward.client.RewardedVideoAdRequestParcel;
import com.google.android.gms.ads.internal.reward.client.zzd;
import com.google.android.gms.ads.internal.reward.mediation.client.RewardItemParcel;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzcg;
import com.google.android.gms.internal.zzem;
import com.google.android.gms.internal.zzgr;
import com.google.android.gms.internal.zzhe;
import com.google.android.gms.internal.zzhh;
import com.google.android.gms.internal.zzhk;
import com.google.android.gms.internal.zzhn;
import com.google.android.gms.internal.zzhs;
import com.google.android.gms.internal.zzid;
import java.util.HashMap;

@zzgr
public class zzhg
extends com.google.android.gms.ads.internal.zzb
implements zzhk {
    private zzd zzGX;
    private String zzGY;
    private boolean zzGZ;
    private HashMap<String, zzhh> zzHa = new HashMap();

    public zzhg(Context context, AdSizeParcel adSizeParcel, zzem zzem2, VersionInfoParcel versionInfoParcel) {
        super(context, adSizeParcel, null, zzem2, versionInfoParcel, null);
    }

    public void setUserId(String userId) {
        zzx.zzci((String)"setUserId must be called on the main UI thread.");
        this.zzGY = userId;
    }

    public void zza(RewardedVideoAdRequestParcel rewardedVideoAdRequestParcel) {
        zzx.zzci((String)"loadAd must be called on the main UI thread.");
        if (TextUtils.isEmpty((CharSequence)rewardedVideoAdRequestParcel.zzqh)) {
            zzb.zzaH("Invalid ad unit id. Aborting.");
            return;
        }
        this.zzGZ = false;
        this.zzot.zzqh = rewardedVideoAdRequestParcel.zzqh;
        super.zzb(rewardedVideoAdRequestParcel.zzEn);
    }

    @Override
    public void zza(final zzhs.zza zza2, zzcg zzcg2) {
        if (zza2.errorCode != -2) {
            zzid.zzIE.post(new Runnable(){

                @Override
                public void run() {
                    zzhg.this.zzb(new zzhs(zza2, null, null, null, null, null, null));
                }
            });
            return;
        }
        this.zzot.zzqH = 0;
        this.zzot.zzqm = new zzhn(this.zzot.context, this.zzGY, zza2, this);
        zzb.zzaF("AdRenderer: " + this.zzot.zzqm.getClass().getName());
        this.zzot.zzqm.zzfu();
    }

    public zzhh zzau(String string) {
        zzhh zzhh2 = this.zzHa.get(string);
        if (zzhh2 == null) {
            try {
                zzhh2 = new zzhh(this.zzox.zzae(string), this);
                this.zzHa.put(string, zzhh2);
            }
            catch (Exception exception) {
                zzb.zzd("Fail to instantiate adapter " + string, exception);
            }
        }
        return zzhh2;
    }

    @Override
    public boolean zza(zzhs zzhs2, zzhs zzhs3) {
        if (this.zzGX != null) {
            try {
                this.zzGX.onRewardedVideoAdLoaded();
            }
            catch (RemoteException remoteException) {
                zzb.zzd("Could not call RewardedVideoAdListener.onAdLoaded().", remoteException);
            }
        }
        return true;
    }

    @Override
    public void pause() {
        zzx.zzci((String)"pause must be called on the main UI thread.");
        for (String string : this.zzHa.keySet()) {
            try {
                zzhh zzhh2 = this.zzHa.get(string);
                if (zzhh2 == null || zzhh2.zzgc() == null) continue;
                zzhh2.zzgc().pause();
            }
            catch (RemoteException remoteException) {
                zzb.zzaH("Fail to pause adapter: " + string);
            }
        }
    }

    @Override
    public void resume() {
        zzx.zzci((String)"resume must be called on the main UI thread.");
        for (String string : this.zzHa.keySet()) {
            try {
                zzhh zzhh2 = this.zzHa.get(string);
                if (zzhh2 == null || zzhh2.zzgc() == null) continue;
                zzhh2.zzgc().resume();
            }
            catch (RemoteException remoteException) {
                zzb.zzaH("Fail to resume adapter: " + string);
            }
        }
    }

    @Override
    public void destroy() {
        zzx.zzci((String)"destroy must be called on the main UI thread.");
        for (String string : this.zzHa.keySet()) {
            try {
                zzhh zzhh2 = this.zzHa.get(string);
                if (zzhh2 == null || zzhh2.zzgc() == null) continue;
                zzhh2.zzgc().destroy();
            }
            catch (RemoteException remoteException) {
                zzb.zzaH("Fail to destroy adapter: " + string);
            }
        }
    }

    @Override
    protected boolean zze(int n) {
        zzb.zzaH("Failed to load ad: " + n);
        if (this.zzGX == null) {
            return false;
        }
        try {
            this.zzGX.onRewardedVideoAdFailedToLoad(n);
            return true;
        }
        catch (RemoteException remoteException) {
            zzb.zzd("Could not call RewardedVideoAdListener.onAdFailedToLoad().", remoteException);
            return false;
        }
    }

    public void zzga() {
        zzx.zzci((String)"showAd must be called on the main UI thread.");
        if (!this.isLoaded()) {
            zzb.zzaH("The reward video has not loaded.");
            return;
        }
        this.zzGZ = true;
        zzhh zzhh2 = this.zzau(this.zzot.zzqo.zzzw);
        if (zzhh2 != null && zzhh2.zzgc() != null) {
            try {
                zzhh2.zzgc().showVideo();
            }
            catch (RemoteException remoteException) {
                zzb.zzd("Could not call showVideo.", remoteException);
            }
        }
    }

    public boolean isLoaded() {
        zzx.zzci((String)"isLoaded must be called on the main UI thread.");
        return this.zzot.zzql == null && this.zzot.zzqm == null && this.zzot.zzqo != null && !this.zzGZ;
    }

    public void zza(zzd zzd2) {
        zzx.zzci((String)"setRewardedVideoAdListener must be called on the main UI thread.");
        this.zzGX = zzd2;
    }

    @Override
    public void onRewardedVideoAdOpened() {
        this.zza(this.zzot.zzqo, false);
        if (this.zzGX == null) {
            return;
        }
        try {
            this.zzGX.onRewardedVideoAdOpened();
        }
        catch (RemoteException remoteException) {
            zzb.zzd("Could not call RewardedVideoAdListener.onAdOpened().", remoteException);
        }
    }

    @Override
    public void onRewardedVideoStarted() {
        zzp.zzbH().zza(this.zzot.context, this.zzot.zzqj.zzJu, this.zzot.zzqo, this.zzot.zzqh, false, this.zzot.zzqo.zzzu.zzyU);
        if (this.zzGX == null) {
            return;
        }
        try {
            this.zzGX.onRewardedVideoStarted();
        }
        catch (RemoteException remoteException) {
            zzb.zzd("Could not call RewardedVideoAdListener.onVideoStarted().", remoteException);
        }
    }

    @Override
    public void onRewardedVideoAdClosed() {
        if (this.zzGX == null) {
            return;
        }
        try {
            this.zzGX.onRewardedVideoAdClosed();
        }
        catch (RemoteException remoteException) {
            zzb.zzd("Could not call RewardedVideoAdListener.onAdClosed().", remoteException);
        }
    }

    @Override
    public void zza(RewardItemParcel rewardItemParcel) {
        zzp.zzbH().zza(this.zzot.context, this.zzot.zzqj.zzJu, this.zzot.zzqo, this.zzot.zzqh, false, this.zzot.zzqo.zzzu.zzyV);
        if (this.zzGX == null) {
            return;
        }
        try {
            if (this.zzot.zzqo != null && this.zzot.zzqo.zzHx != null && !TextUtils.isEmpty((CharSequence)this.zzot.zzqo.zzHx.zzzd)) {
                this.zzGX.zza(new zzhe(this.zzot.zzqo.zzHx.zzzd, this.zzot.zzqo.zzHx.zzze));
            } else {
                this.zzGX.zza(new zzhe(rewardItemParcel.type, rewardItemParcel.zzHv));
            }
        }
        catch (RemoteException remoteException) {
            zzb.zzd("Could not call RewardedVideoAdListener.onRewarded().", remoteException);
        }
    }

    @Override
    public void zzgb() {
        this.onAdClicked();
    }

    @Override
    public void onRewardedVideoAdLeftApplication() {
        if (this.zzGX == null) {
            return;
        }
        try {
            this.zzGX.onRewardedVideoAdLeftApplication();
        }
        catch (RemoteException remoteException) {
            zzb.zzd("Could not call RewardedVideoAdListener.onAdLeftApplication().", remoteException);
        }
    }
}

