/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.content.Context;
import android.os.RemoteException;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.Correlator;
import com.google.android.gms.ads.doubleclick.PublisherAdRequest;
import com.google.android.gms.ads.formats.NativeAdOptions;
import com.google.android.gms.ads.formats.NativeAppInstallAd;
import com.google.android.gms.ads.formats.NativeContentAd;
import com.google.android.gms.ads.formats.NativeCustomTemplateAd;
import com.google.android.gms.ads.internal.client.zzc;
import com.google.android.gms.ads.internal.client.zzd;
import com.google.android.gms.ads.internal.client.zzh;
import com.google.android.gms.ads.internal.client.zzp;
import com.google.android.gms.ads.internal.client.zzq;
import com.google.android.gms.ads.internal.client.zzy;
import com.google.android.gms.ads.internal.formats.NativeAdOptionsParcel;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzdc;
import com.google.android.gms.internal.zzdd;
import com.google.android.gms.internal.zzde;
import com.google.android.gms.internal.zzdf;
import com.google.android.gms.internal.zzev;

public class AdLoader {
    private final zzh zzoq;
    private final Context mContext;
    private final zzp zzor;

    AdLoader(Context context, zzp adLoader) {
        this(context, adLoader, zzh.zzcJ());
    }

    AdLoader(Context context, zzp adLoader, zzh parcelFactory) {
        this.mContext = context;
        this.zzor = adLoader;
        this.zzoq = parcelFactory;
    }

    private void zza(zzy zzy2) {
        try {
            this.zzor.zzf(this.zzoq.zza(this.mContext, zzy2));
        }
        catch (RemoteException remoteException) {
            zzb.zzb("Failed to load ad.", remoteException);
        }
    }

    public void loadAd(AdRequest adRequest) {
        this.zza(adRequest.zzaG());
    }

    public void loadAd(PublisherAdRequest publisherAdRequest) {
        this.zza(publisherAdRequest.zzaG());
    }

    public String getMediationAdapterClassName() {
        try {
            return this.zzor.getMediationAdapterClassName();
        }
        catch (RemoteException remoteException) {
            zzb.zzd("Failed to get the mediation adapter class name.", remoteException);
            return null;
        }
    }

    public boolean isLoading() {
        try {
            return this.zzor.isLoading();
        }
        catch (RemoteException remoteException) {
            zzb.zzd("Failed to check if ad is loading.", remoteException);
            return false;
        }
    }

    public static class Builder {
        private final Context mContext;
        private final zzq zzos;

        public Builder(Context context, String adUnitID) {
            this((Context)zzx.zzb((Object)context, (Object)"context cannot be null"), zzd.zza(context, adUnitID, new zzev()));
        }

        Builder(Context context, zzq builder) {
            this.mContext = context;
            this.zzos = builder;
        }

        public Builder forContentAd(NativeContentAd.OnContentAdLoadedListener listener) {
            try {
                this.zzos.zza(new zzdd(listener));
            }
            catch (RemoteException remoteException) {
                zzb.zzd("Failed to add content ad listener", remoteException);
            }
            return this;
        }

        public Builder forAppInstallAd(NativeAppInstallAd.OnAppInstallAdLoadedListener listener) {
            try {
                this.zzos.zza(new zzdc(listener));
            }
            catch (RemoteException remoteException) {
                zzb.zzd("Failed to add app install ad listener", remoteException);
            }
            return this;
        }

        public Builder forCustomTemplateAd(String templateId, NativeCustomTemplateAd.OnCustomTemplateAdLoadedListener adLoadedListener, NativeCustomTemplateAd.OnCustomClickListener customClickListener) {
            try {
                this.zzos.zza(templateId, new zzdf(adLoadedListener), customClickListener == null ? null : new zzde(customClickListener));
            }
            catch (RemoteException remoteException) {
                zzb.zzd("Failed to add custom template ad listener", remoteException);
            }
            return this;
        }

        public Builder withAdListener(AdListener listener) {
            try {
                this.zzos.zzb(new zzc(listener));
            }
            catch (RemoteException remoteException) {
                zzb.zzd("Failed to set AdListener.", remoteException);
            }
            return this;
        }

        public Builder withNativeAdOptions(NativeAdOptions options) {
            try {
                this.zzos.zza(new NativeAdOptionsParcel(options));
            }
            catch (RemoteException remoteException) {
                zzb.zzd("Failed to specify native ad options", remoteException);
            }
            return this;
        }

        public Builder withCorrelator(Correlator correlator) {
            zzx.zzy((Object)correlator);
            try {
                this.zzos.zzb(correlator.zzaH());
            }
            catch (RemoteException remoteException) {
                zzb.zzd("Failed to set correlator.", remoteException);
            }
            return this;
        }

        public AdLoader build() {
            try {
                return new AdLoader(this.mContext, this.zzos.zzbm());
            }
            catch (RemoteException remoteException) {
                zzb.zzb("Failed to build AdLoader.", remoteException);
                return null;
            }
        }
    }
}

