/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.formats;

import android.content.Context;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.google.android.gms.ads.formats.NativeAd;
import com.google.android.gms.ads.internal.client.zzl;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzcp;

public abstract class NativeAdView
extends FrameLayout {
    private final FrameLayout zzoF;
    private final zzcp zzoG;

    public NativeAdView(Context context) {
        super(context);
        this.zzoF = this.zzn(context);
        this.zzoG = this.zzaK();
    }

    public NativeAdView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.zzoF = this.zzn(context);
        this.zzoG = this.zzaK();
    }

    public NativeAdView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.zzoF = this.zzn(context);
        this.zzoG = this.zzaK();
    }

    public NativeAdView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.zzoF = this.zzn(context);
        this.zzoG = this.zzaK();
    }

    protected void zza(String string2, View view) {
        try {
            this.zzoG.zza(string2, zze.zzB((Object)view));
        }
        catch (RemoteException remoteException) {
            zzb.zzb("Unable to call setAssetView on delegate", remoteException);
        }
    }

    protected View zzm(String string2) {
        try {
            zzd zzd2 = this.zzoG.zzU(string2);
            if (zzd2 != null) {
                return (View)zze.zzp((zzd)zzd2);
            }
        }
        catch (RemoteException remoteException) {
            zzb.zzb("Unable to call getAssetView on delegate", remoteException);
        }
        return null;
    }

    public void setNativeAd(NativeAd ad) {
        try {
            this.zzoG.zzb((zzd)ad.zzaJ());
        }
        catch (RemoteException remoteException) {
            zzb.zzb("Unable to call setNativeAd on delegate", remoteException);
        }
    }

    public void destroy() {
        try {
            this.zzoG.destroy();
        }
        catch (RemoteException remoteException) {
            zzb.zzb("Unable to destroy native ad view", remoteException);
        }
    }

    private FrameLayout zzn(Context context) {
        FrameLayout frameLayout = this.zzo(context);
        frameLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.addView((View)frameLayout);
        return frameLayout;
    }

    FrameLayout zzo(Context context) {
        return new FrameLayout(context);
    }

    private zzcp zzaK() {
        zzx.zzb((Object)this.zzoF, (Object)"createDelegate must be called after mOverlayFrame has been created");
        return zzl.zzcQ().zza(this.zzoF.getContext(), this, this.zzoF);
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        super.addView(child, index, params);
        super.bringChildToFront((View)this.zzoF);
    }

    public void removeView(View child) {
        if (this.zzoF == child) {
            return;
        }
        super.removeView(child);
    }

    public void removeAllViews() {
        super.removeAllViews();
        super.addView((View)this.zzoF);
    }

    public void bringChildToFront(View child) {
        super.bringChildToFront(child);
        if (this.zzoF != child) {
            super.bringChildToFront((View)this.zzoF);
        }
    }
}

