/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.formats;

import android.content.Context;
import android.graphics.Rect;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.formats.zzb;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.zzn;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzan;
import com.google.android.gms.internal.zzbb;
import com.google.android.gms.internal.zzdl;
import com.google.android.gms.internal.zzha;
import com.google.android.gms.internal.zzjn;
import com.google.android.gms.internal.zzjo;
import java.lang.ref.WeakReference;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

@zzha
public class zzh {
    private final Object zzpK = new Object();
    private final zzn zzxP;
    private final Context mContext;
    private final JSONObject zzxS;
    private final zzbb zzxT;
    private final zza zzxU;
    private final zzan zzxV;
    private final VersionInfoParcel zzpI;
    private boolean zzxW;
    private zzjn zzps;
    private String zzxX;
    private WeakReference<View> zzxY = null;

    public zzh(Context context, zzn zzn2, zzbb zzbb2, zzan zzan2, JSONObject jSONObject, zza zza2, VersionInfoParcel versionInfoParcel) {
        this.mContext = context;
        this.zzxP = zzn2;
        this.zzxT = zzbb2;
        this.zzxV = zzan2;
        this.zzxS = jSONObject;
        this.zzxU = zza2;
        this.zzpI = versionInfoParcel;
    }

    public zzb zza(View.OnClickListener onClickListener) {
        com.google.android.gms.ads.internal.formats.zza zza2 = this.zzxU.zzdG();
        if (zza2 == null) {
            return null;
        }
        zzb zzb2 = new zzb(this.mContext, zza2);
        zzb2.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        zzb2.zzdB().setOnClickListener(onClickListener);
        zzb2.zzdB().setContentDescription((CharSequence)"Ad attribution icon");
        return zzb2;
    }

    public void zza(String string2, JSONObject jSONObject, JSONObject jSONObject2, JSONObject jSONObject3) {
        zzx.zzcx((String)"performClick must be called on the main UI thread.");
        try {
            JSONObject jSONObject4 = new JSONObject();
            jSONObject4.put("asset", (Object)string2);
            jSONObject4.put("template", (Object)this.zzxU.zzdF());
            JSONObject jSONObject5 = new JSONObject();
            jSONObject5.put("ad", (Object)this.zzxS);
            jSONObject5.put("click", (Object)jSONObject4);
            jSONObject5.put("has_custom_click_handler", this.zzxP.zzr(this.zzxU.getCustomTemplateId()) != null);
            if (jSONObject != null) {
                jSONObject5.put("view_rectangles", (Object)jSONObject);
            }
            if (jSONObject2 != null) {
                jSONObject5.put("click_point", (Object)jSONObject2);
            }
            if (jSONObject3 != null) {
                jSONObject5.put("native_view_rectangle", (Object)jSONObject3);
            }
            this.zzxT.zza("google.afma.nativeAds.handleClickGmsg", jSONObject5);
        }
        catch (JSONException jSONException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzb("Unable to create click JSON.", jSONException);
        }
    }

    public void zza(View view, Map<String, WeakReference<View>> map, JSONObject jSONObject, JSONObject jSONObject2, JSONObject jSONObject3) {
        zzx.zzcx((String)"performClick must be called on the main UI thread.");
        for (Map.Entry<String, WeakReference<View>> entry : map.entrySet()) {
            View view2 = (View)entry.getValue().get();
            if (!view.equals(view2)) continue;
            this.zza(entry.getKey(), jSONObject, jSONObject2, jSONObject3);
            break;
        }
    }

    public void zzb(MotionEvent motionEvent) {
        this.zzxV.zza(motionEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzi(View view) {
        Object object = this.zzpK;
        synchronized (object) {
            if (this.zzxW) {
                return;
            }
            if (!view.isShown()) {
                return;
            }
            if (!view.getGlobalVisibleRect(new Rect(), null)) {
                return;
            }
            this.recordImpression();
        }
    }

    public void recordImpression() {
        zzx.zzcx((String)"recordImpression must be called on the main UI thread.");
        this.zzn(true);
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("ad", (Object)this.zzxS);
            this.zzxT.zza("google.afma.nativeAds.handleImpressionPing", jSONObject);
        }
        catch (JSONException jSONException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzb("Unable to create impression JSON.", jSONException);
        }
        this.zzxP.zza(this);
    }

    public View zzdL() {
        return this.zzxY != null ? (View)this.zzxY.get() : null;
    }

    public void zzj(View view) {
        this.zzxY = new WeakReference<View>(view);
    }

    public void zzh(View view) {
    }

    public zzjn zzdK() {
        this.zzps = this.zzdM();
        this.zzps.getView().setVisibility(8);
        this.zzxT.zza("/loadHtml", new zzdl(){

            @Override
            public void zza(zzjn zzjn2, final Map<String, String> map) {
                zzh.this.zzps.zzhC().zza(new zzjo.zza(){

                    @Override
                    public void zza(zzjn zzjn2, boolean bl) {
                        zzh.this.zzxX = (String)map.get("id");
                        JSONObject jSONObject = new JSONObject();
                        try {
                            jSONObject.put("messageType", (Object)"htmlLoaded");
                            jSONObject.put("id", (Object)zzh.this.zzxX);
                            zzh.this.zzxT.zzb("sendMessageToNativeJs", jSONObject);
                        }
                        catch (JSONException jSONException) {
                            com.google.android.gms.ads.internal.util.client.zzb.zzb("Unable to dispatch sendMessageToNativeJsevent", jSONException);
                        }
                    }
                });
                String string2 = map.get("overlayHtml");
                String string3 = map.get("baseUrl");
                if (TextUtils.isEmpty((CharSequence)string3)) {
                    zzh.this.zzps.loadData(string2, "text/html", "UTF-8");
                } else {
                    zzh.this.zzps.loadDataWithBaseURL(string3, string2, "text/html", "UTF-8", null);
                }
            }
        });
        this.zzxT.zza("/showOverlay", new zzdl(){

            @Override
            public void zza(zzjn zzjn2, Map<String, String> map) {
                zzh.this.zzps.getView().setVisibility(0);
            }
        });
        this.zzxT.zza("/hideOverlay", new zzdl(){

            @Override
            public void zza(zzjn zzjn2, Map<String, String> map) {
                zzh.this.zzps.getView().setVisibility(8);
            }
        });
        this.zzps.zzhC().zza("/hideOverlay", new zzdl(){

            @Override
            public void zza(zzjn zzjn2, Map<String, String> map) {
                zzh.this.zzps.getView().setVisibility(8);
            }
        });
        this.zzps.zzhC().zza("/sendMessageToSdk", new zzdl(){

            @Override
            public void zza(zzjn zzjn2, Map<String, String> map) {
                JSONObject jSONObject = new JSONObject();
                try {
                    for (String string2 : map.keySet()) {
                        jSONObject.put(string2, (Object)map.get(string2));
                    }
                    jSONObject.put("id", (Object)zzh.this.zzxX);
                    zzh.this.zzxT.zzb("sendMessageToNativeJs", jSONObject);
                }
                catch (JSONException jSONException) {
                    com.google.android.gms.ads.internal.util.client.zzb.zzb("Unable to dispatch sendMessageToNativeJs event", jSONException);
                }
            }
        });
        return this.zzps;
    }

    protected void zzn(boolean bl) {
        this.zzxW = bl;
    }

    zzjn zzdM() {
        return zzp.zzby().zza(this.mContext, AdSizeParcel.zzt(this.mContext), false, false, this.zzxV, this.zzpI);
    }

    public Context getContext() {
        return this.mContext;
    }

    public static interface zza {
        public void zzb(zzh var1);

        public String zzdF();

        public String getCustomTemplateId();

        public com.google.android.gms.ads.internal.formats.zza zzdG();
    }
}

