/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.formats;

import android.graphics.Point;
import android.graphics.Rect;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import com.google.android.gms.ads.internal.client.zzl;
import com.google.android.gms.ads.internal.formats.zzb;
import com.google.android.gms.ads.internal.formats.zzg;
import com.google.android.gms.ads.internal.formats.zzh;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzcp;
import com.google.android.gms.internal.zzha;
import com.google.android.gms.internal.zzip;
import com.google.android.gms.internal.zzji;
import com.google.android.gms.internal.zzjn;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

@zzha
public class zzj
extends zzcp.zza
implements View.OnClickListener,
View.OnTouchListener,
ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener {
    private final Object zzpK = new Object();
    private final FrameLayout zzyf;
    private FrameLayout zzoF;
    private Map<String, WeakReference<View>> zzyg = new HashMap<String, WeakReference<View>>();
    private zzb zzyh;
    private zzh zzxH;
    boolean zzyi = false;
    int zzyj;
    int zzyk;

    public zzj(FrameLayout frameLayout, FrameLayout frameLayout2) {
        this.zzyf = frameLayout;
        this.zzoF = frameLayout2;
        zzji.zza((View)this.zzyf, this);
        zzji.zza((View)this.zzyf, this);
        this.zzyf.setOnTouchListener((View.OnTouchListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zza(String string2, zzd zzd2) {
        View view = (View)zze.zzp((zzd)zzd2);
        Object object = this.zzpK;
        synchronized (object) {
            if (view == null) {
                this.zzyg.remove(string2);
            } else {
                this.zzyg.put(string2, new WeakReference<View>(view));
                view.setOnTouchListener((View.OnTouchListener)this);
                view.setOnClickListener((View.OnClickListener)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public zzd zzU(String string2) {
        Object object = this.zzpK;
        synchronized (object) {
            WeakReference<View> weakReference = this.zzyg.get(string2);
            return zze.zzB(weakReference == null ? null : (View)weakReference.get());
        }
    }

    void zzj(View view) {
        zzh zzh2 = null;
        if (this.zzxH != null && (zzh2 = this.zzxH instanceof zzg ? ((zzg)this.zzxH).zzdJ() : this.zzxH) != null) {
            zzh2.zzj(view);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzb(zzd zzd2) {
        Object object = this.zzpK;
        synchronized (object) {
            this.zzyi = true;
            this.zzj(null);
            final zzh zzh2 = (zzh)zze.zzp((zzd)zzd2);
            if (this.zzxH instanceof zzg && ((zzg)this.zzxH).zzdI()) {
                ((zzg)this.zzxH).zzc(zzh2);
            } else {
                this.zzxH = zzh2;
                if (this.zzxH instanceof zzg) {
                    ((zzg)this.zzxH).zzc(null);
                }
            }
            this.zzoF.removeAllViews();
            this.zzyh = this.zzg(zzh2);
            if (this.zzyh != null) {
                this.zzyg.put("1007", new WeakReference<ViewGroup>(this.zzyh.zzdB()));
                this.zzoF.addView((View)this.zzyh);
            }
            zzip.zzKO.post(new Runnable(){

                @Override
                public void run() {
                    zzjn zzjn2 = zzh2.zzdK();
                    if (zzjn2 != null) {
                        zzj.this.zzoF.addView(zzjn2.getView());
                    }
                }
            });
            zzh2.zzh((View)this.zzyf);
            this.zzj((View)this.zzyf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClick(View view) {
        Object object = this.zzpK;
        synchronized (object) {
            if (this.zzxH == null) {
                return;
            }
            JSONObject jSONObject2 = new JSONObject();
            for (Map.Entry<String, WeakReference<View>> jSONObject3 : this.zzyg.entrySet()) {
                View view2 = (View)jSONObject3.getValue().get();
                Point point = this.zzk(view2);
                JSONObject jSONObject = new JSONObject();
                try {
                    jSONObject.put("width", this.zzq(view2.getWidth()));
                    jSONObject.put("height", this.zzq(view2.getHeight()));
                    jSONObject.put("x", this.zzq(point.x));
                    jSONObject.put("y", this.zzq(point.y));
                    jSONObject2.put(jSONObject3.getKey(), (Object)jSONObject);
                }
                catch (JSONException jSONException) {
                    com.google.android.gms.ads.internal.util.client.zzb.zzaH("Unable to get view rectangle for view " + jSONObject3.getKey());
                }
            }
            JSONObject jSONObject5 = new JSONObject();
            try {
                jSONObject5.put("x", this.zzq(this.zzyj));
                jSONObject5.put("y", this.zzq(this.zzyk));
            }
            catch (JSONException jSONException) {
                com.google.android.gms.ads.internal.util.client.zzb.zzaH("Unable to get click location");
            }
            JSONObject jSONObject = new JSONObject();
            try {
                jSONObject.put("width", this.zzq(this.getMeasuredWidth()));
                jSONObject.put("height", this.zzq(this.getMeasuredHeight()));
            }
            catch (JSONException jSONException) {
                com.google.android.gms.ads.internal.util.client.zzb.zzaH("Unable to get native ad view bounding box");
            }
            if (this.zzyh != null && this.zzyh.zzdB().equals(view)) {
                this.zzxH.zza("1007", jSONObject2, jSONObject5, jSONObject);
            } else {
                this.zzxH.zza(view, this.zzyg, jSONObject2, jSONObject5, jSONObject);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onGlobalLayout() {
        Object object = this.zzpK;
        synchronized (object) {
            if (this.zzyi) {
                int n = this.getMeasuredWidth();
                int n2 = this.getMeasuredHeight();
                if (n != 0 && n2 != 0) {
                    this.zzoF.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(n, n2));
                    this.zzyi = false;
                }
            }
            if (this.zzxH != null) {
                this.zzxH.zzi((View)this.zzyf);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onScrollChanged() {
        Object object = this.zzpK;
        synchronized (object) {
            if (this.zzxH != null) {
                this.zzxH.zzi((View)this.zzyf);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onTouch(View view, MotionEvent motionEvent) {
        Object object = this.zzpK;
        synchronized (object) {
            if (this.zzxH == null) {
                return false;
            }
            Point point = this.zzc(motionEvent);
            this.zzyj = point.x;
            this.zzyk = point.y;
            MotionEvent motionEvent2 = MotionEvent.obtain((MotionEvent)motionEvent);
            motionEvent2.setLocation((float)point.x, (float)point.y);
            this.zzxH.zzb(motionEvent2);
            motionEvent2.recycle();
            return false;
        }
    }

    @Override
    public void destroy() {
        this.zzoF.removeAllViews();
        this.zzoF = null;
        this.zzyg = null;
        this.zzyh = null;
        this.zzxH = null;
    }

    Point zzc(MotionEvent motionEvent) {
        int[] nArray = new int[2];
        this.zzyf.getLocationOnScreen(nArray);
        float f = motionEvent.getRawX() - (float)nArray[0];
        float f2 = motionEvent.getRawY() - (float)nArray[1];
        return new Point((int)f, (int)f2);
    }

    zzb zzg(zzh zzh2) {
        return zzh2.zza(this);
    }

    int getMeasuredWidth() {
        return this.zzyf.getMeasuredWidth();
    }

    int getMeasuredHeight() {
        return this.zzyf.getMeasuredHeight();
    }

    int zzq(int n) {
        return zzl.zzcN().zzc(this.zzxH.getContext(), n);
    }

    Point zzk(View view) {
        if (this.zzyh != null && this.zzyh.zzdB().equals(view)) {
            Point point = new Point();
            this.zzyf.getGlobalVisibleRect(new Rect(), point);
            Point point2 = new Point();
            view.getGlobalVisibleRect(new Rect(), point2);
            return new Point(point2.x - point.x, point2.y - point.y);
        }
        Point point = new Point();
        view.getGlobalVisibleRect(new Rect(), point);
        return point;
    }
}

