/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.TextureView;
import com.google.android.gms.ads.internal.overlay.zzi;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.internal.zzbz;
import com.google.android.gms.internal.zzcd;
import com.google.android.gms.internal.zzcf;
import com.google.android.gms.internal.zzch;
import com.google.android.gms.internal.zzha;
import com.google.android.gms.internal.zzit;
import java.util.concurrent.TimeUnit;

@zzha
public class zzp {
    private final Context mContext;
    private final String zzDX;
    private final VersionInfoParcel zzDY;
    private final zzcf zzDZ;
    private final zzch zzEa;
    private final zzit zzEb = new zzit.zzb().zza("min_1", Double.MIN_VALUE, 1.0).zza("1_5", 1.0, 5.0).zza("5_10", 5.0, 10.0).zza("10_20", 10.0, 20.0).zza("20_30", 20.0, 30.0).zza("30_max", 30.0, Double.MAX_VALUE).zzhi();
    private final long[] zzEc;
    private final String[] zzEd;
    private zzcf zzEe;
    private zzcf zzEf;
    private zzcf zzEg;
    private zzcf zzEh;
    private boolean zzEi;
    private zzi zzEj;
    private boolean zzEk;
    private boolean zzEl;
    private long zzEm = -1L;

    public zzp(Context context, VersionInfoParcel versionInfoParcel, String string2, zzch zzch2, zzcf zzcf2) {
        this.mContext = context;
        this.zzDY = versionInfoParcel;
        this.zzDX = string2;
        this.zzEa = zzch2;
        this.zzDZ = zzcf2;
        String string3 = zzbz.zzvA.get();
        if (string3 == null) {
            this.zzEd = new String[0];
            this.zzEc = new long[0];
            return;
        }
        String[] stringArray = TextUtils.split((String)string3, (String)",");
        this.zzEd = new String[stringArray.length];
        this.zzEc = new long[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                this.zzEc[i] = Long.parseLong(stringArray[i]);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                zzb.zzd("Unable to parse frame hash target time number.", numberFormatException);
                this.zzEc[i] = -1L;
            }
        }
    }

    public void zza(zzi zzi2) {
        zzcd.zza(this.zzEa, this.zzDZ, "vpc");
        this.zzEe = zzcd.zzb(this.zzEa);
        this.zzEj = zzi2;
    }

    public void zzfo() {
        if (this.zzEe == null || this.zzEf != null) {
            return;
        }
        zzcd.zza(this.zzEa, this.zzEe, "vfr");
        this.zzEf = zzcd.zzb(this.zzEa);
    }

    public void onStop() {
        if (zzbz.zzvz.get().booleanValue() && !this.zzEk) {
            Bundle bundle = new Bundle();
            bundle.putString("type", "native-player-metrics");
            bundle.putString("request", this.zzDX);
            bundle.putString("player", this.zzEj.zzeO());
            for (zzit.zza object : this.zzEb.getBuckets()) {
                bundle.putString("fps_c_" + object.name, Integer.toString(object.count));
                bundle.putString("fps_p_" + object.name, Double.toString(object.zzLg));
            }
            for (int i = 0; i < this.zzEc.length; ++i) {
                String string2 = this.zzEd[i];
                if (string2 == null) continue;
                bundle.putString("fh_" + Long.valueOf(this.zzEc[i]), string2);
            }
            com.google.android.gms.ads.internal.zzp.zzbx().zza(this.mContext, this.zzDY.afmaVersion, "gmob-apps", bundle, true);
            this.zzEk = true;
        }
    }

    public void zzb(zzi zzi2) {
        this.zzfA();
        this.zzc(zzi2);
    }

    private void zzfA() {
        if (this.zzEg != null && this.zzEh == null) {
            zzcd.zza(this.zzEa, this.zzEg, "vff");
            zzcd.zza(this.zzEa, this.zzDZ, "vtt");
            this.zzEh = zzcd.zzb(this.zzEa);
        }
        long l = com.google.android.gms.ads.internal.zzp.zzbB().nanoTime();
        if (this.zzEi && this.zzEl && this.zzEm != -1L) {
            double d = (double)TimeUnit.SECONDS.toNanos(1L) / (double)(l - this.zzEm);
            this.zzEb.zza(d);
        }
        this.zzEl = this.zzEi;
        this.zzEm = l;
    }

    private void zzc(zzi zzi2) {
        long l = zzbz.zzvB.get();
        long l2 = zzi2.getCurrentPosition();
        for (int i = 0; i < this.zzEd.length; ++i) {
            long l3;
            if (this.zzEd[i] != null || l <= Math.abs(l2 - (l3 = this.zzEc[i]))) continue;
            this.zzEd[i] = this.zza((TextureView)zzi2);
            break;
        }
    }

    String zza(TextureView textureView) {
        Bitmap bitmap = textureView.getBitmap(8, 8);
        long l = 0L;
        long l2 = 63L;
        for (int i = 0; i < 8; ++i) {
            int n = 0;
            while (n < 8) {
                int n2 = bitmap.getPixel(n, i);
                int n3 = Color.blue((int)n2) + Color.red((int)n2) + Color.green((int)n2);
                long l3 = n3 > 128 ? 1L : 0L;
                l |= l3 << (int)l2;
                ++n;
                --l2;
            }
        }
        return String.format("%016X", l);
    }

    public void zzfB() {
        this.zzEi = true;
        if (this.zzEf != null && this.zzEg == null) {
            zzcd.zza(this.zzEa, this.zzEf, "vfp");
            this.zzEg = zzcd.zzb(this.zzEa);
        }
    }

    public void zzfC() {
        this.zzEi = false;
    }
}

