/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.request;

import android.content.Context;
import android.os.Binder;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Looper;
import android.os.RemoteException;
import com.google.android.gms.ads.internal.request.AdRequestInfoParcel;
import com.google.android.gms.ads.internal.request.AdResponseParcel;
import com.google.android.gms.ads.internal.request.zzc;
import com.google.android.gms.ads.internal.request.zze;
import com.google.android.gms.ads.internal.request.zzg;
import com.google.android.gms.ads.internal.request.zzj;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.internal.zzbs;
import com.google.android.gms.internal.zzbz;
import com.google.android.gms.internal.zzha;
import com.google.android.gms.internal.zzhb;
import com.google.android.gms.internal.zzhc;
import com.google.android.gms.internal.zzir;
import com.google.android.gms.internal.zzjg;

@zzha
public abstract class zzd
implements zzc.zza,
zzir<Void> {
    private final zzjg<AdRequestInfoParcel> zzGi;
    private final zzc.zza zzGj;
    private final Object zzpK = new Object();

    public zzd(zzjg<AdRequestInfoParcel> zzjg2, zzc.zza zza2) {
        this.zzGi = zzjg2;
        this.zzGj = zza2;
    }

    public abstract void zzge();

    public abstract zzj zzgf();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzb(AdResponseParcel adResponseParcel) {
        Object object = this.zzpK;
        synchronized (object) {
            this.zzGj.zzb(adResponseParcel);
            this.zzge();
        }
    }

    public Void zzfO() {
        final zzj zzj2 = this.zzgf();
        if (zzj2 == null) {
            this.zzGj.zzb(new AdResponseParcel(0));
            this.zzge();
            return null;
        }
        this.zzGi.zza(new zzjg.zzc<AdRequestInfoParcel>(){

            @Override
            public void zzc(AdRequestInfoParcel adRequestInfoParcel) {
                if (!zzd.this.zza(zzj2, adRequestInfoParcel)) {
                    zzd.this.zzge();
                }
            }
        }, new zzjg.zza(){

            @Override
            public void run() {
                zzd.this.zzge();
            }
        });
        return null;
    }

    @Override
    public void cancel() {
        this.zzge();
    }

    boolean zza(zzj zzj2, AdRequestInfoParcel adRequestInfoParcel) {
        try {
            zzj2.zza(adRequestInfoParcel, new zzg(this));
            return true;
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Could not fetch ad response from ad request service.", remoteException);
            zzp.zzbA().zzb(remoteException, true);
        }
        catch (NullPointerException nullPointerException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Could not fetch ad response from ad request service due to an Exception.", nullPointerException);
            zzp.zzbA().zzb(nullPointerException, true);
        }
        catch (SecurityException securityException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Could not fetch ad response from ad request service due to an Exception.", securityException);
            zzp.zzbA().zzb(securityException, true);
        }
        catch (Throwable throwable) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Could not fetch ad response from ad request service due to an Exception.", throwable);
            zzp.zzbA().zzb(throwable, true);
        }
        this.zzGj.zzb(new AdResponseParcel(0));
        return false;
    }

    @Override
    public /* synthetic */ Object zzfR() {
        return this.zzfO();
    }

    @zzha
    public static class zzb
    extends zzd
    implements GoogleApiClient.ConnectionCallbacks,
    GoogleApiClient.OnConnectionFailedListener {
        private Context mContext;
        private VersionInfoParcel zzpI;
        private zzjg<AdRequestInfoParcel> zzGi;
        private final zzc.zza zzGj;
        private final Object zzpK = new Object();
        protected zze zzGm;
        private boolean zzGn;

        public zzb(Context context, VersionInfoParcel versionInfoParcel, zzjg<AdRequestInfoParcel> zzjg2, zzc.zza zza2) {
            super(zzjg2, zza2);
            Looper looper;
            this.mContext = context;
            this.zzpI = versionInfoParcel;
            this.zzGi = zzjg2;
            this.zzGj = zza2;
            if (zzbz.zzvF.get().booleanValue()) {
                this.zzGn = true;
                looper = zzp.zzbJ().zzhk();
            } else {
                looper = context.getMainLooper();
            }
            this.zzGm = new zze(context, looper, this, this, this.zzpI.zzLG);
            this.connect();
        }

        protected void connect() {
            this.zzGm.zzqp();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public zzj zzgf() {
            Object object = this.zzpK;
            synchronized (object) {
                try {
                    return this.zzGm.zzgj();
                }
                catch (DeadObjectException | IllegalStateException throwable) {
                    return null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzge() {
            Object object = this.zzpK;
            synchronized (object) {
                if (this.zzGm.isConnected() || this.zzGm.isConnecting()) {
                    this.zzGm.disconnect();
                }
                Binder.flushPendingCommands();
                if (this.zzGn) {
                    zzp.zzbJ().zzhl();
                    this.zzGn = false;
                }
            }
        }

        zzir zzgg() {
            return new zza(this.mContext, this.zzGi, this.zzGj);
        }

        public void onConnectionFailed(ConnectionResult result) {
            com.google.android.gms.ads.internal.util.client.zzb.zzaF("Cannot connect to remote service, fallback to local instance.");
            zzir zzir2 = this.zzgg();
            zzir2.zzfR();
            Bundle bundle = new Bundle();
            bundle.putString("action", "gms_connection_failed_fallback_to_local");
            zzp.zzbx().zzb(this.mContext, this.zzpI.afmaVersion, "gmob-apps", bundle, true);
        }

        public void onConnected(Bundle connectionHint) {
            this.zzfO();
        }

        public void onConnectionSuspended(int cause) {
            com.google.android.gms.ads.internal.util.client.zzb.zzaF("Disconnected from remote ad request service.");
        }

        @Override
        public /* synthetic */ Object zzfR() {
            return super.zzfO();
        }
    }

    @zzha
    public static final class zza
    extends zzd {
        private final Context mContext;

        public zza(Context context, zzjg<AdRequestInfoParcel> zzjg2, zzc.zza zza2) {
            super(zzjg2, zza2);
            this.mContext = context;
        }

        @Override
        public zzj zzgf() {
            zzbs zzbs2 = new zzbs(zzbz.zzvg.get());
            return zzhc.zza(this.mContext, zzbs2, zzhb.zzgn());
        }

        @Override
        public void zzge() {
        }

        @Override
        public /* synthetic */ Object zzfR() {
            return super.zzfO();
        }
    }
}

