/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.internal.zzai;
import com.google.android.gms.internal.zzaj;
import com.google.android.gms.internal.zzap;
import com.google.android.gms.internal.zzaq;
import com.google.android.gms.internal.zztb;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.UUID;

public abstract class zzak
implements zzaj {
    protected MotionEvent zzno;
    protected DisplayMetrics zznp;
    protected zzap zznq;
    protected static GoogleApiClient zznr;
    private static zzaq zzns;

    protected zzak(Context context, zzap zzap2, zzaq zzaq2) {
        this.zznq = zzap2;
        zzns = zzaq2;
        try {
            this.zznp = context.getResources().getDisplayMetrics();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            this.zznp = new DisplayMetrics();
            this.zznp.density = 1.0f;
        }
    }

    protected abstract void zzc(Context var1);

    protected abstract void zzd(Context var1);

    @Override
    public String zzb(Context context) {
        return this.zza(context, null, false);
    }

    @Override
    public String zzb(Context context, String string2) {
        return this.zza(context, string2, true);
    }

    @Override
    public void zza(MotionEvent motionEvent) {
        if (motionEvent.getAction() == 1) {
            if (this.zzno != null) {
                this.zzno.recycle();
            }
            this.zzno = MotionEvent.obtain((MotionEvent)motionEvent);
        }
    }

    @Override
    public void zza(int n, int n2, int n3) {
        if (this.zzno != null) {
            this.zzno.recycle();
        }
        this.zzno = MotionEvent.obtain((long)0L, (long)n3, (int)1, (float)((float)n * this.zznp.density), (float)((float)n2 * this.zznp.density), (float)0.0f, (float)0.0f, (int)0, (float)0.0f, (float)0.0f, (int)0, (int)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String zza(Context context, String string2, boolean bl) {
        String string3;
        try {
            byte[] byArray;
            zzak zzak2 = this;
            synchronized (zzak2) {
                this.zzS();
                if (bl) {
                    this.zzd(context);
                } else {
                    this.zzc(context);
                }
                byArray = this.zzT();
            }
            string3 = byArray.length == 0 ? Integer.toString(5) : this.zza(byArray, string2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            string3 = Integer.toString(7);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string3 = Integer.toString(7);
        }
        catch (IOException iOException) {
            string3 = Integer.toString(3);
        }
        return string3;
    }

    protected void zza(int n, long l) throws IOException {
        zzns.zzb(n, l);
    }

    protected void zza(int n, String string2) throws IOException {
        zzns.zzb(n, string2);
    }

    private void zzS() {
        zzns.reset();
    }

    private byte[] zzT() throws IOException {
        return zzns.zzad();
    }

    String zza(byte[] byArray, String string2) throws NoSuchAlgorithmException, UnsupportedEncodingException, IOException {
        byte[] byArray2;
        Object object;
        if (byArray.length > 239) {
            this.zzS();
            this.zza(20, 1L);
            byArray = this.zzT();
        }
        if (byArray.length < 239) {
            object = new byte[239 - byArray.length];
            new SecureRandom().nextBytes((byte[])object);
            byArray2 = ByteBuffer.allocate(240).put((byte)byArray.length).put(byArray).put((byte[])object).array();
        } else {
            byArray2 = ByteBuffer.allocate(240).put((byte)byArray.length).put(byArray).array();
        }
        object = MessageDigest.getInstance("MD5");
        ((MessageDigest)object).update(byArray2);
        byte[] byArray3 = ((MessageDigest)object).digest();
        byte[] byArray4 = ByteBuffer.allocate(256).put(byArray3).put(byArray2).array();
        byte[] byArray5 = new byte[256];
        new zzai().zzb(byArray4, byArray5);
        if (string2 != null && string2.length() > 0) {
            this.zza(string2, byArray5);
        }
        return this.zznq.zza(byArray5, true);
    }

    void zza(String string2, byte[] byArray) throws UnsupportedEncodingException {
        if (string2.length() > 32) {
            string2 = string2.substring(0, 32);
        }
        byte[] byArray2 = string2.getBytes("UTF-8");
        new zztb(byArray2).zzB(byArray);
    }

    protected String zzk(String string2) {
        if (string2 != null && string2.matches("^[a-fA-F0-9]{8}-([a-fA-F0-9]{4}-){3}[a-fA-F0-9]{12}$")) {
            UUID uUID = UUID.fromString(string2);
            byte[] byArray = new byte[16];
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            byteBuffer.putLong(uUID.getMostSignificantBits());
            byteBuffer.putLong(uUID.getLeastSignificantBits());
            string2 = this.zznq.zza(byArray, true);
        }
        return string2;
    }
}

