/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.provider.CalendarContract;
import android.text.TextUtils;
import com.google.android.gms.R;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.internal.zzbr;
import com.google.android.gms.internal.zzfr;
import com.google.android.gms.internal.zzha;
import com.google.android.gms.internal.zzjn;
import java.util.Map;

@zzha
public class zzfl
extends zzfr {
    private final Map<String, String> zzxc;
    private final Context mContext;
    private String zzBU;
    private long zzBV;
    private long zzBW;
    private String zzBX;
    private String zzBY;

    public zzfl(zzjn zzjn2, Map<String, String> map) {
        super(zzjn2, "createCalendarEvent");
        this.zzxc = map;
        this.mContext = zzjn2.zzhx();
        this.zzez();
    }

    private void zzez() {
        this.zzBU = this.zzai("description");
        this.zzBX = this.zzai("summary");
        this.zzBV = this.zzaj("start_ticks");
        this.zzBW = this.zzaj("end_ticks");
        this.zzBY = this.zzai("location");
    }

    private String zzai(String string2) {
        return TextUtils.isEmpty((CharSequence)this.zzxc.get(string2)) ? "" : this.zzxc.get(string2);
    }

    private long zzaj(String string2) {
        String string3 = this.zzxc.get(string2);
        if (string3 == null) {
            return -1L;
        }
        try {
            return Long.parseLong(string3);
        }
        catch (NumberFormatException numberFormatException) {
            return -1L;
        }
    }

    public void execute() {
        if (this.mContext == null) {
            this.zzal("Activity context is not available.");
            return;
        }
        zzbr zzbr2 = zzp.zzbx().zzN(this.mContext);
        if (!zzbr2.zzdi()) {
            this.zzal("This feature is not available on the device.");
            return;
        }
        AlertDialog.Builder builder = zzp.zzbx().zzM(this.mContext);
        builder.setTitle((CharSequence)zzp.zzbA().zzf(R.string.create_calendar_title, "Create calendar event"));
        builder.setMessage((CharSequence)zzp.zzbA().zzf(R.string.create_calendar_message, "Allow Ad to create a calendar event?"));
        builder.setPositiveButton((CharSequence)zzp.zzbA().zzf(R.string.accept, "Accept"), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                Intent intent = zzfl.this.createIntent();
                zzp.zzbx().zzb(zzfl.this.mContext, intent);
            }
        });
        builder.setNegativeButton((CharSequence)zzp.zzbA().zzf(R.string.decline, "Decline"), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                zzfl.this.zzal("Operation denied by user.");
            }
        });
        builder.create().show();
    }

    Intent createIntent() {
        Intent intent = new Intent("android.intent.action.EDIT").setData(CalendarContract.Events.CONTENT_URI);
        intent.putExtra("title", this.zzBU);
        intent.putExtra("eventLocation", this.zzBY);
        intent.putExtra("description", this.zzBX);
        if (this.zzBV > -1L) {
            intent.putExtra("beginTime", this.zzBV);
        }
        if (this.zzBW > -1L) {
            intent.putExtra("endTime", this.zzBW);
        }
        intent.setFlags(0x10000000);
        return intent;
    }
}

