/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.graphics.Color;
import android.location.Location;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.client.AdRequestParcel;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.SearchAdRequestParcel;
import com.google.android.gms.ads.internal.formats.NativeAdOptionsParcel;
import com.google.android.gms.ads.internal.request.AdRequestInfoParcel;
import com.google.android.gms.ads.internal.request.AdResponseParcel;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.internal.zzbs;
import com.google.android.gms.internal.zzha;
import com.google.android.gms.internal.zzhc;
import com.google.android.gms.internal.zzhi;
import com.google.android.gms.internal.zzhm;
import com.google.android.gms.internal.zzik;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzha
public final class zzhd {
    private static final SimpleDateFormat zzHU = new SimpleDateFormat("yyyyMMdd", Locale.US);

    public static JSONObject zza(Context context, AdRequestInfoParcel adRequestInfoParcel, zzhi zzhi2, zzhm.zza zza2, Location location, zzbs zzbs2, String string2, String string3, List<String> list, Bundle bundle) {
        try {
            CharSequence charSequence;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            if (list.size() > 0) {
                hashMap.put("eid", TextUtils.join((CharSequence)",", list));
            }
            if (adRequestInfoParcel.zzGp != null) {
                hashMap.put("ad_pos", adRequestInfoParcel.zzGp);
            }
            zzhd.zza(hashMap, adRequestInfoParcel.zzGq);
            hashMap.put("format", adRequestInfoParcel.zzqV.zztV);
            if (adRequestInfoParcel.zzqV.width == -1) {
                hashMap.put("smart_w", "full");
            }
            if (adRequestInfoParcel.zzqV.height == -2) {
                hashMap.put("smart_h", "auto");
            }
            if (adRequestInfoParcel.zzqV.zztZ) {
                hashMap.put("fluid", "height");
            }
            if (adRequestInfoParcel.zzqV.zztX != null) {
                charSequence = new StringBuilder();
                for (AdSizeParcel adSizeParcel : adRequestInfoParcel.zzqV.zztX) {
                    if (charSequence.length() != 0) {
                        charSequence.append("|");
                    }
                    charSequence.append(adSizeParcel.width == -1 ? (int)((float)adSizeParcel.widthPixels / zzhi2.zzGC) : adSizeParcel.width);
                    charSequence.append("x");
                    charSequence.append(adSizeParcel.height == -2 ? (int)((float)adSizeParcel.heightPixels / zzhi2.zzGC) : adSizeParcel.height);
                }
                hashMap.put("sz", charSequence);
            }
            if (adRequestInfoParcel.zzGw != 0) {
                hashMap.put("native_version", adRequestInfoParcel.zzGw);
                if (!adRequestInfoParcel.zzqV.zzua) {
                    hashMap.put("native_templates", adRequestInfoParcel.zzrl);
                    hashMap.put("native_image_orientation", zzhd.zzc(adRequestInfoParcel.zzrj));
                    if (!adRequestInfoParcel.zzGH.isEmpty()) {
                        hashMap.put("native_custom_templates", adRequestInfoParcel.zzGH);
                    }
                }
            }
            hashMap.put("slotname", adRequestInfoParcel.zzqP);
            hashMap.put("pn", adRequestInfoParcel.applicationInfo.packageName);
            if (adRequestInfoParcel.zzGr != null) {
                hashMap.put("vc", adRequestInfoParcel.zzGr.versionCode);
            }
            hashMap.put("ms", string3);
            hashMap.put("seq_num", adRequestInfoParcel.zzGt);
            hashMap.put("session_id", adRequestInfoParcel.zzGu);
            hashMap.put("js", adRequestInfoParcel.zzqR.afmaVersion);
            zzhd.zza(hashMap, zzhi2, zza2);
            hashMap.put("platform", Build.MANUFACTURER);
            hashMap.put("submodel", Build.MODEL);
            if (adRequestInfoParcel.zzGq.versionCode >= 2 && adRequestInfoParcel.zzGq.zzty != null) {
                zzhd.zza(hashMap, adRequestInfoParcel.zzGq.zzty);
            }
            if (adRequestInfoParcel.versionCode >= 2) {
                hashMap.put("quality_signals", adRequestInfoParcel.zzGv);
            }
            if (adRequestInfoParcel.versionCode >= 4 && adRequestInfoParcel.zzGy) {
                hashMap.put("forceHttps", adRequestInfoParcel.zzGy);
            }
            if (bundle != null) {
                hashMap.put("content_info", bundle);
            }
            if (adRequestInfoParcel.versionCode >= 5) {
                hashMap.put("u_sd", Float.valueOf(adRequestInfoParcel.zzGC));
                hashMap.put("sh", adRequestInfoParcel.zzGB);
                hashMap.put("sw", adRequestInfoParcel.zzGA);
            } else {
                hashMap.put("u_sd", Float.valueOf(zzhi2.zzGC));
                hashMap.put("sh", zzhi2.zzGB);
                hashMap.put("sw", zzhi2.zzGA);
            }
            if (adRequestInfoParcel.versionCode >= 6) {
                if (!TextUtils.isEmpty((CharSequence)adRequestInfoParcel.zzGD)) {
                    try {
                        hashMap.put("view_hierarchy", new JSONObject(adRequestInfoParcel.zzGD));
                    }
                    catch (JSONException jSONException) {
                        zzb.zzd("Problem serializing view hierarchy to JSON", jSONException);
                    }
                }
                hashMap.put("correlation_id", adRequestInfoParcel.zzGE);
            }
            if (adRequestInfoParcel.versionCode >= 7) {
                hashMap.put("request_id", adRequestInfoParcel.zzGF);
            }
            if (adRequestInfoParcel.versionCode >= 11 && adRequestInfoParcel.zzGJ != null) {
                hashMap.put("capability", adRequestInfoParcel.zzGJ.toBundle());
            }
            zzhd.zza(hashMap, string2);
            if (adRequestInfoParcel.versionCode >= 12 && !TextUtils.isEmpty((CharSequence)adRequestInfoParcel.zzGK)) {
                hashMap.put("anchor", adRequestInfoParcel.zzGK);
            }
            if (zzb.zzQ(2)) {
                charSequence = zzp.zzbx().zzz(hashMap).toString(2);
                zzb.v("Ad Request JSON: " + (String)charSequence);
            }
            return zzp.zzbx().zzz(hashMap);
        }
        catch (JSONException jSONException) {
            zzb.zzaH("Problem serializing ad request to JSON: " + jSONException.getMessage());
            return null;
        }
    }

    private static void zza(HashMap<String, Object> hashMap, String string2) {
        if (string2 != null) {
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            hashMap2.put("token", string2);
            hashMap.put("pan", hashMap2);
        }
    }

    private static void zza(HashMap<String, Object> hashMap, AdRequestParcel adRequestParcel) {
        String string2 = zzik.zzgW();
        if (string2 != null) {
            hashMap.put("abf", string2);
        }
        if (adRequestParcel.zztq != -1L) {
            hashMap.put("cust_age", zzHU.format(new Date(adRequestParcel.zztq)));
        }
        if (adRequestParcel.extras != null) {
            hashMap.put("extras", adRequestParcel.extras);
        }
        if (adRequestParcel.zztr != -1) {
            hashMap.put("cust_gender", adRequestParcel.zztr);
        }
        if (adRequestParcel.zzts != null) {
            hashMap.put("kw", adRequestParcel.zzts);
        }
        if (adRequestParcel.zztu != -1) {
            hashMap.put("tag_for_child_directed_treatment", adRequestParcel.zztu);
        }
        if (adRequestParcel.zztt) {
            hashMap.put("adtest", "on");
        }
        if (adRequestParcel.versionCode >= 2) {
            if (adRequestParcel.zztv) {
                hashMap.put("d_imp_hdr", 1);
            }
            if (!TextUtils.isEmpty((CharSequence)adRequestParcel.zztw)) {
                hashMap.put("ppid", adRequestParcel.zztw);
            }
            if (adRequestParcel.zztx != null) {
                zzhd.zza(hashMap, adRequestParcel.zztx);
            }
        }
        if (adRequestParcel.versionCode >= 3 && adRequestParcel.zztz != null) {
            hashMap.put("url", adRequestParcel.zztz);
        }
        if (adRequestParcel.versionCode >= 5) {
            if (adRequestParcel.zztB != null) {
                hashMap.put("custom_targeting", adRequestParcel.zztB);
            }
            if (adRequestParcel.zztC != null) {
                hashMap.put("category_exclusions", adRequestParcel.zztC);
            }
            if (adRequestParcel.zztD != null) {
                hashMap.put("request_agent", adRequestParcel.zztD);
            }
        }
        if (adRequestParcel.versionCode >= 6 && adRequestParcel.zztE != null) {
            hashMap.put("request_pkg", adRequestParcel.zztE);
        }
        if (adRequestParcel.versionCode >= 7) {
            hashMap.put("is_designed_for_families", adRequestParcel.zztF);
        }
    }

    private static void zza(HashMap<String, Object> hashMap, zzhi zzhi2, zzhm.zza zza2) {
        hashMap.put("am", zzhi2.zzIA);
        hashMap.put("cog", zzhd.zzy(zzhi2.zzIB));
        hashMap.put("coh", zzhd.zzy(zzhi2.zzIC));
        if (!TextUtils.isEmpty((CharSequence)zzhi2.zzID)) {
            hashMap.put("carrier", zzhi2.zzID);
        }
        hashMap.put("gl", zzhi2.zzIE);
        if (zzhi2.zzIF) {
            hashMap.put("simulator", 1);
        }
        if (zzhi2.zzIG) {
            hashMap.put("is_sidewinder", 1);
        }
        hashMap.put("ma", zzhd.zzy(zzhi2.zzIH));
        hashMap.put("sp", zzhd.zzy(zzhi2.zzII));
        hashMap.put("hl", zzhi2.zzIJ);
        if (!TextUtils.isEmpty((CharSequence)zzhi2.zzIK)) {
            hashMap.put("mv", zzhi2.zzIK);
        }
        hashMap.put("muv", zzhi2.zzIL);
        if (zzhi2.zzIM != -2) {
            hashMap.put("cnt", zzhi2.zzIM);
        }
        hashMap.put("gnt", zzhi2.zzIN);
        hashMap.put("pt", zzhi2.zzIO);
        hashMap.put("rm", zzhi2.zzIP);
        hashMap.put("riv", zzhi2.zzIQ);
        Bundle bundle = new Bundle();
        bundle.putString("build", zzhi2.zzIV);
        Bundle bundle2 = new Bundle();
        bundle2.putBoolean("is_charging", zzhi2.zzIS);
        bundle2.putDouble("battery_level", zzhi2.zzIR);
        bundle.putBundle("battery", bundle2);
        Bundle bundle3 = new Bundle();
        bundle3.putInt("active_network_state", zzhi2.zzIU);
        bundle3.putBoolean("active_network_metered", zzhi2.zzIT);
        if (zza2 != null) {
            Bundle bundle4 = new Bundle();
            bundle4.putInt("predicted_latency_micros", zza2.zzJa);
            bundle4.putLong("predicted_down_throughput_bps", zza2.zzJb);
            bundle4.putLong("predicted_up_throughput_bps", zza2.zzJc);
            bundle3.putBundle("predictions", bundle4);
        }
        bundle.putBundle("network", bundle3);
        hashMap.put("device", bundle);
    }

    private static void zza(HashMap<String, Object> hashMap, Location location) {
        HashMap<String, Number> hashMap2 = new HashMap<String, Number>();
        Float f = Float.valueOf(location.getAccuracy() * 1000.0f);
        Long l = location.getTime() * 1000L;
        Long l2 = (long)(location.getLatitude() * 1.0E7);
        Long l3 = (long)(location.getLongitude() * 1.0E7);
        hashMap2.put("radius", f);
        hashMap2.put("lat", l2);
        hashMap2.put("long", l3);
        hashMap2.put("time", l);
        hashMap.put("uule", hashMap2);
    }

    private static void zza(HashMap<String, Object> hashMap, SearchAdRequestParcel searchAdRequestParcel) {
        String string2;
        String string3;
        if (Color.alpha((int)searchAdRequestParcel.zzuI) != 0) {
            hashMap.put("acolor", zzhd.zzL(searchAdRequestParcel.zzuI));
        }
        if (Color.alpha((int)searchAdRequestParcel.backgroundColor) != 0) {
            hashMap.put("bgcolor", zzhd.zzL(searchAdRequestParcel.backgroundColor));
        }
        if (Color.alpha((int)searchAdRequestParcel.zzuJ) != 0 && Color.alpha((int)searchAdRequestParcel.zzuK) != 0) {
            hashMap.put("gradientto", zzhd.zzL(searchAdRequestParcel.zzuJ));
            hashMap.put("gradientfrom", zzhd.zzL(searchAdRequestParcel.zzuK));
        }
        if (Color.alpha((int)searchAdRequestParcel.zzuL) != 0) {
            hashMap.put("bcolor", zzhd.zzL(searchAdRequestParcel.zzuL));
        }
        hashMap.put("bthick", Integer.toString(searchAdRequestParcel.zzuM));
        switch (searchAdRequestParcel.zzuN) {
            case 0: {
                string3 = "none";
                break;
            }
            case 1: {
                string3 = "dashed";
                break;
            }
            case 2: {
                string3 = "dotted";
                break;
            }
            case 3: {
                string3 = "solid";
                break;
            }
            default: {
                string3 = null;
            }
        }
        if (string3 != null) {
            hashMap.put("btype", string3);
        }
        switch (searchAdRequestParcel.zzuO) {
            case 2: {
                string2 = "dark";
                break;
            }
            case 0: {
                string2 = "light";
                break;
            }
            case 1: {
                string2 = "medium";
                break;
            }
            default: {
                string2 = null;
            }
        }
        if (string2 != null) {
            hashMap.put("callbuttoncolor", string2);
        }
        if (searchAdRequestParcel.zzuP != null) {
            hashMap.put("channel", searchAdRequestParcel.zzuP);
        }
        if (Color.alpha((int)searchAdRequestParcel.zzuQ) != 0) {
            hashMap.put("dcolor", zzhd.zzL(searchAdRequestParcel.zzuQ));
        }
        if (searchAdRequestParcel.zzuR != null) {
            hashMap.put("font", searchAdRequestParcel.zzuR);
        }
        if (Color.alpha((int)searchAdRequestParcel.zzuS) != 0) {
            hashMap.put("hcolor", zzhd.zzL(searchAdRequestParcel.zzuS));
        }
        hashMap.put("headersize", Integer.toString(searchAdRequestParcel.zzuT));
        if (searchAdRequestParcel.zzuU != null) {
            hashMap.put("q", searchAdRequestParcel.zzuU);
        }
    }

    private static Integer zzy(boolean bl) {
        return bl ? 1 : 0;
    }

    private static String zzL(int n) {
        return String.format(Locale.US, "#%06x", n & 0xFFFFFF);
    }

    private static String zzc(NativeAdOptionsParcel nativeAdOptionsParcel) {
        int n = nativeAdOptionsParcel != null ? nativeAdOptionsParcel.zzyd : 0;
        switch (n) {
            case 1: {
                return "portrait";
            }
            case 2: {
                return "landscape";
            }
        }
        return "any";
    }

    public static AdResponseParcel zza(Context context, AdRequestInfoParcel adRequestInfoParcel, String string2) {
        try {
            List<String> list;
            List<String> list2;
            List<String> list3;
            JSONObject jSONObject = new JSONObject(string2);
            String string3 = jSONObject.optString("ad_base_url", null);
            String string4 = jSONObject.optString("ad_url", null);
            String string5 = jSONObject.optString("ad_size", null);
            boolean bl = adRequestInfoParcel != null && adRequestInfoParcel.zzGw != 0;
            String string6 = bl ? jSONObject.optString("ad_json", null) : jSONObject.optString("ad_html", null);
            long l = -1L;
            String string7 = jSONObject.optString("debug_dialog", null);
            long l2 = jSONObject.has("interstitial_timeout") ? (long)(jSONObject.getDouble("interstitial_timeout") * 1000.0) : -1L;
            String string8 = jSONObject.optString("orientation", null);
            int n = -1;
            if ("portrait".equals(string8)) {
                n = zzp.zzbz().zzhe();
            } else if ("landscape".equals(string8)) {
                n = zzp.zzbz().zzhd();
            }
            AdResponseParcel adResponseParcel = null;
            if (!TextUtils.isEmpty((CharSequence)string6)) {
                if (TextUtils.isEmpty((CharSequence)string3)) {
                    zzb.zzaH("Could not parse the mediation config: Missing required ad_base_url field");
                    return new AdResponseParcel(0);
                }
            } else if (!TextUtils.isEmpty((CharSequence)string4)) {
                adResponseParcel = zzhc.zza(adRequestInfoParcel, context, adRequestInfoParcel.zzqR.afmaVersion, string4, null, null, null, null, null);
                string3 = adResponseParcel.zzDE;
                string6 = adResponseParcel.body;
                l = adResponseParcel.zzGR;
            } else {
                zzb.zzaH("Could not parse the mediation config: Missing required " + (bl ? "ad_json" : "ad_html") + " or " + "ad_url" + " field.");
                return new AdResponseParcel(0);
            }
            JSONArray jSONArray = jSONObject.optJSONArray("click_urls");
            List<String> list4 = list3 = adResponseParcel == null ? null : adResponseParcel.zzAQ;
            if (jSONArray != null) {
                if (list3 == null) {
                    list3 = new LinkedList<String>();
                }
                for (int i = 0; i < jSONArray.length(); ++i) {
                    list3.add(jSONArray.getString(i));
                }
            }
            JSONArray jSONArray2 = jSONObject.optJSONArray("impression_urls");
            List<String> list5 = list2 = adResponseParcel == null ? null : adResponseParcel.zzAR;
            if (jSONArray2 != null) {
                if (list2 == null) {
                    list2 = new LinkedList<String>();
                }
                for (int i = 0; i < jSONArray2.length(); ++i) {
                    list2.add(jSONArray2.getString(i));
                }
            }
            JSONArray jSONArray3 = jSONObject.optJSONArray("manual_impression_urls");
            List<String> list6 = list = adResponseParcel == null ? null : adResponseParcel.zzGP;
            if (jSONArray3 != null) {
                if (list == null) {
                    list = new LinkedList<String>();
                }
                for (int i = 0; i < jSONArray3.length(); ++i) {
                    list.add(jSONArray3.getString(i));
                }
            }
            if (adResponseParcel != null) {
                if (adResponseParcel.orientation != -1) {
                    n = adResponseParcel.orientation;
                }
                if (adResponseParcel.zzGM > 0L) {
                    l2 = adResponseParcel.zzGM;
                }
            }
            String string9 = jSONObject.optString("active_view");
            String string10 = null;
            boolean bl2 = jSONObject.optBoolean("ad_is_javascript", false);
            if (bl2) {
                string10 = jSONObject.optString("ad_passback_url", null);
            }
            boolean bl3 = jSONObject.optBoolean("mediation", false);
            boolean bl4 = jSONObject.optBoolean("custom_render_allowed", false);
            boolean bl5 = jSONObject.optBoolean("content_url_opted_out", true);
            boolean bl6 = jSONObject.optBoolean("prefetch", false);
            int n2 = jSONObject.optInt("oauth2_token_status", 0);
            long l3 = jSONObject.optLong("refresh_interval_milliseconds", -1L);
            long l4 = jSONObject.optLong("mediation_config_cache_time_milliseconds", -1L);
            String string11 = jSONObject.optString("gws_query_id", "");
            boolean bl7 = "height".equals(jSONObject.optString("fluid", ""));
            return new AdResponseParcel(adRequestInfoParcel, string3, string6, list3, list2, l2, bl3, l4, list, l3, n, string5, l, string7, bl2, string10, string9, bl4, bl, adRequestInfoParcel.zzGy, bl5, bl6, n2, string11, bl7);
        }
        catch (JSONException jSONException) {
            zzb.zzaH("Could not parse the mediation config: " + jSONException.getMessage());
            return new AdResponseParcel(0);
        }
    }
}

