/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.RemoteException;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.reward.client.RewardedVideoAdRequestParcel;
import com.google.android.gms.ads.internal.reward.client.zzd;
import com.google.android.gms.ads.internal.reward.mediation.client.RewardItemParcel;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzch;
import com.google.android.gms.internal.zzew;
import com.google.android.gms.internal.zzha;
import com.google.android.gms.internal.zzhq;
import com.google.android.gms.internal.zzht;
import com.google.android.gms.internal.zzhw;
import com.google.android.gms.internal.zzhz;
import com.google.android.gms.internal.zzie;
import com.google.android.gms.internal.zzip;
import java.util.HashMap;

@zzha
public class zzhs
extends com.google.android.gms.ads.internal.zzb
implements zzhw {
    private zzd zzJf;
    private String zzJg;
    private boolean zzJh;
    private HashMap<String, zzht> zzJi = new HashMap();

    public zzhs(Context context, AdSizeParcel adSizeParcel, zzew zzew2, VersionInfoParcel versionInfoParcel) {
        super(context, adSizeParcel, null, zzew2, versionInfoParcel, null);
    }

    public void setUserId(String userId) {
        zzx.zzcx((String)"setUserId must be called on the main UI thread.");
        this.zzJg = userId;
    }

    public void zza(RewardedVideoAdRequestParcel rewardedVideoAdRequestParcel) {
        zzx.zzcx((String)"loadAd must be called on the main UI thread.");
        if (TextUtils.isEmpty((CharSequence)rewardedVideoAdRequestParcel.zzqP)) {
            zzb.zzaH("Invalid ad unit id. Aborting.");
            return;
        }
        this.zzJh = false;
        this.zzoZ.zzqP = rewardedVideoAdRequestParcel.zzqP;
        super.zzb(rewardedVideoAdRequestParcel.zzGq);
    }

    @Override
    public void zza(final zzie.zza zza2, zzch zzch2) {
        if (zza2.errorCode != -2) {
            zzip.zzKO.post(new Runnable(){

                @Override
                public void run() {
                    zzhs.this.zzb(new zzie(zza2, null, null, null, null, null, null));
                }
            });
            return;
        }
        this.zzoZ.zzrp = 0;
        this.zzoZ.zzqU = new zzhz(this.zzoZ.context, this.zzJg, zza2, this);
        zzb.zzaF("AdRenderer: " + this.zzoZ.zzqU.getClass().getName());
        this.zzoZ.zzqU.zzfR();
    }

    public zzht zzav(String string2) {
        zzht zzht2 = this.zzJi.get(string2);
        if (zzht2 == null) {
            try {
                zzht2 = new zzht(this.zzpd.zzaf(string2), this);
                this.zzJi.put(string2, zzht2);
            }
            catch (Exception exception) {
                zzb.zzd("Fail to instantiate adapter " + string2, exception);
            }
        }
        return zzht2;
    }

    @Override
    public boolean zza(zzie zzie2, zzie zzie3) {
        if (this.zzJf != null) {
            try {
                this.zzJf.onRewardedVideoAdLoaded();
            }
            catch (RemoteException remoteException) {
                zzb.zzd("Could not call RewardedVideoAdListener.onAdLoaded().", remoteException);
            }
        }
        return true;
    }

    @Override
    public void pause() {
        zzx.zzcx((String)"pause must be called on the main UI thread.");
        for (String string2 : this.zzJi.keySet()) {
            try {
                zzht zzht2 = this.zzJi.get(string2);
                if (zzht2 == null || zzht2.zzgA() == null) continue;
                zzht2.zzgA().pause();
            }
            catch (RemoteException remoteException) {
                zzb.zzaH("Fail to pause adapter: " + string2);
            }
        }
    }

    @Override
    public void resume() {
        zzx.zzcx((String)"resume must be called on the main UI thread.");
        for (String string2 : this.zzJi.keySet()) {
            try {
                zzht zzht2 = this.zzJi.get(string2);
                if (zzht2 == null || zzht2.zzgA() == null) continue;
                zzht2.zzgA().resume();
            }
            catch (RemoteException remoteException) {
                zzb.zzaH("Fail to resume adapter: " + string2);
            }
        }
    }

    @Override
    public void destroy() {
        zzx.zzcx((String)"destroy must be called on the main UI thread.");
        for (String string2 : this.zzJi.keySet()) {
            try {
                zzht zzht2 = this.zzJi.get(string2);
                if (zzht2 == null || zzht2.zzgA() == null) continue;
                zzht2.zzgA().destroy();
            }
            catch (RemoteException remoteException) {
                zzb.zzaH("Fail to destroy adapter: " + string2);
            }
        }
    }

    @Override
    protected boolean zzf(int n) {
        zzb.zzaH("Failed to load ad: " + n);
        this.zzoX = false;
        if (this.zzJf == null) {
            return false;
        }
        try {
            this.zzJf.onRewardedVideoAdFailedToLoad(n);
            return true;
        }
        catch (RemoteException remoteException) {
            zzb.zzd("Could not call RewardedVideoAdListener.onAdFailedToLoad().", remoteException);
            return false;
        }
    }

    public void zzgy() {
        zzx.zzcx((String)"showAd must be called on the main UI thread.");
        if (!this.isLoaded()) {
            zzb.zzaH("The reward video has not loaded.");
            return;
        }
        this.zzJh = true;
        zzht zzht2 = this.zzav(this.zzoZ.zzqW.zzBr);
        if (zzht2 != null && zzht2.zzgA() != null) {
            try {
                zzht2.zzgA().showVideo();
            }
            catch (RemoteException remoteException) {
                zzb.zzd("Could not call showVideo.", remoteException);
            }
        }
    }

    public boolean isLoaded() {
        zzx.zzcx((String)"isLoaded must be called on the main UI thread.");
        return this.zzoZ.zzqT == null && this.zzoZ.zzqU == null && this.zzoZ.zzqW != null && !this.zzJh;
    }

    public void zza(zzd zzd2) {
        zzx.zzcx((String)"setRewardedVideoAdListener must be called on the main UI thread.");
        this.zzJf = zzd2;
    }

    @Override
    public void onRewardedVideoAdOpened() {
        this.zza(this.zzoZ.zzqW, false);
        if (this.zzJf == null) {
            return;
        }
        try {
            this.zzJf.onRewardedVideoAdOpened();
        }
        catch (RemoteException remoteException) {
            zzb.zzd("Could not call RewardedVideoAdListener.onAdOpened().", remoteException);
        }
    }

    @Override
    public void onRewardedVideoStarted() {
        zzp.zzbK().zza(this.zzoZ.context, this.zzoZ.zzqR.afmaVersion, this.zzoZ.zzqW, this.zzoZ.zzqP, false, this.zzoZ.zzqW.zzBp.zzAM);
        if (this.zzJf == null) {
            return;
        }
        try {
            this.zzJf.onRewardedVideoStarted();
        }
        catch (RemoteException remoteException) {
            zzb.zzd("Could not call RewardedVideoAdListener.onVideoStarted().", remoteException);
        }
    }

    @Override
    public void onRewardedVideoAdClosed() {
        if (this.zzJf == null) {
            return;
        }
        try {
            this.zzJf.onRewardedVideoAdClosed();
        }
        catch (RemoteException remoteException) {
            zzb.zzd("Could not call RewardedVideoAdListener.onAdClosed().", remoteException);
        }
    }

    @Override
    public void zza(RewardItemParcel rewardItemParcel) {
        zzp.zzbK().zza(this.zzoZ.context, this.zzoZ.zzqR.afmaVersion, this.zzoZ.zzqW, this.zzoZ.zzqP, false, this.zzoZ.zzqW.zzBp.zzAN);
        if (this.zzJf == null) {
            return;
        }
        try {
            if (this.zzoZ.zzqW != null && this.zzoZ.zzqW.zzJF != null && !TextUtils.isEmpty((CharSequence)this.zzoZ.zzqW.zzJF.zzAV)) {
                this.zzJf.zza(new zzhq(this.zzoZ.zzqW.zzJF.zzAV, this.zzoZ.zzqW.zzJF.zzAW));
            } else {
                this.zzJf.zza(new zzhq(rewardItemParcel.type, rewardItemParcel.zzJD));
            }
        }
        catch (RemoteException remoteException) {
            zzb.zzd("Could not call RewardedVideoAdListener.onRewarded().", remoteException);
        }
    }

    @Override
    public void zzgz() {
        this.onAdClicked();
    }

    @Override
    public void onRewardedVideoAdLeftApplication() {
        if (this.zzJf == null) {
            return;
        }
        try {
            this.zzJf.onRewardedVideoAdLeftApplication();
        }
        catch (RemoteException remoteException) {
            zzb.zzd("Could not call RewardedVideoAdListener.onAdLeftApplication().", remoteException);
        }
    }
}

