/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import android.view.MotionEvent;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.internal.zzha;
import java.util.Map;

@zzha
public class zzis {
    private final Context mContext;
    private String zzKT;
    private final float zzCB;
    private float zzKU;
    private float zzKV;
    private float zzKW;
    private int mState = 0;

    public zzis(Context context) {
        this.mContext = context;
        this.zzCB = context.getResources().getDisplayMetrics().density;
    }

    public zzis(Context context, String string2) {
        this(context);
        this.zzKT = string2;
    }

    public void zze(MotionEvent motionEvent) {
        int n = motionEvent.getHistorySize();
        for (int i = 0; i < n; ++i) {
            this.zza(motionEvent.getActionMasked(), motionEvent.getHistoricalX(0, i), motionEvent.getHistoricalY(0, i));
        }
        this.zza(motionEvent.getActionMasked(), motionEvent.getX(), motionEvent.getY());
    }

    void zza(int n, float f, float f2) {
        if (n == 0) {
            this.mState = 0;
            this.zzKU = f;
            this.zzKV = f2;
            this.zzKW = f2;
        } else {
            if (this.mState == -1) {
                return;
            }
            if (n == 2) {
                if (f2 > this.zzKV) {
                    this.zzKV = f2;
                } else if (f2 < this.zzKW) {
                    this.zzKW = f2;
                }
                if (this.zzKV - this.zzKW > 30.0f * this.zzCB) {
                    this.mState = -1;
                    return;
                }
                if (this.mState == 0 || this.mState == 2) {
                    if (f - this.zzKU >= 50.0f * this.zzCB) {
                        this.zzKU = f;
                        ++this.mState;
                    }
                } else if ((this.mState == 1 || this.mState == 3) && f - this.zzKU <= -50.0f * this.zzCB) {
                    this.zzKU = f;
                    ++this.mState;
                }
                if (this.mState == 1 || this.mState == 3) {
                    if (f > this.zzKU) {
                        this.zzKU = f;
                    }
                } else if (this.mState == 2 && f < this.zzKU) {
                    this.zzKU = f;
                }
            } else if (n == 1 && this.mState == 4) {
                this.showDialog();
            }
        }
    }

    public void zzaC(String string2) {
        this.zzKT = string2;
    }

    private void showDialog() {
        if (!(this.mContext instanceof Activity)) {
            zzb.zzaG("Can not create dialog without Activity Context");
            return;
        }
        final String string2 = zzis.zzaD(this.zzKT);
        AlertDialog.Builder builder = new AlertDialog.Builder(this.mContext);
        builder.setMessage((CharSequence)string2);
        builder.setTitle((CharSequence)"Ad Information");
        builder.setPositiveButton((CharSequence)"Share", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                zzp.zzbx().zzb(zzis.this.mContext, Intent.createChooser((Intent)new Intent("android.intent.action.SEND").setType("text/plain").putExtra("android.intent.extra.TEXT", string2), (CharSequence)"Share via"));
            }
        });
        builder.setNegativeButton((CharSequence)"Close", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
            }
        });
        AlertDialog alertDialog = builder.create();
        alertDialog.show();
    }

    static String zzaD(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return "No debug information";
        }
        string2 = string2.replaceAll("\\+", "%20");
        Uri uri = new Uri.Builder().encodedQuery(string2).build();
        StringBuilder stringBuilder = new StringBuilder();
        Map<String, String> map = zzp.zzbx().zze(uri);
        for (String string3 : map.keySet()) {
            stringBuilder.append(string3).append(" = ").append(map.get(string3)).append("\n\n");
        }
        String string4 = stringBuilder.toString().trim();
        return !TextUtils.isEmpty((CharSequence)string4) ? string4 : "No debug information";
    }
}

