/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.MutableContextWrapper;
import android.graphics.Canvas;
import android.net.Uri;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.webkit.DownloadListener;
import android.webkit.ValueCallback;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.zzl;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.ads.internal.zzd;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.internal.zzan;
import com.google.android.gms.internal.zzaz;
import com.google.android.gms.internal.zzcd;
import com.google.android.gms.internal.zzcf;
import com.google.android.gms.internal.zzcg;
import com.google.android.gms.internal.zzch;
import com.google.android.gms.internal.zzdw;
import com.google.android.gms.internal.zzfr;
import com.google.android.gms.internal.zzha;
import com.google.android.gms.internal.zzip;
import com.google.android.gms.internal.zzja;
import com.google.android.gms.internal.zzjm;
import com.google.android.gms.internal.zzjn;
import com.google.android.gms.internal.zzjo;
import com.google.android.gms.internal.zzjs;
import com.google.android.gms.internal.zznx;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

@zzha
class zzjr
extends WebView
implements ViewTreeObserver.OnGlobalLayoutListener,
DownloadListener,
zzjn {
    private final zza zzMw;
    private final Object zzpK = new Object();
    private final zzan zzxV;
    private final VersionInfoParcel zzpI;
    private final zzd zzpc;
    private zzjo zzMx;
    private com.google.android.gms.ads.internal.overlay.zzd zzMy;
    private AdSizeParcel zzBh;
    private boolean zzMz;
    private boolean zzMA;
    private boolean zzMB;
    private boolean zzMC;
    private Boolean zzKh;
    private int zzMD;
    private boolean zzME = true;
    private String zzDX = "";
    private zzcf zzMF;
    private zzcf zzMG;
    private zzcf zzMH;
    private zzcg zzMI;
    private com.google.android.gms.ads.internal.overlay.zzd zzMJ;
    private zzja zzrz;
    private int zzCD = -1;
    private int zzCC = -1;
    private int zzCF = -1;
    private int zzCG = -1;
    private Map<String, zzdw> zzMK;
    private final WindowManager zzrR;

    static zzjr zzb(Context context, AdSizeParcel adSizeParcel, boolean bl, boolean bl2, zzan zzan2, VersionInfoParcel versionInfoParcel, zzch zzch2, zzd zzd2) {
        zza zza2 = new zza(context);
        return new zzjr(zza2, adSizeParcel, bl, bl2, zzan2, versionInfoParcel, zzch2, zzd2);
    }

    protected zzjr(zza zza2, AdSizeParcel adSizeParcel, boolean bl, boolean bl2, zzan zzan2, VersionInfoParcel versionInfoParcel, zzch zzch2, zzd zzd2) {
        super((Context)zza2);
        this.zzMw = zza2;
        this.zzBh = adSizeParcel;
        this.zzMB = bl;
        this.zzMD = -1;
        this.zzxV = zzan2;
        this.zzpI = versionInfoParcel;
        this.zzpc = zzd2;
        this.zzrR = (WindowManager)this.getContext().getSystemService("window");
        this.setBackgroundColor(0);
        WebSettings webSettings = this.getSettings();
        webSettings.setAllowFileAccess(false);
        webSettings.setJavaScriptEnabled(true);
        webSettings.setSavePassword(false);
        webSettings.setSupportMultipleWindows(true);
        webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
        if (Build.VERSION.SDK_INT >= 21) {
            webSettings.setMixedContentMode(0);
        }
        zzp.zzbx().zza((Context)zza2, versionInfoParcel.afmaVersion, webSettings);
        zzp.zzbz().zza(this.getContext(), webSettings);
        this.setDownloadListener(this);
        this.zzhY();
        if (zznx.zzrS()) {
            this.addJavascriptInterface(new zzjs(this), "googleAdsJsInterface");
        }
        this.zzrz = new zzja(this.zzMw.zzhx(), this, null);
        this.zzd(zzch2);
    }

    @Override
    public void setWebViewClient(WebViewClient webViewClient) {
        super.setWebViewClient(webViewClient);
        if (webViewClient instanceof zzjo) {
            this.zzMx = (zzjo)webViewClient;
        }
    }

    @Override
    public WebView getWebView() {
        return this;
    }

    @Override
    public View getView() {
        return this;
    }

    @Override
    public zzd zzhz() {
        return this.zzpc;
    }

    public boolean zzhV() {
        int n;
        int n2;
        if (!this.zzhC().zzcb()) {
            return false;
        }
        DisplayMetrics displayMetrics = zzp.zzbx().zza(this.zzrR);
        int n3 = zzl.zzcN().zzb(displayMetrics, displayMetrics.widthPixels);
        int n4 = zzl.zzcN().zzb(displayMetrics, displayMetrics.heightPixels);
        Activity activity = this.zzhx();
        if (activity == null || activity.getWindow() == null) {
            n2 = n3;
            n = n4;
        } else {
            int[] nArray = zzp.zzbx().zzg(activity);
            n2 = zzl.zzcN().zzb(displayMetrics, nArray[0]);
            n = zzl.zzcN().zzb(displayMetrics, nArray[1]);
        }
        if (this.zzCC == n3 && this.zzCD == n4 && this.zzCF == n2 && this.zzCG == n) {
            return false;
        }
        boolean bl = this.zzCC != n3 || this.zzCD != n4;
        this.zzCC = n3;
        this.zzCD = n4;
        this.zzCF = n2;
        this.zzCG = n;
        new zzfr(this).zza(n3, n4, n2, n, displayMetrics.density, this.zzrR.getDefaultDisplay().getRotation());
        return bl;
    }

    @Override
    public void zzb(String string2, Map<String, ?> map) {
        JSONObject jSONObject;
        try {
            jSONObject = zzp.zzbx().zzz(map);
        }
        catch (JSONException jSONException) {
            zzb.zzaH("Could not convert parameters to JSON.");
            return;
        }
        this.zzb(string2, jSONObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluateJavascript(String script, ValueCallback<String> resultCallback) {
        Object object = this.zzpK;
        synchronized (object) {
            if (this.isDestroyed()) {
                zzb.zzaH("The webview is destroyed. Ignoring action.");
                if (resultCallback != null) {
                    resultCallback.onReceiveValue(null);
                }
                return;
            }
            super.evaluateJavascript(script, resultCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zzaL(String string2) {
        Object object = this.zzpK;
        synchronized (object) {
            if (!this.isDestroyed()) {
                this.loadUrl(string2);
            } else {
                zzb.zzaH("The webview is destroyed. Ignoring action.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadUrl(String uri) {
        Object object = this.zzpK;
        synchronized (object) {
            if (!this.isDestroyed()) {
                try {
                    super.loadUrl(uri);
                }
                catch (Throwable throwable) {
                    zzb.zzaH("Could not call loadUrl. " + throwable);
                }
            } else {
                zzb.zzaH("The webview is destroyed. Ignoring action.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzaI(String string2) {
        Object object = this.zzpK;
        synchronized (object) {
            try {
                super.loadUrl(string2);
            }
            catch (Throwable throwable) {
                zzb.zzaH("Could not call loadUrl. " + throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadData(String data, String mimeType, String encoding) {
        Object object = this.zzpK;
        synchronized (object) {
            if (!this.isDestroyed()) {
                super.loadData(data, mimeType, encoding);
            } else {
                zzb.zzaH("The webview is destroyed. Ignoring action.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadDataWithBaseURL(String baseUrl, String data, String mimeType, String encoding, String historyUrl) {
        Object object = this.zzpK;
        synchronized (object) {
            if (!this.isDestroyed()) {
                super.loadDataWithBaseURL(baseUrl, data, mimeType, encoding, historyUrl);
            } else {
                zzb.zzaH("The webview is destroyed. Ignoring action.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zza(String string2, ValueCallback<String> valueCallback) {
        Object object = this.zzpK;
        synchronized (object) {
            if (!this.isDestroyed()) {
                this.evaluateJavascript(string2, valueCallback);
            } else {
                zzb.zzaH("The webview is destroyed. Ignoring action.");
                if (valueCallback != null) {
                    valueCallback.onReceiveValue(null);
                }
            }
        }
    }

    protected void zzaM(String string2) {
        if (zznx.zzrU()) {
            if (this.zzgQ() == null) {
                this.zzhW();
            }
            if (this.zzgQ().booleanValue()) {
                this.zza(string2, (ValueCallback<String>)null);
            } else {
                this.zzaL("javascript:" + string2);
            }
        } else {
            this.zzaL("javascript:" + string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzhW() {
        Object object = this.zzpK;
        synchronized (object) {
            this.zzKh = zzp.zzbA().zzgQ();
            if (this.zzKh == null) {
                try {
                    String string2 = "(function(){})()";
                    this.evaluateJavascript(string2, null);
                    this.zzb(true);
                }
                catch (IllegalStateException illegalStateException) {
                    this.zzb(false);
                }
            }
        }
    }

    void zzb(Boolean bl) {
        this.zzKh = bl;
        zzp.zzbA().zzb(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Boolean zzgQ() {
        Object object = this.zzpK;
        synchronized (object) {
            return this.zzKh;
        }
    }

    @Override
    public void zza(String string2, JSONObject jSONObject) {
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        String string3 = jSONObject.toString();
        this.zza(string2, string3);
    }

    @Override
    public void zza(String string2, String string3) {
        String string4 = string2 + "(" + string3 + ");";
        this.zzaM(string4);
    }

    @Override
    public void zzb(String string2, JSONObject jSONObject) {
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        String string3 = jSONObject.toString();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("AFMA_ReceiveMessage('");
        stringBuilder.append(string2);
        stringBuilder.append("'");
        stringBuilder.append(",");
        stringBuilder.append(string3);
        stringBuilder.append(");");
        zzb.v("Dispatching AFMA event: " + stringBuilder.toString());
        this.zzaM(stringBuilder.toString());
    }

    @Override
    public void zzhw() {
        this.zzhX();
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.zzpI.afmaVersion);
        this.zzb("onhide", hashMap);
    }

    @Override
    public void zzy(int n) {
        this.zzhX();
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        hashMap.put("closetype", String.valueOf(n));
        hashMap.put("version", this.zzpI.afmaVersion);
        this.zzb("onhide", hashMap);
    }

    private void zzhX() {
        zzcd.zza(this.zzMI.zzdt(), this.zzMF, "aeh");
    }

    @Override
    public void zzfg() {
        if (this.zzMF == null) {
            zzcd.zza(this.zzMI.zzdt(), this.zzMH, "aes");
            this.zzMF = zzcd.zzb(this.zzMI.zzdt());
            this.zzMI.zza("native:view_show", this.zzMF);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.zzpI.afmaVersion);
        this.zzb("onshow", hashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public com.google.android.gms.ads.internal.overlay.zzd zzhA() {
        Object object = this.zzpK;
        synchronized (object) {
            return this.zzMy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public com.google.android.gms.ads.internal.overlay.zzd zzhB() {
        Object object = this.zzpK;
        synchronized (object) {
            return this.zzMJ;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AdSizeParcel zzaP() {
        Object object = this.zzpK;
        synchronized (object) {
            return this.zzBh;
        }
    }

    @Override
    public zzjo zzhC() {
        return this.zzMx;
    }

    @Override
    public boolean zzhD() {
        return this.zzMz;
    }

    @Override
    public zzan zzhE() {
        return this.zzxV;
    }

    @Override
    public VersionInfoParcel zzhF() {
        return this.zzpI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean zzhG() {
        Object object = this.zzpK;
        synchronized (object) {
            return this.zzMB;
        }
    }

    public void onDownloadStart(String url, String userAgent, String contentDisposition, String mimeType, long size) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setDataAndType(Uri.parse((String)url), mimeType);
            zzp.zzbx().zzb(this.getContext(), intent);
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            zzb.zzaF("Couldn't find an Activity to view url/mimetype: " + url + " / " + mimeType);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.zzxV != null) {
            this.zzxV.zza(event);
        }
        if (this.isDestroyed()) {
            return false;
        }
        return super.onTouchEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        Object object = this.zzpK;
        synchronized (object) {
            if (this.isDestroyed()) {
                this.setMeasuredDimension(0, 0);
                return;
            }
            if (this.isInEditMode() || this.zzMB || this.zzBh.zztY || this.zzBh.zztZ) {
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
                return;
            }
            if (this.zzBh.zztW) {
                DisplayMetrics displayMetrics = new DisplayMetrics();
                this.zzrR.getDefaultDisplay().getMetrics(displayMetrics);
                this.setMeasuredDimension(displayMetrics.widthPixels, displayMetrics.heightPixels);
                return;
            }
            int n = View.MeasureSpec.getMode((int)widthMeasureSpec);
            int n2 = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int n3 = View.MeasureSpec.getMode((int)heightMeasureSpec);
            int n4 = View.MeasureSpec.getSize((int)heightMeasureSpec);
            int n5 = Integer.MAX_VALUE;
            if (n == Integer.MIN_VALUE || n == 0x40000000) {
                n5 = n2;
            }
            int n6 = Integer.MAX_VALUE;
            if (n3 == Integer.MIN_VALUE || n3 == 0x40000000) {
                n6 = n4;
            }
            if (this.zzBh.widthPixels > n5 || this.zzBh.heightPixels > n6) {
                float f = this.zzMw.getResources().getDisplayMetrics().density;
                zzb.zzaH("Not enough space to show ad. Needs " + (int)((float)this.zzBh.widthPixels / f) + "x" + (int)((float)this.zzBh.heightPixels / f) + " dp, but only has " + (int)((float)n2 / f) + "x" + (int)((float)n4 / f) + " dp.");
                if (this.getVisibility() != 8) {
                    this.setVisibility(4);
                }
                this.setMeasuredDimension(0, 0);
            } else {
                if (this.getVisibility() != 8) {
                    this.setVisibility(0);
                }
                this.setMeasuredDimension(this.zzBh.widthPixels, this.zzBh.heightPixels);
            }
        }
    }

    public void onGlobalLayout() {
        boolean bl = this.zzhV();
        com.google.android.gms.ads.internal.overlay.zzd zzd2 = this.zzhA();
        if (zzd2 != null && bl) {
            zzd2.zzff();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zza(Context context, AdSizeParcel adSizeParcel, zzch zzch2) {
        Object object = this.zzpK;
        synchronized (object) {
            this.zzrz.zzhn();
            this.setContext(context);
            this.zzMy = null;
            this.zzBh = adSizeParcel;
            this.zzMB = false;
            this.zzMz = false;
            this.zzDX = "";
            this.zzMD = -1;
            zzp.zzbz().zzg(this);
            this.loadUrl("about:blank");
            this.zzMx.reset();
            this.setOnTouchListener(null);
            this.setOnClickListener(null);
            this.zzME = true;
            this.zzd(zzch2);
        }
    }

    private void zzd(zzch zzch2) {
        this.zzic();
        this.zzMI = new zzcg(new zzch(true, "make_wv", this.zzBh.zztV));
        this.zzMI.zzdt().zzc(zzch2);
        this.zzMG = zzcd.zzb(this.zzMI.zzdt());
        this.zzMI.zza("native:view_create", this.zzMG);
        this.zzMH = null;
        this.zzMF = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzb(com.google.android.gms.ads.internal.overlay.zzd zzd2) {
        Object object = this.zzpK;
        synchronized (object) {
            this.zzMy = zzd2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzc(com.google.android.gms.ads.internal.overlay.zzd zzd2) {
        Object object = this.zzpK;
        synchronized (object) {
            this.zzMJ = zzd2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zza(AdSizeParcel adSizeParcel) {
        Object object = this.zzpK;
        synchronized (object) {
            this.zzBh = adSizeParcel;
            this.requestLayout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzD(boolean bl) {
        Object object = this.zzpK;
        synchronized (object) {
            this.zzMB = bl;
            this.zzhY();
        }
    }

    @Override
    public void zzhM() {
        this.zzrz.zzhm();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onAttachedToWindow() {
        Object object = this.zzpK;
        synchronized (object) {
            super.onAttachedToWindow();
            if (!this.isDestroyed()) {
                this.zzrz.onAttachedToWindow();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onDetachedFromWindow() {
        Object object = this.zzpK;
        synchronized (object) {
            if (!this.isDestroyed()) {
                this.zzrz.onDetachedFromWindow();
            }
            super.onDetachedFromWindow();
        }
    }

    @Override
    public void setContext(Context context) {
        this.zzMw.setBaseContext(context);
        this.zzrz.zzk(this.zzMw.zzhx());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzE(boolean bl) {
        Object object = this.zzpK;
        synchronized (object) {
            if (this.zzMy != null) {
                this.zzMy.zza(this.zzMx.zzcb(), bl);
            } else {
                this.zzMz = bl;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRequestedOrientation() {
        Object object = this.zzpK;
        synchronized (object) {
            return this.zzMD;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRequestedOrientation(int requestedOrientation) {
        Object object = this.zzpK;
        synchronized (object) {
            this.zzMD = requestedOrientation;
            if (this.zzMy != null) {
                this.zzMy.setRequestedOrientation(this.zzMD);
            }
        }
    }

    @Override
    public Activity zzhx() {
        return this.zzMw.zzhx();
    }

    @Override
    public Context zzhy() {
        return this.zzMw.zzhy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzhY() {
        Object object = this.zzpK;
        synchronized (object) {
            if (this.zzMB || this.zzBh.zztW) {
                if (Build.VERSION.SDK_INT < 14) {
                    zzb.zzaF("Disabling hardware acceleration on an overlay.");
                    this.zzhZ();
                } else {
                    zzb.zzaF("Enabling hardware acceleration on an overlay.");
                    this.zzia();
                }
            } else if (Build.VERSION.SDK_INT < 18) {
                zzb.zzaF("Disabling hardware acceleration on an AdView.");
                this.zzhZ();
            } else {
                zzb.zzaF("Enabling hardware acceleration on an AdView.");
                this.zzia();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzhZ() {
        Object object = this.zzpK;
        synchronized (object) {
            if (!this.zzMC) {
                zzp.zzbz().zzn((View)this);
            }
            this.zzMC = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzia() {
        Object object = this.zzpK;
        synchronized (object) {
            if (this.zzMC) {
                zzp.zzbz().zzm((View)this);
            }
            this.zzMC = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        Object object = this.zzpK;
        synchronized (object) {
            this.zzic();
            this.zzrz.zzhn();
            if (this.zzMy != null) {
                this.zzMy.close();
                this.zzMy.onDestroy();
                this.zzMy = null;
            }
            this.zzMx.reset();
            if (this.zzMA) {
                return;
            }
            zzp.zzbL().zza(this);
            this.zzib();
            this.zzMA = true;
            zzb.v("Initiating WebView self destruct sequence in 3...");
            this.zzMx.zzhQ();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzhH() {
        Object object = this.zzpK;
        synchronized (object) {
            zzb.v("Destroying WebView!");
            zzip.zzKO.post(new Runnable(){

                @Override
                public void run() {
                    zzjr.super.destroy();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDestroyed() {
        Object object = this.zzpK;
        synchronized (object) {
            return this.zzMA;
        }
    }

    protected void onDraw(Canvas canvas) {
        if (this.isDestroyed()) {
            return;
        }
        if (Build.VERSION.SDK_INT == 21 && canvas.isHardwareAccelerated() && !this.isAttachedToWindow()) {
            return;
        }
        super.onDraw(canvas);
    }

    @Override
    public void zzhN() {
        if (this.zzMH == null) {
            this.zzMH = zzcd.zzb(this.zzMI.zzdt());
            this.zzMI.zza("native:view_load", this.zzMH);
        }
    }

    @Override
    public void onPause() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            if (zznx.zzrN()) {
                super.onPause();
            }
        }
        catch (Exception exception) {
            zzb.zzb("Could not pause webview.", exception);
        }
    }

    @Override
    public void onResume() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            if (zznx.zzrN()) {
                super.onResume();
            }
        }
        catch (Exception exception) {
            zzb.zzb("Could not resume webview.", exception);
        }
    }

    @Override
    public void stopLoading() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            super.stopLoading();
        }
        catch (Exception exception) {
            zzb.zzb("Could not stop loading webview.", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzF(boolean bl) {
        Object object = this.zzpK;
        synchronized (object) {
            this.zzME = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean zzhI() {
        Object object = this.zzpK;
        synchronized (object) {
            zzcd.zza(this.zzMI.zzdt(), this.zzMF, "aebb");
            return this.zzME;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzib() {
        Object object = this.zzpK;
        synchronized (object) {
            if (this.zzMK != null) {
                for (zzdw zzdw2 : this.zzMK.values()) {
                    zzdw2.release();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzaJ(String string2) {
        Object object = this.zzpK;
        synchronized (object) {
            this.zzDX = string2 == null ? "" : string2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getRequestId() {
        Object object = this.zzpK;
        synchronized (object) {
            return this.zzDX;
        }
    }

    @Override
    public zzjm zzhJ() {
        return null;
    }

    @Override
    public zzcf zzhK() {
        return this.zzMH;
    }

    @Override
    public zzcg zzhL() {
        return this.zzMI;
    }

    private void zzic() {
        if (this.zzMI == null) {
            return;
        }
        zzch zzch2 = this.zzMI.zzdt();
        if (zzch2 != null && zzp.zzbA().zzgM() != null) {
            zzp.zzbA().zzgM().zza(zzch2);
        }
    }

    @Override
    public void zza(zzaz zzaz2, boolean bl) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("isVisible", bl ? "1" : "0");
        this.zzb("onAdVisibilityChanged", hashMap);
    }

    @zzha
    public static class zza
    extends MutableContextWrapper {
        private Activity zzLy;
        private Context zzrI;
        private Context zzMM;

        public zza(Context context) {
            super(context);
            this.setBaseContext(context);
        }

        public void setBaseContext(Context base) {
            this.zzrI = base.getApplicationContext();
            this.zzLy = base instanceof Activity ? (Activity)base : null;
            this.zzMM = base;
            super.setBaseContext(this.zzrI);
        }

        public void startActivity(Intent intent) {
            if (this.zzLy != null && !zznx.isAtLeastL()) {
                this.zzLy.startActivity(intent);
            } else {
                intent.setFlags(0x10000000);
                this.zzrI.startActivity(intent);
            }
        }

        public Activity zzhx() {
            return this.zzLy;
        }

        public Object getSystemService(String service) {
            return this.zzMM.getSystemService(service);
        }

        public Context zzhy() {
            return this.zzMM;
        }
    }
}

