/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation;

import android.content.Context;
import android.location.Location;
import android.os.Bundle;
import android.view.View;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdLoader;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.AdView;
import com.google.android.gms.ads.InterstitialAd;
import com.google.android.gms.ads.formats.NativeAdOptions;
import com.google.android.gms.ads.formats.NativeAdView;
import com.google.android.gms.ads.formats.NativeAppInstallAd;
import com.google.android.gms.ads.formats.NativeContentAd;
import com.google.android.gms.ads.internal.client.zzn;
import com.google.android.gms.ads.mediation.MediationAdRequest;
import com.google.android.gms.ads.mediation.MediationAdapter;
import com.google.android.gms.ads.mediation.MediationBannerAdapter;
import com.google.android.gms.ads.mediation.MediationBannerListener;
import com.google.android.gms.ads.mediation.MediationInterstitialListener;
import com.google.android.gms.ads.mediation.MediationNativeAdapter;
import com.google.android.gms.ads.mediation.MediationNativeListener;
import com.google.android.gms.ads.mediation.NativeAppInstallAdMapper;
import com.google.android.gms.ads.mediation.NativeContentAdMapper;
import com.google.android.gms.ads.mediation.NativeMediationAdRequest;
import com.google.android.gms.ads.reward.RewardItem;
import com.google.android.gms.ads.reward.RewardedVideoAdListener;
import com.google.android.gms.ads.reward.mediation.MediationRewardedVideoAdAdapter;
import com.google.android.gms.ads.reward.mediation.MediationRewardedVideoAdListener;
import com.google.android.gms.internal.zzhb;
import com.google.android.gms.internal.zzin;
import com.google.android.gms.internal.zzka;
import java.util.Date;
import java.util.Set;

@zzhb
public abstract class AbstractAdViewAdapter
implements MediationBannerAdapter,
MediationNativeAdapter,
MediationRewardedVideoAdAdapter,
zzka {
    public static final String AD_UNIT_ID_PARAMETER = "pubid";
    protected AdView zzaQ;
    protected InterstitialAd zzaR;
    private AdLoader zzaS;
    private Context zzaT;
    private InterstitialAd zzaU;
    private MediationRewardedVideoAdListener zzaV;
    private String zzaW;
    final RewardedVideoAdListener zzaX = new RewardedVideoAdListener(){

        @Override
        public void onRewardedVideoAdLoaded() {
            AbstractAdViewAdapter.this.zzaV.onAdLoaded(AbstractAdViewAdapter.this);
        }

        @Override
        public void onRewardedVideoAdOpened() {
            AbstractAdViewAdapter.this.zzaV.onAdOpened(AbstractAdViewAdapter.this);
        }

        @Override
        public void onRewardedVideoStarted() {
            AbstractAdViewAdapter.this.zzaV.onVideoStarted(AbstractAdViewAdapter.this);
        }

        @Override
        public void onRewardedVideoAdClosed() {
            AbstractAdViewAdapter.this.zzaV.onAdClosed(AbstractAdViewAdapter.this);
            AbstractAdViewAdapter.this.zzaU = null;
        }

        @Override
        public void onRewarded(RewardItem reward) {
            AbstractAdViewAdapter.this.zzaV.onRewarded(AbstractAdViewAdapter.this, reward);
        }

        @Override
        public void onRewardedVideoAdLeftApplication() {
            AbstractAdViewAdapter.this.zzaV.onAdLeftApplication(AbstractAdViewAdapter.this);
        }

        @Override
        public void onRewardedVideoAdFailedToLoad(int errorCode) {
            AbstractAdViewAdapter.this.zzaV.onAdFailedToLoad(AbstractAdViewAdapter.this, errorCode);
        }
    };

    protected abstract Bundle zza(Bundle var1, Bundle var2);

    AdRequest zza(Context context, MediationAdRequest mediationAdRequest, Bundle bundle, Bundle bundle2) {
        String string2;
        Location location;
        Set<String> set;
        int n;
        AdRequest.Builder builder = new AdRequest.Builder();
        Date date = mediationAdRequest.getBirthday();
        if (date != null) {
            builder.setBirthday(date);
        }
        if ((n = mediationAdRequest.getGender()) != 0) {
            builder.setGender(n);
        }
        if ((set = mediationAdRequest.getKeywords()) != null) {
            location = set.iterator();
            while (location.hasNext()) {
                string2 = (String)location.next();
                builder.addKeyword(string2);
            }
        }
        if ((location = mediationAdRequest.getLocation()) != null) {
            builder.setLocation(location);
        }
        if (mediationAdRequest.isTesting()) {
            builder.addTestDevice(zzn.zzcS().zzT(context));
        }
        if (mediationAdRequest.taggedForChildDirectedTreatment() != -1) {
            builder.tagForChildDirectedTreatment(mediationAdRequest.taggedForChildDirectedTreatment() == 1);
        }
        builder.setIsDesignedForFamilies(mediationAdRequest.isDesignedForFamilies());
        string2 = this.zza(bundle, bundle2);
        builder.addNetworkExtrasBundle(AdMobAdapter.class, (Bundle)string2);
        return builder.build();
    }

    @Override
    public void onDestroy() {
        if (this.zzaQ != null) {
            this.zzaQ.destroy();
            this.zzaQ = null;
        }
        if (this.zzaR != null) {
            this.zzaR = null;
        }
        if (this.zzaS != null) {
            this.zzaS = null;
        }
        if (this.zzaU != null) {
            this.zzaU = null;
        }
    }

    @Override
    public void onPause() {
        if (this.zzaQ != null) {
            this.zzaQ.pause();
        }
    }

    @Override
    public void onResume() {
        if (this.zzaQ != null) {
            this.zzaQ.resume();
        }
    }

    public String getAdUnitId(Bundle serverParameters) {
        return serverParameters.getString(AD_UNIT_ID_PARAMETER);
    }

    @Override
    public void requestBannerAd(Context context, MediationBannerListener bannerListener, Bundle serverParameters, AdSize adSize, MediationAdRequest mediationAdRequest, Bundle extras) {
        this.zzaQ = new AdView(context);
        this.zzaQ.setAdSize(new AdSize(adSize.getWidth(), adSize.getHeight()));
        this.zzaQ.setAdUnitId(this.getAdUnitId(serverParameters));
        this.zzaQ.setAdListener(new zzc(this, bannerListener));
        this.zzaQ.loadAd(this.zza(context, mediationAdRequest, extras, serverParameters));
    }

    @Override
    public View getBannerView() {
        return this.zzaQ;
    }

    @Override
    public void requestInterstitialAd(Context context, MediationInterstitialListener interstitialListener, Bundle serverParameters, MediationAdRequest mediationAdRequest, Bundle extras) {
        this.zzaR = new InterstitialAd(context);
        this.zzaR.setAdUnitId(this.getAdUnitId(serverParameters));
        this.zzaR.setAdListener(new zzd(this, interstitialListener));
        this.zzaR.loadAd(this.zza(context, mediationAdRequest, extras, serverParameters));
    }

    @Override
    public void showInterstitial() {
        this.zzaR.show();
    }

    @Override
    public Bundle getInterstitialAdapterInfo() {
        return new MediationAdapter.zza().zzS(1).zziw();
    }

    @Override
    public void requestNativeAd(Context context, MediationNativeListener listener, Bundle serverParameters, NativeMediationAdRequest mediationAdRequest, Bundle extras) {
        zze zze2 = new zze(this, listener);
        AdLoader.Builder builder = this.zza(context, serverParameters.getString(AD_UNIT_ID_PARAMETER)).withAdListener(zze2);
        NativeAdOptions nativeAdOptions = mediationAdRequest.getNativeAdOptions();
        if (nativeAdOptions != null) {
            builder.withNativeAdOptions(nativeAdOptions);
        }
        if (mediationAdRequest.isAppInstallAdRequested()) {
            builder.forAppInstallAd(zze2);
        }
        if (mediationAdRequest.isContentAdRequested()) {
            builder.forContentAd(zze2);
        }
        this.zzaS = builder.build();
        this.zzaS.loadAd(this.zza(context, mediationAdRequest, extras, serverParameters));
    }

    AdLoader.Builder zza(Context context, String string2) {
        return new AdLoader.Builder(context, string2);
    }

    @Override
    public void initialize(Context context, MediationAdRequest mediationAdRequest, String userId, MediationRewardedVideoAdListener listener, Bundle serverParameters, Bundle networkExtras) {
        this.zzaT = context.getApplicationContext();
        this.zzaW = userId;
        this.zzaV = listener;
        this.zzaV.onInitializationSucceeded(this);
    }

    @Override
    public void loadAd(MediationAdRequest mediationAdRequest, Bundle serverParameters, Bundle networkExtras) {
        if (this.zzaT == null || this.zzaV == null) {
            zzin.e("AdMobAdapter.loadAd called before initialize.");
            return;
        }
        this.zzaU = new InterstitialAd(this.zzaT);
        this.zzaU.zza(true);
        this.zzaU.setAdUnitId(this.getAdUnitId(serverParameters));
        this.zzaU.setRewardedVideoAdListener(this.zzaX);
        this.zzaU.zzm(this.zzaW);
        this.zzaU.loadAd(this.zza(this.zzaT, mediationAdRequest, networkExtras, serverParameters));
    }

    @Override
    public void showVideo() {
        this.zzaU.show();
    }

    @Override
    public boolean isInitialized() {
        return this.zzaV != null;
    }

    static class zzb
    extends NativeContentAdMapper {
        private final NativeContentAd zzba;

        public zzb(NativeContentAd nativeContentAd) {
            this.zzba = nativeContentAd;
            this.setHeadline(nativeContentAd.getHeadline().toString());
            this.setImages(nativeContentAd.getImages());
            this.setBody(nativeContentAd.getBody().toString());
            this.setLogo(nativeContentAd.getLogo());
            this.setCallToAction(nativeContentAd.getCallToAction().toString());
            this.setAdvertiser(nativeContentAd.getAdvertiser().toString());
            this.setOverrideImpressionRecording(true);
            this.setOverrideClickHandling(true);
        }

        @Override
        public void trackView(View view) {
            if (view instanceof NativeAdView) {
                ((NativeAdView)view).setNativeAd(this.zzba);
            }
        }
    }

    static class zza
    extends NativeAppInstallAdMapper {
        private final NativeAppInstallAd zzaZ;

        public zza(NativeAppInstallAd nativeAppInstallAd) {
            this.zzaZ = nativeAppInstallAd;
            this.setHeadline(nativeAppInstallAd.getHeadline().toString());
            this.setImages(nativeAppInstallAd.getImages());
            this.setBody(nativeAppInstallAd.getBody().toString());
            this.setIcon(nativeAppInstallAd.getIcon());
            this.setCallToAction(nativeAppInstallAd.getCallToAction().toString());
            this.setStarRating(nativeAppInstallAd.getStarRating());
            this.setStore(nativeAppInstallAd.getStore().toString());
            this.setPrice(nativeAppInstallAd.getPrice().toString());
            this.setOverrideImpressionRecording(true);
            this.setOverrideClickHandling(true);
        }

        @Override
        public void trackView(View view) {
            if (view instanceof NativeAdView) {
                ((NativeAdView)view).setNativeAd(this.zzaZ);
            }
        }
    }

    static final class zze
    extends AdListener
    implements NativeAppInstallAd.OnAppInstallAdLoadedListener,
    NativeContentAd.OnContentAdLoadedListener,
    com.google.android.gms.ads.internal.client.zza {
        final AbstractAdViewAdapter zzbb;
        final MediationNativeListener zzbe;

        public zze(AbstractAdViewAdapter abstractAdViewAdapter, MediationNativeListener mediationNativeListener) {
            this.zzbb = abstractAdViewAdapter;
            this.zzbe = mediationNativeListener;
        }

        @Override
        public void onAdLoaded() {
        }

        @Override
        public void onAdFailedToLoad(int errorCode) {
            this.zzbe.onAdFailedToLoad(this.zzbb, errorCode);
        }

        @Override
        public void onAdOpened() {
            this.zzbe.onAdOpened(this.zzbb);
        }

        @Override
        public void onAdClosed() {
            this.zzbe.onAdClosed(this.zzbb);
        }

        @Override
        public void onAdLeftApplication() {
            this.zzbe.onAdLeftApplication(this.zzbb);
        }

        @Override
        public void onAdClicked() {
            this.zzbe.onAdClicked(this.zzbb);
        }

        @Override
        public void onAppInstallAdLoaded(NativeAppInstallAd ad) {
            this.zzbe.onAdLoaded(this.zzbb, new zza(ad));
        }

        @Override
        public void onContentAdLoaded(NativeContentAd ad) {
            this.zzbe.onAdLoaded(this.zzbb, new zzb(ad));
        }
    }

    static final class zzd
    extends AdListener
    implements com.google.android.gms.ads.internal.client.zza {
        final AbstractAdViewAdapter zzbb;
        final MediationInterstitialListener zzbd;

        public zzd(AbstractAdViewAdapter abstractAdViewAdapter, MediationInterstitialListener mediationInterstitialListener) {
            this.zzbb = abstractAdViewAdapter;
            this.zzbd = mediationInterstitialListener;
        }

        @Override
        public void onAdLoaded() {
            this.zzbd.onAdLoaded(this.zzbb);
        }

        @Override
        public void onAdFailedToLoad(int errorCode) {
            this.zzbd.onAdFailedToLoad(this.zzbb, errorCode);
        }

        @Override
        public void onAdOpened() {
            this.zzbd.onAdOpened(this.zzbb);
        }

        @Override
        public void onAdClosed() {
            this.zzbd.onAdClosed(this.zzbb);
        }

        @Override
        public void onAdLeftApplication() {
            this.zzbd.onAdLeftApplication(this.zzbb);
        }

        @Override
        public void onAdClicked() {
            this.zzbd.onAdClicked(this.zzbb);
        }
    }

    static final class zzc
    extends AdListener
    implements com.google.android.gms.ads.internal.client.zza {
        final AbstractAdViewAdapter zzbb;
        final MediationBannerListener zzbc;

        public zzc(AbstractAdViewAdapter abstractAdViewAdapter, MediationBannerListener mediationBannerListener) {
            this.zzbb = abstractAdViewAdapter;
            this.zzbc = mediationBannerListener;
        }

        @Override
        public void onAdLoaded() {
            this.zzbc.onAdLoaded(this.zzbb);
        }

        @Override
        public void onAdFailedToLoad(int errorCode) {
            this.zzbc.onAdFailedToLoad(this.zzbb, errorCode);
        }

        @Override
        public void onAdOpened() {
            this.zzbc.onAdOpened(this.zzbb);
        }

        @Override
        public void onAdClosed() {
            this.zzbc.onAdClosed(this.zzbb);
        }

        @Override
        public void onAdLeftApplication() {
            this.zzbc.onAdLeftApplication(this.zzbb);
        }

        @Override
        public void onAdClicked() {
            this.zzbc.onAdClicked(this.zzbb);
        }
    }
}

