/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.client;

import android.content.Context;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.Correlator;
import com.google.android.gms.ads.doubleclick.AppEventListener;
import com.google.android.gms.ads.doubleclick.OnCustomRenderedAdLoadedListener;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.zza;
import com.google.android.gms.ads.internal.client.zzaa;
import com.google.android.gms.ads.internal.client.zzb;
import com.google.android.gms.ads.internal.client.zzc;
import com.google.android.gms.ads.internal.client.zzh;
import com.google.android.gms.ads.internal.client.zzj;
import com.google.android.gms.ads.internal.client.zzk;
import com.google.android.gms.ads.internal.client.zzn;
import com.google.android.gms.ads.internal.client.zzu;
import com.google.android.gms.ads.purchase.InAppPurchaseListener;
import com.google.android.gms.ads.purchase.PlayStorePurchaseListener;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzcg;
import com.google.android.gms.internal.zzew;
import com.google.android.gms.internal.zzgi;
import com.google.android.gms.internal.zzgm;
import com.google.android.gms.internal.zzhb;
import java.util.concurrent.atomic.AtomicBoolean;

@zzhb
public class zzab {
    private final zzew zzuJ = new zzew();
    private final zzh zzoB;
    private final AtomicBoolean zzuK;
    private AdListener zztA;
    private zza zztz;
    private zzu zzuL;
    private AdSize[] zzuo;
    private String zzpS;
    private String zzuM;
    private ViewGroup zzuN;
    private AppEventListener zzun;
    private InAppPurchaseListener zzuO;
    private PlayStorePurchaseListener zzuP;
    private OnCustomRenderedAdLoadedListener zzuQ;
    private boolean zzpE;
    private Correlator zzuR;
    private boolean zzuS;

    public zzab(ViewGroup viewGroup) {
        this(viewGroup, null, false, zzh.zzcO(), false);
    }

    public zzab(ViewGroup viewGroup, boolean bl) {
        this(viewGroup, null, false, zzh.zzcO(), bl);
    }

    public zzab(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl) {
        this(viewGroup, attributeSet, bl, zzh.zzcO(), false);
    }

    public zzab(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl, boolean bl2) {
        this(viewGroup, attributeSet, bl, zzh.zzcO(), bl2);
    }

    zzab(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl, zzh zzh2, zzu zzu2, boolean bl2) {
        this.zzuN = viewGroup;
        this.zzoB = zzh2;
        this.zzuL = zzu2;
        this.zzuK = new AtomicBoolean(false);
        this.zzuS = bl2;
        if (attributeSet != null) {
            Context context = viewGroup.getContext();
            try {
                zzk zzk2 = new zzk(context, attributeSet);
                this.zzuo = zzk2.zzj(bl);
                this.zzpS = zzk2.getAdUnitId();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                zzn.zzcS().zza(viewGroup, new AdSizeParcel(context, AdSize.BANNER), illegalArgumentException.getMessage(), illegalArgumentException.getMessage());
                return;
            }
            if (viewGroup.isInEditMode()) {
                zzn.zzcS().zza(viewGroup, zzab.zza(context, this.zzuo[0], this.zzuS), "Ads by Google");
            }
        }
    }

    zzab(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl, zzh zzh2, boolean bl2) {
        this(viewGroup, attributeSet, bl, zzh2, null, bl2);
    }

    public void destroy() {
        try {
            if (this.zzuL != null) {
                this.zzuL.destroy();
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to destroy AdView.", remoteException);
        }
    }

    public AdListener getAdListener() {
        return this.zztA;
    }

    public AdSize getAdSize() {
        try {
            AdSizeParcel adSizeParcel;
            if (this.zzuL != null && (adSizeParcel = this.zzuL.zzaN()) != null) {
                return adSizeParcel.zzcQ();
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to get the current AdSize.", remoteException);
        }
        return this.zzuo != null ? this.zzuo[0] : null;
    }

    public AdSize[] getAdSizes() {
        return this.zzuo;
    }

    public String getAdUnitId() {
        return this.zzpS;
    }

    public AppEventListener getAppEventListener() {
        return this.zzun;
    }

    public InAppPurchaseListener getInAppPurchaseListener() {
        return this.zzuO;
    }

    public OnCustomRenderedAdLoadedListener getOnCustomRenderedAdLoadedListener() {
        return this.zzuQ;
    }

    public void zza(zzaa zzaa2) {
        try {
            if (this.zzuL == null) {
                this.zzdg();
            }
            if (this.zzuL.zzb(this.zzoB.zza(this.zzuN.getContext(), zzaa2))) {
                this.zzuJ.zzg(zzaa2.zzdb());
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to load ad.", remoteException);
        }
    }

    public void pause() {
        try {
            if (this.zzuL != null) {
                this.zzuL.pause();
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to call pause.", remoteException);
        }
    }

    public void recordManualImpression() {
        if (this.zzuK.getAndSet(true)) {
            return;
        }
        try {
            if (this.zzuL != null) {
                this.zzuL.zzaP();
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to record impression.", remoteException);
        }
    }

    public void resume() {
        try {
            if (this.zzuL != null) {
                this.zzuL.resume();
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to call resume.", remoteException);
        }
    }

    public void setAdListener(AdListener adListener) {
        try {
            this.zztA = adListener;
            if (this.zzuL != null) {
                this.zzuL.zza(adListener != null ? new zzc(adListener) : null);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the AdListener.", remoteException);
        }
    }

    public void zza(zza zza2) {
        try {
            this.zztz = zza2;
            if (this.zzuL != null) {
                this.zzuL.zza(zza2 != null ? new zzb(zza2) : null);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the AdClickListener.", remoteException);
        }
    }

    public void setAdSizes(AdSize ... adSizes) {
        if (this.zzuo != null) {
            throw new IllegalStateException("The ad size can only be set once on AdView.");
        }
        this.zza(adSizes);
    }

    public void zza(AdSize ... adSizeArray) {
        this.zzuo = adSizeArray;
        try {
            if (this.zzuL != null) {
                this.zzuL.zza(zzab.zza(this.zzuN.getContext(), this.zzuo, this.zzuS));
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the ad size.", remoteException);
        }
        this.zzuN.requestLayout();
    }

    public void setAdUnitId(String adUnitId) {
        if (this.zzpS != null) {
            throw new IllegalStateException("The ad unit ID can only be set once on AdView.");
        }
        this.zzpS = adUnitId;
    }

    public void setAppEventListener(AppEventListener appEventListener) {
        try {
            this.zzun = appEventListener;
            if (this.zzuL != null) {
                this.zzuL.zza(appEventListener != null ? new zzj(appEventListener) : null);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the AppEventListener.", remoteException);
        }
    }

    public void setInAppPurchaseListener(InAppPurchaseListener inAppPurchaseListener) {
        if (this.zzuP != null) {
            throw new IllegalStateException("Play store purchase parameter has already been set.");
        }
        try {
            this.zzuO = inAppPurchaseListener;
            if (this.zzuL != null) {
                this.zzuL.zza(inAppPurchaseListener != null ? new zzgi(inAppPurchaseListener) : null);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the InAppPurchaseListener.", remoteException);
        }
    }

    public void setOnCustomRenderedAdLoadedListener(OnCustomRenderedAdLoadedListener onCustomRenderedAdLoadedListener) {
        this.zzuQ = onCustomRenderedAdLoadedListener;
        try {
            if (this.zzuL != null) {
                this.zzuL.zza(onCustomRenderedAdLoadedListener != null ? new zzcg(onCustomRenderedAdLoadedListener) : null);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the onCustomRenderedAdLoadedListener.", remoteException);
        }
    }

    public void setPlayStorePurchaseParams(PlayStorePurchaseListener playStorePurchaseListener, String publicKey) {
        if (this.zzuO != null) {
            throw new IllegalStateException("InAppPurchaseListener has already been set.");
        }
        try {
            this.zzuP = playStorePurchaseListener;
            this.zzuM = publicKey;
            if (this.zzuL != null) {
                this.zzuL.zza(playStorePurchaseListener != null ? new zzgm(playStorePurchaseListener) : null, publicKey);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the play store purchase parameter.", remoteException);
        }
    }

    public void setManualImpressionsEnabled(boolean manualImpressionsEnabled) {
        this.zzpE = manualImpressionsEnabled;
        try {
            if (this.zzuL != null) {
                this.zzuL.setManualImpressionsEnabled(this.zzpE);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set manual impressions.", remoteException);
        }
    }

    public void setCorrelator(Correlator correlator) {
        this.zzuR = correlator;
        try {
            if (this.zzuL != null) {
                this.zzuL.zza(this.zzuR == null ? null : this.zzuR.zzaF());
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set correlator.", remoteException);
        }
    }

    public String getMediationAdapterClassName() {
        try {
            if (this.zzuL != null) {
                return this.zzuL.getMediationAdapterClassName();
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to get the mediation adapter class name.", remoteException);
        }
        return null;
    }

    public boolean isLoading() {
        try {
            if (this.zzuL != null) {
                return this.zzuL.isLoading();
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to check if ad is loading.", remoteException);
        }
        return false;
    }

    private void zzdf() {
        try {
            zzd zzd2 = this.zzuL.zzaM();
            if (zzd2 == null) {
                return;
            }
            this.zzuN.addView((View)zze.zzp((zzd)zzd2));
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to get an ad frame.", remoteException);
        }
    }

    void zzdg() throws RemoteException {
        if ((this.zzuo == null || this.zzpS == null) && this.zzuL == null) {
            throw new IllegalStateException("The ad size and ad unit ID must be set before loadAd is called.");
        }
        this.zzuL = this.zzdh();
        if (this.zztA != null) {
            this.zzuL.zza(new zzc(this.zztA));
        }
        if (this.zztz != null) {
            this.zzuL.zza(new zzb(this.zztz));
        }
        if (this.zzun != null) {
            this.zzuL.zza(new zzj(this.zzun));
        }
        if (this.zzuO != null) {
            this.zzuL.zza(new zzgi(this.zzuO));
        }
        if (this.zzuP != null) {
            this.zzuL.zza(new zzgm(this.zzuP), this.zzuM);
        }
        if (this.zzuQ != null) {
            this.zzuL.zza(new zzcg(this.zzuQ));
        }
        if (this.zzuR != null) {
            this.zzuL.zza(this.zzuR.zzaF());
        }
        this.zzuL.setManualImpressionsEnabled(this.zzpE);
        this.zzdf();
    }

    protected zzu zzdh() throws RemoteException {
        Context context = this.zzuN.getContext();
        return zzn.zzcT().zza(context, zzab.zza(context, this.zzuo, this.zzuS), this.zzpS, this.zzuJ);
    }

    private static AdSizeParcel zza(Context context, AdSize[] adSizeArray, boolean bl) {
        AdSizeParcel adSizeParcel = new AdSizeParcel(context, adSizeArray);
        adSizeParcel.zzi(bl);
        return adSizeParcel;
    }

    private static AdSizeParcel zza(Context context, AdSize adSize, boolean bl) {
        AdSizeParcel adSizeParcel = new AdSizeParcel(context, adSize);
        adSizeParcel.zzi(bl);
        return adSizeParcel;
    }
}

