/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.formats;

import android.content.Context;
import android.graphics.Rect;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.formats.zza;
import com.google.android.gms.ads.internal.formats.zzb;
import com.google.android.gms.ads.internal.formats.zzh;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.ads.internal.zzr;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzan;
import com.google.android.gms.internal.zzdf;
import com.google.android.gms.internal.zzed;
import com.google.android.gms.internal.zzhb;
import com.google.android.gms.internal.zzin;
import com.google.android.gms.internal.zzjp;
import com.google.android.gms.internal.zzjq;
import java.lang.ref.WeakReference;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

@zzhb
public class zzi
implements zzh {
    private final Object zzpV = new Object();
    private final zzp zzyn;
    private final Context mContext;
    private final JSONObject zzyq;
    private final zzed zzyr;
    private final zzh.zza zzys;
    private final zzan zzyt;
    private final VersionInfoParcel zzpT;
    private boolean zzyu;
    private zzjp zzpD;
    private String zzyv;
    private WeakReference<View> zzyw = null;

    public zzi(Context context, zzp zzp2, zzed zzed2, zzan zzan2, JSONObject jSONObject, zzh.zza zza2, VersionInfoParcel versionInfoParcel) {
        this.mContext = context;
        this.zzyn = zzp2;
        this.zzyr = zzed2;
        this.zzyt = zzan2;
        this.zzyq = jSONObject;
        this.zzys = zza2;
        this.zzpT = versionInfoParcel;
    }

    public zzb zza(View.OnClickListener onClickListener) {
        zza zza2 = this.zzys.zzdN();
        if (zza2 == null) {
            return null;
        }
        zzb zzb2 = new zzb(this.mContext, zza2);
        zzb2.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        zzb2.zzdI().setOnClickListener(onClickListener);
        zzb2.zzdI().setContentDescription((CharSequence)"Ad attribution icon");
        return zzb2;
    }

    @Override
    public void zza(String string2, JSONObject jSONObject, JSONObject jSONObject2, JSONObject jSONObject3) {
        zzx.zzcD((String)"performClick must be called on the main UI thread.");
        try {
            JSONObject jSONObject4 = new JSONObject();
            jSONObject4.put("asset", (Object)string2);
            jSONObject4.put("template", (Object)this.zzys.zzdM());
            JSONObject jSONObject5 = new JSONObject();
            jSONObject5.put("ad", (Object)this.zzyq);
            jSONObject5.put("click", (Object)jSONObject4);
            jSONObject5.put("has_custom_click_handler", this.zzyn.zzs(this.zzys.getCustomTemplateId()) != null);
            if (jSONObject != null) {
                jSONObject5.put("view_rectangles", (Object)jSONObject);
            }
            if (jSONObject2 != null) {
                jSONObject5.put("click_point", (Object)jSONObject2);
            }
            if (jSONObject3 != null) {
                jSONObject5.put("native_view_rectangle", (Object)jSONObject3);
            }
            this.zzyr.zza("google.afma.nativeAds.handleClickGmsg", jSONObject5);
        }
        catch (JSONException jSONException) {
            zzin.zzb("Unable to create click JSON.", jSONException);
        }
    }

    @Override
    public void zza(View view, Map<String, WeakReference<View>> map, JSONObject jSONObject, JSONObject jSONObject2, JSONObject jSONObject3) {
        zzx.zzcD((String)"performClick must be called on the main UI thread.");
        for (Map.Entry<String, WeakReference<View>> entry : map.entrySet()) {
            View view2 = (View)entry.getValue().get();
            if (!view.equals(view2)) continue;
            this.zza(entry.getKey(), jSONObject, jSONObject2, jSONObject3);
            break;
        }
    }

    @Override
    public void zzb(MotionEvent motionEvent) {
        this.zzyt.zza(motionEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzh(View view) {
        Object object = this.zzpV;
        synchronized (object) {
            if (this.zzyu) {
                return;
            }
            if (!view.isShown()) {
                return;
            }
            if (!view.getGlobalVisibleRect(new Rect(), null)) {
                return;
            }
            this.recordImpression();
        }
    }

    @Override
    public void recordImpression() {
        zzx.zzcD((String)"recordImpression must be called on the main UI thread.");
        this.zzn(true);
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("ad", (Object)this.zzyq);
            this.zzyr.zza("google.afma.nativeAds.handleImpressionPing", jSONObject);
        }
        catch (JSONException jSONException) {
            zzin.zzb("Unable to create impression JSON.", jSONException);
        }
        this.zzyn.zza(this);
    }

    @Override
    public View zzdS() {
        return this.zzyw != null ? (View)this.zzyw.get() : null;
    }

    @Override
    public void zzi(View view) {
        this.zzyw = new WeakReference<View>(view);
    }

    public void zzg(View view) {
    }

    public zzjp zzdR() {
        this.zzpD = this.zzdT();
        this.zzpD.getView().setVisibility(8);
        this.zzyr.zza("/loadHtml", new zzdf(){

            @Override
            public void zza(zzjp zzjp2, final Map<String, String> map) {
                zzi.this.zzpD.zzhU().zza(new zzjq.zza(){

                    @Override
                    public void zza(zzjp zzjp2, boolean bl) {
                        zzi.this.zzyv = (String)map.get("id");
                        JSONObject jSONObject = new JSONObject();
                        try {
                            jSONObject.put("messageType", (Object)"htmlLoaded");
                            jSONObject.put("id", (Object)zzi.this.zzyv);
                            zzi.this.zzyr.zzb("sendMessageToNativeJs", jSONObject);
                        }
                        catch (JSONException jSONException) {
                            zzin.zzb("Unable to dispatch sendMessageToNativeJsevent", jSONException);
                        }
                    }
                });
                String string2 = map.get("overlayHtml");
                String string3 = map.get("baseUrl");
                if (TextUtils.isEmpty((CharSequence)string3)) {
                    zzi.this.zzpD.loadData(string2, "text/html", "UTF-8");
                } else {
                    zzi.this.zzpD.loadDataWithBaseURL(string3, string2, "text/html", "UTF-8", null);
                }
            }
        });
        this.zzyr.zza("/showOverlay", new zzdf(){

            @Override
            public void zza(zzjp zzjp2, Map<String, String> map) {
                zzi.this.zzpD.getView().setVisibility(0);
            }
        });
        this.zzyr.zza("/hideOverlay", new zzdf(){

            @Override
            public void zza(zzjp zzjp2, Map<String, String> map) {
                zzi.this.zzpD.getView().setVisibility(8);
            }
        });
        this.zzpD.zzhU().zza("/hideOverlay", new zzdf(){

            @Override
            public void zza(zzjp zzjp2, Map<String, String> map) {
                zzi.this.zzpD.getView().setVisibility(8);
            }
        });
        this.zzpD.zzhU().zza("/sendMessageToSdk", new zzdf(){

            @Override
            public void zza(zzjp zzjp2, Map<String, String> map) {
                JSONObject jSONObject = new JSONObject();
                try {
                    for (String string2 : map.keySet()) {
                        jSONObject.put(string2, (Object)map.get(string2));
                    }
                    jSONObject.put("id", (Object)zzi.this.zzyv);
                    zzi.this.zzyr.zzb("sendMessageToNativeJs", jSONObject);
                }
                catch (JSONException jSONException) {
                    zzin.zzb("Unable to dispatch sendMessageToNativeJs event", jSONException);
                }
            }
        });
        return this.zzpD;
    }

    protected void zzn(boolean bl) {
        this.zzyu = bl;
    }

    zzjp zzdT() {
        return zzr.zzbD().zza(this.mContext, AdSizeParcel.zzt(this.mContext), false, false, this.zzyt, this.zzpT);
    }

    @Override
    public Context getContext() {
        return this.mContext;
    }
}

