/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.formats;

import android.graphics.Point;
import android.graphics.Rect;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import com.google.android.gms.ads.internal.client.zzn;
import com.google.android.gms.ads.internal.formats.zzb;
import com.google.android.gms.ads.internal.formats.zzg;
import com.google.android.gms.ads.internal.formats.zzh;
import com.google.android.gms.ads.internal.formats.zzi;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzcj;
import com.google.android.gms.internal.zzhb;
import com.google.android.gms.internal.zzin;
import com.google.android.gms.internal.zzir;
import com.google.android.gms.internal.zzjk;
import com.google.android.gms.internal.zzjp;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

@zzhb
public class zzk
extends zzcj.zza
implements View.OnClickListener,
View.OnTouchListener,
ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener {
    private final Object zzpV = new Object();
    private final FrameLayout zzyD;
    private FrameLayout zzoQ;
    private Map<String, WeakReference<View>> zzyE = new HashMap<String, WeakReference<View>>();
    private zzb zzyF;
    private zzh zzyf;
    boolean zzyG = false;
    int zzyH;
    int zzyI;

    public zzk(FrameLayout frameLayout, FrameLayout frameLayout2) {
        this.zzyD = frameLayout;
        this.zzoQ = frameLayout2;
        zzjk.zza((View)this.zzyD, this);
        zzjk.zza((View)this.zzyD, this);
        this.zzyD.setOnTouchListener((View.OnTouchListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zza(String string2, zzd zzd2) {
        View view = (View)zze.zzp((zzd)zzd2);
        Object object = this.zzpV;
        synchronized (object) {
            if (view == null) {
                this.zzyE.remove(string2);
            } else {
                this.zzyE.put(string2, new WeakReference<View>(view));
                view.setOnTouchListener((View.OnTouchListener)this);
                view.setOnClickListener((View.OnClickListener)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public zzd zzK(String string2) {
        Object object = this.zzpV;
        synchronized (object) {
            WeakReference<View> weakReference = this.zzyE.get(string2);
            return zze.zzC(weakReference == null ? null : (View)weakReference.get());
        }
    }

    void zzi(View view) {
        zzh zzh2 = null;
        if (this.zzyf != null && (zzh2 = this.zzyf instanceof zzg ? ((zzg)this.zzyf).zzdQ() : this.zzyf) != null) {
            zzh2.zzi(view);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zza(zzd zzd2) {
        Object object = this.zzpV;
        synchronized (object) {
            this.zzyG = true;
            this.zzi(null);
            Object object2 = zze.zzp((zzd)zzd2);
            if (!(object2 instanceof zzi)) {
                zzin.zzaK("Not an instance of native engine. This is most likely a transient error");
                return;
            }
            final zzi zzi2 = (zzi)object2;
            if (this.zzyf instanceof zzg && ((zzg)this.zzyf).zzdP()) {
                ((zzg)this.zzyf).zzc(zzi2);
            } else {
                this.zzyf = zzi2;
                if (this.zzyf instanceof zzg) {
                    ((zzg)this.zzyf).zzc(null);
                }
            }
            this.zzoQ.removeAllViews();
            this.zzyF = this.zzd(zzi2);
            if (this.zzyF != null) {
                this.zzyE.put("1007", new WeakReference<ViewGroup>(this.zzyF.zzdI()));
                this.zzoQ.addView((View)this.zzyF);
            }
            zzir.zzMc.post(new Runnable(){

                @Override
                public void run() {
                    zzjp zzjp2 = zzi2.zzdR();
                    if (zzjp2 != null) {
                        zzk.this.zzoQ.addView(zzjp2.getView());
                    }
                }
            });
            zzi2.zzg((View)this.zzyD);
            this.zzi((View)this.zzyD);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClick(View view) {
        Object object = this.zzpV;
        synchronized (object) {
            if (this.zzyf == null) {
                return;
            }
            JSONObject jSONObject2 = new JSONObject();
            for (Map.Entry<String, WeakReference<View>> jSONObject3 : this.zzyE.entrySet()) {
                View view2 = (View)jSONObject3.getValue().get();
                Point point = this.zzj(view2);
                JSONObject jSONObject = new JSONObject();
                try {
                    jSONObject.put("width", this.zzq(view2.getWidth()));
                    jSONObject.put("height", this.zzq(view2.getHeight()));
                    jSONObject.put("x", this.zzq(point.x));
                    jSONObject.put("y", this.zzq(point.y));
                    jSONObject2.put(jSONObject3.getKey(), (Object)jSONObject);
                }
                catch (JSONException jSONException) {
                    zzin.zzaK("Unable to get view rectangle for view " + jSONObject3.getKey());
                }
            }
            JSONObject jSONObject5 = new JSONObject();
            try {
                jSONObject5.put("x", this.zzq(this.zzyH));
                jSONObject5.put("y", this.zzq(this.zzyI));
            }
            catch (JSONException jSONException) {
                zzin.zzaK("Unable to get click location");
            }
            JSONObject jSONObject = new JSONObject();
            try {
                jSONObject.put("width", this.zzq(this.getMeasuredWidth()));
                jSONObject.put("height", this.zzq(this.getMeasuredHeight()));
            }
            catch (JSONException jSONException) {
                zzin.zzaK("Unable to get native ad view bounding box");
            }
            if (this.zzyF != null && this.zzyF.zzdI().equals(view)) {
                this.zzyf.zza("1007", jSONObject2, jSONObject5, jSONObject);
            } else {
                this.zzyf.zza(view, this.zzyE, jSONObject2, jSONObject5, jSONObject);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onGlobalLayout() {
        Object object = this.zzpV;
        synchronized (object) {
            if (this.zzyG) {
                int n = this.getMeasuredWidth();
                int n2 = this.getMeasuredHeight();
                if (n != 0 && n2 != 0) {
                    this.zzoQ.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(n, n2));
                    this.zzyG = false;
                }
            }
            if (this.zzyf != null) {
                this.zzyf.zzh((View)this.zzyD);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onScrollChanged() {
        Object object = this.zzpV;
        synchronized (object) {
            if (this.zzyf != null) {
                this.zzyf.zzh((View)this.zzyD);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onTouch(View view, MotionEvent motionEvent) {
        Object object = this.zzpV;
        synchronized (object) {
            if (this.zzyf == null) {
                return false;
            }
            Point point = this.zzc(motionEvent);
            this.zzyH = point.x;
            this.zzyI = point.y;
            MotionEvent motionEvent2 = MotionEvent.obtain((MotionEvent)motionEvent);
            motionEvent2.setLocation((float)point.x, (float)point.y);
            this.zzyf.zzb(motionEvent2);
            motionEvent2.recycle();
            return false;
        }
    }

    @Override
    public void destroy() {
        this.zzoQ.removeAllViews();
        this.zzoQ = null;
        this.zzyE = null;
        this.zzyF = null;
        this.zzyf = null;
    }

    Point zzc(MotionEvent motionEvent) {
        int[] nArray = new int[2];
        this.zzyD.getLocationOnScreen(nArray);
        float f = motionEvent.getRawX() - (float)nArray[0];
        float f2 = motionEvent.getRawY() - (float)nArray[1];
        return new Point((int)f, (int)f2);
    }

    zzb zzd(zzi zzi2) {
        return zzi2.zza(this);
    }

    int getMeasuredWidth() {
        return this.zzyD.getMeasuredWidth();
    }

    int getMeasuredHeight() {
        return this.zzyD.getMeasuredHeight();
    }

    int zzq(int n) {
        return zzn.zzcS().zzc(this.zzyf.getContext(), n);
    }

    Point zzj(View view) {
        if (this.zzyF != null && this.zzyF.zzdI().equals(view)) {
            Point point = new Point();
            this.zzyD.getGlobalVisibleRect(new Rect(), point);
            Point point2 = new Point();
            view.getGlobalVisibleRect(new Rect(), point2);
            return new Point(point2.x - point.x, point2.y - point.y);
        }
        Point point = new Point();
        view.getGlobalVisibleRect(new Rect(), point);
        return point;
    }
}

