/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.request;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.ads.internal.request.AdRequestInfoParcel;
import com.google.android.gms.ads.internal.request.AdResponseParcel;
import com.google.android.gms.ads.internal.request.zza;
import com.google.android.gms.ads.internal.zzr;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.internal.zzbm;
import com.google.android.gms.internal.zzbt;
import com.google.android.gms.internal.zzdf;
import com.google.android.gms.internal.zzdg;
import com.google.android.gms.internal.zzdk;
import com.google.android.gms.internal.zzed;
import com.google.android.gms.internal.zzeg;
import com.google.android.gms.internal.zzeh;
import com.google.android.gms.internal.zzhb;
import com.google.android.gms.internal.zzhe;
import com.google.android.gms.internal.zzif;
import com.google.android.gms.internal.zzim;
import com.google.android.gms.internal.zzin;
import com.google.android.gms.internal.zzji;
import com.google.android.gms.internal.zzjp;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.json.JSONException;
import org.json.JSONObject;

@zzhb
public class zzm
extends zzim {
    static final long zzIw = TimeUnit.SECONDS.toMillis(10L);
    private static final Object zzqy = new Object();
    private static boolean zzIx = false;
    private static zzeg zzIy = null;
    private static zzdg zzIz = null;
    private static zzdk zzIA = null;
    private static zzdf zzIB = null;
    private final zza.zza zzHg;
    private final AdRequestInfoParcel.zza zzHh;
    private final Object zzGg = new Object();
    private final Context mContext;
    private zzeg.zzd zzIC;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public zzm(Context context, AdRequestInfoParcel.zza zza2, zza.zza zza3) {
        super(true);
        this.zzHg = zza3;
        this.mContext = context;
        this.zzHh = zza2;
        Object object = zzqy;
        synchronized (object) {
            if (!zzIx) {
                zzIA = new zzdk();
                zzIz = new zzdg(context.getApplicationContext(), zza2.zzrl);
                zzIB = new zzc();
                zzIy = new zzeg(this.mContext.getApplicationContext(), this.zzHh.zzrl, zzbt.zzvB.get(), new zzb(), new zza());
                zzIx = true;
            }
        }
    }

    protected static void zzc(zzed zzed2) {
        zzed2.zza("/loadAd", zzIA);
        zzed2.zza("/fetchHttpRequest", zzIz);
        zzed2.zza("/invalidRequest", zzIB);
    }

    protected static void zzd(zzed zzed2) {
        zzed2.zzb("/loadAd", zzIA);
        zzed2.zzb("/fetchHttpRequest", zzIz);
        zzed2.zzb("/invalidRequest", zzIB);
    }

    @Override
    public void zzbr() {
        zzin.zzaI("SdkLessAdLoaderBackgroundTask started.");
        AdRequestInfoParcel adRequestInfoParcel = new AdRequestInfoParcel(this.zzHh, null, -1L);
        AdResponseParcel adResponseParcel = this.zze(adRequestInfoParcel);
        long l = zzr.zzbG().elapsedRealtime();
        final zzif.zza zza2 = new zzif.zza(adRequestInfoParcel, adResponseParcel, null, null, adResponseParcel.errorCode, l, adResponseParcel.zzHX, null);
        com.google.android.gms.ads.internal.util.client.zza.zzMS.post(new Runnable(){

            @Override
            public void run() {
                zzm.this.zzHg.zza(zza2);
                if (zzm.this.zzIC != null) {
                    zzm.this.zzIC.release();
                    zzm.this.zzIC = null;
                }
            }
        });
    }

    private AdResponseParcel zze(AdRequestInfoParcel adRequestInfoParcel) {
        JSONObject jSONObject;
        final String string2 = UUID.randomUUID().toString();
        final JSONObject jSONObject2 = this.zza(adRequestInfoParcel, string2);
        if (jSONObject2 == null) {
            return new AdResponseParcel(0);
        }
        long l = zzr.zzbG().elapsedRealtime();
        Future<JSONObject> future = zzIA.zzR(string2);
        com.google.android.gms.ads.internal.util.client.zza.zzMS.post(new Runnable(){

            @Override
            public void run() {
                zzm.this.zzIC = zzIy.zzer();
                zzm.this.zzIC.zza(new zzji.zzc<zzeh>(){

                    public void zzd(zzeh zzeh2) {
                        try {
                            zzeh2.zza("AFMA_getAdapterLessMediationAd", jSONObject2);
                        }
                        catch (Exception exception) {
                            zzin.zzb("Error requesting an ad url", exception);
                            zzIA.zzS(string2);
                        }
                    }

                    @Override
                    public /* synthetic */ void zze(Object object) {
                        this.zzd((zzeh)object);
                    }
                }, new zzji.zza(){

                    @Override
                    public void run() {
                        zzIA.zzS(string2);
                    }
                });
            }
        });
        long l2 = zzIw - (zzr.zzbG().elapsedRealtime() - l);
        try {
            jSONObject = future.get(l2, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | CancellationException exception) {
            return new AdResponseParcel(-1);
        }
        catch (TimeoutException timeoutException) {
            return new AdResponseParcel(2);
        }
        catch (ExecutionException executionException) {
            return new AdResponseParcel(0);
        }
        if (jSONObject == null) {
            return new AdResponseParcel(-1);
        }
        AdResponseParcel adResponseParcel = zzhe.zza(this.mContext, adRequestInfoParcel, jSONObject.toString());
        if (adResponseParcel.errorCode != -3 && TextUtils.isEmpty((CharSequence)adResponseParcel.body)) {
            return new AdResponseParcel(3);
        }
        return adResponseParcel;
    }

    private JSONObject zza(AdRequestInfoParcel adRequestInfoParcel, String string2) {
        Bundle bundle = adRequestInfoParcel.zzHt.extras.getBundle("sdk_less_server_data");
        String string3 = adRequestInfoParcel.zzHt.extras.getString("sdk_less_network_id");
        if (bundle == null) {
            return null;
        }
        JSONObject jSONObject = zzhe.zza(this.mContext, adRequestInfoParcel, zzr.zzbI().zzE(this.mContext), null, null, new zzbm(zzbt.zzvB.get()), null, null, new ArrayList<String>(), null);
        if (jSONObject == null) {
            return null;
        }
        AdvertisingIdClient.Info info = null;
        try {
            info = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.mContext);
        }
        catch (GooglePlayServicesNotAvailableException | GooglePlayServicesRepairableException | IOException | IllegalStateException throwable) {
            zzin.zzd("Cannot get advertising id info", throwable);
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("request_id", string2);
        hashMap.put("network_id", string3);
        hashMap.put("request_param", jSONObject);
        hashMap.put("data", bundle);
        if (info != null) {
            hashMap.put("adid", info.getId());
            hashMap.put("lat", info.isLimitAdTrackingEnabled() ? 1 : 0);
        }
        try {
            return zzr.zzbC().zzG(hashMap);
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStop() {
        Object object = this.zzGg;
        synchronized (object) {
            com.google.android.gms.ads.internal.util.client.zza.zzMS.post(new Runnable(){

                @Override
                public void run() {
                    if (zzm.this.zzIC != null) {
                        zzm.this.zzIC.release();
                        zzm.this.zzIC = null;
                    }
                }
            });
        }
    }

    public static class zza
    implements zzeg.zzb<zzed> {
        public void zza(zzed zzed2) {
            zzm.zzd(zzed2);
        }

        @Override
        public /* synthetic */ void zze(Object object) {
            this.zza((zzed)object);
        }
    }

    public static class zzb
    implements zzeg.zzb<zzed> {
        public void zza(zzed zzed2) {
            zzm.zzc(zzed2);
        }

        @Override
        public /* synthetic */ void zze(Object object) {
            this.zza((zzed)object);
        }
    }

    public static class zzc
    implements zzdf {
        @Override
        public void zza(zzjp zzjp2, Map<String, String> map) {
            String string2 = map.get("request_id");
            String string3 = map.get("errors");
            zzin.zzaK("Invalid request: " + string3);
            zzIA.zzS(string2);
        }
    }
}

