/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewParent;
import com.google.android.gms.ads.internal.client.AdRequestParcel;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.ThinAdSizeParcel;
import com.google.android.gms.ads.internal.client.zzf;
import com.google.android.gms.ads.internal.client.zzn;
import com.google.android.gms.ads.internal.client.zzu;
import com.google.android.gms.ads.internal.client.zzw;
import com.google.android.gms.ads.internal.client.zzx;
import com.google.android.gms.ads.internal.overlay.zzp;
import com.google.android.gms.ads.internal.request.zza;
import com.google.android.gms.ads.internal.reward.mediation.client.RewardItemParcel;
import com.google.android.gms.ads.internal.zzd;
import com.google.android.gms.ads.internal.zzq;
import com.google.android.gms.ads.internal.zzr;
import com.google.android.gms.ads.internal.zzs;
import com.google.android.gms.common.zze;
import com.google.android.gms.internal.zzax;
import com.google.android.gms.internal.zzbc;
import com.google.android.gms.internal.zzbf;
import com.google.android.gms.internal.zzbt;
import com.google.android.gms.internal.zzbz;
import com.google.android.gms.internal.zzcb;
import com.google.android.gms.internal.zzcf;
import com.google.android.gms.internal.zzdb;
import com.google.android.gms.internal.zzgd;
import com.google.android.gms.internal.zzgh;
import com.google.android.gms.internal.zzgr;
import com.google.android.gms.internal.zzhb;
import com.google.android.gms.internal.zzhr;
import com.google.android.gms.internal.zzif;
import com.google.android.gms.internal.zzig;
import com.google.android.gms.internal.zzij;
import com.google.android.gms.internal.zzik;
import com.google.android.gms.internal.zzin;
import java.util.HashSet;

@zzhb
public abstract class zza
extends zzu.zza
implements com.google.android.gms.ads.internal.client.zza,
zzp,
zza.zza,
zzdb,
zzgr.zza,
zzij {
    protected zzcb zzpe;
    protected zzbz zzpf;
    protected zzbz zzpg;
    protected boolean zzph = false;
    protected final zzq zzpi;
    protected final zzs zzpj;
    protected transient AdRequestParcel zzpk;
    protected final zzax zzpl;
    protected final zzd zzpm;

    zza(zzs zzs2, zzq zzq2, zzd zzd2) {
        this.zzpj = zzs2;
        this.zzpi = zzq2 != null ? zzq2 : new zzq(this);
        this.zzpm = zzd2;
        zzr.zzbC().zzJ(this.zzpj.context);
        zzr.zzbF().zzb(this.zzpj.context, this.zzpj.zzrl);
        this.zzpl = zzr.zzbF().zzhh();
    }

    void zzaL() {
        this.zzpe = new zzcb(zzbt.zzwg.get(), "load_ad", this.zzpj.zzrp.zzuh);
        this.zzpf = new zzbz(-1L, null, null);
        this.zzpg = new zzbz(-1L, null, null);
    }

    @Override
    public void destroy() {
        com.google.android.gms.common.internal.zzx.zzcD((String)"destroy must be called on the main UI thread.");
        this.zzpi.cancel();
        this.zzpl.zzj(this.zzpj.zzrq);
        this.zzpj.destroy();
    }

    @Override
    public com.google.android.gms.dynamic.zzd zzaM() {
        com.google.android.gms.common.internal.zzx.zzcD((String)"getAdFrame must be called on the main UI thread.");
        return com.google.android.gms.dynamic.zze.zzC((Object)((Object)this.zzpj.zzrm));
    }

    @Override
    public AdSizeParcel zzaN() {
        com.google.android.gms.common.internal.zzx.zzcD((String)"getAdSize must be called on the main UI thread.");
        return this.zzpj.zzrp == null ? null : new ThinAdSizeParcel(this.zzpj.zzrp);
    }

    @Override
    public boolean isReady() {
        com.google.android.gms.common.internal.zzx.zzcD((String)"isLoaded must be called on the main UI thread.");
        return this.zzpj.zzrn == null && this.zzpj.zzro == null && this.zzpj.zzrq != null;
    }

    @Override
    public void setManualImpressionsEnabled(boolean enabled) {
        throw new UnsupportedOperationException("Attempt to call setManualImpressionsEnabled for an unsupported ad type.");
    }

    private AdRequestParcel zza(AdRequestParcel adRequestParcel) {
        if (zze.zzap((Context)this.zzpj.context) && adRequestParcel.zztK != null) {
            return new zzf(adRequestParcel).zza(null).zzcN();
        }
        return adRequestParcel;
    }

    @Override
    public boolean zzb(AdRequestParcel adRequestParcel) {
        com.google.android.gms.common.internal.zzx.zzcD((String)"loadAd must be called on the main UI thread.");
        adRequestParcel = this.zza(adRequestParcel);
        if (this.zzpj.zzrn != null || this.zzpj.zzro != null) {
            if (this.zzpk != null) {
                zzin.zzaK("Aborting last ad request since another ad request is already in progress. The current request object will still be cached for future refreshes.");
            } else {
                zzin.zzaK("Loading already in progress, saving this object for future refreshes.");
            }
            this.zzpk = adRequestParcel;
            return false;
        }
        zzin.zzaJ("Starting ad request.");
        this.zzaL();
        this.zzpf = this.zzpe.zzdB();
        if (!adRequestParcel.zztF) {
            zzin.zzaJ("Use AdRequest.Builder.addTestDevice(\"" + zzn.zzcS().zzT(this.zzpj.context) + "\") to get test ads on this device.");
        }
        this.zzph = this.zza(adRequestParcel, this.zzpe);
        return this.zzph;
    }

    protected abstract boolean zza(AdRequestParcel var1, zzcb var2);

    @Override
    public void zza(zzif.zza zza2) {
        long l;
        if (zza2.zzLe.zzHX != -1L && !TextUtils.isEmpty((CharSequence)zza2.zzLe.zzIh) && (l = this.zzp(zza2.zzLe.zzIh)) != -1L) {
            zzbz zzbz2 = this.zzpe.zzb(zza2.zzLe.zzHX + l);
            this.zzpe.zza(zzbz2, "stc");
        }
        this.zzpe.zzN(zza2.zzLe.zzIh);
        this.zzpe.zza(this.zzpf, "arf");
        this.zzpg = this.zzpe.zzdB();
        this.zzpe.zzc("gqi", zza2.zzLe.zzIi);
        this.zzpj.zzrn = null;
        this.zzpj.zzrr = zza2;
        this.zza(zza2, this.zzpe);
    }

    protected abstract void zza(zzif.zza var1, zzcb var2);

    boolean zza(zzif zzif2) {
        return false;
    }

    @Override
    public void zzb(zzif zzif2) {
        this.zzpe.zza(this.zzpg, "awr");
        this.zzpj.zzro = null;
        if (zzif2.errorCode != -2 && zzif2.errorCode != 3) {
            zzr.zzbF().zzb(this.zzpj.zzbS());
        }
        if (zzif2.errorCode == -1) {
            this.zzph = false;
            return;
        }
        if (this.zza(zzif2)) {
            zzin.zzaI("Ad refresh scheduled.");
        }
        if (zzif2.errorCode != -2) {
            this.zzf(zzif2.errorCode);
            return;
        }
        if (this.zzpj.zzrJ == null) {
            this.zzpj.zzrJ = new zzik(this.zzpj.zzrj);
        }
        this.zzpl.zzi(this.zzpj.zzrq);
        if (this.zza(this.zzpj.zzrq, zzif2)) {
            this.zzpj.zzrq = zzif2;
            this.zzpj.zzcb();
            this.zzpe.zzc("is_mraid", this.zzpj.zzrq.zzcv() ? "1" : "0");
            this.zzpe.zzc("is_mediation", this.zzpj.zzrq.zzHT ? "1" : "0");
            if (this.zzpj.zzrq.zzED != null && this.zzpj.zzrq.zzED.zzhU() != null) {
                this.zzpe.zzc("is_video", this.zzpj.zzrq.zzED.zzhU().zzih() ? "1" : "0");
            }
            this.zzpe.zza(this.zzpf, "ttc");
            if (zzr.zzbF().zzhb() != null) {
                zzr.zzbF().zzhb().zza(this.zzpe);
            }
            if (this.zzpj.zzbW()) {
                this.zzaT();
            }
        }
    }

    protected abstract boolean zza(zzif var1, zzif var2);

    @Override
    public void onAdClicked() {
        if (this.zzpj.zzrq == null) {
            zzin.zzaK("Ad state was null when trying to ping click URLs.");
            return;
        }
        zzin.zzaI("Pinging click URLs.");
        this.zzpj.zzrs.zzgT();
        if (this.zzpj.zzrq.zzBQ != null) {
            zzr.zzbC().zza(this.zzpj.context, this.zzpj.zzrl.afmaVersion, this.zzpj.zzrq.zzBQ);
        }
        if (this.zzpj.zzrt != null) {
            try {
                this.zzpj.zzrt.onAdClicked();
            }
            catch (RemoteException remoteException) {
                zzin.zzd("Could not notify onAdClicked event.", remoteException);
            }
        }
    }

    @Override
    public void zzaO() {
        this.zzaR();
    }

    @Override
    public void onAppEvent(String name, String info) {
        if (this.zzpj.zzrv != null) {
            try {
                this.zzpj.zzrv.onAppEvent(name, info);
            }
            catch (RemoteException remoteException) {
                zzin.zzd("Could not call the AppEventListener.", remoteException);
            }
        }
    }

    @Override
    public void zzaP() {
        com.google.android.gms.common.internal.zzx.zzcD((String)"recordManualImpression must be called on the main UI thread.");
        if (this.zzpj.zzrq == null) {
            zzin.zzaK("Ad state was null when trying to ping manual tracking URLs.");
            return;
        }
        zzin.zzaI("Pinging manual tracking URLs.");
        if (this.zzpj.zzrq.zzHV != null && !this.zzpj.zzrq.zzLc) {
            zzr.zzbC().zza(this.zzpj.context, this.zzpj.zzrl.afmaVersion, this.zzpj.zzrq.zzHV);
            this.zzpj.zzrq.zzLc = true;
        }
    }

    @Override
    public void pause() {
        com.google.android.gms.common.internal.zzx.zzcD((String)"pause must be called on the main UI thread.");
    }

    @Override
    public void resume() {
        com.google.android.gms.common.internal.zzx.zzcD((String)"resume must be called on the main UI thread.");
    }

    protected boolean zzc(AdRequestParcel adRequestParcel) {
        ViewParent viewParent = this.zzpj.zzrm.getParent();
        return viewParent instanceof View && ((View)viewParent).isShown() && zzr.zzbC().zzhq();
    }

    public void zzd(AdRequestParcel adRequestParcel) {
        if (this.zzc(adRequestParcel)) {
            this.zzb(adRequestParcel);
        } else {
            zzin.zzaJ("Ad is not visible. Not refreshing ad.");
            this.zzpi.zzg(adRequestParcel);
        }
    }

    @Override
    public void zza(com.google.android.gms.ads.internal.client.zzq zzq2) {
        com.google.android.gms.common.internal.zzx.zzcD((String)"setAdListener must be called on the main UI thread.");
        this.zzpj.zzru = zzq2;
    }

    @Override
    public void zza(com.google.android.gms.ads.internal.reward.client.zzd zzd2) {
        com.google.android.gms.common.internal.zzx.zzcD((String)"setRewardedVideoAdListener can only be called from the UI thread.");
        this.zzpj.zzrF = zzd2;
    }

    @Override
    public void setUserId(String userId) {
        com.google.android.gms.common.internal.zzx.zzcD((String)"setUserId must be called on the main UI thread.");
        this.zzpj.setUserId(userId);
    }

    @Override
    public void zza(com.google.android.gms.ads.internal.client.zzp zzp2) {
        com.google.android.gms.common.internal.zzx.zzcD((String)"setAdListener must be called on the main UI thread.");
        this.zzpj.zzrt = zzp2;
    }

    @Override
    public void zza(AdSizeParcel adSizeParcel) {
        com.google.android.gms.common.internal.zzx.zzcD((String)"setAdSize must be called on the main UI thread.");
        this.zzpj.zzrp = adSizeParcel;
        if (this.zzpj.zzrq != null && this.zzpj.zzrq.zzED != null && this.zzpj.zzrL == 0) {
            this.zzpj.zzrq.zzED.zza(adSizeParcel);
        }
        if (this.zzpj.zzrm == null) {
            return;
        }
        if (this.zzpj.zzrm.getChildCount() > 1) {
            this.zzpj.zzrm.removeView(this.zzpj.zzrm.getNextView());
        }
        this.zzpj.zzrm.setMinimumWidth(adSizeParcel.widthPixels);
        this.zzpj.zzrm.setMinimumHeight(adSizeParcel.heightPixels);
        this.zzpj.zzrm.requestLayout();
    }

    @Override
    public void zza(zzw zzw2) {
        com.google.android.gms.common.internal.zzx.zzcD((String)"setAppEventListener must be called on the main UI thread.");
        this.zzpj.zzrv = zzw2;
    }

    @Override
    public void zza(zzgd zzgd2) {
        throw new IllegalStateException("setInAppPurchaseListener is not supported for current ad type");
    }

    @Override
    public void zza(zzcf zzcf2) {
        throw new IllegalStateException("setOnCustomRenderedAdLoadedListener is not supported for current ad type");
    }

    @Override
    public void zza(zzgh zzgh2, String string2) {
        throw new IllegalStateException("setPlayStorePurchaseParams is not supported for current ad type");
    }

    @Override
    public void zza(zzx zzx2) {
        com.google.android.gms.common.internal.zzx.zzcD((String)"setCorrelationIdProvider must be called on the main UI thread");
        this.zzpj.zzrw = zzx2;
    }

    @Override
    public void stopLoading() {
        com.google.android.gms.common.internal.zzx.zzcD((String)"stopLoading must be called on the main UI thread.");
        this.zzph = false;
        this.zzpj.zzf(true);
    }

    @Override
    public boolean isLoading() {
        return this.zzph;
    }

    Bundle zza(zzbf zzbf2) {
        if (zzbf2 == null) {
            return null;
        }
        if (zzbf2.zzcK()) {
            zzbf2.wakeup();
        }
        zzbc zzbc2 = zzbf2.zzcI();
        String string2 = null;
        String string3 = null;
        if (zzbc2 != null) {
            string2 = zzbc2.zzcy();
            string3 = zzbc2.zzcz();
            zzin.zzaI("In AdManager: loadAd, " + zzbc2.toString());
            if (string2 != null) {
                zzr.zzbF().zzaA(string2);
            }
        } else {
            string2 = zzr.zzbF().zzhf();
        }
        if (string2 != null) {
            Bundle bundle = new Bundle(1);
            bundle.putString("fingerprint", string2);
            if (!string2.equals(string3)) {
                bundle.putString("v_fp", string3);
            }
            return bundle;
        }
        return null;
    }

    long zzp(@NonNull String string2) {
        int n = string2.indexOf("ufe");
        int n2 = string2.indexOf(44, n);
        if (n2 == -1) {
            n2 = string2.length();
        }
        try {
            return Long.parseLong(string2.substring(n + 4, n2));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            zzin.zzaK("Invalid index for Url fetch time in CSI latency info.");
        }
        catch (NumberFormatException numberFormatException) {
            zzin.zzaK("Cannot find valid format of Url fetch time in CSI latency info.");
        }
        return -1L;
    }

    protected void zzb(View view) {
        this.zzpj.zzrm.addView(view, zzr.zzbE().zzhy());
    }

    protected void zzaQ() {
        zzin.zzaJ("Ad closing.");
        if (this.zzpj.zzru != null) {
            try {
                this.zzpj.zzru.onAdClosed();
            }
            catch (RemoteException remoteException) {
                zzin.zzd("Could not call AdListener.onAdClosed().", remoteException);
            }
        }
        if (this.zzpj.zzrF != null) {
            try {
                this.zzpj.zzrF.onRewardedVideoAdClosed();
            }
            catch (RemoteException remoteException) {
                zzin.zzd("Could not call RewardedVideoAdListener.onRewardedVideoAdClosed().", remoteException);
            }
        }
    }

    protected void zzaR() {
        zzin.zzaJ("Ad leaving application.");
        if (this.zzpj.zzru != null) {
            try {
                this.zzpj.zzru.onAdLeftApplication();
            }
            catch (RemoteException remoteException) {
                zzin.zzd("Could not call AdListener.onAdLeftApplication().", remoteException);
            }
        }
        if (this.zzpj.zzrF != null) {
            try {
                this.zzpj.zzrF.onRewardedVideoAdLeftApplication();
            }
            catch (RemoteException remoteException) {
                zzin.zzd("Could not call  RewardedVideoAdListener.onRewardedVideoAdLeftApplication().", remoteException);
            }
        }
    }

    protected void zzaS() {
        zzin.zzaJ("Ad opening.");
        if (this.zzpj.zzru != null) {
            try {
                this.zzpj.zzru.onAdOpened();
            }
            catch (RemoteException remoteException) {
                zzin.zzd("Could not call AdListener.onAdOpened().", remoteException);
            }
        }
        if (this.zzpj.zzrF != null) {
            try {
                this.zzpj.zzrF.onRewardedVideoAdOpened();
            }
            catch (RemoteException remoteException) {
                zzin.zzd("Could not call RewardedVideoAdListener.onRewardedVideoAdOpened().", remoteException);
            }
        }
    }

    protected void zzaT() {
        zzin.zzaJ("Ad finished loading.");
        this.zzph = false;
        if (this.zzpj.zzru != null) {
            try {
                this.zzpj.zzru.onAdLoaded();
            }
            catch (RemoteException remoteException) {
                zzin.zzd("Could not call AdListener.onAdLoaded().", remoteException);
            }
        }
        if (this.zzpj.zzrF != null) {
            try {
                this.zzpj.zzrF.onRewardedVideoAdLoaded();
            }
            catch (RemoteException remoteException) {
                zzin.zzd("Could not call RewardedVideoAdListener.onRewardedVideoAdLoaded().", remoteException);
            }
        }
    }

    protected void zzf(int n) {
        zzin.zzaK("Failed to load ad: " + n);
        this.zzph = false;
        if (this.zzpj.zzru != null) {
            try {
                this.zzpj.zzru.onAdFailedToLoad(n);
            }
            catch (RemoteException remoteException) {
                zzin.zzd("Could not call AdListener.onAdFailedToLoad().", remoteException);
            }
        }
        if (this.zzpj.zzrF != null) {
            try {
                this.zzpj.zzrF.onRewardedVideoAdFailedToLoad(n);
            }
            catch (RemoteException remoteException) {
                zzin.zzd("Could not call RewardedVideoAdListener.onRewardedVideoAdFailedToLoad().", remoteException);
            }
        }
    }

    protected void zzaU() {
        if (this.zzpj.zzrF == null) {
            return;
        }
        try {
            this.zzpj.zzrF.onRewardedVideoStarted();
        }
        catch (RemoteException remoteException) {
            zzin.zzd("Could not call RewardedVideoAdListener.onVideoStarted().", remoteException);
        }
    }

    protected void zza(RewardItemParcel rewardItemParcel) {
        if (this.zzpj.zzrF == null) {
            return;
        }
        try {
            String string2 = "";
            int n = 0;
            if (rewardItemParcel != null) {
                string2 = rewardItemParcel.type;
                n = rewardItemParcel.zzKS;
            }
            this.zzpj.zzrF.zza(new zzhr(string2, n));
        }
        catch (RemoteException remoteException) {
            zzin.zzd("Could not call RewardedVideoAdListener.onRewarded().", remoteException);
        }
    }

    protected void zzc(zzif zzif2) {
        if (zzif2 == null) {
            zzin.zzaK("Ad state was null when trying to ping impression URLs.");
            return;
        }
        zzin.zzaI("Pinging Impression URLs.");
        this.zzpj.zzrs.zzgS();
        if (zzif2.zzBR != null && !zzif2.zzLb) {
            zzr.zzbC().zza(this.zzpj.context, this.zzpj.zzrl.afmaVersion, zzif2.zzBR);
            zzif2.zzLb = true;
        }
    }

    @Override
    public void zza(HashSet<zzig> hashSet) {
        this.zzpj.zza(hashSet);
    }
}

