/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.Messenger;
import android.os.RemoteException;
import android.view.View;
import com.google.android.gms.ads.internal.client.AdRequestParcel;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.zzn;
import com.google.android.gms.ads.internal.overlay.zzg;
import com.google.android.gms.ads.internal.purchase.GInAppPurchaseManagerInfoParcel;
import com.google.android.gms.ads.internal.purchase.zzc;
import com.google.android.gms.ads.internal.purchase.zzf;
import com.google.android.gms.ads.internal.purchase.zzj;
import com.google.android.gms.ads.internal.purchase.zzk;
import com.google.android.gms.ads.internal.request.AdRequestInfoParcel;
import com.google.android.gms.ads.internal.request.CapabilityParcel;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.zza;
import com.google.android.gms.ads.internal.zzd;
import com.google.android.gms.ads.internal.zzq;
import com.google.android.gms.ads.internal.zzr;
import com.google.android.gms.ads.internal.zzs;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzbt;
import com.google.android.gms.internal.zzcb;
import com.google.android.gms.internal.zzdh;
import com.google.android.gms.internal.zzep;
import com.google.android.gms.internal.zzex;
import com.google.android.gms.internal.zzga;
import com.google.android.gms.internal.zzgd;
import com.google.android.gms.internal.zzgh;
import com.google.android.gms.internal.zzhb;
import com.google.android.gms.internal.zzif;
import com.google.android.gms.internal.zzig;
import com.google.android.gms.internal.zzin;
import com.google.android.gms.internal.zzir;
import java.util.ArrayList;
import java.util.UUID;

@zzhb
public abstract class zzb
extends zza
implements zzg,
zzj,
zzdh,
zzep {
    protected final zzex zzpn;
    private final Messenger mMessenger;
    protected transient boolean zzpo;

    public zzb(Context context, AdSizeParcel adSizeParcel, String string2, zzex zzex2, VersionInfoParcel versionInfoParcel, zzd zzd2) {
        this(new zzs(context, adSizeParcel, string2, versionInfoParcel), zzex2, null, zzd2);
    }

    zzb(zzs zzs2, zzex zzex2, zzq zzq2, zzd zzd2) {
        super(zzs2, zzq2, zzd2);
        this.zzpn = zzex2;
        this.mMessenger = new Messenger((Handler)new zzga(this.zzpj.context));
        this.zzpo = false;
    }

    @Override
    public boolean zza(AdRequestParcel adRequestParcel, zzcb zzcb2) {
        if (!this.zzaV()) {
            return false;
        }
        Bundle bundle = null;
        bundle = this.zza(zzr.zzbF().zzG(this.zzpj.context));
        this.zzpi.cancel();
        this.zzpj.zzrL = 0;
        AdRequestInfoParcel.zza zza2 = this.zza(adRequestParcel, bundle);
        zzcb2.zzc("seq_num", zza2.zzHw);
        zzcb2.zzc("request_id", zza2.zzHI);
        zzcb2.zzc("session_id", zza2.zzHx);
        if (zza2.zzHu != null) {
            zzcb2.zzc("app_version", String.valueOf(zza2.zzHu.versionCode));
        }
        this.zzpj.zzrn = zzr.zzby().zza(this.zzpj.context, zza2, this.zzpj.zzrk, this);
        return true;
    }

    @Override
    public void zzb(zzif zzif2) {
        super.zzb(zzif2);
        if (zzif2.errorCode == 3 && zzif2.zzKV != null && zzif2.zzKV.zzBS != null) {
            zzin.zzaI("Pinging no fill URLs.");
            zzr.zzbP().zza(this.zzpj.context, this.zzpj.zzrl.afmaVersion, zzif2, this.zzpj.zzrj, false, zzif2.zzKV.zzBS);
        }
    }

    @Override
    protected boolean zza(zzif zzif2, zzif zzif3) {
        if (zzif2 != null && zzif2.zzCs != null) {
            zzif2.zzCs.zza((zzep)null);
        }
        if (zzif3.zzCs != null) {
            zzif3.zzCs.zza(this);
        }
        int n = 0;
        int n2 = 0;
        if (zzif3.zzKV != null) {
            n = zzif3.zzKV.zzBZ;
            n2 = zzif3.zzKV.zzCa;
        }
        this.zzpj.zzrJ.zzg(n, n2);
        return true;
    }

    @Override
    public void onAdClicked() {
        if (this.zzpj.zzrq == null) {
            zzin.zzaK("Ad state was null when trying to ping click URLs.");
            return;
        }
        if (this.zzpj.zzrq.zzKV != null && this.zzpj.zzrq.zzKV.zzBQ != null) {
            zzr.zzbP().zza(this.zzpj.context, this.zzpj.zzrl.afmaVersion, this.zzpj.zzrq, this.zzpj.zzrj, false, this.zzpj.zzrq.zzKV.zzBQ);
        }
        if (this.zzpj.zzrq.zzCp != null && this.zzpj.zzrq.zzCp.zzBE != null) {
            zzr.zzbP().zza(this.zzpj.context, this.zzpj.zzrl.afmaVersion, this.zzpj.zzrq, this.zzpj.zzrj, false, this.zzpj.zzrq.zzCp.zzBE);
        }
        super.onAdClicked();
    }

    @Override
    boolean zza(zzif zzif2) {
        AdRequestParcel adRequestParcel;
        boolean bl = false;
        if (this.zzpk != null) {
            adRequestParcel = this.zzpk;
            this.zzpk = null;
        } else {
            adRequestParcel = zzif2.zzHt;
            bl = adRequestParcel.extras != null ? adRequestParcel.extras.getBoolean("_noRefresh", false) : false;
        }
        return this.zza(adRequestParcel, zzif2, bl);
    }

    protected boolean zza(AdRequestParcel adRequestParcel, zzif zzif2, boolean bl) {
        if (!bl && this.zzpj.zzbW()) {
            if (zzif2.zzBU > 0L) {
                this.zzpi.zza(adRequestParcel, zzif2.zzBU);
            } else if (zzif2.zzKV != null && zzif2.zzKV.zzBU > 0L) {
                this.zzpi.zza(adRequestParcel, zzif2.zzKV.zzBU);
            } else if (!zzif2.zzHT && zzif2.errorCode == 2) {
                this.zzpi.zzg(adRequestParcel);
            }
        }
        return this.zzpi.zzbw();
    }

    @Override
    public void pause() {
        zzx.zzcD((String)"pause must be called on the main UI thread.");
        if (this.zzpj.zzrq != null && this.zzpj.zzrq.zzED != null && this.zzpj.zzbW()) {
            zzr.zzbE().zzi(this.zzpj.zzrq.zzED);
        }
        if (this.zzpj.zzrq != null && this.zzpj.zzrq.zzCq != null) {
            try {
                this.zzpj.zzrq.zzCq.pause();
            }
            catch (RemoteException remoteException) {
                zzin.zzaK("Could not pause mediation adapter.");
            }
        }
        this.zzpl.zzk(this.zzpj.zzrq);
        this.zzpi.pause();
    }

    @Override
    public void resume() {
        zzx.zzcD((String)"resume must be called on the main UI thread.");
        if (this.zzpj.zzrq != null && this.zzpj.zzrq.zzED != null && this.zzpj.zzbW()) {
            zzr.zzbE().zzj(this.zzpj.zzrq.zzED);
        }
        if (this.zzpj.zzrq != null && this.zzpj.zzrq.zzCq != null) {
            try {
                this.zzpj.zzrq.zzCq.resume();
            }
            catch (RemoteException remoteException) {
                zzin.zzaK("Could not resume mediation adapter.");
            }
        }
        this.zzpi.resume();
        this.zzpl.zzl(this.zzpj.zzrq);
    }

    @Override
    protected boolean zzc(AdRequestParcel adRequestParcel) {
        return super.zzc(adRequestParcel) && !this.zzpo;
    }

    protected boolean zzaV() {
        boolean bl = true;
        if (!zzr.zzbC().zza(this.zzpj.context.getPackageManager(), this.zzpj.context.getPackageName(), "android.permission.INTERNET") || !zzr.zzbC().zzI(this.zzpj.context)) {
            bl = false;
        }
        return bl;
    }

    @Override
    public void zzaW() {
        this.zzpl.zzi(this.zzpj.zzrq);
        this.zzpo = false;
        this.zzaQ();
        this.zzpj.zzrs.zzgU();
    }

    @Override
    public void zzaX() {
        this.zzpo = true;
        this.zzaS();
    }

    @Override
    public void onPause() {
        this.zzpl.zzk(this.zzpj.zzrq);
    }

    @Override
    public void onResume() {
        this.zzpl.zzl(this.zzpj.zzrq);
    }

    @Override
    public void zzaY() {
        this.onAdClicked();
    }

    @Override
    public void zzaZ() {
        this.zzaW();
    }

    @Override
    public void zzba() {
        this.zzaO();
    }

    @Override
    public void zzbb() {
        this.zzaX();
    }

    @Override
    public void zzbc() {
        if (this.zzpj.zzrq != null) {
            zzin.zzaK("Mediation adapter " + this.zzpj.zzrq.zzCr + " refreshed, but mediation adapters should never refresh.");
        }
        this.zza(this.zzpj.zzrq, true);
        this.zzaT();
    }

    private AdRequestInfoParcel.zza zza(AdRequestParcel adRequestParcel, Bundle bundle) {
        int n;
        Object object;
        PackageInfo packageInfo;
        PackageManager packageManager;
        ApplicationInfo applicationInfo = this.zzpj.context.getApplicationInfo();
        try {
            packageManager = this.zzpj.context.getPackageManager();
            packageInfo = packageManager.getPackageInfo(applicationInfo.packageName, 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            packageInfo = null;
        }
        packageManager = this.zzpj.context.getResources().getDisplayMetrics();
        Bundle bundle2 = null;
        if (this.zzpj.zzrm != null && this.zzpj.zzrm.getParent() != null) {
            object = new int[2];
            this.zzpj.zzrm.getLocationOnScreen((int[])object);
            Object object2 = object[0];
            Object object3 = object[1];
            int n2 = this.zzpj.zzrm.getWidth();
            int n3 = this.zzpj.zzrm.getHeight();
            int n4 = 0;
            if (this.zzpj.zzrm.isShown() && object2 + n2 > 0 && object3 + n3 > 0 && object2 <= packageManager.widthPixels && object3 <= packageManager.heightPixels) {
                n4 = 1;
            }
            bundle2 = new Bundle(5);
            bundle2.putInt("x", (int)object2);
            bundle2.putInt("y", (int)object3);
            bundle2.putInt("width", n2);
            bundle2.putInt("height", n3);
            bundle2.putInt("visible", n4);
        }
        object = zzr.zzbF().zzgZ();
        this.zzpj.zzrs = new zzig((String)object, this.zzpj.zzrj);
        this.zzpj.zzrs.zzk(adRequestParcel);
        String string2 = zzr.zzbC().zza(this.zzpj.context, (View)this.zzpj.zzrm, this.zzpj.zzrp);
        long l = 0L;
        if (this.zzpj.zzrw != null) {
            try {
                l = this.zzpj.zzrw.getValue();
            }
            catch (RemoteException remoteException) {
                zzin.zzaK("Cannot get correlation id, default to 0.");
            }
        }
        String string3 = UUID.randomUUID().toString();
        Bundle bundle3 = zzr.zzbF().zza(this.zzpj.context, this, (String)object);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n = 0; n < this.zzpj.zzrC.size(); n += 1) {
            arrayList.add((String)this.zzpj.zzrC.keyAt(n));
        }
        n = this.zzpj.zzrx != null ? 1 : 0;
        boolean bl = this.zzpj.zzry != null && zzr.zzbF().zzhj();
        boolean bl2 = this.zzpm.zzpy.zzfM();
        return new AdRequestInfoParcel.zza(bundle2, adRequestParcel, this.zzpj.zzrp, this.zzpj.zzrj, applicationInfo, packageInfo, (String)object, zzr.zzbF().getSessionId(), this.zzpj.zzrl, bundle3, this.zzpj.zzrH, arrayList, bundle, zzr.zzbF().zzhd(), this.mMessenger, packageManager.widthPixels, packageManager.heightPixels, packageManager.density, string2, l, string3, zzbt.zzdr(), this.zzpj.zzri, this.zzpj.zzrD, new CapabilityParcel(n != 0, bl, bl2), this.zzpj.zzca(), zzr.zzbC().zzbt(), zzr.zzbC().zzR(this.zzpj.context), zzr.zzbC().zzl((View)this.zzpj.zzrm));
    }

    @Override
    public void zza(zzgd zzgd2) {
        zzx.zzcD((String)"setInAppPurchaseListener must be called on the main UI thread.");
        this.zzpj.zzrx = zzgd2;
    }

    @Override
    public void zza(zzgh zzgh2, String string2) {
        zzx.zzcD((String)"setPlayStorePurchaseParams must be called on the main UI thread.");
        this.zzpj.zzrI = new zzk(string2);
        this.zzpj.zzry = zzgh2;
        if (!zzr.zzbF().zzhc() && zzgh2 != null) {
            new zzc(this.zzpj.context, this.zzpj.zzry, this.zzpj.zzrI).zzhn();
        }
    }

    @Override
    public void zza(String string2, ArrayList<String> arrayList) {
        com.google.android.gms.ads.internal.purchase.zzd zzd2 = new com.google.android.gms.ads.internal.purchase.zzd(string2, arrayList, this.zzpj.context, this.zzpj.zzrl.afmaVersion);
        if (this.zzpj.zzrx == null) {
            zzin.zzaK("InAppPurchaseListener is not set. Try to launch default purchase flow.");
            if (!zzn.zzcS().zzU(this.zzpj.context)) {
                zzin.zzaK("Google Play Service unavailable, cannot launch default purchase flow.");
                return;
            }
            if (this.zzpj.zzry == null) {
                zzin.zzaK("PlayStorePurchaseListener is not set.");
                return;
            }
            if (this.zzpj.zzrI == null) {
                zzin.zzaK("PlayStorePurchaseVerifier is not initialized.");
                return;
            }
            if (this.zzpj.zzrM) {
                zzin.zzaK("An in-app purchase request is already in progress, abort");
                return;
            }
            this.zzpj.zzrM = true;
            try {
                if (!this.zzpj.zzry.isValidPurchase(string2)) {
                    this.zzpj.zzrM = false;
                    return;
                }
            }
            catch (RemoteException remoteException) {
                zzin.zzaK("Could not start In-App purchase.");
                this.zzpj.zzrM = false;
                return;
            }
            zzr.zzbM().zza(this.zzpj.context, this.zzpj.zzrl.zzNb, new GInAppPurchaseManagerInfoParcel(this.zzpj.context, this.zzpj.zzrI, zzd2, this));
        } else {
            try {
                this.zzpj.zzrx.zza(zzd2);
            }
            catch (RemoteException remoteException) {
                zzin.zzaK("Could not start In-App purchase.");
            }
        }
    }

    @Override
    public void zza(String string2, boolean bl, int n, final Intent intent, zzf zzf2) {
        try {
            if (this.zzpj.zzry != null) {
                this.zzpj.zzry.zza(new com.google.android.gms.ads.internal.purchase.zzg(this.zzpj.context, string2, bl, n, intent, zzf2));
            }
        }
        catch (RemoteException remoteException) {
            zzin.zzaK("Fail to invoke PlayStorePurchaseListener.");
        }
        zzir.zzMc.postDelayed(new Runnable(){

            @Override
            public void run() {
                int n = zzr.zzbM().zzd(intent);
                zzr.zzbM();
                if (n == 0 && zzb.this.zzpj.zzrq != null && zzb.this.zzpj.zzrq.zzED != null && zzb.this.zzpj.zzrq.zzED.zzhS() != null) {
                    zzb.this.zzpj.zzrq.zzED.zzhS().close();
                }
                zzb.this.zzpj.zzrM = false;
            }
        }, 500L);
    }

    public void recordImpression() {
        this.zza(this.zzpj.zzrq, false);
    }

    protected void zza(zzif zzif2, boolean bl) {
        if (zzif2 == null) {
            zzin.zzaK("Ad state was null when trying to ping impression URLs.");
            return;
        }
        super.zzc(zzif2);
        if (zzif2.zzKV != null && zzif2.zzKV.zzBR != null) {
            zzr.zzbP().zza(this.zzpj.context, this.zzpj.zzrl.afmaVersion, zzif2, this.zzpj.zzrj, bl, zzif2.zzKV.zzBR);
        }
        if (zzif2.zzCp != null && zzif2.zzCp.zzBF != null) {
            zzr.zzbP().zza(this.zzpj.context, this.zzpj.zzrl.afmaVersion, zzif2, this.zzpj.zzrj, bl, zzif2.zzCp.zzBF);
        }
    }

    @Override
    public String getMediationAdapterClassName() {
        if (this.zzpj.zzrq == null) {
            return null;
        }
        return this.zzpj.zzrq.zzCr;
    }

    @Override
    public void showInterstitial() {
        throw new IllegalStateException("showInterstitial is not supported for current ad type");
    }
}

