/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.RemoteException;
import android.view.Window;
import com.google.android.gms.ads.internal.InterstitialAdParameterParcel;
import com.google.android.gms.ads.internal.client.AdRequestParcel;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.overlay.AdOverlayInfoParcel;
import com.google.android.gms.ads.internal.reward.mediation.client.RewardItemParcel;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.zzc;
import com.google.android.gms.ads.internal.zzd;
import com.google.android.gms.ads.internal.zze;
import com.google.android.gms.ads.internal.zzr;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzbt;
import com.google.android.gms.internal.zzcb;
import com.google.android.gms.internal.zzdj;
import com.google.android.gms.internal.zzdn;
import com.google.android.gms.internal.zzex;
import com.google.android.gms.internal.zzhb;
import com.google.android.gms.internal.zzif;
import com.google.android.gms.internal.zzim;
import com.google.android.gms.internal.zzin;
import com.google.android.gms.internal.zzir;
import com.google.android.gms.internal.zzjp;

@zzhb
public class zzk
extends zzc
implements zzdj,
zzdn.zza {
    protected transient boolean zzqc = false;
    private boolean zzqd;
    private float zzqe;
    private String zzqf = "background" + this.hashCode() + "." + "png";

    public zzk(Context context, AdSizeParcel adSizeParcel, String string2, zzex zzex2, VersionInfoParcel versionInfoParcel, zzd zzd2) {
        super(context, adSizeParcel, string2, zzex2, versionInfoParcel, zzd2);
    }

    @Override
    public boolean zza(AdRequestParcel adRequestParcel, zzcb zzcb2) {
        if (this.zzpj.zzrq != null) {
            zzin.zzaK("An interstitial is already loading. Aborting.");
            return false;
        }
        return super.zza(adRequestParcel, zzcb2);
    }

    @Override
    protected zzjp zza(zzif.zza zza2, zze zze2) {
        zzjp zzjp2 = zzr.zzbD().zza(this.zzpj.context, this.zzpj.zzrp, false, false, this.zzpj.zzrk, this.zzpj.zzrl, this.zzpe, this.zzpm);
        zzjp2.zzhU().zzb(this, null, this, this, zzbt.zzwv.get(), this, this, zze2, null);
        this.zza(zzjp2);
        zzjp2.zzaM(zza2.zzLd.zzHI);
        zzdn.zza(zzjp2, this);
        return zzjp2;
    }

    @Override
    protected boolean zza(AdRequestParcel adRequestParcel, zzif zzif2, boolean bl) {
        if (this.zzpj.zzbW() && zzif2.zzED != null) {
            zzr.zzbE().zzi(zzif2.zzED);
        }
        return this.zzpi.zzbw();
    }

    @Override
    public boolean zza(zzif zzif2, zzif zzif3) {
        if (!super.zza(zzif2, zzif3)) {
            return false;
        }
        if (!this.zzpj.zzbW() && this.zzpj.zzrK != null && zzif3.zzKT != null) {
            this.zzpl.zza(this.zzpj.zzrp, zzif3, this.zzpj.zzrK);
        }
        return true;
    }

    @Override
    public void zzaX() {
        this.recordImpression();
        super.zzaX();
    }

    @Override
    protected void zzaQ() {
        this.zzbp();
        super.zzaQ();
    }

    @Override
    public void zzd(boolean bl) {
        this.zzpj.zzql = bl;
    }

    @Override
    public void zza(boolean bl, float f) {
        this.zzqd = bl;
        this.zzqe = f;
    }

    @Override
    public void showInterstitial() {
        Object object;
        String string2;
        zzx.zzcD((String)"showInterstitial must be called on the main UI thread.");
        if (this.zzpj.zzrq == null) {
            zzin.zzaK("The interstitial has not loaded.");
            return;
        }
        if (zzbt.zzwN.get().booleanValue()) {
            String string3 = string2 = this.zzpj.context.getApplicationContext() != null ? this.zzpj.context.getApplicationContext().getPackageName() : this.zzpj.context.getPackageName();
            if (!this.zzqc) {
                zzin.zzaK("It is not recommended to show an interstitial before onAdLoaded completes.");
                object = new Bundle();
                object.putString("appid", string2);
                object.putString("action", "show_interstitial_before_load_finish");
                this.zzb((Bundle)object);
            }
            if (!zzr.zzbC().zzO(this.zzpj.context)) {
                zzin.zzaK("It is not recommended to show an interstitial when app is not in foreground.");
                object = new Bundle();
                object.putString("appid", string2);
                object.putString("action", "show_interstitial_app_not_in_foreground");
                this.zzb((Bundle)object);
            }
        }
        if (this.zzpj.zzbX()) {
            return;
        }
        if (this.zzpj.zzrq.zzHT) {
            try {
                this.zzpj.zzrq.zzCq.showInterstitial();
            }
            catch (RemoteException remoteException) {
                zzin.zzd("Could not show interstitial.", remoteException);
                this.zzbp();
            }
        } else {
            if (this.zzpj.zzrq.zzED == null) {
                zzin.zzaK("The interstitial failed to load.");
                return;
            }
            if (this.zzpj.zzrq.zzED.zzhY()) {
                zzin.zzaK("The interstitial is already showing.");
                return;
            }
            this.zzpj.zzrq.zzED.zzD(true);
            if (this.zzpj.zzrq.zzKT != null) {
                this.zzpl.zza(this.zzpj.zzrp, this.zzpj.zzrq);
            }
            Object object2 = string2 = this.zzpj.zzql ? zzr.zzbC().zzP(this.zzpj.context) : null;
            if (zzbt.zzxe.get().booleanValue() && string2 != null) {
                new zzb((Bitmap)string2, this.zzqf).zzhn();
            } else {
                object = new InterstitialAdParameterParcel(this.zzpj.zzql, this.zzbo(), null, false, 0.0f);
                int n = this.zzpj.zzrq.zzED.getRequestedOrientation();
                if (n == -1) {
                    n = this.zzpj.zzrq.orientation;
                }
                AdOverlayInfoParcel adOverlayInfoParcel = new AdOverlayInfoParcel(this, this, this, this.zzpj.zzrq.zzED, n, this.zzpj.zzrl, this.zzpj.zzrq.zzHY, (InterstitialAdParameterParcel)object);
                zzr.zzbA().zza(this.zzpj.context, adOverlayInfoParcel);
            }
        }
    }

    private void zzb(Bundle bundle) {
        zzr.zzbC().zzb(this.zzpj.context, this.zzpj.zzrl.afmaVersion, "gmob-apps", bundle, false);
    }

    protected boolean zzbo() {
        if (!(this.zzpj.context instanceof Activity)) {
            return false;
        }
        Window window = ((Activity)this.zzpj.context).getWindow();
        if (window == null || window.getDecorView() == null) {
            return false;
        }
        Rect rect = new Rect();
        Rect rect2 = new Rect();
        window.getDecorView().getGlobalVisibleRect(rect, null);
        window.getDecorView().getWindowVisibleDisplayFrame(rect2);
        return rect.bottom != 0 && rect2.bottom != 0 && rect.top == rect2.top;
    }

    @Override
    protected void zzaT() {
        super.zzaT();
        this.zzqc = true;
    }

    public void zzbp() {
        new zza(this.zzqf).zzhn();
        if (this.zzpj.zzbW()) {
            this.zzpj.zzbT();
            this.zzpj.zzrq = null;
            this.zzpj.zzql = false;
            this.zzqc = false;
        }
    }

    @Override
    public void zzbq() {
        if (this.zzpj.zzrq != null && this.zzpj.zzrq.zzKX != null) {
            zzr.zzbC().zza(this.zzpj.context, this.zzpj.zzrl.afmaVersion, this.zzpj.zzrq.zzKX);
        }
        this.zzaU();
    }

    @Override
    public void zzb(RewardItemParcel rewardItemParcel) {
        if (this.zzpj.zzrq != null) {
            if (this.zzpj.zzrq.zzIl != null) {
                zzr.zzbC().zza(this.zzpj.context, this.zzpj.zzrl.afmaVersion, this.zzpj.zzrq.zzIl);
            }
            if (this.zzpj.zzrq.zzIj != null) {
                rewardItemParcel = this.zzpj.zzrq.zzIj;
            }
        }
        this.zza(rewardItemParcel);
    }

    @zzhb
    private class zza
    extends zzim {
        private final String zzqg;

        public zza(String string2) {
            this.zzqg = string2;
        }

        @Override
        public void zzbr() {
            zzr.zzbC().zzg(zzk.this.zzpj.context, this.zzqg);
        }

        @Override
        public void onStop() {
        }
    }

    @zzhb
    private class zzb
    extends zzim {
        private final Bitmap zzqi;
        private final String zzqg;

        public zzb(Bitmap bitmap, String string2) {
            this.zzqi = bitmap;
            this.zzqg = string2;
        }

        @Override
        public void zzbr() {
            boolean bl = zzk.this.zzpj.zzql ? zzr.zzbC().zza(zzk.this.zzpj.context, this.zzqi, this.zzqg) : false;
            InterstitialAdParameterParcel interstitialAdParameterParcel = new InterstitialAdParameterParcel(zzk.this.zzpj.zzql, zzk.this.zzbo(), bl ? this.zzqg : null, zzk.this.zzqd, zzk.this.zzqe);
            int n = zzk.this.zzpj.zzrq.zzED.getRequestedOrientation();
            if (n == -1) {
                n = zzk.this.zzpj.zzrq.orientation;
            }
            final AdOverlayInfoParcel adOverlayInfoParcel = new AdOverlayInfoParcel(zzk.this, zzk.this, zzk.this, zzk.this.zzpj.zzrq.zzED, n, zzk.this.zzpj.zzrl, zzk.this.zzpj.zzrq.zzHY, interstitialAdParameterParcel);
            zzir.zzMc.post(new Runnable(){

                @Override
                public void run() {
                    zzr.zzbA().zza(zzk.this.zzpj.context, adOverlayInfoParcel);
                }
            });
        }

        @Override
        public void onStop() {
        }
    }
}

