/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.graphics.Color;
import android.os.SystemClock;
import android.text.TextUtils;
import android.view.MotionEvent;
import com.google.android.gms.ads.internal.client.zzn;
import com.google.android.gms.ads.internal.overlay.zzk;
import com.google.android.gms.internal.zzdf;
import com.google.android.gms.internal.zzhb;
import com.google.android.gms.internal.zzin;
import com.google.android.gms.internal.zzjo;
import com.google.android.gms.internal.zzjp;
import java.util.Map;
import java.util.WeakHashMap;
import org.json.JSONObject;

@zzhb
public final class zzdo
implements zzdf {
    private final Map<zzjp, Integer> zzzI = new WeakHashMap<zzjp, Integer>();

    private static int zza(Context context, Map<String, String> map, String string2, int n) {
        String string3 = map.get(string2);
        int n2 = n;
        if (string3 != null) {
            try {
                n2 = zzn.zzcS().zzb(context, Integer.parseInt(string3));
            }
            catch (NumberFormatException numberFormatException) {
                zzin.zzaK("Could not parse " + string2 + " in a video GMSG: " + string3);
            }
        }
        return n2;
    }

    @Override
    public void zza(zzjp zzjp2, Map<String, String> map) {
        Object object;
        String string2 = map.get("action");
        if (string2 == null) {
            zzin.zzaK("Action missing from video GMSG.");
            return;
        }
        if (zzin.zzQ(3)) {
            object = new JSONObject(map);
            object.remove("google.afma.Notify_dt");
            zzin.zzaI("Video GMSG: " + string2 + " " + object.toString());
        }
        if ("background".equals(string2)) {
            object = map.get("color");
            if (TextUtils.isEmpty((CharSequence)object)) {
                zzin.zzaK("Color parameter missing from color video GMSG.");
                return;
            }
            try {
                zzk zzk2;
                int n = Color.parseColor((String)object);
                zzjo zzjo2 = zzjp2.zzia();
                if (zzjo2 != null && (zzk2 = zzjo2.zzhM()) != null) {
                    zzk2.setBackgroundColor(n);
                    return;
                }
                this.zzzI.put(zzjp2, n);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                zzin.zzaK("Invalid color parameter in video GMSG.");
            }
            return;
        }
        object = zzjp2.zzia();
        if (object == null) {
            zzin.zzaK("Could not get underlay container for a video GMSG.");
            return;
        }
        boolean bl = "new".equals(string2);
        boolean bl2 = "position".equals(string2);
        if (bl || bl2) {
            int n;
            Context context = zzjp2.getContext();
            int n2 = zzdo.zza(context, map, "x", 0);
            int n3 = zzdo.zza(context, map, "y", 0);
            int n4 = zzdo.zza(context, map, "w", -1);
            int n5 = zzdo.zza(context, map, "h", -1);
            try {
                n = Integer.parseInt(map.get("player"));
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
            if (bl && ((zzjo)object).zzhM() == null) {
                ((zzjo)object).zza(n2, n3, n4, n5, n);
                if (this.zzzI.containsKey(zzjp2)) {
                    int n6 = this.zzzI.get(zzjp2);
                    zzk zzk3 = ((zzjo)object).zzhM();
                    zzk3.setBackgroundColor(n6);
                    zzk3.zzfE();
                }
            } else {
                ((zzjo)object).zze(n2, n3, n4, n5);
            }
        } else {
            zzk zzk4 = ((zzjo)object).zzhM();
            if (zzk4 == null) {
                zzk.zzg(zzjp2);
                return;
            }
            if ("click".equals(string2)) {
                Context context = zzjp2.getContext();
                int n = zzdo.zza(context, map, "x", 0);
                int n7 = zzdo.zza(context, map, "y", 0);
                long l = SystemClock.uptimeMillis();
                MotionEvent motionEvent = MotionEvent.obtain((long)l, (long)l, (int)0, (float)n, (float)n7, (int)0);
                zzk4.zzd(motionEvent);
                motionEvent.recycle();
            } else if ("currentTime".equals(string2)) {
                String string3 = map.get("time");
                if (string3 == null) {
                    zzin.zzaK("Time parameter missing from currentTime video GMSG.");
                    return;
                }
                try {
                    float f = Float.parseFloat(string3);
                    int n = (int)(f * 1000.0f);
                    zzk4.seekTo(n);
                }
                catch (NumberFormatException numberFormatException) {
                    zzin.zzaK("Could not parse time parameter from currentTime video GMSG: " + string3);
                }
            } else if ("hide".equals(string2)) {
                zzk4.setVisibility(4);
            } else if ("load".equals(string2)) {
                zzk4.zzfD();
            } else if ("mimetype".equals(string2)) {
                zzk4.setMimeType(map.get("mimetype"));
            } else if ("muted".equals(string2)) {
                boolean bl3 = Boolean.parseBoolean(map.get("muted"));
                if (bl3) {
                    zzk4.zzff();
                } else {
                    zzk4.zzfg();
                }
            } else if ("pause".equals(string2)) {
                zzk4.pause();
            } else if ("play".equals(string2)) {
                zzk4.play();
            } else if ("show".equals(string2)) {
                zzk4.setVisibility(0);
            } else if ("src".equals(string2)) {
                zzk4.zzap(map.get("src"));
            } else if ("volume".equals(string2)) {
                String string4 = map.get("volume");
                if (string4 == null) {
                    zzin.zzaK("Level parameter missing from volume video GMSG.");
                    return;
                }
                try {
                    float f = Float.parseFloat(string4);
                    zzk4.zza(f);
                }
                catch (NumberFormatException numberFormatException) {
                    zzin.zzaK("Could not parse volume parameter from volume video GMSG: " + string4);
                }
            } else if ("watermark".equals(string2)) {
                zzk4.zzfE();
            } else {
                zzin.zzaK("Unknown video action: " + string2);
            }
        }
    }
}

