/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.MutableContextWrapper;
import android.content.SharedPreferences;
import android.util.Base64;
import com.google.android.gms.ads.internal.client.AdRequestParcel;
import com.google.android.gms.ads.internal.zzr;
import com.google.android.gms.internal.zzbt;
import com.google.android.gms.internal.zzdv;
import com.google.android.gms.internal.zzdz;
import com.google.android.gms.internal.zzea;
import com.google.android.gms.internal.zzec;
import com.google.android.gms.internal.zzhb;
import com.google.android.gms.internal.zzhj;
import com.google.android.gms.internal.zzin;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

@zzhb
public class zzdy {
    private final Map<zzdz, zzea> zzAx = new HashMap<zzdz, zzea>();
    private final LinkedList<zzdz> zzAy = new LinkedList();
    private zzdv zzAz;

    void zza(zzdv zzdv2) {
        if (this.zzAz == null) {
            this.zzAz = zzdv2;
            this.restore();
        }
    }

    zzea.zza zza(AdRequestParcel adRequestParcel, String string2) {
        Object object;
        MutableContextWrapper mutableContextWrapper = this.zzAz.zzed();
        zzhj zzhj2 = new zzhj.zza((Context)mutableContextWrapper).zzgI();
        int n = zzhj2.zzKc;
        zzdz zzdz2 = new zzdz(adRequestParcel, string2, n);
        zzea zzea2 = this.zzAx.get(zzdz2);
        if (zzea2 == null) {
            zzdy.zza("Interstitial pool created at %s.", zzdz2);
            zzea2 = new zzea(adRequestParcel, string2, n);
            this.zzAx.put(zzdz2, zzea2);
        }
        this.zzAy.remove(zzdz2);
        this.zzAy.add(zzdz2);
        zzdz2.zzeg();
        while (this.zzAy.size() > zzbt.zzwG.get()) {
            object = this.zzAy.remove();
            zzea zzea3 = this.zzAx.get(object);
            zzdy.zza("Evicting interstitial queue for %s.", (zzdz)object);
            while (zzea3.size() > 0) {
                zzea.zza zza2 = zzea3.zzej();
                zza2.zzAD.zzbp();
            }
            this.zzAx.remove(object);
        }
        while (zzea2.size() > 0) {
            long l;
            object = zzea2.zzej();
            if (((zzea.zza)object).zzAG && (l = zzr.zzbG().currentTimeMillis() - ((zzea.zza)object).zzAF) > 1000L * (long)zzbt.zzwI.get().intValue()) {
                zzdy.zza("Expired interstitial at %s.", zzdz2);
                continue;
            }
            zzdy.zza("Pooled interstitial returned at %s.", zzdz2);
            return object;
        }
        return null;
    }

    void zzee() {
        if (this.zzAz == null) {
            return;
        }
        for (Map.Entry<zzdz, zzea> entry : this.zzAx.entrySet()) {
            zzdz zzdz2 = entry.getKey();
            zzea zzea2 = entry.getValue();
            while (zzea2.size() < zzbt.zzwH.get()) {
                zzdy.zza("Pooling one interstitial for %s.", zzdz2);
                zzea2.zzb(this.zzAz);
            }
        }
        this.save();
    }

    void save() {
        if (this.zzAz == null) {
            return;
        }
        MutableContextWrapper mutableContextWrapper = this.zzAz.zzed();
        SharedPreferences sharedPreferences = mutableContextWrapper.getSharedPreferences("com.google.android.gms.ads.internal.interstitial.InterstitialAdPool", 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.clear();
        for (Map.Entry<zzdz, zzea> entry : this.zzAx.entrySet()) {
            zzdz zzdz2 = entry.getKey();
            if (!zzdz2.zzeh()) continue;
            zzea zzea2 = entry.getValue();
            zzec zzec2 = new zzec(zzea2);
            String string2 = zzec2.zzem();
            String string3 = zzdz2.toString();
            editor.putString(string3, string2);
            zzdy.zza("Saved interstitial queue for %s.", zzdz2);
        }
        editor.putString("PoolKeys", this.zzef());
        editor.commit();
    }

    void restore() {
        zzdz zzdz2;
        if (this.zzAz == null) {
            return;
        }
        MutableContextWrapper mutableContextWrapper = this.zzAz.zzed();
        SharedPreferences sharedPreferences = mutableContextWrapper.getSharedPreferences("com.google.android.gms.ads.internal.interstitial.InterstitialAdPool", 0);
        this.flush();
        HashMap<String, zzdz> hashMap = new HashMap<String, zzdz>();
        String[] stringArray = sharedPreferences.getAll().entrySet().iterator();
        while (stringArray.hasNext()) {
            String[] stringArray2 = stringArray.next();
            try {
                String string2 = (String)stringArray2.getKey();
                if (string2.equals("PoolKeys")) continue;
                String string3 = (String)stringArray2.getValue();
                zzec object = new zzec(string3);
                zzdz2 = new zzdz(object.zzqH, object.zzpS, object.zzAC);
                if (this.zzAx.containsKey(zzdz2)) continue;
                zzea zzea2 = new zzea(object.zzqH, object.zzpS, object.zzAC);
                this.zzAx.put(zzdz2, zzea2);
                hashMap.put(zzdz2.toString(), zzdz2);
                zzdy.zza("Restored interstitial queue for %s.", zzdz2);
            }
            catch (IOException | ClassCastException exception) {
                zzin.zzd("Malformed preferences value for InterstitialAdPool.", exception);
            }
        }
        for (String string2 : stringArray = this.zzY(sharedPreferences.getString("PoolKeys", ""))) {
            zzdz2 = (zzdz)hashMap.get(string2);
            if (!this.zzAx.containsKey(zzdz2)) continue;
            this.zzAy.add(zzdz2);
        }
    }

    void flush() {
        while (this.zzAy.size() > 0) {
            zzdz zzdz2 = this.zzAy.remove();
            zzea zzea2 = this.zzAx.get(zzdz2);
            zzdy.zza("Flushing interstitial queue for %s.", zzdz2);
            while (zzea2.size() > 0) {
                zzea.zza zza2 = zzea2.zzej();
                zza2.zzAD.zzbp();
            }
            this.zzAx.remove(zzdz2);
        }
    }

    private String zzef() {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            Iterator iterator = this.zzAy.iterator();
            while (iterator.hasNext()) {
                String string2 = ((zzdz)iterator.next()).toString();
                stringBuilder.append(Base64.encodeToString((byte[])string2.getBytes("UTF-8"), (int)0));
                if (!iterator.hasNext()) continue;
                stringBuilder.append("\u0000");
            }
            return stringBuilder.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    private String[] zzY(String string2) {
        try {
            String[] stringArray = string2.split("\u0000");
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = new String(Base64.decode((String)stringArray[i], (int)0), "UTF-8");
            }
            return stringArray;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String[0];
        }
    }

    private static void zza(String string2, zzdz zzdz2) {
        if (zzin.zzQ(2)) {
            zzin.v(String.format(string2, zzdz2));
        }
    }
}

