/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.provider.CalendarContract;
import android.text.TextUtils;
import com.google.android.gms.R;
import com.google.android.gms.ads.internal.zzr;
import com.google.android.gms.internal.zzbl;
import com.google.android.gms.internal.zzfs;
import com.google.android.gms.internal.zzhb;
import com.google.android.gms.internal.zzjp;
import java.util.Map;

@zzhb
public class zzfm
extends zzfs {
    private final Map<String, String> zzxA;
    private final Context mContext;
    private String zzCU;
    private long zzCV;
    private long zzCW;
    private String zzCX;
    private String zzCY;

    public zzfm(zzjp zzjp2, Map<String, String> map) {
        super(zzjp2, "createCalendarEvent");
        this.zzxA = map;
        this.mContext = zzjp2.zzhP();
        this.zzeK();
    }

    private void zzeK() {
        this.zzCU = this.zzaj("description");
        this.zzCX = this.zzaj("summary");
        this.zzCV = this.zzak("start_ticks");
        this.zzCW = this.zzak("end_ticks");
        this.zzCY = this.zzaj("location");
    }

    private String zzaj(String string2) {
        return TextUtils.isEmpty((CharSequence)this.zzxA.get(string2)) ? "" : this.zzxA.get(string2);
    }

    private long zzak(String string2) {
        String string3 = this.zzxA.get(string2);
        if (string3 == null) {
            return -1L;
        }
        try {
            return Long.parseLong(string3);
        }
        catch (NumberFormatException numberFormatException) {
            return -1L;
        }
    }

    public void execute() {
        if (this.mContext == null) {
            this.zzam("Activity context is not available.");
            return;
        }
        zzbl zzbl2 = zzr.zzbC().zzM(this.mContext);
        if (!zzbl2.zzdo()) {
            this.zzam("This feature is not available on the device.");
            return;
        }
        AlertDialog.Builder builder = zzr.zzbC().zzL(this.mContext);
        builder.setTitle((CharSequence)zzr.zzbF().zzd(R.string.create_calendar_title, "Create calendar event"));
        builder.setMessage((CharSequence)zzr.zzbF().zzd(R.string.create_calendar_message, "Allow Ad to create a calendar event?"));
        builder.setPositiveButton((CharSequence)zzr.zzbF().zzd(R.string.accept, "Accept"), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                Intent intent = zzfm.this.createIntent();
                zzr.zzbC().zzb(zzfm.this.mContext, intent);
            }
        });
        builder.setNegativeButton((CharSequence)zzr.zzbF().zzd(R.string.decline, "Decline"), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                zzfm.this.zzam("Operation denied by user.");
            }
        });
        builder.create().show();
    }

    @TargetApi(value=14)
    Intent createIntent() {
        Intent intent = new Intent("android.intent.action.EDIT").setData(CalendarContract.Events.CONTENT_URI);
        intent.putExtra("title", this.zzCU);
        intent.putExtra("eventLocation", this.zzCY);
        intent.putExtra("description", this.zzCX);
        if (this.zzCV > -1L) {
            intent.putExtra("beginTime", this.zzCV);
        }
        if (this.zzCW > -1L) {
            intent.putExtra("endTime", this.zzCW);
        }
        intent.setFlags(0x10000000);
        return intent;
    }
}

