/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.RemoteException;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.formats.zzc;
import com.google.android.gms.ads.internal.formats.zzf;
import com.google.android.gms.ads.internal.formats.zzh;
import com.google.android.gms.ads.internal.formats.zzi;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzan;
import com.google.android.gms.internal.zzbt;
import com.google.android.gms.internal.zzcp;
import com.google.android.gms.internal.zzct;
import com.google.android.gms.internal.zzdf;
import com.google.android.gms.internal.zzed;
import com.google.android.gms.internal.zzee;
import com.google.android.gms.internal.zzgx;
import com.google.android.gms.internal.zzgy;
import com.google.android.gms.internal.zzgz;
import com.google.android.gms.internal.zzhb;
import com.google.android.gms.internal.zzif;
import com.google.android.gms.internal.zzin;
import com.google.android.gms.internal.zzir;
import com.google.android.gms.internal.zziw;
import com.google.android.gms.internal.zzjd;
import com.google.android.gms.internal.zzje;
import com.google.android.gms.internal.zzjf;
import com.google.android.gms.internal.zzjg;
import com.google.android.gms.internal.zzjp;
import com.google.android.gms.internal.zzna;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzhb
public class zzgw
implements Callable<zzif> {
    private static final long zzGF = TimeUnit.SECONDS.toMillis(60L);
    private final Context mContext;
    private final zziw zzGG;
    private final zzp zzGH;
    private final zzan zzyt;
    private final zzee zzGI;
    private final Object zzpV = new Object();
    private final zzif.zza zzGd;
    private boolean zzGJ;
    private int zzGu;
    private List<String> zzGK;
    private JSONObject zzGL;

    public zzgw(Context context, zzp zzp2, zzee zzee2, zziw zziw2, zzan zzan2, zzif.zza zza2) {
        this.mContext = context;
        this.zzGH = zzp2;
        this.zzGG = zziw2;
        this.zzGI = zzee2;
        this.zzGd = zza2;
        this.zzyt = zzan2;
        this.zzGJ = false;
        this.zzGu = -2;
        this.zzGK = null;
    }

    public zzif zzgl() {
        try {
            zzed zzed2 = this.zzgm();
            JSONObject jSONObject = this.zzb(zzed2);
            zza zza2 = this.zze(jSONObject);
            zzh.zza zza3 = this.zza(zzed2, zza2, jSONObject);
            this.zza(zza3, zzed2);
            zzif zzif2 = this.zza(zza3);
            return zzif2;
        }
        catch (CancellationException cancellationException) {
        }
        catch (ExecutionException executionException) {
        }
        catch (InterruptedException interruptedException) {
        }
        catch (JSONException jSONException) {
            zzin.zzd("Malformed native JSON response.", jSONException);
        }
        catch (TimeoutException timeoutException) {
            zzin.zzd("Timeout when loading native ad.", timeoutException);
        }
        if (!this.zzGJ) {
            this.zzF(0);
        }
        return this.zza(null);
    }

    private zzed zzgm() throws CancellationException, ExecutionException, InterruptedException, TimeoutException {
        if (this.zzgn()) {
            return null;
        }
        String string2 = zzbt.zzwC.get();
        String string3 = this.zzGd.zzLe.zzEF.indexOf("https") == 0 ? "https:" : "http:";
        String string4 = string3 + string2;
        zzed zzed2 = this.zzGI.zza(this.mContext, this.zzGd.zzLd.zzrl, string4, this.zzyt).get(zzGF, TimeUnit.MILLISECONDS);
        zzed2.zza(this.zzGH, this.zzGH, this.zzGH, this.zzGH, false, null, null, null, null);
        return zzed2;
    }

    private JSONObject zzb(final zzed zzed2) throws TimeoutException, JSONException {
        zzdf zzdf2;
        if (this.zzgn()) {
            return null;
        }
        final zzjd zzjd2 = new zzjd();
        final zzb zzb2 = new zzb();
        zzb2.zzHb = zzdf2 = new zzdf(){

            @Override
            public void zza(zzjp zzjp2, Map<String, String> map) {
                zzed2.zzb("/nativeAdPreProcess", zzb2.zzHb);
                try {
                    String string2 = map.get("success");
                    if (!TextUtils.isEmpty((CharSequence)string2)) {
                        zzjd2.zzg(new JSONObject(string2).getJSONArray("ads").getJSONObject(0));
                        return;
                    }
                }
                catch (JSONException jSONException) {
                    zzin.zzb("Malformed native JSON response.", jSONException);
                }
                zzgw.this.zzF(0);
                zzx.zza((boolean)zzgw.this.zzgn(), (Object)"Unable to set the ad state error!");
                zzjd2.zzg(null);
            }
        };
        zzed2.zza("/nativeAdPreProcess", zzdf2);
        JSONObject jSONObject = new JSONObject(this.zzGd.zzLe.body);
        zzed2.zza("google.afma.nativeAds.preProcessJsonGmsg", jSONObject);
        return (JSONObject)zzjd2.get(zzGF, TimeUnit.MILLISECONDS);
    }

    protected zza zze(JSONObject jSONObject) throws JSONException, TimeoutException {
        boolean bl;
        if (this.zzgn()) {
            return null;
        }
        String string2 = jSONObject.getString("template_id");
        boolean bl2 = this.zzGd.zzLd.zzrD != null ? this.zzGd.zzLd.zzrD.zzyA : false;
        boolean bl3 = bl = this.zzGd.zzLd.zzrD != null ? this.zzGd.zzLd.zzrD.zzyC : false;
        if ("2".equals(string2)) {
            return new zzgx(bl2, bl);
        }
        if ("1".equals(string2)) {
            return new zzgy(bl2, bl);
        }
        if ("3".equals(string2)) {
            final String string3 = jSONObject.getString("custom_template_id");
            final zzjd zzjd2 = new zzjd();
            zzir.zzMc.post(new Runnable(){

                @Override
                public void run() {
                    zzjd2.zzg(zzgw.this.zzGH.zzbv().get((Object)string3));
                }
            });
            if (zzjd2.get(zzGF, TimeUnit.MILLISECONDS) != null) {
                return new zzgz(bl2);
            }
            zzin.e("No handler for custom template: " + jSONObject.getString("custom_template_id"));
        } else {
            this.zzF(0);
        }
        return null;
    }

    private void zza(zzh.zza zza2, zzed zzed2) {
        zzdf zzdf2;
        if (!(zza2 instanceof zzf)) {
            return;
        }
        final zzf zzf2 = (zzf)zza2;
        zzb zzb2 = new zzb();
        zzb2.zzHb = zzdf2 = new zzdf(){

            @Override
            public void zza(zzjp zzjp2, Map<String, String> map) {
                String string2 = map.get("asset");
                zzgw.this.zzb(zzf2, string2);
            }
        };
        zzed2.zza("/nativeAdCustomClick", zzdf2);
    }

    private void zzb(zzcp zzcp2, String string2) {
        try {
            zzct zzct2 = this.zzGH.zzs(zzcp2.getCustomTemplateId());
            if (zzct2 != null) {
                zzct2.zza(zzcp2, string2);
            }
        }
        catch (RemoteException remoteException) {
            zzin.zzd("Failed to call onCustomClick for asset " + string2 + ".", remoteException);
        }
    }

    private zzh.zza zza(zzed zzed2, zza zza2, JSONObject jSONObject) throws ExecutionException, InterruptedException, JSONException {
        if (this.zzgn()) {
            return null;
        }
        JSONObject jSONObject2 = jSONObject.getJSONObject("tracking_urls_and_actions");
        String[] stringArray = this.zzc(jSONObject2, "impression_tracking_urls");
        this.zzGK = stringArray == null ? null : Arrays.asList(stringArray);
        this.zzGL = jSONObject2.optJSONObject("active_view");
        Object t = zza2.zza(this, jSONObject);
        if (t == null) {
            zzin.e("Failed to retrieve ad assets.");
            return null;
        }
        t.zzb(new zzi(this.mContext, this.zzGH, zzed2, this.zzyt, jSONObject, (zzh.zza)t, this.zzGd.zzLd.zzrl));
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private zzif zza(zzh.zza zza2) {
        int n;
        Object object = this.zzpV;
        synchronized (object) {
            n = this.zzGu;
            if (zza2 == null && this.zzGu == -2) {
                n = 0;
            }
        }
        if (n != -2) {
            zza2 = null;
        }
        return new zzif(this.zzGd.zzLd.zzHt, null, this.zzGd.zzLe.zzBQ, n, this.zzGd.zzLe.zzBR, this.zzGK, this.zzGd.zzLe.orientation, this.zzGd.zzLe.zzBU, this.zzGd.zzLd.zzHw, false, null, null, null, null, null, 0L, this.zzGd.zzrp, this.zzGd.zzLe.zzHS, this.zzGd.zzKY, this.zzGd.zzKZ, this.zzGd.zzLe.zzHY, this.zzGL, zza2, null, null, null, this.zzGd.zzLe.zzIm);
    }

    public zzjg<com.google.android.gms.ads.internal.formats.zza> zzf(JSONObject jSONObject) throws JSONException {
        JSONObject jSONObject2 = jSONObject.optJSONObject("attribution");
        if (jSONObject2 == null) {
            return new zzje<Object>(null);
        }
        final String string2 = jSONObject2.optString("text");
        final int n = jSONObject2.optInt("text_size", -1);
        final Integer n2 = this.zzb(jSONObject2, "text_color");
        final Integer n3 = this.zzb(jSONObject2, "bg_color");
        final int n4 = jSONObject2.optInt("animation_ms", 1000);
        final int n5 = jSONObject2.optInt("presentation_ms", 4000);
        ArrayList arrayList = new ArrayList<zzjg<zzc>>();
        if (jSONObject2.optJSONArray("images") != null) {
            arrayList = this.zza(jSONObject2, "images", false, false, true);
        } else {
            arrayList.add(this.zza(jSONObject2, "image", false, false));
        }
        zzjg zzjg2 = zzjf.zzl(arrayList);
        return zzjf.zza(zzjg2, new zzjf.zza<List<zzc>, com.google.android.gms.ads.internal.formats.zza>(){

            public com.google.android.gms.ads.internal.formats.zza zzh(List<zzc> list) {
                try {
                    return list == null || list.isEmpty() ? null : new com.google.android.gms.ads.internal.formats.zza(string2, zzgw.zzf(list), n3, n2, n > 0 ? Integer.valueOf(n) : null, n5 + n4);
                }
                catch (RemoteException remoteException) {
                    zzin.zzb("Could not get attribution icon", remoteException);
                    return null;
                }
            }

            @Override
            public /* synthetic */ Object zzf(Object object) {
                return this.zzh((List)object);
            }
        });
    }

    private Integer zzb(JSONObject jSONObject, String string2) {
        try {
            JSONObject jSONObject2 = jSONObject.getJSONObject(string2);
            int n = jSONObject2.getInt("r");
            int n2 = jSONObject2.getInt("g");
            int n3 = jSONObject2.getInt("b");
            return Color.rgb((int)n, (int)n2, (int)n3);
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    public Future<zzc> zza(JSONObject jSONObject, String string2, boolean bl) throws JSONException {
        JSONObject jSONObject2 = jSONObject.getJSONObject(string2);
        boolean bl2 = jSONObject2.optBoolean("require", true);
        jSONObject2 = jSONObject2 == null ? new JSONObject() : jSONObject2;
        return this.zza(jSONObject2, bl2, bl);
    }

    public zzjg<zzc> zza(JSONObject jSONObject, String string2, boolean bl, boolean bl2) throws JSONException {
        JSONObject jSONObject2 = bl ? jSONObject.getJSONObject(string2) : jSONObject.optJSONObject(string2);
        jSONObject2 = jSONObject2 == null ? new JSONObject() : jSONObject2;
        return this.zza(jSONObject2, bl, bl2);
    }

    public List<zzjg<zzc>> zza(JSONObject jSONObject, String string2, boolean bl, boolean bl2, boolean bl3) throws JSONException {
        JSONArray jSONArray = bl ? jSONObject.getJSONArray(string2) : jSONObject.optJSONArray(string2);
        ArrayList<zzjg<zzc>> arrayList = new ArrayList<zzjg<zzc>>();
        if (jSONArray == null || jSONArray.length() == 0) {
            this.zza(0, bl);
            return arrayList;
        }
        int n = bl3 ? jSONArray.length() : 1;
        for (int i = 0; i < n; ++i) {
            JSONObject jSONObject2 = jSONArray.getJSONObject(i);
            jSONObject2 = jSONObject2 == null ? new JSONObject() : jSONObject2;
            arrayList.add(this.zza(jSONObject2, bl, bl2));
        }
        return arrayList;
    }

    private zzjg<zzc> zza(JSONObject jSONObject, final boolean bl, boolean bl2) throws JSONException {
        final String string2 = bl ? jSONObject.getString("url") : jSONObject.optString("url");
        final double d = jSONObject.optDouble("scale", 1.0);
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.zza(0, bl);
            return new zzje<Object>(null);
        }
        if (bl2) {
            return new zzje<zzc>(new zzc(null, Uri.parse((String)string2), d));
        }
        return this.zzGG.zza(string2, new zziw.zza<zzc>(){

            public zzc zzgo() {
                zzgw.this.zza(2, bl);
                return null;
            }

            public zzc zzg(InputStream inputStream) {
                byte[] byArray = null;
                try {
                    byArray = zzna.zzk((InputStream)inputStream);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (byArray == null) {
                    zzgw.this.zza(2, bl);
                    return null;
                }
                Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length);
                if (bitmap == null) {
                    zzgw.this.zza(2, bl);
                    return null;
                }
                bitmap.setDensity((int)(160.0 * d));
                return new zzc((Drawable)new BitmapDrawable(Resources.getSystem(), bitmap), Uri.parse((String)string2), d);
            }

            @Override
            public /* synthetic */ Object zzgp() {
                return this.zzgo();
            }

            @Override
            public /* synthetic */ Object zzh(InputStream inputStream) {
                return this.zzg(inputStream);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean zzgn() {
        Object object = this.zzpV;
        synchronized (object) {
            return this.zzGJ;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzF(int n) {
        Object object = this.zzpV;
        synchronized (object) {
            this.zzGJ = true;
            this.zzGu = n;
        }
    }

    public void zza(int n, boolean bl) {
        if (bl) {
            this.zzF(n);
        }
    }

    private String[] zzc(JSONObject jSONObject, String string2) throws JSONException {
        JSONArray jSONArray = jSONObject.optJSONArray(string2);
        if (jSONArray == null) {
            return null;
        }
        String[] stringArray = new String[jSONArray.length()];
        for (int i = 0; i < jSONArray.length(); ++i) {
            stringArray[i] = jSONArray.getString(i);
        }
        return stringArray;
    }

    private static List<Drawable> zzf(List<zzc> list) throws RemoteException {
        ArrayList<Drawable> arrayList = new ArrayList<Drawable>();
        for (zzc zzc2 : list) {
            arrayList.add((Drawable)zze.zzp((zzd)zzc2.zzdJ()));
        }
        return arrayList;
    }

    @Override
    public /* synthetic */ Object call() throws Exception {
        return this.zzgl();
    }

    class zzb {
        public zzdf zzHb;

        zzb() {
        }
    }

    public static interface zza<T extends zzh.zza> {
        public T zza(zzgw var1, JSONObject var2) throws JSONException, InterruptedException, ExecutionException;
    }
}

