/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.graphics.Color;
import android.location.Location;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.client.AdRequestParcel;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.SearchAdRequestParcel;
import com.google.android.gms.ads.internal.formats.NativeAdOptionsParcel;
import com.google.android.gms.ads.internal.request.AdRequestInfoParcel;
import com.google.android.gms.ads.internal.request.AdResponseParcel;
import com.google.android.gms.ads.internal.reward.mediation.client.RewardItemParcel;
import com.google.android.gms.ads.internal.zzr;
import com.google.android.gms.internal.zzbm;
import com.google.android.gms.internal.zzhb;
import com.google.android.gms.internal.zzhd;
import com.google.android.gms.internal.zzhj;
import com.google.android.gms.internal.zzhn;
import com.google.android.gms.internal.zzil;
import com.google.android.gms.internal.zzin;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzhb
public final class zzhe {
    private static final SimpleDateFormat zzJg = new SimpleDateFormat("yyyyMMdd", Locale.US);

    public static JSONObject zza(Context context, AdRequestInfoParcel adRequestInfoParcel, zzhj zzhj2, zzhn.zza zza2, Location location, zzbm zzbm2, String string2, String string3, List<String> list, Bundle bundle) {
        try {
            CharSequence charSequence;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            if (list.size() > 0) {
                hashMap.put("eid", TextUtils.join((CharSequence)",", list));
            }
            if (adRequestInfoParcel.zzHs != null) {
                hashMap.put("ad_pos", adRequestInfoParcel.zzHs);
            }
            zzhe.zza(hashMap, adRequestInfoParcel.zzHt);
            hashMap.put("format", adRequestInfoParcel.zzrp.zzuh);
            if (adRequestInfoParcel.zzrp.width == -1) {
                hashMap.put("smart_w", "full");
            }
            if (adRequestInfoParcel.zzrp.height == -2) {
                hashMap.put("smart_h", "auto");
            }
            if (adRequestInfoParcel.zzrp.zzul) {
                hashMap.put("fluid", "height");
            }
            if (adRequestInfoParcel.zzrp.zzuj != null) {
                charSequence = new StringBuilder();
                for (AdSizeParcel adSizeParcel : adRequestInfoParcel.zzrp.zzuj) {
                    if (charSequence.length() != 0) {
                        charSequence.append("|");
                    }
                    charSequence.append(adSizeParcel.width == -1 ? (int)((float)adSizeParcel.widthPixels / zzhj2.zzHF) : adSizeParcel.width);
                    charSequence.append("x");
                    charSequence.append(adSizeParcel.height == -2 ? (int)((float)adSizeParcel.heightPixels / zzhj2.zzHF) : adSizeParcel.height);
                }
                hashMap.put("sz", charSequence);
            }
            if (adRequestInfoParcel.zzHz != 0) {
                hashMap.put("native_version", adRequestInfoParcel.zzHz);
                if (!adRequestInfoParcel.zzrp.zzum) {
                    hashMap.put("native_templates", adRequestInfoParcel.zzrH);
                    hashMap.put("native_image_orientation", zzhe.zzc(adRequestInfoParcel.zzrD));
                    if (!adRequestInfoParcel.zzHK.isEmpty()) {
                        hashMap.put("native_custom_templates", adRequestInfoParcel.zzHK);
                    }
                }
            }
            hashMap.put("slotname", adRequestInfoParcel.zzrj);
            hashMap.put("pn", adRequestInfoParcel.applicationInfo.packageName);
            if (adRequestInfoParcel.zzHu != null) {
                hashMap.put("vc", adRequestInfoParcel.zzHu.versionCode);
            }
            hashMap.put("ms", string3);
            hashMap.put("seq_num", adRequestInfoParcel.zzHw);
            hashMap.put("session_id", adRequestInfoParcel.zzHx);
            hashMap.put("js", adRequestInfoParcel.zzrl.afmaVersion);
            zzhe.zza(hashMap, zzhj2, zza2);
            hashMap.put("platform", Build.MANUFACTURER);
            hashMap.put("submodel", Build.MODEL);
            if (adRequestInfoParcel.zzHt.versionCode >= 2 && adRequestInfoParcel.zzHt.zztK != null) {
                zzhe.zza(hashMap, adRequestInfoParcel.zzHt.zztK);
            }
            if (adRequestInfoParcel.versionCode >= 2) {
                hashMap.put("quality_signals", adRequestInfoParcel.zzHy);
            }
            if (adRequestInfoParcel.versionCode >= 4 && adRequestInfoParcel.zzHB) {
                hashMap.put("forceHttps", adRequestInfoParcel.zzHB);
            }
            if (bundle != null) {
                hashMap.put("content_info", bundle);
            }
            if (adRequestInfoParcel.versionCode >= 5) {
                hashMap.put("u_sd", Float.valueOf(adRequestInfoParcel.zzHF));
                hashMap.put("sh", adRequestInfoParcel.zzHE);
                hashMap.put("sw", adRequestInfoParcel.zzHD);
            } else {
                hashMap.put("u_sd", Float.valueOf(zzhj2.zzHF));
                hashMap.put("sh", zzhj2.zzHE);
                hashMap.put("sw", zzhj2.zzHD);
            }
            if (adRequestInfoParcel.versionCode >= 6) {
                if (!TextUtils.isEmpty((CharSequence)adRequestInfoParcel.zzHG)) {
                    try {
                        hashMap.put("view_hierarchy", new JSONObject(adRequestInfoParcel.zzHG));
                    }
                    catch (JSONException jSONException) {
                        zzin.zzd("Problem serializing view hierarchy to JSON", jSONException);
                    }
                }
                hashMap.put("correlation_id", adRequestInfoParcel.zzHH);
            }
            if (adRequestInfoParcel.versionCode >= 7) {
                hashMap.put("request_id", adRequestInfoParcel.zzHI);
            }
            if (adRequestInfoParcel.versionCode >= 11 && adRequestInfoParcel.zzHM != null) {
                hashMap.put("capability", adRequestInfoParcel.zzHM.toBundle());
            }
            zzhe.zza(hashMap, string2);
            if (adRequestInfoParcel.versionCode >= 12 && !TextUtils.isEmpty((CharSequence)adRequestInfoParcel.zzHN)) {
                hashMap.put("anchor", adRequestInfoParcel.zzHN);
            }
            if (adRequestInfoParcel.versionCode >= 13) {
                hashMap.put("avol", Float.valueOf(adRequestInfoParcel.zzHO));
            }
            if (adRequestInfoParcel.versionCode >= 14 && adRequestInfoParcel.zzHP > 0) {
                hashMap.put("target_api", adRequestInfoParcel.zzHP);
            }
            if (adRequestInfoParcel.versionCode >= 15) {
                hashMap.put("scroll_index", adRequestInfoParcel.zzHQ == -1 ? -1 : adRequestInfoParcel.zzHQ);
            }
            if (zzin.zzQ(2)) {
                charSequence = zzr.zzbC().zzG(hashMap).toString(2);
                zzin.v("Ad Request JSON: " + (String)charSequence);
            }
            return zzr.zzbC().zzG(hashMap);
        }
        catch (JSONException jSONException) {
            zzin.zzaK("Problem serializing ad request to JSON: " + jSONException.getMessage());
            return null;
        }
    }

    private static void zza(HashMap<String, Object> hashMap, String string2) {
        if (string2 != null) {
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            hashMap2.put("token", string2);
            hashMap.put("pan", hashMap2);
        }
    }

    private static void zza(HashMap<String, Object> hashMap, AdRequestParcel adRequestParcel) {
        String string2 = zzil.zzhm();
        if (string2 != null) {
            hashMap.put("abf", string2);
        }
        if (adRequestParcel.zztC != -1L) {
            hashMap.put("cust_age", zzJg.format(new Date(adRequestParcel.zztC)));
        }
        if (adRequestParcel.extras != null) {
            hashMap.put("extras", adRequestParcel.extras);
        }
        if (adRequestParcel.zztD != -1) {
            hashMap.put("cust_gender", adRequestParcel.zztD);
        }
        if (adRequestParcel.zztE != null) {
            hashMap.put("kw", adRequestParcel.zztE);
        }
        if (adRequestParcel.zztG != -1) {
            hashMap.put("tag_for_child_directed_treatment", adRequestParcel.zztG);
        }
        if (adRequestParcel.zztF) {
            hashMap.put("adtest", "on");
        }
        if (adRequestParcel.versionCode >= 2) {
            if (adRequestParcel.zztH) {
                hashMap.put("d_imp_hdr", 1);
            }
            if (!TextUtils.isEmpty((CharSequence)adRequestParcel.zztI)) {
                hashMap.put("ppid", adRequestParcel.zztI);
            }
            if (adRequestParcel.zztJ != null) {
                zzhe.zza(hashMap, adRequestParcel.zztJ);
            }
        }
        if (adRequestParcel.versionCode >= 3 && adRequestParcel.zztL != null) {
            hashMap.put("url", adRequestParcel.zztL);
        }
        if (adRequestParcel.versionCode >= 5) {
            if (adRequestParcel.zztN != null) {
                hashMap.put("custom_targeting", adRequestParcel.zztN);
            }
            if (adRequestParcel.zztO != null) {
                hashMap.put("category_exclusions", adRequestParcel.zztO);
            }
            if (adRequestParcel.zztP != null) {
                hashMap.put("request_agent", adRequestParcel.zztP);
            }
        }
        if (adRequestParcel.versionCode >= 6 && adRequestParcel.zztQ != null) {
            hashMap.put("request_pkg", adRequestParcel.zztQ);
        }
        if (adRequestParcel.versionCode >= 7) {
            hashMap.put("is_designed_for_families", adRequestParcel.zztR);
        }
    }

    private static void zza(HashMap<String, Object> hashMap, zzhj zzhj2, zzhn.zza zza2) {
        hashMap.put("am", zzhj2.zzJQ);
        hashMap.put("cog", zzhe.zzy(zzhj2.zzJR));
        hashMap.put("coh", zzhe.zzy(zzhj2.zzJS));
        if (!TextUtils.isEmpty((CharSequence)zzhj2.zzJT)) {
            hashMap.put("carrier", zzhj2.zzJT);
        }
        hashMap.put("gl", zzhj2.zzJU);
        if (zzhj2.zzJV) {
            hashMap.put("simulator", 1);
        }
        if (zzhj2.zzJW) {
            hashMap.put("is_sidewinder", 1);
        }
        hashMap.put("ma", zzhe.zzy(zzhj2.zzJX));
        hashMap.put("sp", zzhe.zzy(zzhj2.zzJY));
        hashMap.put("hl", zzhj2.zzJZ);
        if (!TextUtils.isEmpty((CharSequence)zzhj2.zzKa)) {
            hashMap.put("mv", zzhj2.zzKa);
        }
        hashMap.put("muv", zzhj2.zzKb);
        if (zzhj2.zzKc != -2) {
            hashMap.put("cnt", zzhj2.zzKc);
        }
        hashMap.put("gnt", zzhj2.zzKd);
        hashMap.put("pt", zzhj2.zzKe);
        hashMap.put("rm", zzhj2.zzKf);
        hashMap.put("riv", zzhj2.zzKg);
        Bundle bundle = new Bundle();
        bundle.putString("build", zzhj2.zzKl);
        Bundle bundle2 = new Bundle();
        bundle2.putBoolean("is_charging", zzhj2.zzKi);
        bundle2.putDouble("battery_level", zzhj2.zzKh);
        bundle.putBundle("battery", bundle2);
        Bundle bundle3 = new Bundle();
        bundle3.putInt("active_network_state", zzhj2.zzKk);
        bundle3.putBoolean("active_network_metered", zzhj2.zzKj);
        if (zza2 != null) {
            Bundle bundle4 = new Bundle();
            bundle4.putInt("predicted_latency_micros", zza2.zzKq);
            bundle4.putLong("predicted_down_throughput_bps", zza2.zzKr);
            bundle4.putLong("predicted_up_throughput_bps", zza2.zzKs);
            bundle3.putBundle("predictions", bundle4);
        }
        bundle.putBundle("network", bundle3);
        hashMap.put("device", bundle);
    }

    private static void zza(HashMap<String, Object> hashMap, Location location) {
        HashMap<String, Number> hashMap2 = new HashMap<String, Number>();
        Float f = Float.valueOf(location.getAccuracy() * 1000.0f);
        Long l = location.getTime() * 1000L;
        Long l2 = (long)(location.getLatitude() * 1.0E7);
        Long l3 = (long)(location.getLongitude() * 1.0E7);
        hashMap2.put("radius", f);
        hashMap2.put("lat", l2);
        hashMap2.put("long", l3);
        hashMap2.put("time", l);
        hashMap.put("uule", hashMap2);
    }

    private static void zza(HashMap<String, Object> hashMap, SearchAdRequestParcel searchAdRequestParcel) {
        String string2;
        String string3;
        if (Color.alpha((int)searchAdRequestParcel.zzvd) != 0) {
            hashMap.put("acolor", zzhe.zzL(searchAdRequestParcel.zzvd));
        }
        if (Color.alpha((int)searchAdRequestParcel.backgroundColor) != 0) {
            hashMap.put("bgcolor", zzhe.zzL(searchAdRequestParcel.backgroundColor));
        }
        if (Color.alpha((int)searchAdRequestParcel.zzve) != 0 && Color.alpha((int)searchAdRequestParcel.zzvf) != 0) {
            hashMap.put("gradientto", zzhe.zzL(searchAdRequestParcel.zzve));
            hashMap.put("gradientfrom", zzhe.zzL(searchAdRequestParcel.zzvf));
        }
        if (Color.alpha((int)searchAdRequestParcel.zzvg) != 0) {
            hashMap.put("bcolor", zzhe.zzL(searchAdRequestParcel.zzvg));
        }
        hashMap.put("bthick", Integer.toString(searchAdRequestParcel.zzvh));
        switch (searchAdRequestParcel.zzvi) {
            case 0: {
                string3 = "none";
                break;
            }
            case 1: {
                string3 = "dashed";
                break;
            }
            case 2: {
                string3 = "dotted";
                break;
            }
            case 3: {
                string3 = "solid";
                break;
            }
            default: {
                string3 = null;
            }
        }
        if (string3 != null) {
            hashMap.put("btype", string3);
        }
        switch (searchAdRequestParcel.zzvj) {
            case 2: {
                string2 = "dark";
                break;
            }
            case 0: {
                string2 = "light";
                break;
            }
            case 1: {
                string2 = "medium";
                break;
            }
            default: {
                string2 = null;
            }
        }
        if (string2 != null) {
            hashMap.put("callbuttoncolor", string2);
        }
        if (searchAdRequestParcel.zzvk != null) {
            hashMap.put("channel", searchAdRequestParcel.zzvk);
        }
        if (Color.alpha((int)searchAdRequestParcel.zzvl) != 0) {
            hashMap.put("dcolor", zzhe.zzL(searchAdRequestParcel.zzvl));
        }
        if (searchAdRequestParcel.zzvm != null) {
            hashMap.put("font", searchAdRequestParcel.zzvm);
        }
        if (Color.alpha((int)searchAdRequestParcel.zzvn) != 0) {
            hashMap.put("hcolor", zzhe.zzL(searchAdRequestParcel.zzvn));
        }
        hashMap.put("headersize", Integer.toString(searchAdRequestParcel.zzvo));
        if (searchAdRequestParcel.zzvp != null) {
            hashMap.put("q", searchAdRequestParcel.zzvp);
        }
    }

    private static Integer zzy(boolean bl) {
        return bl ? 1 : 0;
    }

    private static String zzL(int n) {
        return String.format(Locale.US, "#%06x", n & 0xFFFFFF);
    }

    private static String zzc(NativeAdOptionsParcel nativeAdOptionsParcel) {
        int n = nativeAdOptionsParcel != null ? nativeAdOptionsParcel.zzyB : 0;
        switch (n) {
            case 1: {
                return "portrait";
            }
            case 2: {
                return "landscape";
            }
        }
        return "any";
    }

    public static AdResponseParcel zza(Context context, AdRequestInfoParcel adRequestInfoParcel, String string2) {
        try {
            List<String> list;
            List<String> list2;
            List<String> list3;
            JSONObject jSONObject = new JSONObject(string2);
            String string3 = jSONObject.optString("ad_base_url", null);
            String string4 = jSONObject.optString("ad_url", null);
            String string5 = jSONObject.optString("ad_size", null);
            boolean bl = adRequestInfoParcel != null && adRequestInfoParcel.zzHz != 0;
            String string6 = bl ? jSONObject.optString("ad_json", null) : jSONObject.optString("ad_html", null);
            long l = -1L;
            String string7 = jSONObject.optString("debug_dialog", null);
            long l2 = jSONObject.has("interstitial_timeout") ? (long)(jSONObject.getDouble("interstitial_timeout") * 1000.0) : -1L;
            String string8 = jSONObject.optString("orientation", null);
            int n = -1;
            if ("portrait".equals(string8)) {
                n = zzr.zzbE().zzhw();
            } else if ("landscape".equals(string8)) {
                n = zzr.zzbE().zzhv();
            }
            AdResponseParcel adResponseParcel = null;
            if (!TextUtils.isEmpty((CharSequence)string6)) {
                if (TextUtils.isEmpty((CharSequence)string3)) {
                    zzin.zzaK("Could not parse the mediation config: Missing required ad_base_url field");
                    return new AdResponseParcel(0);
                }
            } else if (!TextUtils.isEmpty((CharSequence)string4)) {
                adResponseParcel = zzhd.zza(adRequestInfoParcel, context, adRequestInfoParcel.zzrl.afmaVersion, string4, null, null, null, null, null);
                string3 = adResponseParcel.zzEF;
                string6 = adResponseParcel.body;
                l = adResponseParcel.zzHX;
            } else {
                zzin.zzaK("Could not parse the mediation config: Missing required " + (bl ? "ad_json" : "ad_html") + " or " + "ad_url" + " field.");
                return new AdResponseParcel(0);
            }
            JSONArray jSONArray = jSONObject.optJSONArray("click_urls");
            List<String> list4 = list3 = adResponseParcel == null ? null : adResponseParcel.zzBQ;
            if (jSONArray != null) {
                list3 = zzhe.zza(jSONArray, list3);
            }
            JSONArray jSONArray2 = jSONObject.optJSONArray("impression_urls");
            List<String> list5 = list2 = adResponseParcel == null ? null : adResponseParcel.zzBR;
            if (jSONArray2 != null) {
                list2 = zzhe.zza(jSONArray2, list2);
            }
            JSONArray jSONArray3 = jSONObject.optJSONArray("manual_impression_urls");
            List<String> list6 = list = adResponseParcel == null ? null : adResponseParcel.zzHV;
            if (jSONArray3 != null) {
                list = zzhe.zza(jSONArray3, list);
            }
            if (adResponseParcel != null) {
                if (adResponseParcel.orientation != -1) {
                    n = adResponseParcel.orientation;
                }
                if (adResponseParcel.zzHS > 0L) {
                    l2 = adResponseParcel.zzHS;
                }
            }
            String string9 = jSONObject.optString("active_view");
            String string10 = null;
            boolean bl2 = jSONObject.optBoolean("ad_is_javascript", false);
            if (bl2) {
                string10 = jSONObject.optString("ad_passback_url", null);
            }
            boolean bl3 = jSONObject.optBoolean("mediation", false);
            boolean bl4 = jSONObject.optBoolean("custom_render_allowed", false);
            boolean bl5 = jSONObject.optBoolean("content_url_opted_out", true);
            boolean bl6 = jSONObject.optBoolean("prefetch", false);
            int n2 = jSONObject.optInt("oauth2_token_status", 0);
            long l3 = jSONObject.optLong("refresh_interval_milliseconds", -1L);
            long l4 = jSONObject.optLong("mediation_config_cache_time_milliseconds", -1L);
            String string11 = jSONObject.optString("gws_query_id", "");
            boolean bl7 = "height".equals(jSONObject.optString("fluid", ""));
            boolean bl8 = jSONObject.optBoolean("native_express", false);
            List<String> list7 = zzhe.zza(jSONObject.optJSONArray("video_start_urls"), null);
            List<String> list8 = zzhe.zza(jSONObject.optJSONArray("video_complete_urls"), null);
            RewardItemParcel rewardItemParcel = RewardItemParcel.zza(jSONObject.optJSONArray("rewards"));
            boolean bl9 = jSONObject.optBoolean("use_displayed_impression", false);
            return new AdResponseParcel(adRequestInfoParcel, string3, string6, list3, list2, l2, bl3, l4, list, l3, n, string5, l, string7, bl2, string10, string9, bl4, bl, adRequestInfoParcel.zzHB, bl5, bl6, n2, string11, bl7, bl8, rewardItemParcel, list7, list8, bl9);
        }
        catch (JSONException jSONException) {
            zzin.zzaK("Could not parse the mediation config: " + jSONException.getMessage());
            return new AdResponseParcel(0);
        }
    }

    @Nullable
    private static List<String> zza(@Nullable JSONArray jSONArray, @Nullable List<String> list) throws JSONException {
        if (jSONArray == null) {
            return null;
        }
        if (list == null) {
            list = new LinkedList<String>();
        }
        for (int i = 0; i < jSONArray.length(); ++i) {
            list.add(jSONArray.getString(i));
        }
        return list;
    }

    public static JSONObject zzc(AdResponseParcel adResponseParcel) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        if (adResponseParcel.zzEF != null) {
            jSONObject.put("ad_base_url", (Object)adResponseParcel.zzEF);
        }
        if (adResponseParcel.zzHW != null) {
            jSONObject.put("ad_size", (Object)adResponseParcel.zzHW);
        }
        jSONObject.put("native", adResponseParcel.zzuk);
        if (adResponseParcel.zzuk) {
            jSONObject.put("ad_json", (Object)adResponseParcel.body);
        } else {
            jSONObject.put("ad_html", (Object)adResponseParcel.body);
        }
        if (adResponseParcel.zzHY != null) {
            jSONObject.put("debug_dialog", (Object)adResponseParcel.zzHY);
        }
        if (adResponseParcel.zzHS != -1L) {
            jSONObject.put("interstitial_timeout", (double)adResponseParcel.zzHS / 1000.0);
        }
        if (adResponseParcel.orientation == zzr.zzbE().zzhw()) {
            jSONObject.put("orientation", (Object)"portrait");
        } else if (adResponseParcel.orientation == zzr.zzbE().zzhv()) {
            jSONObject.put("orientation", (Object)"landscape");
        }
        if (adResponseParcel.zzBQ != null) {
            jSONObject.put("click_urls", (Object)zzhe.zzi(adResponseParcel.zzBQ));
        }
        if (adResponseParcel.zzBR != null) {
            jSONObject.put("impression_urls", (Object)zzhe.zzi(adResponseParcel.zzBR));
        }
        if (adResponseParcel.zzHV != null) {
            jSONObject.put("manual_impression_urls", (Object)zzhe.zzi(adResponseParcel.zzHV));
        }
        if (adResponseParcel.zzIb != null) {
            jSONObject.put("active_view", (Object)adResponseParcel.zzIb);
        }
        jSONObject.put("ad_is_javascript", adResponseParcel.zzHZ);
        if (adResponseParcel.zzIa != null) {
            jSONObject.put("ad_passback_url", (Object)adResponseParcel.zzIa);
        }
        jSONObject.put("mediation", adResponseParcel.zzHT);
        jSONObject.put("custom_render_allowed", adResponseParcel.zzIc);
        jSONObject.put("content_url_opted_out", adResponseParcel.zzId);
        jSONObject.put("prefetch", adResponseParcel.zzIe);
        jSONObject.put("oauth2_token_status", adResponseParcel.zzIf);
        if (adResponseParcel.zzBU != -1L) {
            jSONObject.put("refresh_interval_milliseconds", adResponseParcel.zzBU);
        }
        if (adResponseParcel.zzHU != -1L) {
            jSONObject.put("mediation_config_cache_time_milliseconds", adResponseParcel.zzHU);
        }
        if (!TextUtils.isEmpty((CharSequence)adResponseParcel.zzIi)) {
            jSONObject.put("gws_query_id", (Object)adResponseParcel.zzIi);
        }
        jSONObject.put("fluid", (Object)(adResponseParcel.zzul ? "height" : ""));
        jSONObject.put("native_express", adResponseParcel.zzum);
        if (adResponseParcel.zzIk != null) {
            jSONObject.put("video_start_urls", (Object)zzhe.zzi(adResponseParcel.zzIk));
        }
        if (adResponseParcel.zzIl != null) {
            jSONObject.put("video_complete_urls", (Object)zzhe.zzi(adResponseParcel.zzIl));
        }
        if (adResponseParcel.zzIj != null) {
            jSONObject.put("rewards", (Object)adResponseParcel.zzIj.zzgR());
        }
        jSONObject.put("use_displayed_impression", adResponseParcel.zzIm);
        return jSONObject;
    }

    @Nullable
    static JSONArray zzi(List<String> list) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        for (String string2 : list) {
            jSONArray.put((Object)string2);
        }
        return jSONArray;
    }
}

