/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.reward.client.RewardedVideoAdRequestParcel;
import com.google.android.gms.ads.internal.reward.mediation.client.RewardItemParcel;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.zzb;
import com.google.android.gms.ads.internal.zzd;
import com.google.android.gms.ads.internal.zzr;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzcb;
import com.google.android.gms.internal.zzen;
import com.google.android.gms.internal.zzeo;
import com.google.android.gms.internal.zzew;
import com.google.android.gms.internal.zzex;
import com.google.android.gms.internal.zzhb;
import com.google.android.gms.internal.zzhe;
import com.google.android.gms.internal.zzhw;
import com.google.android.gms.internal.zzia;
import com.google.android.gms.internal.zzif;
import com.google.android.gms.internal.zzin;
import com.google.android.gms.internal.zzir;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

@zzhb
public class zzht
extends zzb
implements zzhw {
    private static final zzew zzKv = new zzew();
    private final Map<String, zzia> zzKw = new HashMap<String, zzia>();
    private boolean zzKx;

    public zzht(Context context, zzd zzd2, AdSizeParcel adSizeParcel, zzex zzex2, VersionInfoParcel versionInfoParcel) {
        super(context, adSizeParcel, null, zzex2, versionInfoParcel, zzd2);
    }

    public void zza(RewardedVideoAdRequestParcel rewardedVideoAdRequestParcel) {
        zzx.zzcD((String)"loadAd must be called on the main UI thread.");
        if (TextUtils.isEmpty((CharSequence)rewardedVideoAdRequestParcel.zzrj)) {
            zzin.zzaK("Invalid ad unit id. Aborting.");
            return;
        }
        this.zzKx = false;
        this.zzpj.zzrj = rewardedVideoAdRequestParcel.zzrj;
        super.zzb(rewardedVideoAdRequestParcel.zzHt);
    }

    @Override
    public void zza(final zzif.zza zza2, zzcb zzcb2) {
        if (zza2.errorCode != -2) {
            zzir.zzMc.post(new Runnable(){

                @Override
                public void run() {
                    zzht.this.zzb(new zzif(zza2, null, null, null, null, null, null));
                }
            });
            return;
        }
        this.zzpj.zzrr = zza2;
        if (zza2.zzKV == null) {
            this.zzpj.zzrr = this.zzc(zza2);
        }
        this.zzpj.zzrL = 0;
        this.zzpj.zzro = zzr.zzbB().zza(this.zzpj.context, this.zzpj.getUserId(), this.zzpj.zzrr, this);
    }

    @Nullable
    public zzia zzaw(String string2) {
        zzia zzia2 = this.zzKw.get(string2);
        if (zzia2 == null) {
            try {
                zzex zzex2 = this.zzpn;
                if ("com.google.ads.mediation.admob.AdMobAdapter".equals(string2)) {
                    zzex2 = zzKv;
                }
                zzia2 = new zzia(zzex2.zzaf(string2), this);
                this.zzKw.put(string2, zzia2);
            }
            catch (Exception exception) {
                zzin.zzd("Fail to instantiate adapter " + string2, exception);
            }
        }
        return zzia2;
    }

    @Override
    public boolean zza(zzif zzif2, zzif zzif3) {
        return true;
    }

    @Override
    public void pause() {
        zzx.zzcD((String)"pause must be called on the main UI thread.");
        for (String string2 : this.zzKw.keySet()) {
            try {
                zzia zzia2 = this.zzKw.get(string2);
                if (zzia2 == null || zzia2.zzgP() == null) continue;
                zzia2.zzgP().pause();
            }
            catch (RemoteException remoteException) {
                zzin.zzaK("Fail to pause adapter: " + string2);
            }
        }
    }

    @Override
    public void resume() {
        zzx.zzcD((String)"resume must be called on the main UI thread.");
        for (String string2 : this.zzKw.keySet()) {
            try {
                zzia zzia2 = this.zzKw.get(string2);
                if (zzia2 == null || zzia2.zzgP() == null) continue;
                zzia2.zzgP().resume();
            }
            catch (RemoteException remoteException) {
                zzin.zzaK("Fail to resume adapter: " + string2);
            }
        }
    }

    @Override
    public void destroy() {
        zzx.zzcD((String)"destroy must be called on the main UI thread.");
        for (String string2 : this.zzKw.keySet()) {
            try {
                zzia zzia2 = this.zzKw.get(string2);
                if (zzia2 == null || zzia2.zzgP() == null) continue;
                zzia2.zzgP().destroy();
            }
            catch (RemoteException remoteException) {
                zzin.zzaK("Fail to destroy adapter: " + string2);
            }
        }
    }

    public void zzgL() {
        zzx.zzcD((String)"showAd must be called on the main UI thread.");
        if (!this.isLoaded()) {
            zzin.zzaK("The reward video has not loaded.");
            return;
        }
        this.zzKx = true;
        zzia zzia2 = this.zzaw(this.zzpj.zzrq.zzCr);
        if (zzia2 != null && zzia2.zzgP() != null) {
            try {
                zzia2.zzgP().showVideo();
            }
            catch (RemoteException remoteException) {
                zzin.zzd("Could not call showVideo.", remoteException);
            }
        }
    }

    public boolean isLoaded() {
        zzx.zzcD((String)"isLoaded must be called on the main UI thread.");
        return this.zzpj.zzrn == null && this.zzpj.zzro == null && this.zzpj.zzrq != null && !this.zzKx;
    }

    @Override
    public void onRewardedVideoAdOpened() {
        this.zza(this.zzpj.zzrq, false);
        this.zzaS();
    }

    @Override
    public void onRewardedVideoStarted() {
        if (this.zzpj.zzrq != null && this.zzpj.zzrq.zzCp != null) {
            zzr.zzbP().zza(this.zzpj.context, this.zzpj.zzrl.afmaVersion, this.zzpj.zzrq, this.zzpj.zzrj, false, this.zzpj.zzrq.zzCp.zzBH);
        }
        this.zzaU();
    }

    @Override
    public void onRewardedVideoAdClosed() {
        this.zzaQ();
    }

    @Override
    public void zzc(@Nullable RewardItemParcel rewardItemParcel) {
        if (this.zzpj.zzrq != null && this.zzpj.zzrq.zzCp != null) {
            zzr.zzbP().zza(this.zzpj.context, this.zzpj.zzrl.afmaVersion, this.zzpj.zzrq, this.zzpj.zzrj, false, this.zzpj.zzrq.zzCp.zzBI);
        }
        if (this.zzpj.zzrq != null && this.zzpj.zzrq.zzKV != null && !TextUtils.isEmpty((CharSequence)this.zzpj.zzrq.zzKV.zzBV)) {
            rewardItemParcel = new RewardItemParcel(this.zzpj.zzrq.zzKV.zzBV, this.zzpj.zzrq.zzKV.zzBW);
        }
        this.zza(rewardItemParcel);
    }

    @Override
    public void zzgM() {
        this.onAdClicked();
    }

    @Override
    public void onRewardedVideoAdLeftApplication() {
        this.zzaR();
    }

    private zzif.zza zzc(zzif.zza zza2) {
        Object object;
        zzin.v("Creating mediation ad response for non-mediated rewarded ad.");
        String string2 = null;
        String string3 = null;
        try {
            string2 = zzhe.zzc(zza2.zzLe).toString();
            object = new JSONObject();
            object.put("pubid", (Object)zza2.zzLd.zzrj);
            string3 = object.toString();
        }
        catch (JSONException jSONException) {
            zzin.zzb("Unable to generate ad state for non-mediated rewarded video.", jSONException);
            return this.zzd(zza2);
        }
        object = new zzen(string2, null, Arrays.asList("com.google.ads.mediation.admob.AdMobAdapter"), null, null, Collections.emptyList(), Collections.emptyList(), string3, null, Collections.emptyList(), Collections.emptyList(), null, null, null, null, null);
        zzeo zzeo2 = new zzeo(Arrays.asList(object), -1L, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), "", -1L, 0, 1, null, 0, -1, -1L);
        return new zzif.zza(zza2.zzLd, zza2.zzLe, zzeo2, zza2.zzrp, zza2.errorCode, zza2.zzKY, zza2.zzKZ, zza2.zzKT);
    }

    private zzif.zza zzd(zzif.zza zza2) {
        return new zzif.zza(zza2.zzLd, zza2.zzLe, null, zza2.zzrp, 0, zza2.zzKY, zza2.zzKZ, zza2.zzKT);
    }
}

