/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.formats;

import android.content.Context;
import android.graphics.Rect;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.formats.zza;
import com.google.android.gms.ads.internal.formats.zzb;
import com.google.android.gms.ads.internal.formats.zzh;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.zzq;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.internal.zzaq;
import com.google.android.gms.internal.zzeh;
import com.google.android.gms.internal.zzfk;
import com.google.android.gms.internal.zzia;
import com.google.android.gms.internal.zzig;
import com.google.android.gms.internal.zzjw;
import com.google.android.gms.internal.zzla;
import com.google.android.gms.internal.zzlb;
import java.lang.ref.WeakReference;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

@zzig
public class zzi
implements zzh {
    private final Object zzpp = new Object();
    private final zzq zzAT;
    private final Context mContext;
    private final JSONObject zzAW;
    private final zzia zzAX;
    private final zzh.zza zzAY;
    private final zzaq zzAZ;
    private final VersionInfoParcel zzqP;
    private boolean zzBa;
    private zzla zzBb;
    private String zzBc;
    private String zzBd;
    private WeakReference<View> zzBe = null;

    public zzi(Context context, zzq zzq2, zzia zzia2, zzaq zzaq2, JSONObject jSONObject, zzh.zza zza2, VersionInfoParcel versionInfoParcel, String string) {
        this.mContext = context;
        this.zzAT = zzq2;
        this.zzAX = zzia2;
        this.zzAZ = zzaq2;
        this.zzAW = jSONObject;
        this.zzAY = zza2;
        this.zzqP = versionInfoParcel;
        this.zzBd = string;
    }

    public zzb zza(View.OnClickListener onClickListener) {
        zza zza2 = this.zzAY.zzeQ();
        if (zza2 == null) {
            return null;
        }
        zzb zzb2 = new zzb(this.mContext, zza2);
        zzb2.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        zzb2.zzeL().setOnClickListener(onClickListener);
        zzb2.zzeL().setContentDescription((CharSequence)"Ad attribution icon");
        return zzb2;
    }

    public void zza(String string, JSONObject jSONObject, JSONObject jSONObject2, JSONObject jSONObject3) {
        zzaa.zzdc((String)"performClick must be called on the main UI thread.");
        try {
            JSONObject jSONObject4 = new JSONObject();
            jSONObject4.put("asset", (Object)string);
            jSONObject4.put("template", (Object)this.zzAY.zzeP());
            final JSONObject jSONObject5 = new JSONObject();
            jSONObject5.put("ad", (Object)this.zzAW);
            jSONObject5.put("click", (Object)jSONObject4);
            jSONObject5.put("has_custom_click_handler", this.zzAT.zzv(this.zzAY.getCustomTemplateId()) != null);
            if (jSONObject != null) {
                jSONObject5.put("view_rectangles", (Object)jSONObject);
            }
            if (jSONObject2 != null) {
                jSONObject5.put("click_point", (Object)jSONObject2);
            }
            if (jSONObject3 != null) {
                jSONObject5.put("native_view_rectangle", (Object)jSONObject3);
            }
            jSONObject5.put("ads_id", (Object)this.zzBd);
            this.zzAX.zza(new zzia.zza(){

                @Override
                public void zze(zzfk zzfk2) {
                    zzfk2.zza("google.afma.nativeAds.handleClickGmsg", jSONObject5);
                }
            });
        }
        catch (JSONException jSONException) {
            zzjw.zzb((String)"Unable to create click JSON.", (Throwable)jSONException);
        }
    }

    public void zza(View view, Map<String, WeakReference<View>> map, JSONObject jSONObject, JSONObject jSONObject2, JSONObject jSONObject3) {
        zzaa.zzdc((String)"performClick must be called on the main UI thread.");
        for (Map.Entry<String, WeakReference<View>> entry : map.entrySet()) {
            View view2 = (View)entry.getValue().get();
            if (!view.equals(view2)) continue;
            this.zza(entry.getKey(), jSONObject, jSONObject2, jSONObject3);
            return;
        }
        if ("2".equals(this.zzAY.zzeP())) {
            this.zza("2099", jSONObject, jSONObject2, jSONObject3);
        } else if ("1".equals(this.zzAY.zzeP())) {
            this.zza("1099", jSONObject, jSONObject2, jSONObject3);
        }
    }

    public void zzb(MotionEvent motionEvent) {
        this.zzAZ.zza(motionEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzh(View view) {
        Object object = this.zzpp;
        synchronized (object) {
            if (this.zzBa) {
                return;
            }
            if (!view.isShown()) {
                return;
            }
            if (!view.getGlobalVisibleRect(new Rect(), null)) {
                return;
            }
            this.recordImpression();
        }
    }

    public void recordImpression() {
        zzaa.zzdc((String)"recordImpression must be called on the main UI thread.");
        this.zzp(true);
        try {
            final JSONObject jSONObject = new JSONObject();
            jSONObject.put("ad", (Object)this.zzAW);
            jSONObject.put("ads_id", (Object)this.zzBd);
            this.zzAX.zza(new zzia.zza(){

                @Override
                public void zze(zzfk zzfk2) {
                    zzfk2.zza("google.afma.nativeAds.handleImpressionPing", jSONObject);
                }
            });
        }
        catch (JSONException jSONException) {
            zzjw.zzb((String)"Unable to create impression JSON.", (Throwable)jSONException);
        }
        this.zzAT.zza(this);
    }

    public View zzeV() {
        return this.zzBe != null ? (View)this.zzBe.get() : null;
    }

    public void zzi(View view) {
        this.zzBe = new WeakReference<View>(view);
    }

    public void zzg(View view) {
    }

    public zzla zzeU() {
        this.zzBb = this.zzeW();
        this.zzBb.getView().setVisibility(8);
        zzia.zza zza2 = new zzia.zza(){

            @Override
            public void zze(final zzfk zzfk2) {
                zzfk2.zza("/loadHtml", new zzeh(){

                    @Override
                    public void zza(zzla zzla2, final Map<String, String> map) {
                        zzi.this.zzBb.zzjD().zza(new zzlb.zza(){

                            @Override
                            public void zza(zzla zzla2, boolean bl) {
                                zzi.this.zzBc = (String)map.get("id");
                                JSONObject jSONObject = new JSONObject();
                                try {
                                    jSONObject.put("messageType", (Object)"htmlLoaded");
                                    jSONObject.put("id", (Object)zzi.this.zzBc);
                                    zzfk2.zzb("sendMessageToNativeJs", jSONObject);
                                }
                                catch (JSONException jSONException) {
                                    zzjw.zzb((String)"Unable to dispatch sendMessageToNativeJs event", (Throwable)jSONException);
                                }
                            }
                        });
                        String string = map.get("overlayHtml");
                        String string2 = map.get("baseUrl");
                        if (TextUtils.isEmpty((CharSequence)string2)) {
                            zzi.this.zzBb.loadData(string, "text/html", "UTF-8");
                        } else {
                            zzi.this.zzBb.loadDataWithBaseURL(string2, string, "text/html", "UTF-8", null);
                        }
                    }
                });
                zzfk2.zza("/showOverlay", new zzeh(){

                    @Override
                    public void zza(zzla zzla2, Map<String, String> map) {
                        zzi.this.zzBb.getView().setVisibility(0);
                    }
                });
                zzfk2.zza("/hideOverlay", new zzeh(){

                    @Override
                    public void zza(zzla zzla2, Map<String, String> map) {
                        zzi.this.zzBb.getView().setVisibility(8);
                    }
                });
                zzi.this.zzBb.zzjD().zza("/hideOverlay", new zzeh(){

                    @Override
                    public void zza(zzla zzla2, Map<String, String> map) {
                        zzi.this.zzBb.getView().setVisibility(8);
                    }
                });
                zzi.this.zzBb.zzjD().zza("/sendMessageToSdk", new zzeh(){

                    @Override
                    public void zza(zzla zzla2, Map<String, String> map) {
                        JSONObject jSONObject = new JSONObject();
                        try {
                            for (String string : map.keySet()) {
                                jSONObject.put(string, (Object)map.get(string));
                            }
                            jSONObject.put("id", (Object)zzi.this.zzBc);
                            zzfk2.zzb("sendMessageToNativeJs", jSONObject);
                        }
                        catch (JSONException jSONException) {
                            zzjw.zzb((String)"Unable to dispatch sendMessageToNativeJs event", (Throwable)jSONException);
                        }
                    }
                });
            }
        };
        this.zzAX.zza(zza2);
        return this.zzBb;
    }

    protected void zzp(boolean bl) {
        this.zzBa = bl;
    }

    zzla zzeW() {
        return zzu.zzcl().zza(this.mContext, AdSizeParcel.zzk((Context)this.mContext), false, false, this.zzAZ, this.zzqP);
    }

    public Context getContext() {
        return this.mContext;
    }
}

