/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.support.customtabs.CustomTabsIntent;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.overlay.AdLauncherIntentInfoParcel;
import com.google.android.gms.ads.internal.overlay.AdOverlayInfoParcel;
import com.google.android.gms.ads.internal.overlay.zzg;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.ads.mediation.MediationAdRequest;
import com.google.android.gms.ads.mediation.MediationInterstitialAdapter;
import com.google.android.gms.ads.mediation.MediationInterstitialListener;
import com.google.android.gms.internal.zzdi;
import com.google.android.gms.internal.zzig;
import com.google.android.gms.internal.zzka;

@zzig
public class zzgp
implements MediationInterstitialAdapter {
    private Activity zzFN;
    private zzdi zzFO;
    private MediationInterstitialListener zzFP;
    private Uri mUri;

    public static boolean zzp(Context context) {
        return zzdi.zzo(context);
    }

    public void requestInterstitialAd(Context context, MediationInterstitialListener mediationInterstitialListener, Bundle bundle, MediationAdRequest mediationAdRequest, Bundle bundle2) {
        this.zzFP = mediationInterstitialListener;
        if (this.zzFP == null) {
            zzb.zzaW((String)"Listener not set for mediation. Returning.");
            return;
        }
        if (!(context instanceof Activity)) {
            zzb.zzaW((String)"AdMobCustomTabs can only work with Activity context. Bailing out.");
            this.zzFP.onAdFailedToLoad((MediationInterstitialAdapter)this, 0);
            return;
        }
        if (!zzgp.zzp(context)) {
            zzb.zzaW((String)"Default browser does not support custom tabs. Bailing out.");
            this.zzFP.onAdFailedToLoad((MediationInterstitialAdapter)this, 0);
            return;
        }
        String string = bundle.getString("tab_url");
        if (TextUtils.isEmpty((CharSequence)string)) {
            zzb.zzaW((String)"The tab_url retrieved from mediation metadata is empty. Bailing out.");
            this.zzFP.onAdFailedToLoad((MediationInterstitialAdapter)this, 0);
            return;
        }
        this.zzFN = (Activity)context;
        this.mUri = Uri.parse((String)string);
        this.zzFO = new zzdi();
        zzdi.zza zza2 = new zzdi.zza(){

            @Override
            public void zzeH() {
                zzb.zzaU((String)"Hinting CustomTabsService for the load of the new url.");
            }

            @Override
            public void zzeI() {
                zzb.zzaU((String)"Disconnecting from CustomTabs service.");
            }
        };
        this.zzFO.zza(zza2);
        this.zzFO.zze(this.zzFN);
        this.zzFP.onAdLoaded((MediationInterstitialAdapter)this);
    }

    public void showInterstitial() {
        CustomTabsIntent customTabsIntent = new CustomTabsIntent.Builder(this.zzFO.zzeF()).build();
        customTabsIntent.intent.setData(this.mUri);
        AdLauncherIntentInfoParcel adLauncherIntentInfoParcel = new AdLauncherIntentInfoParcel(customTabsIntent.intent);
        final AdOverlayInfoParcel adOverlayInfoParcel = new AdOverlayInfoParcel(adLauncherIntentInfoParcel, null, new zzg(){

            @Override
            public void zzbs() {
                zzb.zzaU((String)"AdMobCustomTabsAdapter overlay is closed.");
                zzgp.this.zzFP.onAdClosed((MediationInterstitialAdapter)zzgp.this);
                zzgp.this.zzFO.zzd(zzgp.this.zzFN);
            }

            @Override
            public void onPause() {
                zzb.zzaU((String)"AdMobCustomTabsAdapter overlay is paused.");
            }

            @Override
            public void onResume() {
                zzb.zzaU((String)"AdMobCustomTabsAdapter overlay is resumed.");
            }

            @Override
            public void zzbt() {
                zzb.zzaU((String)"Opening AdMobCustomTabsAdapter overlay.");
                zzgp.this.zzFP.onAdOpened((MediationInterstitialAdapter)zzgp.this);
            }
        }, null, new VersionInfoParcel(0, 0, false));
        zzka.zzQu.post(new Runnable(){

            @Override
            public void run() {
                zzu.zzci().zza((Context)zzgp.this.zzFN, adOverlayInfoParcel);
            }
        });
        zzu.zzcn().zzE(false);
    }

    public void onDestroy() {
        zzb.zzaU((String)"Destroying AdMobCustomTabsAdapter adapter.");
        try {
            this.zzFO.zzd(this.zzFN);
        }
        catch (Exception exception) {
            zzb.zzb((String)"Exception while unbinding from CustomTabsService.", (Throwable)exception);
        }
    }

    public void onPause() {
        zzb.zzaU((String)"Pausing AdMobCustomTabsAdapter adapter.");
    }

    public void onResume() {
        zzb.zzaU((String)"Resuming AdMobCustomTabsAdapter adapter.");
    }
}

