/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.RelativeLayout;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.zzm;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.common.util.zzf;
import com.google.android.gms.internal.zzgw;
import com.google.android.gms.internal.zzgx;
import com.google.android.gms.internal.zzig;
import com.google.android.gms.internal.zzjw;
import com.google.android.gms.internal.zzla;
import java.util.Map;
import java.util.Set;

@zzig
public class zzgr
extends zzgw {
    static final Set<String> zzFX = zzf.zzc((Object[])new String[]{"top-left", "top-right", "top-center", "center", "bottom-left", "bottom-right", "bottom-center"});
    private String zzFY = "top-right";
    private boolean zzFZ = true;
    private int zzGa = 0;
    private int zzGb = 0;
    private int zzpj = -1;
    private int zzGc = 0;
    private int zzGd = 0;
    private int zzpi = -1;
    private final Object zzpp = new Object();
    private final zzla zzBb;
    private final Activity zzFN;
    private AdSizeParcel zzrJ;
    private ImageView zzGe;
    private LinearLayout zzGf;
    private zzgx zzGg;
    private PopupWindow zzGh;
    private RelativeLayout zzGi;
    private ViewGroup zzGj;

    public zzgr(zzla zzla2, zzgx zzgx2) {
        super(zzla2, "resize");
        this.zzBb = zzla2;
        this.zzFN = zzla2.zzjy();
        this.zzGg = zzgx2;
    }

    private void zzi(Map<String, String> map) {
        String string2;
        if (!TextUtils.isEmpty((CharSequence)map.get("width"))) {
            this.zzpi = zzu.zzck().zzaO(map.get("width"));
        }
        if (!TextUtils.isEmpty((CharSequence)map.get("height"))) {
            this.zzpj = zzu.zzck().zzaO(map.get("height"));
        }
        if (!TextUtils.isEmpty((CharSequence)map.get("offsetX"))) {
            this.zzGc = zzu.zzck().zzaO(map.get("offsetX"));
        }
        if (!TextUtils.isEmpty((CharSequence)map.get("offsetY"))) {
            this.zzGd = zzu.zzck().zzaO(map.get("offsetY"));
        }
        if (!TextUtils.isEmpty((CharSequence)map.get("allowOffscreen"))) {
            this.zzFZ = Boolean.parseBoolean(map.get("allowOffscreen"));
        }
        if (!TextUtils.isEmpty((CharSequence)(string2 = map.get("customClosePosition")))) {
            this.zzFY = string2;
        }
    }

    boolean zzfO() {
        return this.zzpi > -1 && this.zzpj > -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Map<String, String> map) {
        Object object = this.zzpp;
        synchronized (object) {
            Bitmap bitmap;
            if (this.zzFN == null) {
                this.zzas("Not an activity context. Cannot resize.");
                return;
            }
            if (this.zzBb.zzbi() == null) {
                this.zzas("Webview is not yet available, size is not set.");
                return;
            }
            if (this.zzBb.zzbi().zzvt) {
                this.zzas("Is interstitial. Cannot resize an interstitial.");
                return;
            }
            if (this.zzBb.zzjH()) {
                this.zzas("Cannot resize an expanded banner.");
                return;
            }
            this.zzi(map);
            if (!this.zzfO()) {
                this.zzas("Invalid width and height options. Cannot resize.");
                return;
            }
            Window window = this.zzFN.getWindow();
            if (window == null || window.getDecorView() == null) {
                this.zzas("Activity context is not ready, cannot get window or decor view.");
                return;
            }
            int[] nArray = this.zzfP();
            if (nArray == null) {
                this.zzas("Resize location out of screen or close button is not visible.");
                return;
            }
            int n = zzm.zzdQ().zza((Context)this.zzFN, this.zzpi);
            int n2 = zzm.zzdQ().zza((Context)this.zzFN, this.zzpj);
            ViewParent viewParent = this.zzBb.getView().getParent();
            if (viewParent != null && viewParent instanceof ViewGroup) {
                ((ViewGroup)viewParent).removeView(this.zzBb.getView());
                if (this.zzGh == null) {
                    this.zzGj = (ViewGroup)viewParent;
                    bitmap = zzu.zzck().zzl(this.zzBb.getView());
                    this.zzGe = new ImageView((Context)this.zzFN);
                    this.zzGe.setImageBitmap(bitmap);
                    this.zzrJ = this.zzBb.zzbi();
                    this.zzGj.addView((View)this.zzGe);
                } else {
                    this.zzGh.dismiss();
                }
            } else {
                this.zzas("Webview is detached, probably in the middle of a resize or expand.");
                return;
            }
            this.zzGi = new RelativeLayout((Context)this.zzFN);
            this.zzGi.setBackgroundColor(0);
            this.zzGi.setLayoutParams(new ViewGroup.LayoutParams(n, n2));
            this.zzGh = zzu.zzck().zza((View)this.zzGi, n, n2, false);
            this.zzGh.setOutsideTouchable(true);
            this.zzGh.setTouchable(true);
            this.zzGh.setClippingEnabled(!this.zzFZ);
            this.zzGi.addView(this.zzBb.getView(), -1, -1);
            this.zzGf = new LinearLayout((Context)this.zzFN);
            bitmap = new RelativeLayout.LayoutParams(zzm.zzdQ().zza((Context)this.zzFN, 50), zzm.zzdQ().zza((Context)this.zzFN, 50));
            switch (this.zzFY) {
                case "top-left": {
                    bitmap.addRule(10);
                    bitmap.addRule(9);
                    break;
                }
                case "top-center": {
                    bitmap.addRule(10);
                    bitmap.addRule(14);
                    break;
                }
                case "center": {
                    bitmap.addRule(13);
                    break;
                }
                case "bottom-left": {
                    bitmap.addRule(12);
                    bitmap.addRule(9);
                    break;
                }
                case "bottom-center": {
                    bitmap.addRule(12);
                    bitmap.addRule(14);
                    break;
                }
                case "bottom-right": {
                    bitmap.addRule(12);
                    bitmap.addRule(11);
                    break;
                }
                default: {
                    bitmap.addRule(10);
                    bitmap.addRule(11);
                }
            }
            this.zzGf.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    zzgr.this.zzr(true);
                }
            });
            this.zzGf.setContentDescription((CharSequence)"Close button");
            this.zzGi.addView((View)this.zzGf, (ViewGroup.LayoutParams)bitmap);
            try {
                this.zzGh.showAtLocation(window.getDecorView(), 0, zzm.zzdQ().zza((Context)this.zzFN, nArray[0]), zzm.zzdQ().zza((Context)this.zzFN, nArray[1]));
            }
            catch (RuntimeException runtimeException) {
                String string2 = String.valueOf(runtimeException.getMessage());
                this.zzas(string2.length() != 0 ? "Cannot show popup window: ".concat(string2) : new String("Cannot show popup window: "));
                this.zzGi.removeView(this.zzBb.getView());
                if (this.zzGj != null) {
                    this.zzGj.removeView((View)this.zzGe);
                    this.zzGj.addView(this.zzBb.getView());
                    this.zzBb.zza(this.zzrJ);
                }
                return;
            }
            this.zzb(nArray[0], nArray[1]);
            this.zzBb.zza(new AdSizeParcel((Context)this.zzFN, new AdSize(this.zzpi, this.zzpj)));
            this.zzc(nArray[0], nArray[1]);
            this.zzau("resized");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzr(boolean bl) {
        Object object = this.zzpp;
        synchronized (object) {
            if (this.zzGh != null) {
                this.zzGh.dismiss();
                this.zzGi.removeView(this.zzBb.getView());
                if (this.zzGj != null) {
                    this.zzGj.removeView((View)this.zzGe);
                    this.zzGj.addView(this.zzBb.getView());
                    this.zzBb.zza(this.zzrJ);
                }
                if (bl) {
                    this.zzau("default");
                    if (this.zzGg != null) {
                        this.zzGg.zzbE();
                    }
                }
                this.zzGh = null;
                this.zzGi = null;
                this.zzGj = null;
                this.zzGf = null;
            }
        }
    }

    private int[] zzfP() {
        if (!this.zzfR()) {
            return null;
        }
        if (this.zzFZ) {
            return new int[]{this.zzGa + this.zzGc, this.zzGb + this.zzGd};
        }
        int[] nArray = zzu.zzck().zzi(this.zzFN);
        int[] nArray2 = zzu.zzck().zzk(this.zzFN);
        int n = nArray[0];
        int n2 = this.zzGa + this.zzGc;
        int n3 = this.zzGb + this.zzGd;
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 + this.zzpi > n) {
            n2 = n - this.zzpi;
        }
        if (n3 < nArray2[0]) {
            n3 = nArray2[0];
        } else if (n3 + this.zzpj > nArray2[1]) {
            n3 = nArray2[1] - this.zzpj;
        }
        return new int[]{n2, n3};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(int n, int n2, boolean bl) {
        Object object = this.zzpp;
        synchronized (object) {
            this.zzGa = n;
            this.zzGb = n2;
            if (this.zzGh != null && bl) {
                int[] nArray = this.zzfP();
                if (nArray != null) {
                    this.zzGh.update(zzm.zzdQ().zza((Context)this.zzFN, nArray[0]), zzm.zzdQ().zza((Context)this.zzFN, nArray[1]), this.zzGh.getWidth(), this.zzGh.getHeight());
                    this.zzc(nArray[0], nArray[1]);
                } else {
                    this.zzr(true);
                }
            }
        }
    }

    void zzb(int n, int n2) {
        if (this.zzGg != null) {
            this.zzGg.zza(n, n2, this.zzpi, this.zzpj);
        }
    }

    void zzc(int n, int n2) {
        int n3 = zzu.zzck().zzk(this.zzFN)[0];
        this.zzb(n, n2 - n3, this.zzpi, this.zzpj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean zzfQ() {
        Object object = this.zzpp;
        synchronized (object) {
            return this.zzGh != null;
        }
    }

    public void zzd(int n, int n2) {
        this.zzGa = n;
        this.zzGb = n2;
    }

    boolean zzfR() {
        int[] nArray = zzu.zzck().zzi(this.zzFN);
        int[] nArray2 = zzu.zzck().zzk(this.zzFN);
        int n = nArray[0];
        int n2 = nArray[1];
        if (this.zzpi < 50 || this.zzpi > n) {
            zzjw.zzaW((String)"Width is too small or too large.");
            return false;
        }
        if (this.zzpj < 50 || this.zzpj > n2) {
            zzjw.zzaW((String)"Height is too small or too large.");
            return false;
        }
        if (this.zzpj == n2 && this.zzpi == n) {
            zzjw.zzaW((String)"Cannot resize to a full-screen ad.");
            return false;
        }
        if (this.zzFZ) {
            int n3 = -1;
            int n4 = -2;
            switch (this.zzFY) {
                case "top-left": {
                    n3 = this.zzGa + this.zzGc;
                    n4 = this.zzGb + this.zzGd;
                    break;
                }
                case "top-center": {
                    n3 = this.zzGa + this.zzGc + this.zzpi / 2 - 25;
                    n4 = this.zzGb + this.zzGd;
                    break;
                }
                case "center": {
                    n3 = this.zzGa + this.zzGc + this.zzpi / 2 - 25;
                    n4 = this.zzGb + this.zzGd + this.zzpj / 2 - 25;
                    break;
                }
                case "bottom-left": {
                    n3 = this.zzGa + this.zzGc;
                    n4 = this.zzGb + this.zzGd + this.zzpj - 50;
                    break;
                }
                case "bottom-center": {
                    n3 = this.zzGa + this.zzGc + this.zzpi / 2 - 25;
                    n4 = this.zzGb + this.zzGd + this.zzpj - 50;
                    break;
                }
                case "bottom-right": {
                    n3 = this.zzGa + this.zzGc + this.zzpi - 50;
                    n4 = this.zzGb + this.zzGd + this.zzpj - 50;
                    break;
                }
                default: {
                    n3 = this.zzGa + this.zzGc + this.zzpi - 50;
                    n4 = this.zzGb + this.zzGd;
                }
            }
            if (n3 < 0 || n3 + 50 > n || n4 < nArray2[0] || n4 + 50 > nArray2[1]) {
                return false;
            }
        }
        return true;
    }
}

