/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.formats;

import android.graphics.Point;
import android.graphics.Rect;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import com.google.android.gms.ads.internal.client.zzm;
import com.google.android.gms.ads.internal.formats.zzb;
import com.google.android.gms.ads.internal.formats.zzg;
import com.google.android.gms.ads.internal.formats.zzh;
import com.google.android.gms.ads.internal.formats.zzi;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzdl;
import com.google.android.gms.internal.zzig;
import com.google.android.gms.internal.zzjw;
import com.google.android.gms.internal.zzka;
import com.google.android.gms.internal.zzla;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

@zzig
public class zzk
extends zzdl.zza
implements View.OnClickListener,
View.OnTouchListener,
ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener {
    private final Object zzpp = new Object();
    private final FrameLayout zzBo;
    private FrameLayout zzpC;
    private Map<String, WeakReference<View>> zzBp = new HashMap<String, WeakReference<View>>();
    private zzb zzBq;
    private zzh zzAL;
    boolean zzBr = false;
    int zzBs;
    int zzBt;

    public zzk(FrameLayout frameLayout, FrameLayout frameLayout2) {
        this.zzBo = frameLayout;
        this.zzpC = frameLayout2;
        zzu.zzcE().zza((View)this.zzBo, this);
        zzu.zzcE().zza((View)this.zzBo, this);
        this.zzBo.setOnTouchListener((View.OnTouchListener)this);
        this.zzBo.setOnClickListener((View.OnClickListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzc(String string, zzd zzd2) {
        View view = (View)zze.zzx((zzd)zzd2);
        Object object = this.zzpp;
        synchronized (object) {
            if (view == null) {
                this.zzBp.remove(string);
            } else {
                this.zzBp.put(string, new WeakReference<View>(view));
                view.setOnTouchListener((View.OnTouchListener)this);
                view.setClickable(true);
                view.setOnClickListener((View.OnClickListener)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public zzd zzP(String string) {
        Object object = this.zzpp;
        synchronized (object) {
            WeakReference<View> weakReference = this.zzBp.get(string);
            return zze.zzD(weakReference == null ? null : (View)weakReference.get());
        }
    }

    void zzi(View view) {
        zzh zzh2 = null;
        if (this.zzAL != null && (zzh2 = this.zzAL instanceof zzg ? ((zzg)this.zzAL).zzeT() : this.zzAL) != null) {
            zzh2.zzi(view);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zze(zzd zzd2) {
        Object object = this.zzpp;
        synchronized (object) {
            this.zzeX();
            if (this.zzpC != null) {
                this.zzpC.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(0, 0));
                this.zzBo.requestLayout();
            }
            this.zzBr = true;
            this.zzi(null);
            Object object2 = zze.zzx((zzd)zzd2);
            if (!(object2 instanceof zzi)) {
                zzjw.zzaW((String)"Not an instance of native engine. This is most likely a transient error");
                return;
            }
            final zzi zzi2 = (zzi)object2;
            if (this.zzAL instanceof zzg && ((zzg)this.zzAL).zzeS()) {
                ((zzg)this.zzAL).zzc(zzi2);
            } else {
                this.zzAL = zzi2;
                if (this.zzAL instanceof zzg) {
                    ((zzg)this.zzAL).zzc(null);
                }
            }
            this.zzpC.removeAllViews();
            this.zzBq = this.zzc(zzi2);
            if (this.zzBq != null) {
                this.zzBp.put("1007", new WeakReference<ViewGroup>(this.zzBq.zzeL()));
                this.zzpC.addView((View)this.zzBq);
            }
            zzka.zzQu.post(new Runnable(){

                @Override
                public void run() {
                    zzla zzla2 = zzi2.zzeU();
                    if (zzla2 != null && zzk.this.zzpC != null) {
                        zzk.this.zzpC.addView(zzla2.getView());
                    }
                }
            });
            zzi2.zzg((View)this.zzBo);
            this.zzi((View)this.zzBo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClick(View view) {
        Object object = this.zzpp;
        synchronized (object) {
            if (this.zzAL == null) {
                return;
            }
            JSONObject jSONObject2 = new JSONObject();
            for (Map.Entry<String, WeakReference<View>> jSONObject3 : this.zzBp.entrySet()) {
                View view2 = (View)jSONObject3.getValue().get();
                if (view2 == null) continue;
                Point point = this.zzj(view2);
                JSONObject jSONObject = new JSONObject();
                try {
                    jSONObject.put("width", this.zzv(view2.getWidth()));
                    jSONObject.put("height", this.zzv(view2.getHeight()));
                    jSONObject.put("x", this.zzv(point.x));
                    jSONObject.put("y", this.zzv(point.y));
                    jSONObject2.put(jSONObject3.getKey(), (Object)jSONObject);
                }
                catch (JSONException jSONException) {
                    String string = String.valueOf(jSONObject3.getKey());
                    zzjw.zzaW((String)(string.length() != 0 ? "Unable to get view rectangle for view ".concat(string) : new String("Unable to get view rectangle for view ")));
                }
            }
            JSONObject jSONObject5 = new JSONObject();
            try {
                jSONObject5.put("x", this.zzv(this.zzBs));
                jSONObject5.put("y", this.zzv(this.zzBt));
            }
            catch (JSONException jSONException) {
                zzjw.zzaW((String)"Unable to get click location");
            }
            JSONObject jSONObject = new JSONObject();
            try {
                jSONObject.put("width", this.zzv(this.getMeasuredWidth()));
                jSONObject.put("height", this.zzv(this.getMeasuredHeight()));
            }
            catch (JSONException jSONException) {
                zzjw.zzaW((String)"Unable to get native ad view bounding box");
            }
            if (this.zzBq != null && this.zzBq.zzeL().equals(view)) {
                this.zzAL.zza("1007", jSONObject2, jSONObject5, jSONObject);
            } else {
                this.zzAL.zza(view, this.zzBp, jSONObject2, jSONObject5, jSONObject);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onGlobalLayout() {
        Object object = this.zzpp;
        synchronized (object) {
            if (this.zzBr) {
                int n = this.getMeasuredWidth();
                int n2 = this.getMeasuredHeight();
                if (n != 0 && n2 != 0 && this.zzpC != null) {
                    this.zzpC.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(n, n2));
                    this.zzBr = false;
                }
            }
            if (this.zzAL != null) {
                this.zzAL.zzh((View)this.zzBo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onScrollChanged() {
        Object object = this.zzpp;
        synchronized (object) {
            if (this.zzAL != null) {
                this.zzAL.zzh((View)this.zzBo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onTouch(View view, MotionEvent motionEvent) {
        Object object = this.zzpp;
        synchronized (object) {
            if (this.zzAL == null) {
                return false;
            }
            Point point = this.zzc(motionEvent);
            this.zzBs = point.x;
            this.zzBt = point.y;
            MotionEvent motionEvent2 = MotionEvent.obtain((MotionEvent)motionEvent);
            motionEvent2.setLocation((float)point.x, (float)point.y);
            this.zzAL.zzb(motionEvent2);
            motionEvent2.recycle();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.zzpp;
        synchronized (object) {
            if (this.zzpC != null) {
                this.zzpC.removeAllViews();
            }
            this.zzpC = null;
            this.zzBp = null;
            this.zzBq = null;
            this.zzAL = null;
        }
    }

    private void zzeX() {
        this.zzBo.setOnTouchListener((View.OnTouchListener)this);
        this.zzBo.setClickable(true);
        this.zzBo.setOnClickListener((View.OnClickListener)this);
        for (Map.Entry<String, WeakReference<View>> entry : this.zzBp.entrySet()) {
            View view = (View)entry.getValue().get();
            if (view == null) continue;
            view.setOnTouchListener((View.OnTouchListener)this);
            view.setClickable(true);
            view.setOnClickListener((View.OnClickListener)this);
        }
    }

    Point zzc(MotionEvent motionEvent) {
        int[] nArray = new int[2];
        this.zzBo.getLocationOnScreen(nArray);
        float f = motionEvent.getRawX() - (float)nArray[0];
        float f2 = motionEvent.getRawY() - (float)nArray[1];
        return new Point((int)f, (int)f2);
    }

    zzb zzc(zzi zzi2) {
        return zzi2.zza(this);
    }

    int getMeasuredWidth() {
        return this.zzBo.getMeasuredWidth();
    }

    int getMeasuredHeight() {
        return this.zzBo.getMeasuredHeight();
    }

    int zzv(int n) {
        return zzm.zzdQ().zzb(this.zzAL.getContext(), n);
    }

    Point zzj(View view) {
        if (this.zzBq != null && this.zzBq.zzeL().equals(view)) {
            Point point = new Point();
            this.zzBo.getGlobalVisibleRect(new Rect(), point);
            Point point2 = new Point();
            view.getGlobalVisibleRect(new Rect(), point2);
            return new Point(point2.x - point.x, point2.y - point.y);
        }
        Point point = new Point();
        view.getGlobalVisibleRect(new Rect(), point);
        return point;
    }
}

